/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dealNotice.bo.DealNoticeItemInfoBO;
import com.tydic.enquiry.api.dealNotice.bo.ModifyDealNoticeItemInfoReqBO;
import com.tydic.enquiry.api.dealNotice.bo.ModifyDealNoticeItemInfoRspBO;
import com.tydic.enquiry.api.dealNotice.service.ModifyDealNoticeItemInfoService;
import com.tydic.enquiry.api.performlist.bo.QuotationItemInfo;
import com.tydic.enquiry.dao.DIqrDealNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.po.DIqrDealNoticePO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.util.RedisUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=ModifyDealNoticeItemInfoService.class)
public class ModifyDealNoticeItemInfoServiceImpl
implements ModifyDealNoticeItemInfoService {
    private static final Logger log = LoggerFactory.getLogger(ModifyDealNoticeItemInfoServiceImpl.class);
    @Autowired
    private DIqrDealNoticeMapper dIqrDealNoticeMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private RedisUtils redisUtils;

    public ModifyDealNoticeItemInfoRspBO modifyDealNoticeItemInfo(ModifyDealNoticeItemInfoReqBO reqBO) {
        ModifyDealNoticeItemInfoRspBO rspBO = new ModifyDealNoticeItemInfoRspBO();
        if (null == reqBO.getDealNoticeId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u4e66ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((String)reqBO.getRedisNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u4e66ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            DIqrDealNoticePO dIqrDealNoticePO = this.dIqrDealNoticeMapper.selectByPrimaryKey(reqBO.getDealNoticeId());
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(dIqrDealNoticePO.getInquiryId());
            List<?> obj = this.redisUtils.getList("DIC_DEAL_NOTICE_QUOTATION_ITEM_" + reqBO.getRedisNo());
            log.info("listDicByTypeCode::obj=" + obj);
            List<Object> quoteRedis = new ArrayList();
            if (null != obj) {
                quoteRedis = obj;
            }
            if (CollectionUtils.isEmpty(quoteRedis)) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u660e\u7ec6\u6570\u636e\u672a\u5237\u5165\u7f13\u5b58\uff01");
                return rspBO;
            }
            List quotationItemList = reqBO.getQuotationItemList();
            ArrayList<DealNoticeItemInfoBO> toRedis = new ArrayList<DealNoticeItemInfoBO>();
            for (DealNoticeItemInfoBO dealNoticeItemInfoBO : quoteRedis) {
                for (QuotationItemInfo item : quotationItemList) {
                    if (!dealNoticeItemInfoBO.getQuotationId().equals(item.getQuotationId().toString()) || !dealNoticeItemInfoBO.getQuotationItemId().equals(item.getQuotationItemId().toString())) continue;
                    DealNoticeItemInfoBO d = new DealNoticeItemInfoBO();
                    if ("1".equals(inquiryMatePO.getBusiType()) && item.getQuotePrice().compareTo(dealNoticeItemInfoBO.getBudgetPrice()) < 0) {
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u5355\u4ef7\uff01");
                        return rspBO;
                    }
                    BeanUtils.copyProperties((Object)dealNoticeItemInfoBO, (Object)d);
                    d.setQuotePrice(item.getQuotePrice());
                    d.setQuoteAmount(item.getQuoteAmount());
                    if (item.getPurchaseNum() != null) {
                        d.setPurcharseNum(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(item.getPurchaseNum())));
                    }
                    d.setBrand(item.getBrand());
                    d.setManufacturer(item.getManufacturer());
                    d.setGoodsCode(item.getGoodsCode());
                    d.setExtraGoodsCode(item.getExtraGoodsCode());
                    toRedis.add(d);
                }
            }
            this.redisUtils.delete("DIC_DEAL_NOTICE_QUOTATION_ITEM_" + reqBO.getRedisNo());
            this.redisUtils.setList("DIC_DEAL_NOTICE_QUOTATION_ITEM_" + reqBO.getRedisNo(), toRedis);
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25\uff01" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }
}

