/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusReqBO;
import com.tydic.enquiry.api.performlist.service.UpExecOrderStatusService;
import com.tydic.enquiry.api.quote.bo.ConfirmBiddingResultsReqBO;
import com.tydic.enquiry.api.quote.bo.ConfirmBiddingResultsRspBO;
import com.tydic.enquiry.api.quote.service.ConfirmBiddingResultsService;
import com.tydic.enquiry.api.registdoc.bo.UpMarginPayStatusReqBO;
import com.tydic.enquiry.api.registdoc.service.UpMarginPayStatusService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.enquiry.util.SendMsgUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=ConfirmBiddingResultsService.class)
public class ConfirmBiddingResultsServiceImpl
implements ConfirmBiddingResultsService {
    private static final Logger log = LoggerFactory.getLogger(ConfirmBiddingResultsServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private UpExecOrderStatusService upExecOrderStatusService;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    UpMarginPayStatusService upMarginPayStatusService;
    @Value(value="${msg.center.url}")
    private String msgUrl;

    public ConfirmBiddingResultsRspBO confirmBiddingResults(ConfirmBiddingResultsReqBO confirmBiddingResultsReqBO) {
        ConfirmBiddingResultsRspBO rspBO = new ConfirmBiddingResultsRspBO();
        List<DIqrInquiryBidsectionPO> bidsectionPOList = this.dIqrInquiryBidsectionMapper.selectByInquiryId(confirmBiddingResultsReqBO.getInquiryId());
        if (CollectionUtils.isNotEmpty(bidsectionPOList)) {
            for (DIqrInquiryBidsectionPO bidsectionPO : bidsectionPOList) {
                DIqrQuotationPO qryInquiryQuotationPO = new DIqrQuotationPO();
                ArrayList<Integer> docStatusList = new ArrayList<Integer>();
                docStatusList.add(Integer.valueOf("40014"));
                docStatusList.add(Integer.valueOf("40015"));
                qryInquiryQuotationPO.setInquiryId(confirmBiddingResultsReqBO.getInquiryId());
                qryInquiryQuotationPO.setHisStatus("1");
                qryInquiryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
                qryInquiryQuotationPO.setDocStatusList(docStatusList);
                qryInquiryQuotationPO.setBidsectionId(bidsectionPO.getBidsectionId());
                List<DIqrQuotationPO> inquiryQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryInquiryQuotationPO);
                Long mostQuotationId = null;
                if (inquiryQuotationPOs != null && inquiryQuotationPOs.size() > 0) {
                    Long quoteAmount = inquiryQuotationPOs.get(0).getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)inquiryQuotationPOs.get(0).getAmountSec())) {
                        quoteAmount = QuoteUtil.decode(inquiryQuotationPOs.get(0).getAmountSec(), ((DIqrQuotationPO)inquiryQuotationPOs.get(0)).getQuotationId().toString());
                    }
                    mostQuotationId = inquiryQuotationPOs.get(0).getQuotationId();
                    Iterator iterator = inquiryQuotationPOs.iterator();
                    while (iterator.hasNext()) {
                        DIqrQuotationPO dIqrQuotationPO = (DIqrQuotationPO)iterator.next();
                        Long amount = dIqrQuotationPO.getAmount();
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                            amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                        }
                        if (quoteAmount <= amount) continue;
                        mostQuotationId = dIqrQuotationPO.getQuotationId();
                    }
                }
                DIqrQuotationPO updateStatusPO = new DIqrQuotationPO();
                updateStatusPO.setReviewResult(Constants.REVIEW_RESULT_2);
                updateStatusPO.setInquiryId(confirmBiddingResultsReqBO.getInquiryId());
                updateStatusPO.setBidsectionId(bidsectionPO.getBidsectionId());
                this.dIqrQuotationMapper.updateStatusByInquiryId(updateStatusPO);
                updateStatusPO.setReviewResult(Constants.REVIEW_RESULT_1);
                updateStatusPO.setQuotationId(mostQuotationId);
                this.dIqrQuotationMapper.updateStatusByInquiryId(updateStatusPO);
            }
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(confirmBiddingResultsReqBO.getInquiryId());
        ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
        execOrderStatusReqBO.setInquiryId(confirmBiddingResultsReqBO.getInquiryId());
        execOrderStatusReqBO.setOperId(confirmBiddingResultsReqBO.getUserId());
        execOrderStatusReqBO.setOperName(confirmBiddingResultsReqBO.getUsername());
        if (Constants.PURCHASE_METHOD_INVITE.intValue() == dIqrInquiryMatePO.getPurchaseMethod().intValue()) {
            execOrderStatusReqBO.setDocStatus(Integer.valueOf("2009"));
            execOrderStatusReqBO.setNodeStatus("2009");
        } else {
            execOrderStatusReqBO.setDocStatus(Integer.valueOf("2008"));
            execOrderStatusReqBO.setNodeStatus("2008");
        }
        execOrderStatusReqBO.setUpFlag("1");
        this.upExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
        log.info("ConfirmBiddingResultsService:SendMsgUtil::dIqrInquiryMatePO.getPurchaseMethod()=" + dIqrInquiryMatePO.getPurchaseMethod());
        if (Constants.PURCHASE_METHOD_INVITE.intValue() == dIqrInquiryMatePO.getPurchaseMethod().intValue()) {
            String phoneNumbers = null;
            List<DIqrRegistDocPO> dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(dIqrInquiryMatePO.getInquiryId());
            if (CollectionUtils.isNotEmpty(dIqrRegistDocList)) {
                for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocList) {
                    log.info("ConfirmBiddingResultsService:dIqrRegistDocPO.getSupplierId()=" + dIqrRegistDocPO.getSupplierId());
                    if (!"2".equals(dIqrRegistDocPO.getPayStatus())) continue;
                    UpMarginPayStatusReqBO upMarginPayStatusReqBO = new UpMarginPayStatusReqBO();
                    upMarginPayStatusReqBO.setRegistId(dIqrRegistDocPO.getRegistId());
                    upMarginPayStatusReqBO.setSupplierId(dIqrRegistDocPO.getSupplierId());
                    upMarginPayStatusReqBO.setPayFlag("3");
                    this.upMarginPayStatusService.upMarginPayStatus(upMarginPayStatusReqBO);
                }
                List phoneNumberList = dIqrRegistDocList.stream().map(DIqrRegistDocPO::getPhoneNumber).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(phoneNumberList)) {
                    phoneNumbers = StringUtils.join(phoneNumberList, (String)",");
                }
                log.info("ConfirmBiddingResultsService:SendMsgUtil::phoneNumbers=" + phoneNumbers);
                if (StringUtils.isNotBlank((CharSequence)phoneNumbers)) {
                    String finalPhoneNumbers = phoneNumbers;
                    String noticeTitle = "\u60a8\u53c2\u4e0e\u7684\u7f16\u53f7\uff1a" + dIqrInquiryMatePO.getInquiryCode() + "\uff0c\u540d\u79f0\uff1a" + dIqrInquiryMatePO.getInquiryName() + "\u9879\u76ee\u5df2\u4e2d\u6807";
                    log.info("ConfirmBiddingResultsService:SendMsgUtil::noticeTitle=" + noticeTitle);
                    log.info("ConfirmBiddingResultsService:SendMsgUtil::dIqrInquiryMatePO.getPurchaseName()=" + dIqrInquiryMatePO.getPurchaseName());
                    new Thread(() -> SendMsgUtil.sendMsg(finalPhoneNumbers, noticeTitle, dIqrInquiryMatePO.getPurchaseName(), this.msgUrl)).start();
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6267\u884c\u5355\u786e\u8ba4\u7ade\u4ef7\u7ed3\u679c\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

