/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryQuoteReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryQuoteRspBO;
import com.tydic.enquiry.api.quoteFinish.service.RecoveryQuoteService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.enquiry.vo.QuotationInfoVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=RecoveryQuoteService.class)
public class RecoveryQuoteServiceImpl
implements RecoveryQuoteService {
    private static final Logger log = LoggerFactory.getLogger(RecoveryQuoteServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;

    public RecoveryQuoteRspBO recoveryQuote(RecoveryQuoteReqBO reqBO) {
        RecoveryQuoteRspBO rspBO = new RecoveryQuoteRspBO();
        List<DIqrInquiryMatePO> iqrInquiryMatePOS = this.dIqrInquiryMateMapper.queryInquiryMateList(Integer.parseInt("2003"), new Date());
        if (!CollectionUtils.isEmpty(iqrInquiryMatePOS)) {
            for (DIqrInquiryMatePO inquiryMatePO : iqrInquiryMatePOS) {
                Long amount;
                List<DIqrQuotationPO> quoteList;
                List<DIqrQuotationPO> quotationPOS = this.dIqrQuotationMapper.selectByInquiryIdDocStatus(inquiryMatePO.getInquiryId(), "4002");
                if (CollectionUtils.isEmpty(quotationPOS) || quotationPOS.size() < inquiryMatePO.getLeastQuoteNum()) {
                    inquiryMatePO.setDocStatus(Integer.parseInt("2008"));
                    inquiryMatePO.setNodeStatus(Integer.parseInt("2105"));
                    this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(inquiryMatePO);
                }
                if ((CollectionUtils.isEmpty(quotationPOS) || quotationPOS.size() < inquiryMatePO.getLeastQuoteNum()) && inquiryMatePO.getPlanId() != null) {
                    DPlanMaterialPO planPO = new DPlanMaterialPO();
                    planPO.setPlanId(inquiryMatePO.getPlanId());
                    planPO.setDocStatus(Integer.parseInt("1006"));
                    this.dPlanMaterialMapper.updateStatusByPlanId(planPO);
                }
                if (!CollectionUtils.isEmpty(quotationPOS)) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.parseInt("4004"));
                    vo.setNodeStatus(Integer.parseInt("4104"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO dIqrQuotationPO : quotationPOS) {
                        quotationIds.add(dIqrQuotationPO.getQuotationId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                    DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                    dIqrQuotationPkgPO.setDocStatus(Integer.parseInt("4004"));
                    dIqrQuotationPkgPO.setNodeStatus(Integer.parseInt("4104"));
                    dIqrQuotationPkgPO.setQuotationIds(quotationIds);
                    this.dIqrQuotationPkgMapper.updateByQuotationIds(dIqrQuotationPkgPO);
                }
                if (!CollectionUtils.isEmpty(quoteList = this.dIqrQuotationMapper.selectByInquiryIdDocStatus(inquiryMatePO.getInquiryId(), "4001"))) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.parseInt("4005"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO quotationPO2 : quoteList) {
                        quotationIds.add(quotationPO2.getQuotationId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                    DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                    dIqrQuotationPkgPO.setDocStatus(Integer.parseInt("4005"));
                    dIqrQuotationPkgPO.setNodeStatus(Integer.parseInt("4105"));
                    dIqrQuotationPkgPO.setQuotationIds(quotationIds);
                    this.dIqrQuotationPkgMapper.updateByQuotationIds(dIqrQuotationPkgPO);
                }
                List<DIqrQuotationPO> allQuotationList = this.dIqrQuotationMapper.selectByInquiryId(inquiryMatePO.getInquiryId());
                List<DIqrQuotationPkgPO> allQuotationPkgList = this.dIqrQuotationPkgMapper.selectByInquiryId(inquiryMatePO.getInquiryId());
                List<DIqrQuotationItemPO> list = this.dIqrQuotationItemMapper.selectByInquiryId(inquiryMatePO.getInquiryId());
                ArrayList<DIqrQuotationPO> updateQuotationList = new ArrayList<DIqrQuotationPO>();
                ArrayList<DIqrQuotationPkgPO> updateQuotationPkgList = new ArrayList<DIqrQuotationPkgPO>();
                ArrayList<DIqrQuotationItemPO> updateQuotationItemList = new ArrayList<DIqrQuotationItemPO>();
                if (allQuotationList != null && allQuotationList.size() >= 0) {
                    for (DIqrQuotationPO dIqrQuotationPO : allQuotationList) {
                        if (!StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) continue;
                        amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
                        updateQuotationPO.setQuotationId(dIqrQuotationPO.getQuotationId());
                        updateQuotationPO.setAmountSec("");
                        updateQuotationPO.setAmount(amount);
                        updateQuotationList.add(updateQuotationPO);
                    }
                }
                if (allQuotationPkgList != null && allQuotationPkgList.size() >= 0) {
                    for (DIqrQuotationPkgPO dIqrQuotationPkgPO : allQuotationPkgList) {
                        if (!StringUtils.isNotEmpty((CharSequence)dIqrQuotationPkgPO.getAmountSec())) continue;
                        amount = QuoteUtil.decode(dIqrQuotationPkgPO.getAmountSec(), dIqrQuotationPkgPO.getQuotationId().toString());
                        DIqrQuotationPkgPO updateQuotationPkgPO = new DIqrQuotationPkgPO();
                        updateQuotationPkgPO.setQuotationPkgId(dIqrQuotationPkgPO.getQuotationPkgId());
                        updateQuotationPkgPO.setAmountSec("");
                        updateQuotationPkgPO.setAmount(amount);
                        updateQuotationPkgList.add(updateQuotationPkgPO);
                    }
                }
                if (list != null && list.size() >= 0) {
                    for (DIqrQuotationItemPO dIqrQuotationItemPO : list) {
                        if (StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec()) && StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) continue;
                        DIqrQuotationItemPO updateQuotationItemPO = new DIqrQuotationItemPO();
                        updateQuotationItemPO.setQuotationItemId(dIqrQuotationItemPO.getQuotationItemId());
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                            Long quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuoteAmountSec("");
                            updateQuotationItemPO.setQuoteAmount(quoteAmount);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                            Long quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuotePriceSec("");
                            updateQuotationItemPO.setQuotePrice(quotePrice);
                        }
                        updateQuotationItemList.add(updateQuotationItemPO);
                    }
                }
                if (!CollectionUtils.isEmpty(updateQuotationList)) {
                    this.dIqrQuotationMapper.updatePriceByIdList(updateQuotationList);
                }
                if (!CollectionUtils.isEmpty(updateQuotationPkgList)) {
                    this.dIqrQuotationPkgMapper.updatePriceByIdList(updateQuotationPkgList);
                }
                if (CollectionUtils.isEmpty(updateQuotationItemList)) continue;
                this.dIqrQuotationItemMapper.updatePriceByIdList(updateQuotationItemList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("");
        return rspBO;
    }
}

