/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.InquiryDetailBO;
import com.tydic.enquiry.api.performlist.bo.PackageBO;
import com.tydic.enquiry.api.performlist.bo.QryIqrPkgDetailReqBO;
import com.tydic.enquiry.api.performlist.bo.QryIqrPkgDetailRspBO;
import com.tydic.enquiry.api.performlist.service.QryIqrPkgDetailService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_UAT", serviceInterface=QryIqrPkgDetailService.class)
public class QryIqrPkgDetailServiceImpl
implements QryIqrPkgDetailService {
    private static final Logger log = LoggerFactory.getLogger(QryIqrPkgDetailServiceImpl.class);
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;

    public QryIqrPkgDetailRspBO qryIqrPkgDetail(QryIqrPkgDetailReqBO reqBO) {
        log.info("\u5165\u53c2\u6570\u636e\uff1areqBO.toString()=" + reqBO.toString());
        QryIqrPkgDetailRspBO rspBO = new QryIqrPkgDetailRspBO();
        List<DIqrInquiryMateItemPO> dIqrInquiryMateItemPOList = null;
        dIqrInquiryMateItemPOList = reqBO.getInquiryPkgId() != null && !"".equals(reqBO.getInquiryPkgId()) ? this.dIqrInquiryMateItemMapper.selectInquiryItemByPkgId(reqBO.getInquiryPkgId()) : this.dIqrInquiryMateItemMapper.selectInquiryItemByInquiryId(reqBO.getInquiryId());
        if (CollectionUtils.isNotEmpty(dIqrInquiryMateItemPOList)) {
            ArrayList<PackageBO> packageBOList = new ArrayList<PackageBO>();
            for (DIqrInquiryMateItemPO po : dIqrInquiryMateItemPOList) {
                PackageBO packageBO = new PackageBO();
                BeanUtils.copyProperties((Object)po, (Object)packageBO);
                try {
                    packageBO.setPkgTotalAmount(MoneyUtils.Long2BigDecimal((Long)po.getPkgTotalAmount()));
                    packageBO.setPkgCreateDate(DateUtils.dateToStr((Date)po.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                List<DIqrInquiryDetailPO> dIqrInquiryDetailPOList = this.dIqrInquiryDetailMapper.selectByInquiryPkgId(po.getInquiryPkgId());
                if (CollectionUtils.isNotEmpty(dIqrInquiryDetailPOList)) {
                    ArrayList<InquiryDetailBO> inquiryDetailBOList = new ArrayList<InquiryDetailBO>();
                    for (DIqrInquiryDetailPO detailPO : dIqrInquiryDetailPOList) {
                        InquiryDetailBO inquiryDetailBO = new InquiryDetailBO();
                        log.info("detailPO.getInquiryItemId()=" + detailPO.getInquiryItemId());
                        BeanUtils.copyProperties((Object)detailPO, (Object)inquiryDetailBO);
                        try {
                            inquiryDetailBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)detailPO.getGoodsNumber()));
                            inquiryDetailBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)detailPO.getBudgetPrice()));
                            inquiryDetailBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)detailPO.getBudgetAmount()));
                            inquiryDetailBO.setEvalAmount(MoneyUtils.Long2BigDecimal((Long)detailPO.getEvalAmount()));
                            inquiryDetailBO.setOriginalAmount(MoneyUtils.Long2BigDecimal((Long)detailPO.getOriginalAmount()));
                            inquiryDetailBO.setShowAmount(MoneyUtils.Long2BigDecimal((Long)detailPO.getShowAmount()));
                        }
                        catch (Exception e) {
                            log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                            rspBO.setRespCode("9999");
                            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                        }
                        inquiryDetailBOList.add(inquiryDetailBO);
                    }
                    packageBO.setDetailList(inquiryDetailBOList);
                }
                packageBOList.add(packageBO);
            }
            rspBO.setPackageList(packageBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\uff1arspBO.toString()=" + rspBO.toString());
        return rspBO;
    }
}

