/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.PurchaseNoticeBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeRegistReqBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeRegistRspBO;
import com.tydic.enquiry.api.performlist.service.QryNoticeRegistService;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_UAT", serviceInterface=QryNoticeRegistService.class)
public class QryNoticeRegistServiceImpl
implements QryNoticeRegistService {
    private static final Logger log = LoggerFactory.getLogger(QryNoticeRegistServiceImpl.class);
    @Autowired
    private DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryNoticeRegistRspBO qryNoticeRegistInfo(QryNoticeRegistReqBO reqBO) {
        log.info("QryNoticeRegistReqBO\u5165\u53c2\u6570\u636e\u4fe1\u606f******************" + reqBO);
        QryNoticeRegistRspBO rspBO = new QryNoticeRegistRspBO();
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<DIqrPurchaseNoticePO> dIqrPurchaseNoticePOList = null;
        if (!"ALL".equals(reqBO.getPurchaseMethod())) {
            map.put("purchaseMethod", reqBO.getPurchaseMethod());
        }
        map.put("purchaseId", reqBO.getPurchaseId());
        map.put("inquiryCode", reqBO.getInquiryCode());
        map.put("inquiryName", reqBO.getInquiryName());
        map.put("busiType", reqBO.getBusiType());
        map.put("supplierId", reqBO.getSupplierId());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLimitQuoteDate())) {
            map.put("limitQuoteDate", DateUtils.strToDate((String)reqBO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ("Y".equals(reqBO.getIsPagination())) {
            try {
                dIqrPurchaseNoticePOList = this.dIqrPurchaseNoticeMapper.queryHadRegistForDealForPage(map, (Page<Map<String, Object>>)page);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc(e.toString());
                log.error("\u5f02\u5e38\u4fe1\u606f\uff1ae=" + e.toString());
                return rspBO;
            }
        } else {
            dIqrPurchaseNoticePOList = this.dIqrPurchaseNoticeMapper.queryHadRegistForDealNoPage(map);
        }
        log.info("***************** end");
        if (CollectionUtils.isNotEmpty(dIqrPurchaseNoticePOList)) {
            ArrayList<PurchaseNoticeBO> purchaseNoticeBOList = new ArrayList<PurchaseNoticeBO>();
            for (DIqrPurchaseNoticePO po : dIqrPurchaseNoticePOList) {
                PurchaseNoticeBO purchaseNoticeBO = new PurchaseNoticeBO();
                BeanUtils.copyProperties((Object)po, (Object)purchaseNoticeBO);
                purchaseNoticeBO.setRegistBeginDate(DateUtils.dateToStr((Date)po.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                purchaseNoticeBO.setRegistEndDate(DateUtils.dateToStr((Date)po.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                purchaseNoticeBO.setQuoteBeginDate(DateUtils.dateToStr((Date)po.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                purchaseNoticeBO.setQuoteEndDate(DateUtils.dateToStr((Date)po.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                purchaseNoticeBO.setRegistTimeReq(DateUtils.dateToStr((Date)po.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss") + " \u81f3 " + DateUtils.dateToStr((Date)po.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                purchaseNoticeBO.setQuoteTimeReq(DateUtils.dateToStr((Date)po.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss") + " \u81f3 " + DateUtils.dateToStr((Date)po.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (po.getDocType() != null) {
                    purchaseNoticeBO.setPurchaseMethod(Integer.valueOf(Integer.parseInt(po.getDocType())));
                }
                purchaseNoticeBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", po.getDocType()));
                purchaseNoticeBOList.add(purchaseNoticeBO);
            }
            rspBO.setRows(purchaseNoticeBOList);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

