/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.performlist.bo.NoticeBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeReqBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeRspBO;
import com.tydic.enquiry.api.performlist.service.QryNoticeService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrConfirmNoticeMapper;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.po.DIqrConfirmNoticePO;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_UAT", serviceInterface=QryNoticeService.class)
public class QryNoticeServiceImpl
implements QryNoticeService {
    private static final Logger log = LoggerFactory.getLogger(QryNoticeServiceImpl.class);
    @Autowired
    DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    DIqrConfirmNoticeMapper dIqrConfirmNoticeMapper;

    public QryNoticeRspBO qryNotice(QryNoticeReqBO reqBO) {
        log.info("QryNoticeService\u5165\u53c2\u6570\u636e\u4fe1\u606f" + reqBO);
        QryNoticeRspBO rspBO = new QryNoticeRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiType())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (null == reqBO.getType()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            NoticeBO noticeBO;
            ArrayList<NoticeBO> purchaseNoticeBOList;
            Page page;
            HashMap<String, Object> map;
            if (Constants.NOTICE_TYPE_1.equals(reqBO.getType())) {
                map = new HashMap<String, Object>();
                page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
                map.put("busiType", reqBO.getBusiType());
                map.put("purchaseMethod", Constants.PURCHASE_METHOD_PUB);
                List<DIqrPurchaseNoticePO> dIqrPurchaseNoticePOList = null;
                dIqrPurchaseNoticePOList = "Y".equals(reqBO.getIsPagination()) ? this.dIqrPurchaseNoticeMapper.queryRegistForPage(map, (Page<Map<String, Object>>)page) : this.dIqrPurchaseNoticeMapper.queryHadRegistForDealNoPage(map);
                if (CollectionUtils.isNotEmpty(dIqrPurchaseNoticePOList)) {
                    purchaseNoticeBOList = new ArrayList<NoticeBO>();
                    for (DIqrPurchaseNoticePO dIqrPurchaseNoticePO : dIqrPurchaseNoticePOList) {
                        noticeBO = new NoticeBO();
                        BeanUtils.copyProperties((Object)dIqrPurchaseNoticePO, (Object)noticeBO);
                        noticeBO.setPlanUnit(dIqrPurchaseNoticePO.getPurchaseId());
                        noticeBO.setPlanUnitName(dIqrPurchaseNoticePO.getPurchaseName());
                        noticeBO.setPublishTime(DateUtils.dateToStrLong((Date)dIqrPurchaseNoticePO.getPublishTime()));
                        purchaseNoticeBOList.add(noticeBO);
                    }
                    rspBO.setRows(purchaseNoticeBOList);
                    rspBO.setPageNo(page.getPageNo());
                } else {
                    rspBO.setPageNo(1);
                    rspBO.setRows(Collections.EMPTY_LIST);
                }
                rspBO.setTotal(page.getTotalPages());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            }
            if (Constants.NOTICE_TYPE_2.equals(reqBO.getType())) {
                map = new HashMap();
                page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
                map.put("busiType", reqBO.getBusiType());
                map.put("purchaseMethod", Constants.PURCHASE_METHOD_PUB);
                List<DIqrConfirmNoticePO> dIqrConfirmNoticePOList = null;
                dIqrConfirmNoticePOList = "Y".equals(reqBO.getIsPagination()) ? this.dIqrConfirmNoticeMapper.queryNoticeForPage(map, (Page<Map<String, Object>>)page) : this.dIqrConfirmNoticeMapper.queryNoticeNoPage(map);
                if (CollectionUtils.isNotEmpty(dIqrConfirmNoticePOList)) {
                    purchaseNoticeBOList = new ArrayList();
                    for (DIqrConfirmNoticePO dIqrConfirmNoticePO : dIqrConfirmNoticePOList) {
                        noticeBO = new NoticeBO();
                        BeanUtils.copyProperties((Object)dIqrConfirmNoticePO, (Object)noticeBO);
                        noticeBO.setPlanUnit(dIqrConfirmNoticePO.getPurchaseId());
                        noticeBO.setPlanUnitName(dIqrConfirmNoticePO.getPurchaseName());
                        noticeBO.setPublishTime(DateUtils.dateToStrLong((Date)dIqrConfirmNoticePO.getPublishTime()));
                        purchaseNoticeBOList.add(noticeBO);
                    }
                    rspBO.setRows(purchaseNoticeBOList);
                    rspBO.setPageNo(page.getPageNo());
                } else {
                    rspBO.setPageNo(1);
                    rspBO.setRows(Collections.EMPTY_LIST);
                }
                rspBO.setTotal(page.getTotalPages());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u516c\u544a\u5217\u8868\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

