/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillPkgListReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillPkgListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.service.QryQuotationBillPkgListService;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_UAT", serviceInterface=QryQuotationBillPkgListService.class)
public class QryQuotationBillPkgListServiceImpl
implements QryQuotationBillPkgListService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationBillPkgListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;

    public QryQuotationBillPkgListRspBO qryQuotationBillPkgList(QryQuotationBillPkgListReqBO reqBO) {
        QryQuotationBillPkgListRspBO rspBO = new QryQuotationBillPkgListRspBO();
        ArrayList<QuotationPackageBO> quotePackageList = new ArrayList<QuotationPackageBO>();
        DIqrQuotationPO dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
        if (dIqrQuotationPO == null || !"1".equals(dIqrQuotationPO.getHisStatus())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u4e3a\u5386\u53f2\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(dIqrQuotationPO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u5bf9\u5e94\u7684\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (dIqrInquiryMatePO.getDelayCnt() != null && dIqrInquiryMatePO.getDelayCnt() > 0) {
            rspBO.setIsDelay(Integer.valueOf(1));
        }
        rspBO.setDelayCnt(dIqrInquiryMatePO.getDelayCnt());
        rspBO.setDelayLengthTime(dIqrInquiryMatePO.getDelayLengthTime());
        rspBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        rspBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        List<DIqrInquiryMateItemPO> dIqrInquiryMateItemPOList = this.dIqrInquiryMateItemMapper.selectInquiryItemByInquiryId(dIqrQuotationPO.getInquiryId());
        if (CollectionUtils.isEmpty(dIqrInquiryMateItemPOList)) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728\u5305\u4fe1\u606f\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        List<DIqrQuotationPkgPO> dIqrQuotationPkgPOList = this.dIqrQuotationPkgMapper.selectByQuotationId(reqBO.getQuotationId());
        if (CollectionUtils.isEmpty(dIqrQuotationPkgPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        for (DIqrQuotationPkgPO dIqrQuotationPkgPO : dIqrQuotationPkgPOList) {
            for (DIqrInquiryMateItemPO dIqrInquiryMateItemPO : dIqrInquiryMateItemPOList) {
                if (!dIqrInquiryMateItemPO.getInquiryPkgId().equals(dIqrQuotationPkgPO.getInquiryPkgId())) continue;
                QuotationPackageBO quotationPackageBO = new QuotationPackageBO();
                quotationPackageBO.setInquiryId(dIqrInquiryMateItemPO.getInquiryId());
                quotationPackageBO.setInquiryPkgId(dIqrInquiryMateItemPO.getInquiryPkgId());
                quotationPackageBO.setPkgOrderNo(dIqrInquiryMateItemPO.getInquiryPkgId());
                quotationPackageBO.setPkgCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMateItemPO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                try {
                    Long amount = dIqrQuotationPkgPO.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPkgPO.getAmountSec())) {
                        amount = QuoteUtil.decode(dIqrQuotationPkgPO.getAmountSec(), dIqrQuotationPkgPO.getQuotationId().toString());
                    }
                    quotationPackageBO.setPkgTotalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryMateItemPO.getPkgTotalAmount()));
                    quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                quotationPackageBO.setDetailNum(dIqrQuotationPkgPO.getQuotePkgDetailNum());
                quotationPackageBO.setQuotationId(dIqrQuotationPkgPO.getQuotationId());
                quotationPackageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                quotationPackageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
                quotationPackageBO.setQuotationSubmitTime(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                quotePackageList.add(quotationPackageBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u5305\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        rspBO.setPackageList(quotePackageList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

