/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.atom.dictionary.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.enquiry.api.dictionary.bo.SCodeDictionariesBO;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.dao.SCodeDictionariesMapper;
import com.tydic.enquiry.dao.SCodeTypeMapper;
import com.tydic.enquiry.po.SCodeDictionariesPO;
import com.tydic.enquiry.po.SCodeTypePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="QryDicAtomService")
public class QryDicAtomServiceImpl
implements QryDicAtomService {
    private static final Logger log = LoggerFactory.getLogger(QryDicAtomServiceImpl.class);
    @Autowired
    private SCodeDictionariesMapper sCodeDictionariesMapper;
    @Autowired
    private SCodeTypeMapper sCodeTypeMapper;
    @Autowired
    private CacheClient cacheClient;

    public void initDicCached() {
        log.info("\u542f\u52a8\u52a0\u8f7d\u5b57\u5178\u8868\u5165redis");
        List<SCodeDictionariesPO> dicPOList = null;
        try {
            dicPOList = this.sCodeDictionariesMapper.selectAll();
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5b57\u5178\u8868\u5931\u8d25\uff1a" + e2.getMessage());
        }
        if (CollectionUtils.isEmpty(dicPOList)) {
            return;
        }
        this.setToCache(dicPOList);
        List<SCodeTypePO> sCodeTypePOList = this.sCodeTypeMapper.getAllTypeCode();
        for (SCodeTypePO po : sCodeTypePOList) {
            List<SCodeDictionariesPO> cachedDictionariesList = this.sCodeDictionariesMapper.selectByTypeCode(po.getTypeCode());
            if (CollectionUtils.isEmpty(cachedDictionariesList)) continue;
            log.info("po.getTypeCode()=" + po.getTypeCode());
            List<SCodeDictionariesBO> codeDictionariesList = cachedDictionariesList.stream().map(e -> {
                SCodeDictionariesBO dicBO = new SCodeDictionariesBO();
                BeanUtils.copyProperties((Object)e, (Object)dicBO);
                return dicBO;
            }).collect(Collectors.toList());
            this.setToCacheList(po.getTypeCode(), codeDictionariesList);
        }
        log.debug("\u5b57\u5178\u8868\u521d\u59cb\u5316\u52a0\u8f7d\u5b8c\u6bd5");
    }

    public String getDicCodeName(String typeCode, String code) {
        String key = "DIC_" + typeCode + "_" + code;
        Object valueObj = null;
        try {
            valueObj = this.cacheClient.get(key);
        }
        catch (Exception e) {
            log.error("\u4ece\u7f13\u5b58\u4e2d\u67e5\u8be2\u3010" + key + "\u3011\u5931\u8d25");
        }
        if (null != valueObj) {
            return valueObj.toString();
        }
        SCodeDictionariesPO codeDictionariesPO = null;
        try {
            codeDictionariesPO = this.sCodeDictionariesMapper.selectByTypeCodeAndCode(typeCode, code);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u3010" + key + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null == codeDictionariesPO) {
            return null;
        }
        try {
            this.cacheClient.set(key, (Object)codeDictionariesPO.getCodeTitle());
        }
        catch (Exception e) {
            log.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return codeDictionariesPO.getCodeTitle();
    }

    public List<SCodeDictionariesBO> listDicByTypeCode(String typeCode) {
        log.info("listDicByTypeCode::typeCode=" + typeCode);
        if (StringUtils.isBlank((CharSequence)typeCode)) {
            log.error("\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        log.info("listDicByTypeCode::codeDictionarieslist");
        List codeDictionariesList = null;
        try {
            log.info("listDicByTypeCode::KeyCodeConstant.DEFAULT_DICLIST_PREFIX_CODE=DICLIST_");
            Object obj = this.cacheClient.get("DICLIST_" + typeCode);
            log.info("listDicByTypeCode::obj=" + obj);
            if (null != obj) {
                codeDictionariesList = (List)obj;
            } else {
                log.info("listDicByTypeCode::selectByTypeCode:typeCode=" + typeCode);
                List<SCodeDictionariesPO> codeDictionariesPOS = this.sCodeDictionariesMapper.selectByTypeCode(typeCode);
                if (CollectionUtils.isEmpty(codeDictionariesPOS)) {
                    return null;
                }
                codeDictionariesList = codeDictionariesPOS.stream().map(e -> {
                    SCodeDictionariesBO dicBO = new SCodeDictionariesBO();
                    BeanUtils.copyProperties((Object)e, (Object)dicBO);
                    return dicBO;
                }).collect(Collectors.toList());
                this.cacheClient.set("DICLIST_" + typeCode, codeDictionariesList);
            }
            return codeDictionariesList;
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8f6c\u4e49\u7801\u5931\u8d25\uff1a" + e2.getMessage());
            return null;
        }
    }

    public List<SCodeDictionariesBO> listDicByTypeCodeAndParent(String typeCode, String parentCode) {
        if (StringUtils.isBlank((CharSequence)typeCode)) {
            log.error("\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List codeDictionariesList = null;
        try {
            Object obj = this.cacheClient.get("DIC_" + typeCode + "_" + parentCode);
            if (null != obj) {
                codeDictionariesList = (List)obj;
            } else {
                List<SCodeDictionariesPO> codeDictionariesPOS = this.sCodeDictionariesMapper.selectCodeList(typeCode, parentCode);
                if (CollectionUtils.isEmpty(codeDictionariesPOS)) {
                    return null;
                }
                codeDictionariesList = codeDictionariesPOS.stream().map(e -> {
                    SCodeDictionariesBO dicBO = new SCodeDictionariesBO();
                    BeanUtils.copyProperties((Object)e, (Object)dicBO);
                    return dicBO;
                }).collect(Collectors.toList());
                this.cacheClient.set("DIC_" + typeCode + "_" + parentCode, codeDictionariesList);
            }
            return codeDictionariesList;
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8f6c\u4e49\u7801\u5931\u8d25\uff1a" + e2.getMessage());
            return null;
        }
    }

    public Map<String, String> mapDicByTypeCode(String typeCode) {
        if (StringUtils.isBlank((CharSequence)typeCode)) {
            log.error("\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List<SCodeDictionariesBO> cachedDictionariesPOS = this.listDicByTypeCode(typeCode);
        if (CollectionUtils.isEmpty(cachedDictionariesPOS)) {
            return null;
        }
        try {
            for (SCodeDictionariesBO cachedDictionariesPO : cachedDictionariesPOS) {
                result.put(cachedDictionariesPO.getCode(), cachedDictionariesPO.getCodeTitle());
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8f6c\u4e49\u7801\u5931\u8d25\uff1a", (Throwable)e);
        }
        return result;
    }

    public void refreshDicCached(String typeCode) {
        log.info("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58" + typeCode);
        try {
            this.cacheClient.delete("DICLIST_" + typeCode);
            Set keys = this.cacheClient.getkeys("DIC_" + typeCode + "*");
            if (CollectionUtils.isNotEmpty((Collection)keys)) {
                for (String key : keys) {
                    this.cacheClient.delete(key);
                }
            }
        }
        catch (Exception e2) {
            log.error("\u6e05\u9664\u7f13\u5b58\u3010" + typeCode + "\u3011\u5931\u8d25");
        }
        List<SCodeDictionariesPO> pos = null;
        try {
            pos = this.sCodeDictionariesMapper.selectByTypeCode(typeCode);
        }
        catch (Exception e3) {
            log.error("\u6839\u636e\u7236\u7ea7\u7f16\u7801\u67e5\u8be2\u7801\u8868\u5931\u8d25\uff1a" + e3.getMessage());
        }
        if (CollectionUtils.isEmpty(pos)) {
            return;
        }
        List<SCodeDictionariesBO> codeDictionariesList = pos.stream().map(e -> {
            SCodeDictionariesBO dicBO = new SCodeDictionariesBO();
            BeanUtils.copyProperties((Object)e, (Object)dicBO);
            return dicBO;
        }).collect(Collectors.toList());
        this.setToCacheList(typeCode, codeDictionariesList);
        this.setToCache(pos);
        log.info("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u5b8c\u6bd5");
    }

    public List<SCodeDictionariesBO> getAllDicList() {
        ArrayList<SCodeDictionariesBO> dicAllList = new ArrayList<SCodeDictionariesBO>();
        try {
            Set keys = this.cacheClient.getkeys("DICLIST_*");
            if (CollectionUtils.isNotEmpty((Collection)keys)) {
                List codeDictionariesList = null;
                for (String key : keys) {
                    Object obj = this.cacheClient.get(key);
                    if (null == obj) continue;
                    codeDictionariesList = (List)obj;
                    for (SCodeDictionariesBO sCodeDictionariesBO : codeDictionariesList) {
                        dicAllList.add(sCodeDictionariesBO);
                    }
                }
            } else {
                List<SCodeTypePO> sCodeTypePOList = this.sCodeTypeMapper.getAllTypeCode();
                for (SCodeTypePO po : sCodeTypePOList) {
                    List<SCodeDictionariesPO> cachedDictionariesList = this.sCodeDictionariesMapper.selectByTypeCode(po.getTypeCode());
                    if (CollectionUtils.isEmpty(cachedDictionariesList)) continue;
                    log.info("po.getTypeCode()=" + po.getTypeCode());
                    List<SCodeDictionariesBO> codeDictionariesList = cachedDictionariesList.stream().map(e -> {
                        SCodeDictionariesBO dicBO = new SCodeDictionariesBO();
                        BeanUtils.copyProperties((Object)e, (Object)dicBO);
                        dicAllList.add(dicBO);
                        return dicBO;
                    }).collect(Collectors.toList());
                    this.setToCacheList(po.getTypeCode(), codeDictionariesList);
                }
            }
            return dicAllList;
        }
        catch (Exception e2) {
            log.error("\u53d6\u5168\u91cf\u6570\u636e\u5931\u8d25" + e2.getMessage());
            return null;
        }
    }

    private void setToCache(List<SCodeDictionariesPO> codeDictionariesPOS) {
        for (SCodeDictionariesPO po : codeDictionariesPOS) {
            String key = "DIC_" + po.getTypeCode() + "_" + po.getCode();
            String value = po.getCodeTitle();
            try {
                this.cacheClient.set(key, (Object)value);
            }
            catch (Exception e) {
                log.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void setToCacheList(String typeCode, List<SCodeDictionariesBO> cachedDictionariesBOS) {
        String key = "DICLIST_" + typeCode;
        try {
            this.cacheClient.set(key, cachedDictionariesBOS);
        }
        catch (Exception e) {
            log.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

