/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.QuotationItemInfo;
import com.tydic.enquiry.api.performlist.bo.UpdateQuotationBillItemReqBO;
import com.tydic.enquiry.api.performlist.bo.UpdateQuotationBillItemRspBO;
import com.tydic.enquiry.api.performlist.service.UpdateQuotationBillItemService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMidMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemMidPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.UpdateQuotationBillItemService"})
public class UpdateQuotationBillItemServiceImpl
implements UpdateQuotationBillItemService {
    private static final Logger log = LoggerFactory.getLogger(UpdateQuotationBillItemServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationItemMidMapper dIqrQuotationItemMidMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;

    @PostMapping(value={"upQuotationBillItem"})
    public UpdateQuotationBillItemRspBO upQuotationBillItem(@RequestBody UpdateQuotationBillItemReqBO reqBO) {
        UpdateQuotationBillItemRspBO rspBO = new UpdateQuotationBillItemRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getQuotationId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((String)reqBO.getRedisNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355RedisNo\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getQuotationItemList() || reqBO.getQuotationItemList().size() <= 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            Date nowDate;
            DIqrQuotationPO quotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
            if (quotationPO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(quotationPO.getInquiryId());
            if (inquiryMatePO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8be5\u62a5\u4ef7\u5355\u5bf9\u5e94\u7684\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if (inquiryMatePO.getDocStatus() == null || !"2003".equals(inquiryMatePO.getDocStatus().toString())) {
                rspBO.setRespCode("9900");
                rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u4e0d\u53ef\u4ee5\u8fdb\u884c\u62a5\u4ef7\uff01");
                return rspBO;
            }
            rspBO = this.initParam(reqBO, quotationPO.getBusiType(), quotationPO.getDocType(), inquiryMatePO.getTotalPriceFlag());
            if ("9999".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            Date limitQuoteDate = inquiryMatePO.getLimitQuoteDate();
            Date quoteEndDate = inquiryMatePO.getQuoteEndDate();
            if (quoteEndDate.before(nowDate = new Date())) {
                rspBO.setRespCode("9900");
                rspBO.setRespDesc("\u62a5\u4ef7\u65f6\u95f4\u5df2\u8fc7\u4e0d\u53ef\u62a5\u4ef7\uff01");
                return rspBO;
            }
            if (limitQuoteDate.after(nowDate)) {
                rspBO.setRespCode("9900");
                rspBO.setRespDesc("\u62a5\u4ef7\u65f6\u95f4\u8fd8\u672a\u5f00\u59cb\u4e0d\u53ef\u62a5\u4ef7\uff01");
                return rspBO;
            }
            if ("21".equals(inquiryMatePO.getDocType()) && !quotationPO.getDocStatus().toString().equals("4001") || "22".equals(inquiryMatePO.getDocType()) && "4002".equals(quotationPO.getDocStatus().toString()) && Integer.parseInt(quotationPO.getQuoteRounds()) >= quotationPO.getQuoteTimeLimit()) {
                rspBO.setRespCode("9900");
                rspBO.setRespDesc("\u5f53\u524d\u5355\u636e\u8fd8\u672a\u5f00\u59cb\u4e0b\u4e00\u6b21\u62a5\u4ef7\u6216\u62a5\u4ef7\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7!");
                return rspBO;
            }
            HashMap<Long, BigDecimal> quotationItemQriceMap = new HashMap<Long, BigDecimal>();
            DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
            ArrayList<Integer> docStatusList = new ArrayList<Integer>();
            docStatusList.add(Integer.valueOf("4002"));
            docStatusList.add(Integer.valueOf("4004"));
            docStatusList.add(Integer.valueOf("4006"));
            qryQuotationPO.setInquiryId(quotationPO.getInquiryId());
            qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
            qryQuotationPO.setHisStatus("1");
            qryQuotationPO.setDocStatusList(docStatusList);
            if (inquiryMatePO.getComparedQuoteType() != null && "3".equals(inquiryMatePO.getComparedQuoteType())) {
                qryQuotationPO.setQuotationId(reqBO.getQuotationId());
            }
            List<DIqrQuotationPO> effectiveQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
            if ("23".equals(inquiryMatePO.getDocType()) && CollectionUtils.isNotEmpty(effectiveQuotationPOList)) {
                ArrayList<Long> effectiveQuotationId = new ArrayList<Long>();
                for (DIqrQuotationPO dIqrQuotationPO : effectiveQuotationPOList) {
                    effectiveQuotationId.add(dIqrQuotationPO.getQuotationId());
                }
                DIqrQuotationItemPO effectiveQuotationItemPO = new DIqrQuotationItemPO();
                effectiveQuotationItemPO.setQuotationIds(effectiveQuotationId);
                effectiveQuotationItemPO.setIsValidAmount(1);
                List<DIqrQuotationItemPO> effectiveQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationItem(effectiveQuotationItemPO);
                for (DIqrQuotationItemPO dIqrQuotationItemPO : effectiveQuotationItemPOList) {
                    Long quoteAmount = dIqrQuotationItemPO.getQuoteAmount();
                    if (StringUtils.isNotEmpty((String)dIqrQuotationItemPO.getQuoteAmountSec())) {
                        quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    if (quotationItemQriceMap.size() <= 0 || quotationItemQriceMap.get(dIqrQuotationItemPO.getInquiryItemId()) == null) {
                        quotationItemQriceMap.put(dIqrQuotationItemPO.getInquiryItemId(), MoneyUtils.Long2BigDecimal((Long)quoteAmount));
                        continue;
                    }
                    if (inquiryMatePO.getComparedQuoteType() != null && "1".equals(inquiryMatePO.getComparedQuoteType()) && MoneyUtils.Long2BigDecimal((Long)quoteAmount).compareTo((BigDecimal)quotationItemQriceMap.get(dIqrQuotationItemPO.getInquiryItemId())) > 0) {
                        quotationItemQriceMap.put(dIqrQuotationItemPO.getInquiryItemId(), MoneyUtils.Long2BigDecimal((Long)quoteAmount));
                        continue;
                    }
                    if (inquiryMatePO.getComparedQuoteType() == null || !"2".equals(inquiryMatePO.getComparedQuoteType()) || MoneyUtils.Long2BigDecimal((Long)quoteAmount).compareTo((BigDecimal)quotationItemQriceMap.get(dIqrQuotationItemPO.getInquiryItemId())) >= 0) continue;
                    quotationItemQriceMap.put(dIqrQuotationItemPO.getInquiryItemId(), MoneyUtils.Long2BigDecimal((Long)quoteAmount));
                }
                log.info("\u62a5\u4ef7\u5355\u6700\u4f4e/\u6700\u9ad8\u62a5\u4ef7\u4fe1\u606f\uff1a" + JSON.toJSONString(quotationItemQriceMap));
            }
            List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationId(reqBO.getQuotationId());
            ArrayList<DIqrQuotationItemMidPO> dIqrQuotationItemMidPOList = new ArrayList<DIqrQuotationItemMidPO>();
            for (QuotationItemInfo quotationItemInfo : reqBO.getQuotationItemList()) {
                String offerIncreaseName;
                String comparedQuoteName;
                DIqrQuotationItemMidPO dIqrQuotationItemMidPO = new DIqrQuotationItemMidPO();
                BigDecimal quotationAmount = new BigDecimal("0");
                BigDecimal mostQuotationItemQrice = new BigDecimal("0");
                BigDecimal proportion = new BigDecimal("0");
                BigDecimal price = new BigDecimal("0");
                BigDecimal hundred = new BigDecimal("100");
                if ("23".equals(inquiryMatePO.getDocType()) && StringUtils.isNotEmpty((String)inquiryMatePO.getOfferIncreaseValue())) {
                    proportion = new BigDecimal(inquiryMatePO.getOfferIncreaseValue()).divide(hundred);
                    price = new BigDecimal(inquiryMatePO.getOfferIncreaseValue());
                }
                if ("23".equals(inquiryMatePO.getDocType()) && inquiryMatePO.getQuoteMethod() != null && "2".equals(inquiryMatePO.getQuoteMethod().toString()) && quotationItemQriceMap.size() > 0 && quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId()) != null && "2".equals(inquiryMatePO.getBusiType()) && "1".equals(inquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = (BigDecimal)quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId());
                    mostQuotationItemQrice = mostQuotationItemQrice.multiply(proportion.add(new BigDecimal("1"))).setScale(2, 4);
                } else if ("23".equals(inquiryMatePO.getDocType()) && inquiryMatePO.getQuoteMethod() != null && "2".equals(inquiryMatePO.getQuoteMethod().toString()) && quotationItemQriceMap.size() > 0 && quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId()) != null && "2".equals(inquiryMatePO.getBusiType()) && "2".equals(inquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = (BigDecimal)quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId());
                    mostQuotationItemQrice = mostQuotationItemQrice.add(price);
                } else if ("23".equals(inquiryMatePO.getDocType()) && inquiryMatePO.getQuoteMethod() != null && "2".equals(inquiryMatePO.getQuoteMethod().toString()) && quotationItemQriceMap.size() > 0 && quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId()) != null && !"2".equals(inquiryMatePO.getBusiType()) && "1".equals(inquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = (BigDecimal)quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId());
                    mostQuotationItemQrice = mostQuotationItemQrice.multiply(new BigDecimal("1").subtract(proportion)).setScale(2, 4);
                } else if ("23".equals(inquiryMatePO.getDocType()) && inquiryMatePO.getQuoteMethod() != null && "2".equals(inquiryMatePO.getQuoteMethod().toString()) && quotationItemQriceMap.size() > 0 && quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId()) != null && !"2".equals(inquiryMatePO.getBusiType()) && "2".equals(inquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = (BigDecimal)quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId());
                    mostQuotationItemQrice = mostQuotationItemQrice.subtract(price);
                }
                String materialName = "";
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
                    if (quotationItemInfo.getQuotationItemId().longValue() == dIqrQuotationItemPO.getQuotationItemId().longValue() && quotationItemInfo.getQuotePrice() != null && quotationItemInfo.getQuotePrice().compareTo(BigDecimal.ZERO) > 0) {
                        quotationAmount = quotationItemInfo.getQuotePrice().multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    }
                    if (StringUtils.isNotBlank((String)dIqrQuotationItemPO.getQuotePriceSec())) {
                        dIqrQuotationItemPO.setQuotePrice(QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString()));
                    }
                    if (quotationItemInfo.getQuotationItemId().longValue() == dIqrQuotationItemPO.getQuotationItemId().longValue() && dIqrQuotationItemPO.getQuotePrice() != null && dIqrQuotationItemPO.getQuotePrice() > 0L && quotationItemInfo.getQuotePrice() != null && quotationItemInfo.getQuotePrice().compareTo(BigDecimal.ZERO) > 0) {
                        if (!"2".equals(inquiryMatePO.getBusiType()) && "22".equals(inquiryMatePO.getDocType()) && quotationItemInfo.getQuotePrice().compareTo(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getQuotePrice())) > 0) {
                            rspBO.setRespCode("9900");
                            rspBO.setRespDesc("\u591a\u6b21\u8bae\u4ef7\uff0c\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u4e0a\u6b21\u62a5\u4ef7\u5355\u4ef7\uff01");
                            return rspBO;
                        }
                        if ("2".equals(inquiryMatePO.getBusiType()) && "22".equals(inquiryMatePO.getDocType()) && quotationItemInfo.getQuotePrice().compareTo(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getQuotePrice())) < 0) {
                            rspBO.setRespCode("9900");
                            rspBO.setRespDesc("\u591a\u6b21\u8bae\u4ef7\uff0c\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u4e0a\u6b21\u62a5\u4ef7\u5355\u4ef7\uff01");
                            return rspBO;
                        }
                        if (!"2".equals(inquiryMatePO.getBusiType()) && "23".equals(inquiryMatePO.getDocType()) && quotationItemInfo.getQuotePrice().compareTo(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getBudgetPrice())) > 0) {
                            rspBO.setRespCode("9900");
                            rspBO.setRespDesc("\u7ade\u4ef7\u5355\uff0c\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u9884\u7b97\u5355\u4ef7\uff01");
                            return rspBO;
                        }
                        if ("2".equals(inquiryMatePO.getBusiType()) && "23".equals(inquiryMatePO.getDocType()) && quotationItemInfo.getQuotePrice().compareTo(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getBudgetPrice())) < 0) {
                            rspBO.setRespCode("9900");
                            rspBO.setRespDesc("\u7ade\u4ef7\u5355\uff0c\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u4e0a\u6b21\u9884\u7b97\u5355\u4ef7\uff01");
                            return rspBO;
                        }
                    }
                    if (quotationItemInfo.getQuotationItemId().longValue() != dIqrQuotationItemPO.getQuotationItemId().longValue()) continue;
                    dIqrQuotationItemMidPO.setQuotationId(dIqrQuotationItemPO.getQuotationId());
                    materialName = dIqrQuotationItemPO.getMaterialName();
                    break;
                }
                log.info("\u62a5\u4ef7\u6700\u9ad8/\u6700\u4f4e\u91d1\u989d\u4e3a\uff1amostQuotationItemQrice=" + mostQuotationItemQrice);
                if (!"2".equals(inquiryMatePO.getBusiType()) && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && quotationAmount.compareTo(mostQuotationItemQrice) > 0) {
                    comparedQuoteName = "";
                    comparedQuoteName = "2".equals(inquiryMatePO.getComparedQuoteType()) ? "\u6700\u4f4e\u62a5\u4ef7" : "\u4e0a\u6b21\u62a5\u4ef7";
                    offerIncreaseName = "";
                    offerIncreaseName = "1".equals(inquiryMatePO.getOfferIncreaseType()) ? "\u4f4e" + price + "%\u4ee5\u4e0a" : "\u4f4e" + price + "\u5143\u4ee5\u4e0a";
                    rspBO.setRespCode("9900");
                    rspBO.setRespDesc("\u5f53\u524d\u5355\u9879\u660e\u7ec6(" + materialName + ")\u62a5\u4ef7\u5fc5\u987b\u6bd4" + comparedQuoteName + "(" + quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId()) + "\u5143)" + offerIncreaseName + "!!!");
                    return rspBO;
                }
                if ("2".equals(inquiryMatePO.getBusiType()) && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && quotationAmount.compareTo(mostQuotationItemQrice) < 0) {
                    comparedQuoteName = "";
                    comparedQuoteName = "1".equals(inquiryMatePO.getComparedQuoteType()) ? "\u6700\u9ad8\u62a5\u4ef7" : "\u4e0a\u6b21\u62a5\u4ef7";
                    offerIncreaseName = "";
                    offerIncreaseName = "1".equals(inquiryMatePO.getOfferIncreaseType()) ? "\u9ad8" + price + "%\u4ee5\u4e0a" : "\u9ad8" + price + "\u5143\u4ee5\u4e0a";
                    rspBO.setRespCode("9900");
                    rspBO.setRespDesc("\u5f53\u524d\u5355\u9879\u660e\u7ec6(" + materialName + ")\u62a5\u4ef7\u5fc5\u987b\u6bd4" + comparedQuoteName + "(" + quotationItemQriceMap.get(quotationItemInfo.getInquiryItemId()) + "\u5143)" + offerIncreaseName + "!!!");
                    return rspBO;
                }
                BeanUtils.copyProperties((Object)quotationItemInfo, (Object)dIqrQuotationItemMidPO);
                dIqrQuotationItemMidPO.setQuoteAmount(0L);
                dIqrQuotationItemMidPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationAmount), dIqrQuotationItemMidPO.getQuotationId().toString()));
                dIqrQuotationItemMidPO.setQuotePrice(0L);
                dIqrQuotationItemMidPO.setQuotePriceSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationItemInfo.getQuotePrice()), dIqrQuotationItemMidPO.getQuotationId().toString()));
                dIqrQuotationItemMidPO.setRedisNo(reqBO.getRedisNo());
                this.dIqrQuotationItemMidMapper.updateByQuotationItemId(dIqrQuotationItemMidPO);
                dIqrQuotationItemMidPOList.add(dIqrQuotationItemMidPO);
            }
        }
        catch (Exception e) {
            log.error("\u62a5\u4ef7\u5355\u66f4\u65b0\u5931\u8d25\uff1a", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25\uff01" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }

    private UpdateQuotationBillItemRspBO initParam(UpdateQuotationBillItemReqBO reqBO, String busiType, String docType, String totalPriceFlag) {
        UpdateQuotationBillItemRspBO rspBO = new UpdateQuotationBillItemRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getQuotationId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getQuotationItemList())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getQuotationItemList().stream().map(e -> {
            if (null == e.getQuotationItemId()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((StringUtils.isEmpty((String)totalPriceFlag) || !"Y".equals(totalPriceFlag)) && "1".equals(busiType)) {
                if (StringUtils.isEmpty((String)e.getBrand())) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u5927\u5355\u8bae\u4ef7\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)e.getManufacturer())) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u5927\u5355\u8bae\u4ef7\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!(!StringUtils.isEmpty((String)totalPriceFlag) && "Y".equals(totalPriceFlag) || null != e.getQuotePrice() && e.getQuotePrice().compareTo(BigDecimal.ZERO) > 0)) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return rspBO;
        }).collect(Collectors.toList());
        return rspBO;
    }
}

