/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.quote.bo.UpdateQuotationMarginPayReqBO;
import com.tydic.enquiry.api.quote.bo.UpdateQuotationMarginPayRspBO;
import com.tydic.enquiry.api.quote.service.UpdateQuotationMarginPayService;
import com.tydic.enquiry.api.registdoc.bo.RecvRefMarginPayReqBO;
import com.tydic.enquiry.api.registdoc.bo.RecvRefMarginPayRspBO;
import com.tydic.enquiry.api.registdoc.service.RecvRefMarginPayService;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.dao.DIqrTransSerialMapper;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.po.DIqrRegistMarginPO;
import com.tydic.enquiry.po.DIqrTransSerialPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.RecvRefMarginPayService"})
public class RecvRefMarginPayServiceImpl
implements RecvRefMarginPayService {
    private static final Logger log = LoggerFactory.getLogger(RecvRefMarginPayServiceImpl.class);
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    UpdateQuotationMarginPayService updateQuotationMarginPayService;
    @Autowired
    private DIqrRegistMarginMapper dIqrRegistMarginMapper;
    @Autowired
    private DIqrTransSerialMapper dIqrTransSerialMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"submitMarginPay"})
    public RecvRefMarginPayRspBO submitMarginPay(@RequestBody RecvRefMarginPayReqBO reqBO) {
        log.info("===submitMarginPay\u5165\u53c2\u6570\u636e::reqBO=" + reqBO.toString());
        RecvRefMarginPayRspBO rspBO = new RecvRefMarginPayRspBO();
        Date operDate = new Date();
        Long registId = reqBO.getRegistId();
        boolean upRegistDocFlag = true;
        List<DIqrRegistMarginPO> registMarginList = null;
        DIqrRegistDocPO dIqrRegistDocPO = null;
        log.info("======reqBO.getPayFlag()=" + reqBO.getPayFlag());
        log.info("======reqBO.getOutOrderId()=" + reqBO.getOutOrderId());
        log.info("======reqBO.getRefundOutOrderId()=" + reqBO.getRefundOutOrderId());
        if ("1".equals(reqBO.getPayFlag()) && !StringUtils.isEmpty((Object)reqBO.getOutOrderId())) {
            registMarginList = this.dIqrRegistMarginMapper.selectRegistMarginByOutOrderId(reqBO.getOutOrderId());
        } else if (!StringUtils.isEmpty((Object)reqBO.getRefundOutOrderId())) {
            registMarginList = this.dIqrRegistMarginMapper.selectRegistMarginByRefundOutOrderId(reqBO.getRefundOutOrderId());
        }
        log.info("======CollectionUtils.isEmpty(registMarginList)=");
        if (!CollectionUtils.isEmpty(registMarginList)) {
            int i;
            registId = registMarginList.get(0).getRegistId();
            String outOrderId = registMarginList.get(0).getOutOrderId();
            log.info("==selectRegistMarginByOutOrderId==registId=" + registId);
            log.info("==\u8fd4\u56de\u7684\u62a5\u540d\u5355ID==outOrderId=" + outOrderId);
            log.info("\u66f4\u65b0\u62a5\u540d\u5305\u72b6\u6001==registId=" + registId);
            DIqrRegistMarginPO dIqrRegistMarginPO = new DIqrRegistMarginPO();
            if ("1".equals(reqBO.getPayFlag())) {
                dIqrRegistMarginPO.setRegistId(registId);
                dIqrRegistMarginPO.setPayStatus("Y");
                dIqrRegistMarginPO.setPayDate(operDate);
                dIqrRegistMarginPO.setPayStatusQry("N");
                i = this.dIqrRegistMarginMapper.updateByPrimaryRegistId(dIqrRegistMarginPO);
                if (i < 0) {
                    log.error("\u62a5\u540d\u5305\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01\uff1aregistId=" + registId);
                    throw new ZTBusinessException("\u62a5\u540d\u5305\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                }
            } else {
                dIqrRegistMarginPO.setOutOrderId(outOrderId);
                dIqrRegistMarginPO.setPayStatus("4");
                i = this.dIqrRegistMarginMapper.updateRefundInfoByOutOrderId(dIqrRegistMarginPO);
                if (i < 0) {
                    log.error("\u62a5\u540d\u5305\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01\uff1aregistId=" + registId);
                    throw new ZTBusinessException("\u62a5\u540d\u5305\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                }
            }
            log.info("=dIqrRegistDocMapper.selectByPrimaryKey=end==registId=" + registId);
            dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(registId);
        } else {
            log.info("=dIqrRegistDocMapper.selectByPrimaryKey==registId=" + registId);
            if ("1".equals(reqBO.getPayFlag())) {
                dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(registId);
            } else {
                log.info("=dIqrRegistDocMapper.selectRegistDocByRefundOrderId==reqBO.getRefundOutOrderId()=" + reqBO.getRefundOutOrderId());
                dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByRefundOrderId(reqBO.getRefundOutOrderId());
            }
        }
        if (dIqrRegistDocPO != null) {
            int registDocResult;
            DIqrRegistDocPO docPO = new DIqrRegistDocPO();
            log.info("reqBO.getPayFlag()=" + reqBO.getPayFlag());
            if ("1".equals(reqBO.getPayFlag())) {
                docPO.setRegistId(registId);
                docPO.setDocStatus(Integer.parseInt("3003"));
                docPO.setPayStatus("2");
                docPO.setPayDate(operDate);
                if (!CollectionUtils.isEmpty(registMarginList)) {
                    docPO.setPayUserId(registMarginList.get(0).getPayUserId());
                    docPO.setPayUserName(registMarginList.get(0).getPayUserName());
                }
                log.info("reqBO.getMarginOrderId()=" + reqBO.getMarginOrderId());
                docPO.setMarginOrderId(reqBO.getMarginOrderId());
            } else {
                List<DIqrRegistMarginPO> registMarginPOList = this.dIqrRegistMarginMapper.selectRegistMarginByRegistId(dIqrRegistDocPO.getRegistId());
                if (!CollectionUtils.isEmpty(registMarginPOList)) {
                    for (DIqrRegistMarginPO dIqrRegistMarginPO : registMarginPOList) {
                        if (!"3".equals(dIqrRegistMarginPO.getPayStatus()) && !"Y".equals(dIqrRegistMarginPO.getPayStatus())) continue;
                        upRegistDocFlag = false;
                        break;
                    }
                }
                log.info("=\u9000\u8fd8\u4fdd\u8bc1\u91d1\u5224\u65ad\u662f\u5426\u4fee\u6539\u62a5\u540d\u5355\u8868\u4fdd\u8bc1\u91d1\u72b6\u6001\u4e3a\u5df2\u9000\u8fd8=updateByPrimaryKeySelective=upRegistDocFlag=" + upRegistDocFlag);
                docPO.setRegistId(registId);
                docPO.setPayStatus("4");
                docPO.setRefundDate(operDate);
            }
            if (upRegistDocFlag && (registDocResult = this.dIqrRegistDocMapper.updateByPrimaryKeySelective(docPO)) < 0) {
                log.error("==\u62a5\u540d\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01\uff1aregistId=" + registId);
                throw new ZTBusinessException("\u62a5\u540d\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
            }
            if ("1".equals(reqBO.getPayFlag())) {
                log.info("UpdateQuotationMarginPayReqBO==dIqrRegistDocPO.getMarginAmount()=" + dIqrRegistDocPO.getMarginAmount());
                UpdateQuotationMarginPayReqBO updateQuotationMarginPayReqBO = new UpdateQuotationMarginPayReqBO();
                updateQuotationMarginPayReqBO.setRegistId(registId);
                updateQuotationMarginPayReqBO.setMarginAmount(dIqrRegistDocPO.getMarginAmount());
                updateQuotationMarginPayReqBO.setPayUserId(reqBO.getOperId());
                updateQuotationMarginPayReqBO.setPayUserName(reqBO.getOperName());
                updateQuotationMarginPayReqBO.setPayDate(operDate);
                updateQuotationMarginPayReqBO.setPayStatus("2");
                UpdateQuotationMarginPayRspBO updateQuotationMarginPayRspBO = this.updateQuotationMarginPayService.updateQuotationMarginPay(updateQuotationMarginPayReqBO);
                if (!"0000".equals(updateQuotationMarginPayRspBO.getRespCode())) {
                    log.error(updateQuotationMarginPayRspBO.getRespDesc() + "\uff1aregistId=" + registId);
                    throw new ZTBusinessException(updateQuotationMarginPayRspBO.getRespDesc());
                }
            }
            BigDecimal amount = new BigDecimal(100);
            DIqrTransSerialPO dIqrTransSerialPO = new DIqrTransSerialPO();
            BeanUtils.copyProperties((Object)reqBO.getMarginSnBO(), (Object)dIqrTransSerialPO);
            dIqrTransSerialPO.setRegistId(registId);
            dIqrTransSerialPO.setChannelId(dIqrRegistDocPO.getReceChannelId());
            dIqrTransSerialPO.setChannelName(dIqrRegistDocPO.getReceChannelName());
            dIqrTransSerialPO.setCreateDate(new Date());
            dIqrTransSerialPO.setTradeTime(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getMarginSnBO().getTradeTime()));
            dIqrTransSerialPO.setPayBusiType(reqBO.getPayFlag());
            dIqrTransSerialPO.setTotalFee(reqBO.getMarginSnBO().getTotalFee().multiply(amount).longValue());
            dIqrTransSerialPO.setRealFee(reqBO.getMarginSnBO().getRealFee().multiply(amount).longValue());
            if ("1".equals(reqBO.getPayFlag())) {
                dIqrTransSerialPO.setPayBusiTypeName("\u4ed8\u6b3e");
                if ("1".equals(dIqrRegistDocPO.getQuoteMethod() + "")) {
                    dIqrTransSerialPO.setPayOperId(dIqrRegistDocPO.getPayUserId());
                    dIqrTransSerialPO.setPayOperName(dIqrRegistDocPO.getPayUserName());
                } else if (!CollectionUtils.isEmpty(registMarginList)) {
                    dIqrTransSerialPO.setPayOperId(registMarginList.get(0).getPayUserId());
                    dIqrTransSerialPO.setPayOperName(registMarginList.get(0).getPayUserName());
                }
            } else {
                dIqrTransSerialPO.setPayBusiTypeName("\u9000\u6b3e");
                if ("1".equals(dIqrRegistDocPO.getQuoteMethod() + "")) {
                    dIqrTransSerialPO.setOriOutOrderId(dIqrRegistDocPO.getRegistId() + "");
                    dIqrTransSerialPO.setPayOperId(dIqrRegistDocPO.getPayUserId());
                    dIqrTransSerialPO.setPayOperName(dIqrRegistDocPO.getPayUserName());
                    dIqrTransSerialPO.setRefundUserId(dIqrRegistDocPO.getRefundUserId());
                    dIqrTransSerialPO.setRefundUserName(dIqrRegistDocPO.getRefundUserName());
                } else if (!CollectionUtils.isEmpty(registMarginList)) {
                    dIqrTransSerialPO.setOriOutOrderId(registMarginList.get(0).getOutOrderId());
                    dIqrTransSerialPO.setPayOperId(registMarginList.get(0).getPayUserId());
                    dIqrTransSerialPO.setPayOperName(registMarginList.get(0).getPayUserName());
                    dIqrTransSerialPO.setRefundUserId(registMarginList.get(0).getRefundUserId());
                    dIqrTransSerialPO.setRefundUserName(registMarginList.get(0).getRefundUserName());
                }
            }
            int transSnResult = this.dIqrTransSerialMapper.insertSelective(dIqrTransSerialPO);
            if (transSnResult < 0) {
                log.error("==\u8bb0\u5f55\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01\uff1aregistId=" + registId);
                throw new ZTBusinessException("\u8bb0\u5f55\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        rspBO.setDocId(registId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("==submitMarginPay==rspBO=" + rspBO.toString());
        return rspBO;
    }

    @PostMapping(value={"updateMarginOutOrderId"})
    public RecvRefMarginPayRspBO updateMarginOutOrderId(@RequestBody RecvRefMarginPayReqBO recvRefMarginPayReqBO) {
        DIqrTransSerialPO dIqrTransSerialQry;
        log.info("==updateMarginOutOrderId==recvRefMarginPayReqBO=" + recvRefMarginPayReqBO.toString());
        RecvRefMarginPayRspBO rspBO = new RecvRefMarginPayRspBO();
        Date operDate = new Date();
        log.info("==updateMarginOutOrderId==recvRefMarginPayReqBO.getIsSplitFlag()=" + recvRefMarginPayReqBO.getIsSplitFlag());
        if ("Y".equals(recvRefMarginPayReqBO.getIsSplitFlag())) {
            DIqrRegistMarginPO marginPO = new DIqrRegistMarginPO();
            if ("1".equals(recvRefMarginPayReqBO.getPayFlag())) {
                marginPO.setRegistId(recvRefMarginPayReqBO.getRegistId());
                marginPO.setOutOrderId(recvRefMarginPayReqBO.getOutOrderId());
                marginPO.setMarginOrderId(recvRefMarginPayReqBO.getMarginOrderId());
                marginPO.setPayUserId(recvRefMarginPayReqBO.getUserId());
                marginPO.setPayUserName(recvRefMarginPayReqBO.getUsername());
                marginPO.setPayStatusQry("N");
                int marginResult = this.dIqrRegistMarginMapper.updateByPrimaryRegistId(marginPO);
                log.info("==updateMarginOutOrderId==marginResult=" + marginResult);
                if (marginResult < 0) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u540d\u5305\u4fdd\u8bc1\u91d1\u4fe1\u606f\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
            } else {
                DIqrTransSerialPO dIqrTransSerialPO = this.dIqrTransSerialMapper.selectByPrimaryKey(recvRefMarginPayReqBO.getOutOrderId());
                marginPO.setOutOrderId(recvRefMarginPayReqBO.getOutOrderId());
                marginPO.setRefundUserId(recvRefMarginPayReqBO.getUserId());
                marginPO.setRefundUserName(recvRefMarginPayReqBO.getUsername());
                marginPO.setRefundOutOrderId(recvRefMarginPayReqBO.getRefundOutOrderId());
                if (dIqrTransSerialPO != null && !"190".equals(dIqrTransSerialPO.getPayMethod())) {
                    marginPO.setPayStatus("4");
                }
                int marginResult = this.dIqrRegistMarginMapper.updateRefundInfoByOutOrderId(marginPO);
                log.info("==updateMarginOutOrderId==marginResult=" + marginResult);
                if (marginResult < 0) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u540d\u5305\u4fdd\u8bc1\u91d1\u4fe1\u606f\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
                if (dIqrTransSerialPO != null && !"190".equals(dIqrTransSerialPO.getPayMethod())) {
                    int registDocResult;
                    boolean upRegistDocFlag = true;
                    List<DIqrRegistMarginPO> registMarginPOList = this.dIqrRegistMarginMapper.selectRegistMarginByRegistId(dIqrTransSerialPO.getRegistId());
                    if (!CollectionUtils.isEmpty(registMarginPOList)) {
                        for (DIqrRegistMarginPO dIqrRegistMarginPO : registMarginPOList) {
                            if (!"3".equals(dIqrRegistMarginPO.getPayStatus()) && !"Y".equals(dIqrRegistMarginPO.getPayStatus())) continue;
                            upRegistDocFlag = false;
                            break;
                        }
                    }
                    log.info("==updateMarginOutOrderId=updateByPrimaryKeySelective=upRegistDocFlag=" + upRegistDocFlag);
                    DIqrRegistDocPO docPO = new DIqrRegistDocPO();
                    docPO.setRegistId(dIqrTransSerialPO.getRegistId());
                    docPO.setRefundUserId(recvRefMarginPayReqBO.getUserId());
                    docPO.setRefundUserName(recvRefMarginPayReqBO.getUsername());
                    docPO.setAnyDog2(recvRefMarginPayReqBO.getRefundOutOrderId());
                    docPO.setPayStatus("4");
                    docPO.setRefundDate(operDate);
                    log.info("==updateMarginOutOrderId=updateByPrimaryKeySelective=recvRefMarginPayReqBO.getRegistId()" + recvRefMarginPayReqBO.getRegistId());
                    if (upRegistDocFlag && (registDocResult = this.dIqrRegistDocMapper.updateByPrimaryKeySelective(docPO)) < 0) {
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u62a5\u540d\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                        return rspBO;
                    }
                }
            }
        } else {
            DIqrRegistDocPO docPO = new DIqrRegistDocPO();
            docPO.setRegistId(recvRefMarginPayReqBO.getRegistId());
            if ("1".equals(recvRefMarginPayReqBO.getPayFlag())) {
                docPO.setMarginOrderId(recvRefMarginPayReqBO.getMarginOrderId());
                docPO.setPayUserId(recvRefMarginPayReqBO.getUserId());
                docPO.setPayUserName(recvRefMarginPayReqBO.getUsername());
            } else {
                DIqrTransSerialPO dIqrTransSerialPO = this.dIqrTransSerialMapper.selectByPrimaryKey(recvRefMarginPayReqBO.getRegistId() + "");
                if (dIqrTransSerialPO != null && !"190".equals(dIqrTransSerialPO.getPaymentInsId())) {
                    docPO.setPayStatus("4");
                    docPO.setRefundDate(new Date());
                }
                docPO.setRefundUserId(recvRefMarginPayReqBO.getUserId());
                docPO.setRefundUserName(recvRefMarginPayReqBO.getUsername());
                docPO.setAnyDog2(recvRefMarginPayReqBO.getRefundOutOrderId());
            }
            log.info("==updateMarginOutOrderId==recvRefMarginPayReqBO.getMarginOrderId()=" + recvRefMarginPayReqBO.getMarginOrderId());
            int registDocResult = this.dIqrRegistDocMapper.updateByPrimaryKeySelective(docPO);
            if (registDocResult < 0) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u540d\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        if ("2".equals(recvRefMarginPayReqBO.getPayFlag()) && (dIqrTransSerialQry = this.dIqrTransSerialMapper.selectByPrimaryKey(recvRefMarginPayReqBO.getOutOrderId())) != null && !"190".equals(dIqrTransSerialQry.getPayMethod())) {
            BigDecimal amount = new BigDecimal(100);
            DIqrTransSerialPO dIqrTransSerialPO = new DIqrTransSerialPO();
            BeanUtils.copyProperties((Object)dIqrTransSerialQry, (Object)dIqrTransSerialPO);
            dIqrTransSerialPO.setRegistId(dIqrTransSerialQry.getRegistId());
            dIqrTransSerialPO.setCreateDate(operDate);
            dIqrTransSerialPO.setTradeTime(operDate);
            dIqrTransSerialPO.setPayBusiType(recvRefMarginPayReqBO.getPayFlag());
            dIqrTransSerialPO.setTotalFee(recvRefMarginPayReqBO.getRefundFee().multiply(amount).longValue());
            dIqrTransSerialPO.setRealFee(recvRefMarginPayReqBO.getRefundFee().multiply(amount).longValue());
            dIqrTransSerialPO.setPayBusiTypeName("\u9000\u6b3e");
            dIqrTransSerialPO.setRefundUserId(recvRefMarginPayReqBO.getUserId());
            dIqrTransSerialPO.setRefundUserName(recvRefMarginPayReqBO.getUsername());
            dIqrTransSerialPO.setOriOutOrderId(recvRefMarginPayReqBO.getOutOrderId());
            dIqrTransSerialPO.setOutOrderId(recvRefMarginPayReqBO.getRefundOutOrderId());
            int transSnResult = this.dIqrTransSerialMapper.insertSelective(dIqrTransSerialPO);
            if (transSnResult < 0) {
                log.error("==\u8bb0\u5f55\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01\uff1aregistId=" + recvRefMarginPayReqBO.getRegistId());
                throw new ZTBusinessException("\u8bb0\u5f55\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("==updateMarginOutOrderId==rspBO.toString()=" + rspBO.toString());
        return rspBO;
    }
}

