/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.demandlist;

import com.tydic.enquiry.api.demandlist.bo.PlanDetailBO;
import com.tydic.enquiry.api.demandlist.bo.ReqBatchImportReqBO;
import com.tydic.enquiry.api.demandlist.bo.ReqBatchImportRspBO;
import com.tydic.enquiry.api.demandlist.service.ReqBatchImportService;
import com.tydic.enquiry.dao.DPlanItemMaterialMapper;
import com.tydic.enquiry.po.DPlanItemMaterialPO;
import com.tydic.enquiry.util.RedisUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.demandlist.service.ReqBatchImportService"})
public class ReqBatchImportServiceImpl
implements ReqBatchImportService {
    private static final Logger log = LoggerFactory.getLogger(ReqBatchImportServiceImpl.class);
    @Autowired
    private DPlanItemMaterialMapper dPlanItemMaterialMapper;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"importReqDetail"})
    public ReqBatchImportRspBO importReqDetail(@RequestBody ReqBatchImportReqBO reqBO) {
        log.info("\u5165\u53c2+reqBO:" + reqBO.toString());
        ReqBatchImportRspBO rsqBO = new ReqBatchImportRspBO();
        ArrayList<PlanDetailBO> list = new ArrayList<PlanDetailBO>();
        try {
            log.info("reqBO.getUrl():" + reqBO.getUrl());
            String type = reqBO.getUrl().substring(reqBO.getUrl().lastIndexOf(".") + 1);
            InputStream input = new URL(reqBO.getUrl()).openStream();
            if (input != null) {
                HSSFWorkbook workbook;
                if ("xls".equals(type)) {
                    workbook = new HSSFWorkbook(input);
                } else if ("xlsx".equals(type)) {
                    workbook = new XSSFWorkbook(input);
                } else {
                    log.error("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
                    rsqBO.setRespCode("9999");
                    rsqBO.setRespDesc("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
                    return rsqBO;
                }
                log.info("workbook.getNumberOfSheets()=" + workbook.getNumberOfSheets());
                for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                    Sheet sheet = workbook.getSheetAt(i);
                    int lastRowNum = ReqBatchImportServiceImpl.getExcelRealRow(sheet);
                    log.info("lastRowNum=" + lastRowNum);
                    if (lastRowNum <= 2000) {
                        for (int j = 10; j <= lastRowNum; ++j) {
                            Row row = sheet.getRow(j);
                            PlanDetailBO planDetailBO = new PlanDetailBO();
                            planDetailBO.setMaterialName(ReqBatchImportServiceImpl.getCellValue(row.getCell(1)));
                            planDetailBO.setMaterialId(ReqBatchImportServiceImpl.getCellValue(row.getCell(2)));
                            planDetailBO.setMaterialClassId(ReqBatchImportServiceImpl.getCellValue(row.getCell(3)));
                            planDetailBO.setMaterialClassName(ReqBatchImportServiceImpl.getCellValue(row.getCell(4)));
                            log.info("row.getCell(5).getStringCellValue()=" + ReqBatchImportServiceImpl.getCellValue(row.getCell(5)));
                            planDetailBO.setSpec(ReqBatchImportServiceImpl.getCellValue(row.getCell(5)));
                            log.info("row.getCell(6).getStringCellValue()=" + ReqBatchImportServiceImpl.getCellValue(row.getCell(6)));
                            planDetailBO.setModel(ReqBatchImportServiceImpl.getCellValue(row.getCell(6)));
                            planDetailBO.setFigureNo(ReqBatchImportServiceImpl.getCellValue(row.getCell(7)));
                            planDetailBO.setMaterialsQuality(ReqBatchImportServiceImpl.getCellValue(row.getCell(8)));
                            planDetailBO.setUnitNameInfo(ReqBatchImportServiceImpl.getCellValue(row.getCell(9)));
                            log.info("RequireNumber=" + ReqBatchImportServiceImpl.getCellValue(row.getCell(10)));
                            BigDecimal requireNumberTemp = new BigDecimal(ReqBatchImportServiceImpl.getCellValue(row.getCell(10)));
                            planDetailBO.setRequireNumber(requireNumberTemp.setScale(2, RoundingMode.HALF_UP));
                            log.info("budgetPrice=" + ReqBatchImportServiceImpl.getCellValue(row.getCell(11)));
                            BigDecimal budgetPriceTemp = new BigDecimal(ReqBatchImportServiceImpl.getCellValue(row.getCell(11)));
                            planDetailBO.setBudgetPrice(budgetPriceTemp.setScale(2, RoundingMode.HALF_UP));
                            BigDecimal budgetAmountTemp = budgetPriceTemp.multiply(requireNumberTemp);
                            planDetailBO.setBudgetAmount(budgetAmountTemp.setScale(2, RoundingMode.HALF_UP));
                            planDetailBO.setRemarks(ReqBatchImportServiceImpl.getCellValue(row.getCell(13)));
                            planDetailBO.setRecommendBrandName(ReqBatchImportServiceImpl.getCellValue(row.getCell(14)));
                            planDetailBO.setOperFlag("1");
                            list.add(planDetailBO);
                        }
                        continue;
                    }
                    log.error("\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7b5b\u9009\u540e\u518d\u8fdb\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u6216\u8005\u76f4\u63a5\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
                    rsqBO.setRespCode("9999");
                    rsqBO.setRespDesc("\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7b5b\u9009\u540e\u518d\u8fdb\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u6216\u8005\u76f4\u63a5\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
                    return rsqBO;
                }
                if ("3".equals(reqBO.getEidtFlag())) {
                    List<DPlanItemMaterialPO> dPlanItemMaterialPOList = this.dPlanItemMaterialMapper.selectItemMaterialByPlanId(reqBO.getPlanId());
                    if (dPlanItemMaterialPOList == null) {
                        rsqBO.setRespCode("9999");
                        rsqBO.setRespDesc("\u7269\u8d44\u9700\u6c42\u660e\u7ec6\u5355\u4e0d\u5b58\u5728");
                        return rsqBO;
                    }
                    for (DPlanItemMaterialPO dPlanItemMaterialPO : dPlanItemMaterialPOList) {
                        PlanDetailBO planDetailBO = new PlanDetailBO();
                        BeanUtils.copyProperties((Object)dPlanItemMaterialPO, (Object)planDetailBO);
                        planDetailBO.setOperFlag("2");
                        list.add(planDetailBO);
                    }
                }
            } else {
                rsqBO.setRespCode("9999");
                rsqBO.setRespDesc("\u5bfc\u5165\u6587\u4ef6\u4e0d\u5b58\u5728");
                return rsqBO;
            }
            rsqBO.setDetailList(list);
        }
        catch (Exception e) {
            log.error(e.toString());
            rsqBO.setRespCode("9999");
            rsqBO.setRespDesc("\u6279\u91cf\u5bfc\u5165\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            return rsqBO;
        }
        rsqBO.setRespCode("0000");
        rsqBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2+rsqBO:" + rsqBO.toString());
        return rsqBO;
    }

    public static String getCellValue(Cell cell) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        CellType cellType = cell.getCellType();
        log.info("cellType=" + cellType);
        switch (cellType) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = fmt.format(cell.getDateCellValue());
                    break;
                }
                cellValue = String.valueOf(cell.getNumericCellValue());
                if (!cellValue.contains("E")) break;
                cellValue = String.valueOf(new Double(cell.getNumericCellValue()).longValue());
                break;
            }
            case STRING: {
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            }
            case BOOLEAN: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            }
            case BLANK: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case ERROR: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }

    public static int getExcelRealRow(Sheet sheet) {
        boolean flag = false;
        int i = 1;
        while (i <= sheet.getLastRowNum()) {
            Row r = sheet.getRow(i);
            if (r == null) {
                sheet.shiftRows(i + 1, sheet.getLastRowNum(), -1);
                continue;
            }
            flag = false;
            for (Cell c : r) {
                if (c.getCellType() == CellType.BLANK) continue;
                flag = true;
                break;
            }
            if (flag) {
                ++i;
                continue;
            }
            if (i == sheet.getLastRowNum()) {
                sheet.removeRow(r);
                continue;
            }
            sheet.shiftRows(i + 1, sheet.getLastRowNum(), -1);
        }
        return sheet.getLastRowNum();
    }
}

