/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.google.common.base.Preconditions;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.externalinter.bo.CacheBO;
import com.tydic.externalinter.service.DemoCacheService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

@Service(group="dev", version="0.0.1")
public class DemoCacheServiceImpl
implements DemoCacheService {
    private static Logger logger = LoggerFactory.getLogger(DemoCacheServiceImpl.class);
    @Resource
    CacheClient cacheClient;

    public void setValue(CacheBO cacheBO) {
        logger.info("Cache: {}:{}", (Object)cacheBO.getKey(), (Object)cacheBO.getValue());
        this.cacheClient.set(cacheBO.getKey(), (Object)cacheBO.getValue());
    }

    public CacheBO getValue(CacheBO cacheBO) {
        Object oValue = this.cacheClient.get(cacheBO.getKey());
        Preconditions.checkNotNull((Object)oValue, (Object)("Can't find the value of the key " + cacheBO.getKey()));
        return new CacheBO(cacheBO.getKey(), oValue.toString());
    }

    public Map<String, Object> getRedisPoolStatus() {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        JedisPool jedisPool = this.cacheClient.getJedisPool();
        rtnMap.put("numActive", jedisPool.getNumActive());
        rtnMap.put("numIdle", jedisPool.getNumIdle());
        rtnMap.put("numWaiters", jedisPool.getNumWaiters());
        return rtnMap;
    }
}

