/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.tydic.externalinter.bo.ErpSyncDataBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.bo.PayInfoBO;
import com.tydic.externalinter.service.ERPSyncDataService;
import com.tydic.ordunr.ability.UnrCreateOrderAbilityService;
import com.tydic.ordunr.ability.UnrQryOrderDetailAbilityService;
import com.tydic.ordunr.ability.bo.UnrCreateOrderAbilityReqBO;
import com.tydic.ordunr.ability.bo.UnrOrdItemAbilityRspBO;
import com.tydic.ordunr.ability.bo.UnrQryOrderDetailAbilityRspBO;
import com.tydic.ordunr.busi.bo.UnrQryOrderReqBO;
import com.tydic.ordunr.comb.bo.SaleOrderInfoCombReqBO;
import com.tydic.ordunr.comb.bo.SaleOrderItemBO;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.erpstock.SpInfoBO;
import com.tydic.zhmd.service.ERPSyncSaleDataService;
import com.tydic.zhmd.service.ShopService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.intfce.sku.QuerySkuByMaterialIdExtSkuIdCustomService;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomReqBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncDataService")
public class ERPSyncDataServiceImpl
implements ERPSyncDataService {
    public static final Logger logger = LoggerFactory.getLogger(ERPSyncDataServiceImpl.class);
    @Resource
    private QuerySkuByMaterialIdExtSkuIdCustomService querySkuByMaterialIdExtSkuIdCustomService;
    @Resource
    private ShopService shopService;
    @Resource
    private StockService stockService;
    @Resource
    private UnrQryOrderDetailAbilityService unrQryOrderDetailAbilityService;
    @Resource
    private UnrCreateOrderAbilityService unrCreateOrderAbilityService;
    @Resource
    private ERPSyncSaleDataService erpSyncSaleDataService;

    public ExternaLinterResultData syncData(ErpSyncDataBO erpSyncDataBO) {
        logger.debug("ERP\u9500\u552e\u6570\u636e\u540c\u6b65\u5f00\u59cb");
        try {
            ResultData resultData;
            List spInfo;
            String czType = erpSyncDataBO.getCzType().trim();
            String mdID = erpSyncDataBO.getMdID().trim();
            String orderCode = erpSyncDataBO.getOrderID().trim();
            if (czType.equals("1")) {
                logger.debug("ERP\u9500\u552e\u6570\u636e\u65b0\u589e\uff0c\u76f8\u5f53\u4e0e\u5e93\u5b58\u4e2d\u7684\u51fa\u5e93");
                spInfo = erpSyncDataBO.getSpInfo();
                resultData = this.setErpStatus(spInfo, orderCode, mdID, 2);
                if (!resultData.getSuccess().booleanValue()) {
                    return new ExternaLinterResultData(Boolean.valueOf(false), "", resultData.getRespDesc());
                }
                logger.debug("ERP\u9500\u552e\u6570\u636e\u65b0\u589e\u6210\u529f");
            } else if (czType.equals("2")) {
                logger.debug("ERP\u9500\u552e\u6570\u636e\u5220\u9664\uff0c\u76f8\u5f53\u4e0e\u5e93\u5b58\u4e2d\u7684\u5165\u5e93");
                spInfo = erpSyncDataBO.getSpInfo();
                resultData = this.setErpStatus(spInfo, orderCode, mdID, 1);
                if (!resultData.getSuccess().booleanValue()) {
                    return new ExternaLinterResultData(Boolean.valueOf(false), "", resultData.getRespDesc());
                }
                logger.debug("ERP\u9500\u552e\u6570\u636e\u5220\u9664\u6210\u529f");
            } else if (czType.equals("3")) {
                logger.debug("ERP\u9500\u552e\u6570\u636e\u4fee\u6539,\u9700\u8981\u4e0e\u539f\u9500\u552e\u660e\u7ec6\u6bd4\u8f83");
                logger.debug("ERP\u9500\u552e\u6570\u636e\u4fee\u6539\uff0c\u539f\u9500\u552e\u660e\u7ec6\u5168\u90e8\u5165\u5e93");
                ResultData spInfoList = this.getSpInfo(erpSyncDataBO.getOrderID(), erpSyncDataBO.getMdID());
                if (!spInfoList.getSuccess().booleanValue()) {
                    return new ExternaLinterResultData(Boolean.valueOf(false), "", spInfoList.getRespDesc());
                }
                logger.debug("\u539f\u9500\u552e\u660e\u7ec6\u5168\u90e8\u5165\u5e93\u6210\u529f");
                logger.debug("ERP\u9500\u552e\u6570\u636e\u4fee\u6539\uff0c\u65b0\u9500\u552e\u660e\u7ec6\u5168\u90e8\u51fa\u5e93");
                List spInfo2 = erpSyncDataBO.getSpInfo();
                ResultData resultData2 = this.setErpStatus(spInfo2, orderCode, mdID, 2);
                if (!resultData2.getSuccess().booleanValue()) {
                    return new ExternaLinterResultData(Boolean.valueOf(false), "", resultData2.getRespDesc());
                }
                logger.debug("\u65b0\u9500\u552e\u660e\u7ec6\u5168\u90e8\u51fa\u5e93\u6210\u529f");
            }
            logger.debug("\u6700\u540e\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u7684\u63a5\u53e3\uff0c\u901a\u77e5\u8ba2\u5355\u4e2d\u5fc3");
            UnrCreateOrderAbilityReqBO unrCreateOrderAbilityReqBO = new UnrCreateOrderAbilityReqBO();
            unrCreateOrderAbilityReqBO.setTotalAmount(new BigDecimal(erpSyncDataBO.getDdje()));
            List payInfo = erpSyncDataBO.getPayInfo();
            int payTatal = 0;
            for (PayInfoBO payInfoBO : payInfo) {
                payTatal = Integer.parseInt(payInfoBO.getPayMoney()) + payTatal;
            }
            unrCreateOrderAbilityReqBO.setRealPayAmount(new BigDecimal(payTatal));
            unrCreateOrderAbilityReqBO.setOrderSource(Integer.valueOf(99));
            unrCreateOrderAbilityReqBO.setOutOrderNo(orderCode);
            unrCreateOrderAbilityReqBO.setPayedAmount(new BigDecimal(0));
            unrCreateOrderAbilityReqBO.setOrderSystem("S001");
            unrCreateOrderAbilityReqBO.setPurchaseType(Integer.valueOf(10));
            unrCreateOrderAbilityReqBO.setPurchaserId("");
            unrCreateOrderAbilityReqBO.setPayType(Integer.valueOf(Integer.parseInt(((PayInfoBO)payInfo.get(0)).getPayMode())));
            unrCreateOrderAbilityReqBO.setTotalTransportationFee(new BigDecimal(0));
            unrCreateOrderAbilityReqBO.setIsDisPatch(Integer.valueOf(0));
            List spInfoBOList = erpSyncDataBO.getSpInfo();
            ArrayList<SaleOrderInfoCombReqBO> saleList = new ArrayList<SaleOrderInfoCombReqBO>();
            SaleOrderInfoCombReqBO saleOrderInfoCombReqBO = new SaleOrderInfoCombReqBO();
            ShopBO shopBO = new ShopBO();
            shopBO.setShopMdId(mdID);
            ResultData wareHouse = this.shopService.findWarehouseByShopId(shopBO);
            saleOrderInfoCombReqBO.setSkuEntrepotCode(wareHouse.getRespData().toString());
            ResultData shopByMdId = this.shopService.findShopByMdId(shopBO);
            ShopBO respData = (ShopBO)shopByMdId.getRespData();
            saleOrderInfoCombReqBO.setShopId(respData.getShopId());
            ArrayList<SaleOrderItemBO> saleOrderItemBOList = new ArrayList<SaleOrderItemBO>();
            for (SpInfoBO spInfoBO : spInfoBOList) {
                SaleOrderItemBO saleOrderItemBO = new SaleOrderItemBO();
                Long skuID = this.getSkuID(spInfoBO, mdID);
                saleOrderItemBO.setSkuId(skuID.toString());
                saleOrderItemBO.setPurchaseCount(new BigDecimal(spInfoBO.getNumber()));
                saleOrderItemBO.setSkuSalePrice(new BigDecimal(spInfoBO.getSjjg()));
                saleOrderItemBOList.add(saleOrderItemBO);
            }
            saleOrderInfoCombReqBO.setSaleOrderItemList(saleOrderItemBOList);
            saleList.add(saleOrderInfoCombReqBO);
            unrCreateOrderAbilityReqBO.setSaleOrderInfoList(saleList);
            this.unrCreateOrderAbilityService.dealCreateOrder(unrCreateOrderAbilityReqBO);
        }
        catch (Exception e) {
            logger.debug("ERP\u9500\u552e\u6570\u636e\u540c\u6b65\uff0c\u51fa\u73b0\u5f02\u5e38\u9519\u8bef");
            e.printStackTrace();
            return new ExternaLinterResultData(Boolean.valueOf(false), "", "ERP\u9500\u552e\u6570\u636e\u540c\u6b65\uff0c\u51fa\u73b0\u5f02\u5e38\u9519\u8bef");
        }
        logger.debug("ERP\u6570\u636e\u540c\u6b65\u63a5\u53e3\u5b8c\u6210");
        return new ExternaLinterResultData(Boolean.valueOf(true), "", "ERP\u6570\u636e\u540c\u6b65\u6210\u529f");
    }

    public ResultData handleSyncData(SpInfoBO spInfoBO, String mdID, String orderCode, long skuID, int status) throws Exception {
        ResultData resultData = this.erpSyncSaleDataService.syncSaleData(spInfoBO, mdID, orderCode, skuID, status);
        if (resultData.getSuccess().booleanValue()) {
            return resultData;
        }
        return resultData;
    }

    private Long getSkuID(SpInfoBO spInfoBO, String mdID) throws Exception {
        logger.debug("\u5f00\u59cb\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u83b7\u5f97skuID");
        long skuId = 0L;
        ShopBO shopBO = new ShopBO();
        shopBO.setShopMdId(mdID);
        ResultData shopByMdId = this.shopService.findShopByMdId(shopBO);
        shopBO = (ShopBO)shopByMdId.getRespData();
        QuerySkuByMaterialIdExtSkuIdCustomReqBO reqBO = new QuerySkuByMaterialIdExtSkuIdCustomReqBO();
        ArrayList<String> extSkuIds = new ArrayList<String>();
        extSkuIds.add(spInfoBO.getZjm());
        ArrayList<Long> materialIds = new ArrayList<Long>();
        materialIds.add(Long.parseLong(spInfoBO.getScmID()));
        reqBO.setSupplierId(shopBO.getShopId());
        reqBO.setExtSkuIds(extSkuIds);
        reqBO.setMaterialIds(materialIds);
        QuerySkuByMaterialIdExtSkuIdCustomRspBO querySkuDetailRspBO = this.querySkuByMaterialIdExtSkuIdCustomService.querySkuByMaterialIdExtSkuId(reqBO);
        if (querySkuDetailRspBO == null || querySkuDetailRspBO.getSkus().size() == 0) {
            return skuId;
        }
        List querySkuDetailRspBOSkus = querySkuDetailRspBO.getSkus();
        skuId = ((SkuBO)querySkuDetailRspBOSkus.get(0)).getSkuId();
        logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u670d\u52a1\u7ed3\u675f");
        return skuId;
    }

    private ResultData getSpInfo(String orderCode, String mdID) throws Exception {
        logger.debug("\u5f00\u59cb\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\uff0c\u83b7\u5f97\u539f\u9500\u552e\u660e\u7ec6");
        ArrayList list = new ArrayList();
        UnrQryOrderReqBO unrQryOrderReqBO = new UnrQryOrderReqBO();
        unrQryOrderReqBO.setOutOrderNo(orderCode);
        unrQryOrderReqBO.setOrderSystem("S001");
        UnrQryOrderDetailAbilityRspBO unrQryOrderDetailAbilityRspBO = this.unrQryOrderDetailAbilityService.qryUnrQryOrderDetail(unrQryOrderReqBO);
        if (unrQryOrderDetailAbilityRspBO == null) {
            logger.debug("\u8ba2\u5355\u4e2d\u5fc3\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u660e\u7ec6");
            return new ResultData(Boolean.valueOf(false), "9999", "\u8ba2\u5355\u4e2d\u5fc3\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u660e\u7ec6");
        }
        List ordItemListRspBO = unrQryOrderDetailAbilityRspBO.getOrdItemListRspBO();
        if (ordItemListRspBO == null || ordItemListRspBO.size() == 0) {
            logger.debug("\u8ba2\u5355\u4e2d\u5fc3\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u660e\u7ec6");
            return new ResultData(Boolean.valueOf(false), "9999", "\u8ba2\u5355\u4e2d\u5fc3\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u660e\u7ec6");
        }
        for (UnrOrdItemAbilityRspBO unrOrdItemAbilityRspBO : ordItemListRspBO) {
            SpInfoBO spInfoBO = new SpInfoBO();
            spInfoBO.setNumber(unrOrdItemAbilityRspBO.getPurchaseCount().toString().trim());
            long skuId = Long.parseLong(unrOrdItemAbilityRspBO.getSkuId());
            ResultData resultData = this.handleSyncData(spInfoBO, mdID, orderCode, skuId, 1);
            if (resultData.getSuccess().booleanValue()) continue;
            logger.debug("\u539f\u9500\u552e\u660e\u7ec6\u5165\u5e93\u5904\u7406\u5931\u8d25");
            return new ResultData(Boolean.valueOf(false), "9999", "\u539f\u9500\u552e\u660e\u7ec6\u5165\u5e93\u5904\u7406\u5931\u8d25");
        }
        logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u7ed3\u675f");
        return new ResultData(Boolean.valueOf(true));
    }

    private ResultData setErpStatus(List<SpInfoBO> spInfo, String orderCode, String mdID, int status) throws Exception {
        for (SpInfoBO spInfoBO : spInfo) {
            Long skuID = this.getSkuID(spInfoBO, mdID);
            if (skuID == null || skuID == 0L) {
                logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u7684\u63a5\u53e3\u83b7\u53d6skuID\u5931\u8d25");
                return new ResultData(Boolean.valueOf(false), "", "\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u7684\u63a5\u53e3\u83b7\u53d6skuID\u5931\u8d25");
            }
            ResultData resultData = this.handleSyncData(spInfoBO, mdID, orderCode, skuID, status);
            if (resultData.getSuccess().booleanValue()) continue;
            logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u5931\u8d25\uff0c\u539f\u56e0:" + resultData.getRespDesc());
            return new ResultData(Boolean.valueOf(false), "", resultData.getRespDesc());
        }
        return new ResultData(Boolean.valueOf(true));
    }
}

