/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.spu.bo.CommodityBO;
import com.ohaotian.commodity.busi.sku.web.CreateSkuBusiService;
import com.ohaotian.commodity.busi.sku.web.bo.CreateSkuBusiReqBO;
import com.tydic.externalinter.bo.ErpCommodityBO;
import com.tydic.externalinter.bo.commodity.ErpChInfoBO;
import com.tydic.externalinter.bo.commodity.ErpKCInfoBO;
import com.tydic.externalinter.bo.commodity.ErpSpInfoBO;
import com.tydic.externalinter.dao.ErpChInfoDao;
import com.tydic.externalinter.dao.ErpCommodityDao;
import com.tydic.externalinter.dao.ErpKCInfoDao;
import com.tydic.externalinter.dao.ErpSpInfoDao;
import com.tydic.externalinter.dao.po.ErpChInfoPO;
import com.tydic.externalinter.dao.po.ErpCommodityPO;
import com.tydic.externalinter.dao.po.ErpKCInfoPO;
import com.tydic.externalinter.dao.po.ErpSpInfoPO;
import com.tydic.externalinter.service.ErpCommodityService;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.SkuInfoBO;
import com.tydic.zhmd.bo.SkuInfoListBO;
import com.tydic.zhmd.service.ShopService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.intfce.sku.QuerySkuByMaterialIdExtSkuIdCustomService;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomReqBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="erpCommodityService")
public class ErpCommodityServiceImpl
implements ErpCommodityService {
    private static Logger logger = LoggerFactory.getLogger(ErpCommodityServiceImpl.class);
    @Resource
    CreateSkuBusiService createSkuBusiService;
    @Resource
    QuerySkuByMaterialIdExtSkuIdCustomService querySkuByMaterialIdExtSkuIdCustomService;
    @Resource
    StockService stockService;
    @Resource
    ShopService shopService;
    @Resource
    ErpCommodityDao erpCommodityDao;
    @Resource
    ErpKCInfoDao erpKCInfoDaoDao;
    @Resource
    ErpSpInfoDao erpSpInfoDao;
    @Resource
    ErpChInfoDao erpChInfoDao;

    public ResultData receiveCommodity(ErpCommodityBO erpCommodityBO) {
        ErpCommodityPO erpCommodityPO = this.saveErpCommodity(erpCommodityBO);
        erpCommodityPO.setErpCommodityCommodityState(1);
        try {
            this.saveErpCommodityToShopCenter(erpCommodityBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        erpCommodityPO.setErpCommodityStockState(1);
        erpCommodityPO.setErpCommodityState(1);
        return null;
    }

    private ErpCommodityPO saveErpCommodity(ErpCommodityBO erpCommodityBO) {
        ErpCommodityPO erpCommodityPO = new ErpCommodityPO();
        String operID = erpCommodityBO.getOperID();
        erpCommodityPO.setErpCommodityOperid(operID);
        erpCommodityPO.setErpCommodityState(0);
        erpCommodityPO.setErpCommodityCommodityState(0);
        erpCommodityPO.setErpCommodityStockState(0);
        this.erpCommodityDao.insert(erpCommodityPO);
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            ErpKCInfoPO erpKCInfoPO = new ErpKCInfoPO();
            erpKCInfoPO.setMdId(erpKCInfoBO.getMdID());
            erpKCInfoPO.setErpCommodityId(erpCommodityPO.getErpCommodityId());
            this.erpKCInfoDaoDao.insert(erpKCInfoPO);
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                ErpSpInfoPO erpSpInfoPO = new ErpSpInfoPO();
                erpSpInfoPO.setErpSpInfoHaveCh(spInfoBO.getHaveCh());
                erpSpInfoPO.setErpSpInfoZjm(spInfoBO.getZjm());
                erpSpInfoPO.setErpSpInfoScmId(spInfoBO.getScmId());
                erpSpInfoPO.setErpSpInfoCgType(spInfoBO.getCgType());
                erpSpInfoPO.setErpSpInfoType(spInfoBO.getType());
                erpSpInfoPO.setErpSpInfoPp(spInfoBO.getPp());
                erpSpInfoPO.setErpSpInfoName(spInfoBO.getName());
                erpSpInfoPO.setErpSpInfoFullName(spInfoBO.getFullName());
                erpSpInfoPO.setErpSpInfoColor(spInfoBO.getColor());
                erpSpInfoPO.setErpSpInfoNc(spInfoBO.getNc());
                erpSpInfoPO.setErpSpInfoKcsl(spInfoBO.getKcsl());
                erpSpInfoPO.setErpSpInfoJg1(spInfoBO.getJg1());
                erpSpInfoPO.setErpKcInfoId(erpKCInfoPO.getErpKcInfoId());
                this.erpSpInfoDao.insert(erpSpInfoPO);
                List chInfoBOList = spInfoBO.getChInfo();
                for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                    ErpChInfoPO erpChInfoPO = new ErpChInfoPO();
                    erpChInfoPO.setErpChInfoCh(erpChInfoBO.getCh());
                    erpChInfoPO.setErpSpInfoId(erpSpInfoPO.getErpSpInfoId());
                    this.erpChInfoDao.insert(erpChInfoPO);
                }
            }
        }
        return erpCommodityPO;
    }

    private void saveErpCommodityToCommodityCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID());
            if (shopBO == null) {
                throw new Exception("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                CreateSkuBusiReqBO createSkuBusiReqBO = new CreateSkuBusiReqBO();
                PriceBO priceBO = new PriceBO();
                priceBO.setSalePrice(new Long(spInfoBO.getJg1()));
                priceBO.setSupplierId(shopBO.getShopId());
                createSkuBusiReqBO.setPrice(priceBO);
                CommodityBO commodityBO = new CommodityBO();
                commodityBO.setCommodityTypeId(Long.valueOf(1L));
                com.ohaotian.commodity.atom.sku.bo.SkuBO skuBO = new com.ohaotian.commodity.atom.sku.bo.SkuBO();
                skuBO.setSupplierId(shopBO.getShopId());
                skuBO.setBrandName(spInfoBO.getName());
                skuBO.setMfgSku(spInfoBO.getName());
                skuBO.setSkuName(spInfoBO.getName());
                skuBO.setSkuLongName(spInfoBO.getFullName());
                skuBO.setSkuPrice(new Long(spInfoBO.getJg1()));
                skuBO.setSkuLocation(Integer.valueOf(1));
                skuBO.setVendorName(shopBO.getShopMdName());
                createSkuBusiReqBO.setSku(skuBO);
                createSkuBusiReqBO.setSpu(commodityBO);
                this.createSkuBusiService.createSku(createSkuBusiReqBO);
            }
        }
    }

    private void saveErpCommodityToShopCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        SkuInfoListBO skuInfoLisBO = new SkuInfoListBO();
        ArrayList<SkuInfoBO> skuInfoBOList = new ArrayList<SkuInfoBO>();
        skuInfoLisBO.setSkuInfoBO(skuInfoBOList);
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID());
            if (shopBO == null) {
                throw new Exception("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                List chInfoBOList = spInfoBO.getChInfo();
                ArrayList<String> skuInstanceCode = new ArrayList<String>();
                for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                    skuInstanceCode.add(erpChInfoBO.getCh());
                }
                Long skuId = this.getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(shopBO.getShopId(), spInfoBO.getScmId(), spInfoBO.getZjm());
                SkuInfoBO skuInfoBO = new SkuInfoBO();
                skuInfoBO.setSkuId(skuId);
                skuInfoBO.setShopId(shopBO.getShopId());
                skuInfoBO.setChangeAmount(Integer.valueOf(Integer.parseInt(spInfoBO.getKcsl())));
                skuInfoBO.setSkuInstanceCode(skuInstanceCode);
                skuInfoBO.setSkuStockPurchaseType(Integer.valueOf(Integer.parseInt(spInfoBO.getCgType())));
                skuInfoBO.setScmID(spInfoBO.getScmId());
                skuInfoBO.setZjm(spInfoBO.getZjm());
                skuInfoBOList.add(skuInfoBO);
            }
        }
        System.out.println("\u8c03\u7528\u95e8\u5e97\u4e2d\u5fc3\u53c2\u6570\uff1a" + JSON.toJSONString((Object)skuInfoLisBO));
        this.stockService.inStock(skuInfoLisBO);
    }

    private ShopBO getShopBoByShopMdId(String shopMdId) {
        ShopBO tempShop = new ShopBO();
        tempShop.setShopId(Long.valueOf(1000003L));
        return tempShop;
    }

    private Long getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(Long shopId, String materialId, String extSkuId) {
        QuerySkuByMaterialIdExtSkuIdCustomReqBO querySkuByMaterialIdExtSkuIdCustomReqBO = new QuerySkuByMaterialIdExtSkuIdCustomReqBO();
        querySkuByMaterialIdExtSkuIdCustomReqBO.setSupplierId(shopId);
        ArrayList<Long> materialIds = new ArrayList<Long>();
        materialIds.add(Long.parseLong(materialId));
        querySkuByMaterialIdExtSkuIdCustomReqBO.setMaterialIds(materialIds);
        ArrayList<String> extSkuIds = new ArrayList<String>();
        extSkuIds.add(extSkuId);
        querySkuByMaterialIdExtSkuIdCustomReqBO.setExtSkuIds(extSkuIds);
        QuerySkuByMaterialIdExtSkuIdCustomRspBO querySkuDetailRspBO = this.querySkuByMaterialIdExtSkuIdCustomService.querySkuByMaterialIdExtSkuId(querySkuByMaterialIdExtSkuIdCustomReqBO);
        if (querySkuDetailRspBO != null && querySkuDetailRspBO.getSkus().size() != 0) {
            return ((SkuBO)querySkuDetailRspBO.getSkus().get(0)).getSkuId();
        }
        return null;
    }

    private Long getCode() {
        StringBuilder sb = new StringBuilder("");
        Random ra = new Random();
        for (int i = 0; i < 6; ++i) {
            sb.append(ra.nextInt(10));
        }
        return new Long(sb.toString());
    }
}

