/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.tydic.externalinter.bo.ERPSyncPriceBusIBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.service.ERPSyncProductPriceService;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.erpstock.JgInfoBO;
import com.tydic.zhmd.service.ShopService;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncProductPriceService")
public class ERPSyncProductPriceServiceImpl
implements ERPSyncProductPriceService {
    public static final Logger logger = LoggerFactory.getLogger(ERPSyncProductPriceServiceImpl.class);
    @Resource
    private UpdateSkuPriceService updateSkuPriceService;
    @Resource
    private ShopService shopService;

    public ExternaLinterResultData syncProductPrice(ERPSyncPriceBusIBO erpSyncPriceBusIBO) {
        logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u5f00\u59cb");
        logger.debug("\u53c2\u6570\uff1a" + erpSyncPriceBusIBO.toString());
        ArrayList<JgInfoReqBO> list = new ArrayList<JgInfoReqBO>();
        try {
            List jgInfo = erpSyncPriceBusIBO.getJgInfo();
            if (jgInfo == null || jgInfo.size() == 0) {
                logger.debug("ERP\u4f20\u53c2\u4e0d\u6b63\u786e");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u4f20\u53c2\u4e0d\u6b63\u786e");
            }
            for (JgInfoBO jgInfoBO : jgInfo) {
                JgInfoReqBO jgInfoReqBO = new JgInfoReqBO();
                jgInfoReqBO.setZjm(jgInfoBO.getZjm());
                jgInfoReqBO.setScmID(jgInfoBO.getScmID());
                ShopBO shopBO = new ShopBO();
                shopBO.setShopMdId(jgInfoBO.getMdID());
                ResultData shopByMdId = this.shopService.findShopByMdId(shopBO);
                shopBO = (ShopBO)shopByMdId.getRespData();
                jgInfoReqBO.setMdID(shopBO.getShopId().toString());
                BigDecimal jg1 = new BigDecimal(jgInfoBO.getJg1()).multiply(new BigDecimal(1000));
                jgInfoReqBO.setJgl(jg1.toString());
                BigDecimal vipPrice = new BigDecimal(jgInfoBO.getVipPrice()).multiply(new BigDecimal(1000));
                jgInfoReqBO.setVipPrice(vipPrice.toString());
                list.add(jgInfoReqBO);
            }
            UpdateSkuPriceReqBO updateSkuPriceReqBO = new UpdateSkuPriceReqBO();
            updateSkuPriceReqBO.setJgInfo(list);
            logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u7684\u63a5\u53e3\uff1a" + ((Object)list).toString());
            logger.debug("\u770b\u770b\u53c2\u6570\uff1a" + ((JgInfoReqBO)updateSkuPriceReqBO.getJgInfo().get(0)).getJgl());
            RspBusiBaseBO rspBusiBaseBO = this.updateSkuPriceService.updateSkuPrice(updateSkuPriceReqBO);
            logger.debug("\u770b\u770b\u8fd4\u56de\u53c2\u6570\uff1a" + rspBusiBaseBO.getRespCode());
            if (!rspBusiBaseBO.getRespCode().equals("0000")) {
                logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u5931\u8d25\uff1a" + rspBusiBaseBO.getRespDesc());
            }
        }
        catch (Exception e) {
            logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", e.getMessage());
        }
        logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u7ed3\u675f");
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000");
    }
}

