/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.spu.bo.CommodityBO;
import com.ohaotian.commodity.busi.sku.web.CreateSkuBusiService;
import com.ohaotian.commodity.busi.sku.web.bo.CreateSkuBusiReqBO;
import com.tydic.externalinter.bo.ErpCommodityBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.bo.commodity.ErpChInfoBO;
import com.tydic.externalinter.bo.commodity.ErpKCInfoBO;
import com.tydic.externalinter.bo.commodity.ErpSpInfoBO;
import com.tydic.externalinter.dao.ErpChInfoDao;
import com.tydic.externalinter.dao.ErpCommodityDao;
import com.tydic.externalinter.dao.ErpKCInfoDao;
import com.tydic.externalinter.dao.ErpSpInfoDao;
import com.tydic.externalinter.dao.po.ErpChInfoPO;
import com.tydic.externalinter.dao.po.ErpCommodityPO;
import com.tydic.externalinter.dao.po.ErpKCInfoPO;
import com.tydic.externalinter.dao.po.ErpSpInfoPO;
import com.tydic.externalinter.service.ErpCommodityService;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.SkuInfoBO;
import com.tydic.zhmd.bo.SkuInfoListBO;
import com.tydic.zhmd.service.ShopService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.intfce.sku.QuerySkuByMaterialIdExtSkuIdCustomService;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomReqBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="erpCommodityService")
public class ErpCommodityServiceImpl
implements ErpCommodityService {
    private static Logger logger = LoggerFactory.getLogger(ErpCommodityServiceImpl.class);
    @Resource
    CreateSkuBusiService createSkuBusiService;
    @Resource
    QuerySkuByMaterialIdExtSkuIdCustomService querySkuByMaterialIdExtSkuIdCustomService;
    @Resource
    StockService stockService;
    @Resource
    ShopService shopService;
    @Resource
    ErpCommodityDao erpCommodityDao;
    @Resource
    ErpKCInfoDao erpKCInfoDaoDao;
    @Resource
    ErpSpInfoDao erpSpInfoDao;
    @Resource
    ErpChInfoDao erpChInfoDao;

    public ExternaLinterResultData receiveCommodity(ErpCommodityBO erpCommodityBO) {
        if (!this.validateErpCommodity(erpCommodityBO)) {
            return new ExternaLinterResultData(Boolean.valueOf(false), "", "\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        logger.debug("\u63a5\u53d7\u5230\u7684\u53c2\u6570\uff1a" + erpCommodityBO.toString());
        logger.debug("\u5f00\u59cb\u672c\u5730\u4fdd\u5b58");
        ErpCommodityPO erpCommodityPO = this.saveErpCommodity(erpCommodityBO);
        logger.debug("\u672c\u5730\u4fdd\u5b58\u6210\u529f\uff01");
        try {
            logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u4fdd\u5b58");
            this.saveErpCommodityToCommodityCenter(erpCommodityBO);
            logger.debug("\u5df2\u7ecf\u5546\u54c1\u4e2d\u5fc3\u6210\u529f");
            erpCommodityPO.setErpCommodityCommodityState(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            ExternaLinterResultData externaLinterResultData = new ExternaLinterResultData(Boolean.valueOf(false));
            externaLinterResultData.setRespDesc(e.getMessage());
            return externaLinterResultData;
        }
        try {
            logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u4fdd\u5b58");
            this.saveErpCommodityToShopCenter(erpCommodityBO);
            logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u6210\u529f");
            erpCommodityPO.setErpCommodityStockState(1);
        }
        catch (Exception e) {
            ExternaLinterResultData externaLinterResultData = new ExternaLinterResultData(Boolean.valueOf(false));
            externaLinterResultData.setRespDesc(e.getMessage());
            return externaLinterResultData;
        }
        erpCommodityPO.setErpCommodityState(1);
        logger.debug("\u6210\u529f\uff01\uff01\uff01\uff01\uff01");
        return new ExternaLinterResultData(Boolean.valueOf(true));
    }

    private ErpCommodityPO saveErpCommodity(ErpCommodityBO erpCommodityBO) {
        logger.debug("\u4fdd\u5b58\u5230\u672c\u5730\u7684\u65b9\u5f0f\u5165\u53c2\uff1a" + erpCommodityBO.toString());
        ErpCommodityPO erpCommodityPO = new ErpCommodityPO();
        String operID = erpCommodityBO.getOperID();
        erpCommodityPO.setErpCommodityOperid(operID);
        erpCommodityPO.setErpCommodityState(0);
        erpCommodityPO.setErpCommodityCommodityState(0);
        erpCommodityPO.setErpCommodityStockState(0);
        logger.debug("erp\u5546\u54c1\u6570\u636e\uff1a" + erpCommodityPO.toString());
        this.erpCommodityDao.insert(erpCommodityPO);
        logger.debug("erp\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff1a");
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        logger.debug("\u51c6\u5907\u8fdb\u5165\u5faa\u73af");
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            logger.debug("\u8fdb\u5165\u7b2c\u4e00\u5c42\u5faa\u73af");
            ErpKCInfoPO erpKCInfoPO = new ErpKCInfoPO();
            erpKCInfoPO.setMdId(erpKCInfoBO.getMdID());
            erpKCInfoPO.setErpCommodityId(erpCommodityPO.getErpCommodityId());
            this.erpKCInfoDaoDao.insert(erpKCInfoPO);
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                logger.debug("\u8fdb\u5165\u7b2c\u4e8c\u5c42\u5faa\u73af");
                ErpSpInfoPO erpSpInfoPO = new ErpSpInfoPO();
                erpSpInfoPO.setErpSpInfoHaveCh(spInfoBO.getHaveCh());
                erpSpInfoPO.setErpSpInfoZjm(spInfoBO.getZjm());
                erpSpInfoPO.setErpSpInfoScmId(spInfoBO.getScmID());
                if (null != spInfoBO.getCgType()) {
                    erpSpInfoPO.setErpSpInfoCgType(spInfoBO.getCgType());
                }
                erpSpInfoPO.setErpSpInfoType(spInfoBO.getType());
                erpSpInfoPO.setErpSpInfoPp(spInfoBO.getPp());
                erpSpInfoPO.setErpSpInfoName(spInfoBO.getName());
                erpSpInfoPO.setErpSpInfoFullName(spInfoBO.getFullName());
                erpSpInfoPO.setErpSpInfoColor(spInfoBO.getColor());
                erpSpInfoPO.setErpSpInfoNc(spInfoBO.getNc());
                String[] kcsls = spInfoBO.getKcsl().split("\\.");
                erpSpInfoPO.setErpSpInfoKcsl(kcsls[0]);
                erpSpInfoPO.setErpSpInfoJg1(spInfoBO.getJg1());
                erpSpInfoPO.setErpKcInfoId(erpKCInfoPO.getErpKcInfoId());
                this.erpSpInfoDao.insert(erpSpInfoPO);
                logger.debug("\u8fdb\u5165\u7b2c\u4e09\u5c42\u524d\u7684\u67e5\u770b");
                logger.debug(spInfoBO.toString());
                List chInfoBOList = spInfoBO.getChInfo();
                if (!CollectionUtils.isNotEmpty((Collection)chInfoBOList)) continue;
                for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                    logger.debug("\u8fdb\u5165\u7b2c\u4e09\u5c42\u5faa\u73af");
                    ErpChInfoPO erpChInfoPO = new ErpChInfoPO();
                    erpChInfoPO.setErpChInfoCh(erpChInfoBO.getCh());
                    erpChInfoPO.setErpSpInfoId(erpSpInfoPO.getErpSpInfoId());
                    this.erpChInfoDao.insert(erpChInfoPO);
                }
            }
        }
        return erpCommodityPO;
    }

    private void saveErpCommodityToCommodityCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        logger.debug("\u8c03\u7528\u4e0a\u5546\u54c1\u4e2d\u5fc3\u4fdd\u5b58\u65b9\u6cd5\u5165\u53c2\uff1a" + erpCommodityBO.toString());
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID());
            if (shopBO == null) {
                throw new Exception("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                CreateSkuBusiReqBO createSkuBusiReqBO = new CreateSkuBusiReqBO();
                PriceBO priceBO = new PriceBO();
                BigDecimal jg1 = new BigDecimal(spInfoBO.getJg1());
                priceBO.setSalePrice(Long.valueOf(jg1.longValue() * 1000L));
                priceBO.setSupplierId(shopBO.getShopId());
                createSkuBusiReqBO.setPrice(priceBO);
                CommodityBO commodityBO = new CommodityBO();
                commodityBO.setCommodityTypeId(Long.valueOf(1L));
                commodityBO.setCommodityCode("no");
                commodityBO.setSupplierId(shopBO.getShopId());
                com.ohaotian.commodity.atom.sku.bo.SkuBO skuBO = new com.ohaotian.commodity.atom.sku.bo.SkuBO();
                skuBO.setSupplierId(shopBO.getShopId());
                skuBO.setBrandName(spInfoBO.getName());
                skuBO.setMfgSku(spInfoBO.getName());
                skuBO.setSkuName(spInfoBO.getName());
                skuBO.setSkuLongName(spInfoBO.getFullName());
                skuBO.setSkuPrice(Long.valueOf(jg1.longValue() * 1000L));
                skuBO.setExtSkuId(spInfoBO.getZjm());
                skuBO.setSkuLocation(Integer.valueOf(1));
                skuBO.setCommodityTypeId(Long.valueOf(1L));
                skuBO.setSkuStatus(Integer.valueOf(1));
                skuBO.setMaterialId(spInfoBO.getScmID());
                skuBO.setVendorName(shopBO.getShopMdName());
                createSkuBusiReqBO.setSku(skuBO);
                createSkuBusiReqBO.setSpu(commodityBO);
                createSkuBusiReqBO.setSkuPicture(new ArrayList());
                createSkuBusiReqBO.setSkuSpec(new ArrayList());
                logger.debug("\u5f00\u59cb\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u5165\u53c2\uff1a" + createSkuBusiReqBO.toString());
                logger.debug("\u5f00\u59cb\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0cJSON\uff1a" + JSON.toJSONString((Object)createSkuBusiReqBO));
                this.createSkuBusiService.createSku(createSkuBusiReqBO);
            }
        }
    }

    private void saveErpCommodityToShopCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u4fdd\u5b58\u65b9\u6cd5\u5165\u53c2\uff1a" + erpCommodityBO.toString());
        SkuInfoListBO skuInfoLisBO = new SkuInfoListBO();
        ArrayList<SkuInfoBO> skuInfoBOList = new ArrayList<SkuInfoBO>();
        skuInfoLisBO.setSkuInfoBO(skuInfoBOList);
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            logger.debug("\u8fdb\u5165KCInfoBO\u5faa\u73af");
            shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID());
            if (shopBO == null) {
                throw new Exception("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                logger.debug("\u8fdb\u5165SpInfo\u5faa\u73af");
                logger.debug("\u6253\u5370\u8fd9\u4e2a\u53c2\u6570\uff1a" + spInfoBO.toString());
                List chInfoBOList = null;
                ArrayList<String> skuInstanceCode = new ArrayList<String>();
                logger.debug("\u5224\u65ad\u524d" + spInfoBO.getChInfo());
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    chInfoBOList = spInfoBO.getChInfo();
                }
                logger.debug("\u5224\u65ad\u7ed3\u675f");
                if (!CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) continue;
                logger.debug("chInfo\u4e0d\u4e3a\u7a7a\u7684\u60c5\u51b5");
                for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                    skuInstanceCode.add(erpChInfoBO.getCh());
                }
                logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6skuId\uff0c\u95e8\u5e97Id:" + shopBO.getShopId() + "\u7269\u6599\u7f16\u7801\uff1a" + spInfoBO.getScmID() + "\u52a9\u8bb0\u7801\uff1a" + spInfoBO.getZjm());
                Long skuId = this.getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(shopBO.getShopId(), spInfoBO.getScmID(), spInfoBO.getZjm());
                logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6skuId:" + skuId);
                SkuInfoBO skuInfoBO = new SkuInfoBO();
                skuInfoBO.setSkuId(skuId);
                skuInfoBO.setShopId(shopBO.getShopId());
                String[] kcsls = spInfoBO.getKcsl().split("\\.");
                skuInfoBO.setChangeAmount(Integer.valueOf(Integer.parseInt(kcsls[0])));
                skuInfoBO.setSkuInstanceCode(skuInstanceCode);
                if (null != spInfoBO.getCgType() && !StringUtils.isEmpty((String)spInfoBO.getCgType().trim())) {
                    skuInfoBO.setSkuStockPurchaseType(Integer.valueOf(Integer.parseInt(spInfoBO.getCgType())));
                }
                skuInfoBO.setScmID(spInfoBO.getScmID());
                skuInfoBO.setZjm(spInfoBO.getZjm());
                skuInfoBOList.add(skuInfoBO);
            }
        }
        System.out.println("\u8c03\u7528\u95e8\u5e97\u4e2d\u5fc3\u53c2\u6570\uff1a" + JSON.toJSONString((Object)skuInfoLisBO));
        this.stockService.inStock(skuInfoLisBO);
    }

    private ShopBO getShopBoByShopMdId(String shopMdId) {
        ShopBO tempShop = new ShopBO();
        tempShop.setShopMdId(shopMdId);
        ResultData resultData = this.shopService.findShopByMdId(tempShop);
        ShopBO shopBO = (ShopBO)resultData.getRespData();
        return shopBO;
    }

    private Long getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(Long shopId, String materialId, String extSkuId) {
        QuerySkuByMaterialIdExtSkuIdCustomReqBO querySkuByMaterialIdExtSkuIdCustomReqBO = new QuerySkuByMaterialIdExtSkuIdCustomReqBO();
        querySkuByMaterialIdExtSkuIdCustomReqBO.setSupplierId(shopId);
        ArrayList<String> materialIds = new ArrayList<String>();
        materialIds.add(materialId);
        querySkuByMaterialIdExtSkuIdCustomReqBO.setMaterialIds(materialIds);
        ArrayList<String> extSkuIds = new ArrayList<String>();
        extSkuIds.add(extSkuId);
        querySkuByMaterialIdExtSkuIdCustomReqBO.setExtSkuIds(extSkuIds);
        QuerySkuByMaterialIdExtSkuIdCustomRspBO querySkuDetailRspBO = this.querySkuByMaterialIdExtSkuIdCustomService.querySkuByMaterialIdExtSkuId(querySkuByMaterialIdExtSkuIdCustomReqBO);
        if (querySkuDetailRspBO != null && querySkuDetailRspBO.getSkus().size() != 0) {
            return ((SkuBO)querySkuDetailRspBO.getSkus().get(0)).getSkuId();
        }
        return null;
    }

    private boolean validateErpCommodity(ErpCommodityBO erpCommodityBO) {
        logger.debug("\u8fdb\u5165\u6821\u9a8c");
        if (erpCommodityBO == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            return false;
        }
        if (!this.validateString(erpCommodityBO.getOperID())) {
            logger.debug("\u5355\u636e\u53f7\u4e3a\u7a7a");
            return false;
        }
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        if (!this.validateList(erpKCInfoBOList)) {
            logger.debug("\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a");
            return false;
        }
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            if (!this.validateString(erpKCInfoBO.getMdID())) {
                logger.debug("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
                return false;
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            if (!this.validateList(spInfoBOList)) {
                logger.debug("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
                return false;
            }
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                if (!this.validateString(spInfoBO.getHaveCh())) {
                    logger.debug("\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
                    return false;
                }
                if (!spInfoBO.getHaveCh().equals("1") && !spInfoBO.getHaveCh().equals("2")) {
                    logger.debug("\u662f\u5426\u6709\u4e32\u53f7\u679a\u4e3e\u9519\u8bef");
                    return false;
                }
                if (!this.validateString(spInfoBO.getZjm())) {
                    logger.debug("\u52a9\u8bb0\u7801\u4e3a\u7a7a");
                    return false;
                }
                if (!this.validateString(spInfoBO.getScmID())) {
                    logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    return false;
                }
                if (!this.validateString(spInfoBO.getName())) {
                    logger.debug("\u578b\u53f7\u4e3a\u7a7a");
                    return false;
                }
                if (!this.validateString(spInfoBO.getFullName())) {
                    return false;
                }
                if (!this.validateString(spInfoBO.getKcsl())) {
                    logger.debug("\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a");
                    return false;
                }
                if (!this.validateString(spInfoBO.getJg1())) {
                    logger.debug("\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a");
                    return false;
                }
                if (!spInfoBO.getHaveCh().equals("1")) continue;
                List chInfoBOList = spInfoBO.getChInfo();
                if (!this.validateList(chInfoBOList)) {
                    logger.debug("\u5b58\u5728\u4e32\u53f7\u4f46\u662f\u4e32\u53f7\u5217\u8868\u4e3a\u7a7a");
                    return false;
                }
                String[] Kscls = spInfoBO.getKcsl().split("\\.");
                logger.debug(String.valueOf(chInfoBOList.size()));
                logger.debug(Kscls[0]);
                logger.debug("\u7ed3\u679c\uff1a" + !Kscls[0].equals(String.valueOf(chInfoBOList.size())));
                if (!Kscls[0].equals(String.valueOf(chInfoBOList.size()))) {
                    logger.debug("\u53ef\u7528\u5e93\u5b58\u91cf\u548c\u4e32\u53f7\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4");
                    return false;
                }
                for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                    if (this.validateString(erpChInfoBO.getCh())) continue;
                    logger.debug("\u4e32\u53f7\u4e3a\u7a7a");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateString(String str) {
        boolean b = false;
        if (str != null && str.trim().length() > 0) {
            b = true;
        }
        return b;
    }

    private boolean validateList(List ls) {
        boolean b = false;
        if (ls != null && ls.size() > 0) {
            b = true;
        }
        return b;
    }

    private Long getCode() {
        StringBuilder sb = new StringBuilder("");
        Random ra = new Random();
        for (int i = 0; i < 6; ++i) {
            sb.append(ra.nextInt(10));
        }
        return new Long(sb.toString());
    }
}

