/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.externalinter.busi.bo.IssueInvoiceBusiReqBO;
import com.tydic.externalinter.busi.bo.IssueInvoiceBusiRespBO;
import com.tydic.externalinter.busi.service.IssueInvoiceBusiService;
import com.tydic.externalinter.config.HttpUntil;
import com.tydic.externalinter.config.MyX509TrustManager;
import com.tydic.externalinter.config.ObtainPublicElement;
import com.tydic.externalinter.config.PropertiesReaderUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="issueInvoiceBusiService")
public class IssueInvoiceBusiServiceImpl
implements IssueInvoiceBusiService {
    private static final Logger logger = LoggerFactory.getLogger(IssueInvoiceBusiServiceImpl.class);

    public IssueInvoiceBusiRespBO issueInvoice(IssueInvoiceBusiReqBO issueInvoiceBusiReqBO) {
        IssueInvoiceBusiRespBO issueInvoiceBusiRespBO = new IssueInvoiceBusiRespBO();
        logger.debug("\u5f00\u59cb\u8c03\u7528\u53d1\u7968\u670d\u52a1\u3002\u3002\u3002");
        try {
            String url = PropertiesReaderUtils.getHttpsURL();
            String appId = PropertiesReaderUtils.getAppId();
            String provicenId = PropertiesReaderUtils.getProvicenId();
            logger.debug("\u67e5\u770b\u53c2\u6570" + url + "==" + appId + "==" + provicenId);
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(new Date());
            Random random = new Random();
            String result = "";
            for (int i = 0; i < 6; ++i) {
                result = result + random.nextInt(10);
            }
            String rTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + result;
            String transid = provicenId + rTime;
            logger.debug("\u52a0\u5bc6\u4e2d...");
            ObtainPublicElement obtainPublicElement = new ObtainPublicElement();
            String allToken = obtainPublicElement.getPublicElement(timestamp, transid).get("sign").toString();
            String jsonHead = "{\"HEAD\": {\"APP_ID\": \"" + appId + "\",\"TIMESTAMP\": \"" + timestamp + "\",\"TRANS_ID\": \"" + transid + "\",\"TOKEN\":\"" + allToken + "\" ,\"RESERVED\":[{ \"RESERVED_ID\": \"\",\"RESERVED_VALUE\":\"\" },{\"RESERVED_ID\": \"\", \"RESERVED_VALUE\": \"\"} ] },";
            String jsonBody = "\"BODY\":" + JsonUtils.objectBeanToJsonString((Object)issueInvoiceBusiReqBO) + ",";
            String attached = "\"ATTACHED\": {\"MEDIA_INFO\":\"\"}}";
            String all = jsonHead + jsonBody + attached;
            logger.debug("url\u5730\u5740\uff1a" + url + "------------\u8bf7\u6c42\u62a5\u6587\uff1a" + all);
            String comeBack = null;
            if (url.startsWith("https")) {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                comeBack = myX509TrustManager.httpsRequest(url, "POST", all);
            } else {
                HttpUntil httpUntil = new HttpUntil();
                comeBack = httpUntil.httpPost(url, all);
            }
            logger.debug("\u53d1\u9001\u8bf7\u6c42\u7ed3\u675f\u3002\u3002\u3002");
            if (comeBack.contains("9999")) {
                issueInvoiceBusiRespBO.setRespCode("9999");
                issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u5931\u8d25");
            } else {
                issueInvoiceBusiRespBO.setRespCode("0000");
                issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.info("\u7cfb\u7edf\u5f02\u5e38..." + e.getStackTrace());
            issueInvoiceBusiRespBO.setRespCode("9999");
            issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u5931\u8d25");
        }
        return issueInvoiceBusiRespBO;
    }

    public static void main(String[] args) {
        HttpUntil httpUntil = new HttpUntil();
        String comeBack = httpUntil.httpPost("http://lscs.139erp.com/erp_scm_tyls_eserver/HttpServerToNewRetail?interfaceType=02", "{\"operID\":\"2018083004\",\r\n\"orderID\":\"20180004\",\r\n\"fpType\":\"1\",\r\n\"sbh\":\"\",\r\n\"fptt\":\"\u65b0\u6280\u672f\u6709\u9650\u516c\u53f8\",\r\n\"addess\":\"\",\r\n\"telephone\":\"\",\r\n\"khh\":\"\",\r\n\"yhzh\":\"\",\r\n\"gkPhone\":\"18812038860\",\r\n\"gkEmail\":\"sunlh@tydic.com\"}");
        System.out.println(comeBack);
    }
}

