/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.ohaotian.base.common.exception.ResourceException;
import com.tydic.externalinter.atom.StockSyncTaskAtomService;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.dao.StockSyncTaskDao;
import com.tydic.externalinter.dao.po.StockSyncTaskPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockSyncTaskAtomServiceImpl
implements StockSyncTaskAtomService {
    private static final Logger logger = LoggerFactory.getLogger(StockSyncTaskAtomServiceImpl.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    @Autowired
    private StockSyncTaskDao stockSyncErrorHistoryDao;

    @Override
    public void saveTaskInfo(StockSyncTaskPO reqPO) {
        if (null == reqPO) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            this.stockSyncErrorHistoryDao.insertSelective(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u65b0\u589e\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public StockSyncTaskPO getTaskInfo(StockSyncTaskPO reqPO) {
        String serialNum = reqPO.getSerialNum();
        if (StringUtils.isBlank((CharSequence)serialNum) || StringUtils.isBlank((CharSequence)reqPO.getChangeType())) {
            logger.error("\u6d41\u6c34\u53f7\u6216\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u6d41\u6c34\u53f7\u6216\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        StockSyncTaskPO record = new StockSyncTaskPO();
        record.setSerialNum(serialNum);
        record.setChangeType(reqPO.getChangeType());
        StockSyncTaskPO taskInfo = null;
        try {
            taskInfo = this.stockSyncErrorHistoryDao.selectByCondition(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u67e5\u8be2\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null != taskInfo) {
            return taskInfo;
        }
        this.saveTaskInfo(record);
        return record;
    }

    @Override
    public void modifyTaskInfo(StockSyncTaskPO reqPO) {
        if (StringUtils.isBlank((CharSequence)reqPO.getSerialNum()) || StringUtils.isBlank((CharSequence)reqPO.getChangeType())) {
            logger.error("\u6d41\u6c34\u53f7\u6216\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u6d41\u6c34\u53f7\u6216\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        try {
            this.stockSyncErrorHistoryDao.updateBySerialNumAndChangeType(reqPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u66f4\u65b0\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public ExternaLinterResultData modifyPubMethod(StockSyncTaskPO reqPO, String code, String msg) {
        if (null == reqPO.getTaskExecTimes()) {
            reqPO.setTaskExecTimes(1);
            reqPO.setRespCode(code);
            reqPO.setRespDesc(msg);
        } else {
            reqPO.setTaskExecTimes(reqPO.getTaskExecTimes() + 1);
        }
        reqPO.setTaskExecTime(new Date());
        reqPO.setTaskExecRespCode(code);
        reqPO.setTaskExecRespDesc(msg);
        if ("0000".equals(code)) {
            reqPO.setTaskExecStatus("02");
        } else {
            reqPO.setTaskExecStatus("01");
        }
        try {
            this.modifyTaskInfo(reqPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4efb\u52a1\u3010" + reqPO.getSerialNum() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u66f4\u65b0\u4efb\u52a1\u3010" + reqPO.getSerialNum() + "\u3011\u5931\u8d25");
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }
}

