/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.tydic.externalinter.ability.bo.ExtJgInfoBO;
import com.tydic.externalinter.bo.ERPSyncPriceBusIBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.service.ERPSyncProductPriceService;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.service.ShopService;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceReqBO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncProductPriceService")
public class ERPSyncProductPriceServiceImpl
implements ERPSyncProductPriceService {
    private static final Logger logger = LoggerFactory.getLogger(ERPSyncProductPriceServiceImpl.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    @Resource
    private UpdateSkuPriceService updateSkuPriceService;
    @Resource
    private ShopService shopService;

    public ExternaLinterResultData syncProductPrice(ERPSyncPriceBusIBO erpSyncPriceBusIBO) {
        if (isDebug.booleanValue()) {
            logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u5f00\u59cb");
            logger.debug("\u53c2\u6570\uff1a" + erpSyncPriceBusIBO.toString());
        }
        ArrayList<JgInfoReqBO> list = new ArrayList<JgInfoReqBO>();
        try {
            List jgInfo = erpSyncPriceBusIBO.getJgInfo();
            if (jgInfo == null || jgInfo.size() == 0) {
                logger.error("ERP\u4f20\u53c2\u4e0d\u6b63\u786e");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u4f20\u53c2\u4e0d\u6b63\u786e");
            }
            for (ExtJgInfoBO jgInfoBO : jgInfo) {
                JgInfoReqBO jgInfoReqBO = new JgInfoReqBO();
                jgInfoReqBO.setZjm(jgInfoBO.getZjm());
                jgInfoReqBO.setScmID(jgInfoBO.getScmID());
                ShopBO shopBO = new ShopBO();
                shopBO.setShopMdId(jgInfoBO.getMdID());
                ResultData shopByMdId = this.shopService.findShopByMdId(shopBO);
                shopBO = (ShopBO)shopByMdId.getRespData();
                if (shopBO == null) {
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u95e8\u5e97\u4fe1\u606f");
                }
                jgInfoReqBO.setMdID(shopBO.getShopId().toString());
                if (StringUtils.isNotBlank((CharSequence)jgInfoBO.getJg1())) {
                    jgInfoReqBO.setJgl(jgInfoBO.getJg1());
                }
                if (StringUtils.isNotBlank((CharSequence)jgInfoBO.getVipPrice())) {
                    jgInfoReqBO.setVipPrice(jgInfoBO.getVipPrice());
                }
                if (StringUtils.isNotBlank((CharSequence)jgInfoBO.getLimitPrice())) {
                    jgInfoReqBO.setLimitPrice(jgInfoBO.getLimitPrice());
                }
                jgInfoReqBO.setAssessmentPrice(StringUtils.isNotBlank((CharSequence)jgInfoBO.getAssessmentPrice()) ? jgInfoBO.getAssessmentPrice() : null);
                jgInfoReqBO.setPurchasePrice(StringUtils.isNotBlank((CharSequence)jgInfoBO.getPurchasePrice()) ? jgInfoBO.getPurchasePrice() : null);
                list.add(jgInfoReqBO);
            }
            UpdateSkuPriceReqBO updateSkuPriceReqBO = new UpdateSkuPriceReqBO();
            updateSkuPriceReqBO.setJgInfo(list);
            if (isDebug.booleanValue()) {
                logger.debug("\u8c03\u7528\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5165\u53c2\uff1a" + updateSkuPriceReqBO);
            }
            RspBusiBaseBO rspBusiBaseBO = this.updateSkuPriceService.updateSkuPrice(updateSkuPriceReqBO);
            if (isDebug.booleanValue()) {
                logger.debug("\u8c03\u7528\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u51fa\u53c2\uff1a" + rspBusiBaseBO);
            }
        }
        catch (Exception e) {
            logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", e.getMessage());
        }
        logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u7ed3\u675f");
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    public static void main(String[] args) {
    }
}

