/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.base.common.exception.ResourceException;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.atom.spu.bo.CommodityBO;
import com.ohaotian.commodity.busi.sku.web.CreateSkuBusiService;
import com.ohaotian.commodity.busi.sku.web.bo.CreateSkuBusiReqBO;
import com.ohaotian.commodity.busi.sku.web.bo.CreateSkuBusiRspBO;
import com.tydic.externalinter.atom.StockSyncTaskAtomService;
import com.tydic.externalinter.bo.ErpCommodityBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.bo.commodity.ErpChInfoBO;
import com.tydic.externalinter.bo.commodity.ErpKCInfoBO;
import com.tydic.externalinter.bo.commodity.ErpSpInfoBO;
import com.tydic.externalinter.dao.ErpChInfoDao;
import com.tydic.externalinter.dao.ErpCommodityDao;
import com.tydic.externalinter.dao.ErpKCInfoDao;
import com.tydic.externalinter.dao.ErpSpInfoDao;
import com.tydic.externalinter.dao.po.ErpChInfoPO;
import com.tydic.externalinter.dao.po.ErpCommodityPO;
import com.tydic.externalinter.dao.po.ErpKCInfoPO;
import com.tydic.externalinter.dao.po.ErpSpInfoPO;
import com.tydic.externalinter.dao.po.StockSyncTaskPO;
import com.tydic.externalinter.service.ErpCommodityService;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.SkuInfoBO;
import com.tydic.zhmd.bo.SkuInfoListBO;
import com.tydic.zhmd.service.ShopService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.intfce.sku.QuerySkuByMaterialIdExtSkuIdCustomService;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomReqBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="erpCommodityService")
public class ErpCommodityServiceImpl
implements ErpCommodityService {
    private static Logger logger = LoggerFactory.getLogger(ErpCommodityServiceImpl.class);
    private static Boolean isDebug = logger.isDebugEnabled();
    @Resource
    CreateSkuBusiService createSkuBusiService;
    @Resource
    QuerySkuByMaterialIdExtSkuIdCustomService querySkuByMaterialIdExtSkuIdCustomService;
    @Resource
    StockService stockService;
    @Resource
    ShopService shopService;
    @Resource
    ErpCommodityDao erpCommodityDao;
    @Resource
    ErpKCInfoDao erpKCInfoDaoDao;
    @Resource
    ErpSpInfoDao erpSpInfoDao;
    @Resource
    ErpChInfoDao erpChInfoDao;
    @Autowired
    private StockSyncTaskAtomService stockSyncTaskAtomService;
    private static final String PATTERN = "^(-)?([1-9]\\d*|[0]{1,1})$";

    public ExternaLinterResultData receiveCommodity(ErpCommodityBO erpCommodityBO) {
        ExternaLinterResultData modifyRsp;
        String erpInputParams = JSON.toJSONString((Object)erpCommodityBO);
        if (isDebug.booleanValue()) {
            logger.debug("\u5e93\u5b58\u4fe1\u606f\u540c\u6b65\u5165\u53c2\uff1a" + erpCommodityBO);
        }
        StockSyncTaskPO stockSyncTaskPO = null;
        try {
            StockSyncTaskPO reqPO = new StockSyncTaskPO();
            reqPO.setSerialNum(erpCommodityBO.getOperID());
            if ("2".equals(erpCommodityBO.getCzType())) {
                reqPO.setChangeType("5");
            } else {
                reqPO.setChangeType("4");
            }
            stockSyncTaskPO = this.stockSyncTaskAtomService.getTaskInfo(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u540c\u6b65\u4efb\u52a1\u3010" + erpCommodityBO.getOperID() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u65b0\u589e\u540c\u6b65\u4efb\u52a1\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((CharSequence)stockSyncTaskPO.getRespCode()) && "0000".equals(stockSyncTaskPO.getRespCode())) {
            logger.error("\u5e93\u5b58\u4fe1\u606f\u5df2\u540c\u6b65");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5e93\u5b58\u4fe1\u606f\u5df2\u540c\u6b65");
        }
        if (StringUtils.isNotBlank((CharSequence)stockSyncTaskPO.getTaskExecRespCode()) && "0000".equals(stockSyncTaskPO.getTaskExecRespCode()) && "02".equals(stockSyncTaskPO.getTaskExecStatus())) {
            logger.error("\u5df2\u6210\u529f\u5355\u636e\u4e0d\u5141\u8bb8\u91cd\u590d\u540c\u6b65");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5df2\u6210\u529f\u5355\u636e\u4e0d\u5141\u8bb8\u91cd\u590d\u540c\u6b65");
        }
        stockSyncTaskPO.setInputParams(erpInputParams);
        String code = "9999";
        String validStr = this.validateErpCommodity(erpCommodityBO);
        if (StringUtils.isNotBlank((CharSequence)validStr)) {
            ExternaLinterResultData modifyRsp2 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, validStr);
            if (!"0000".equals(modifyRsp2.getRespCode())) {
                return modifyRsp2;
            }
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", validStr);
        }
        String ctType = erpCommodityBO.getCzType();
        if (StringUtils.isBlank((CharSequence)ctType)) {
            ctType = "1";
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u5f00\u59cb\u672c\u5730\u4fdd\u5b58");
        }
        this.saveErpCommodity(erpCommodityBO);
        if (isDebug.booleanValue()) {
            logger.debug("\u672c\u5730\u4fdd\u5b58\u6210\u529f\uff01");
        }
        switch (ctType) {
            case "1": {
                if (isDebug.booleanValue()) {
                    logger.debug("\u5e93\u5b58\u65b0\u589e");
                }
                try {
                    if (isDebug.booleanValue()) {
                        logger.debug("\u65b0\u589e\u5546\u54c1");
                    }
                    this.saveErpCommodityToCommodityCenter(erpCommodityBO);
                    if (isDebug.booleanValue()) {
                        logger.debug("\u65b0\u589e\u5546\u54c1\u6210\u529f");
                    }
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
                    ExternaLinterResultData modifyRsp3 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, "\u65b0\u589e\u5546\u54c1\u5931\u8d25");
                    if (!"0000".equals(modifyRsp3.getRespCode())) {
                        return modifyRsp3;
                    }
                    ExternaLinterResultData externaLinterResultData = new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25");
                    return externaLinterResultData;
                }
                try {
                    ExternaLinterResultData instockRsp;
                    if (isDebug.booleanValue()) {
                        logger.debug("\u65b0\u589e\u5e93\u5b58");
                    }
                    if (!(instockRsp = this.saveErpCommodityToShopCenter(erpCommodityBO)).getSuccess().booleanValue()) {
                        ExternaLinterResultData modifyRsp4 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, instockRsp.getRespDesc());
                        if (!"0000".equals(modifyRsp4.getRespCode())) {
                            return modifyRsp4;
                        }
                        return instockRsp;
                    }
                    if (isDebug.booleanValue()) {
                        logger.debug("\u65b0\u589e\u5e93\u5b58\u6210\u529f");
                    }
                }
                catch (Exception e) {
                    logger.error("\u5e93\u5b58\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
                    ExternaLinterResultData modifyRsp5 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, e.getMessage());
                    if (!"0000".equals(modifyRsp5.getRespCode())) {
                        return modifyRsp5;
                    }
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", e.getMessage());
                }
                if (!isDebug.booleanValue()) break;
                logger.debug("\u5e93\u5b58\u65b0\u589e\u5b8c\u6210");
                break;
            }
            case "2": {
                if (isDebug.booleanValue()) {
                    logger.debug("\u5e93\u5b58\u5220\u9664");
                }
                SkuInfoListBO reqBO = new SkuInfoListBO();
                ArrayList<SkuInfoBO> reqList = new ArrayList<SkuInfoBO>();
                try {
                    for (ErpKCInfoBO kc : erpCommodityBO.getKcInfo()) {
                        List spInfoBOS = kc.getSpInfo();
                        for (ErpSpInfoBO erpSpInfoBO : spInfoBOS) {
                            SkuInfoBO sku = new SkuInfoBO();
                            String amount = erpSpInfoBO.getKcsl();
                            if (StringUtils.isNotBlank((CharSequence)amount)) {
                                if (amount.contains(".")) {
                                    amount = amount.substring(0, amount.lastIndexOf("."));
                                }
                                if (!Pattern.matches(PATTERN, amount)) {
                                    logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                                    throw new ResourceException("9999", "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                                }
                                sku.setChangeAmount(Integer.valueOf(Integer.parseInt(amount)));
                            }
                            sku.setScmID(erpSpInfoBO.getScmID());
                            if (StringUtils.isNotBlank((CharSequence)erpSpInfoBO.getCgType())) {
                                sku.setSkuStockPurchaseType(Integer.valueOf(Integer.parseInt(erpSpInfoBO.getCgType())));
                            }
                            sku.setShopCode(kc.getMdID());
                            ArrayList<String> erpCodes = null;
                            if (CollectionUtils.isNotEmpty((Collection)erpSpInfoBO.getChInfo())) {
                                erpCodes = new ArrayList<String>(erpSpInfoBO.getChInfo().size());
                                for (ErpChInfoBO chInfo : erpSpInfoBO.getChInfo()) {
                                    if (!StringUtils.isNotBlank((CharSequence)chInfo.getCh())) continue;
                                    erpCodes.add(chInfo.getCh());
                                }
                                sku.setSkuInstanceCode(erpCodes);
                            }
                            sku.setZjm(erpSpInfoBO.getZjm());
                            reqList.add(sku);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u5c01\u88c5\u5e93\u5b58\u5220\u9664\u5165\u53c2\u5931\u8d25\uff1a" + e.getMessage());
                    ExternaLinterResultData modifyRsp6 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, "\u5c01\u88c5\u5e93\u5b58\u5220\u9664\u5165\u53c2\u5931\u8d25");
                    if (!"0000".equals(modifyRsp6.getRespCode())) {
                        return modifyRsp6;
                    }
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5c01\u88c5\u5e93\u5b58\u5220\u9664\u5165\u53c2\u5931\u8d25");
                }
                reqBO.setSkuInfoBO(reqList);
                if (isDebug.booleanValue()) {
                    logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u53c2\uff1a" + reqBO);
                }
                ResultData delStockRsp = null;
                try {
                    delStockRsp = this.stockService.removeSkuStock(reqBO);
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                    ExternaLinterResultData modifyRsp7 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25");
                    if (!"0000".equals(modifyRsp7.getRespCode())) {
                        return modifyRsp7;
                    }
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25");
                }
                if ("0000".equals(delStockRsp.getRespCode())) break;
                logger.error("\u5e93\u5b58\u5220\u9664\u5931\u8d25\uff1a" + delStockRsp.getRespDesc());
                ExternaLinterResultData modifyRsp8 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, delStockRsp.getRespDesc());
                if (!"0000".equals(modifyRsp8.getRespCode())) {
                    return modifyRsp8;
                }
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", delStockRsp.getRespDesc());
            }
            default: {
                logger.error("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                ExternaLinterResultData modifyRsp9 = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, code, "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                if (!"0000".equals(modifyRsp9.getRespCode())) {
                    return modifyRsp9;
                }
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            }
        }
        if (!"0000".equals((modifyRsp = this.stockSyncTaskAtomService.modifyPubMethod(stockSyncTaskPO, "0000", "\u6210\u529f")).getRespCode())) {
            return modifyRsp;
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private ErpCommodityPO saveErpCommodity(ErpCommodityBO erpCommodityBO) {
        ErpCommodityPO erpCommodityPO = new ErpCommodityPO();
        try {
            if (isDebug.booleanValue()) {
                logger.debug("\u4fdd\u5b58\u5230\u672c\u5730\u7684\u65b9\u5f0f\u5165\u53c2\uff1a" + erpCommodityBO.toString());
            }
            String operID = erpCommodityBO.getOperID();
            erpCommodityPO.setErpCommodityOperid(operID);
            erpCommodityPO.setErpCommodityState(0);
            erpCommodityPO.setErpCommodityCommodityState(0);
            erpCommodityPO.setErpCommodityStockState(0);
            if (isDebug.booleanValue()) {
                logger.debug("erp\u5546\u54c1\u6570\u636e\uff1a" + erpCommodityPO);
            }
            this.erpCommodityDao.insert(erpCommodityPO);
            if (isDebug.booleanValue()) {
                logger.debug("erp\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff1a");
            }
            List erpKCInfoBOList = erpCommodityBO.getKcInfo();
            for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
                ErpKCInfoPO erpKCInfoPO = new ErpKCInfoPO();
                erpKCInfoPO.setMdId(erpKCInfoBO.getMdID());
                erpKCInfoPO.setErpCommodityId(erpCommodityPO.getErpCommodityId());
                this.erpKCInfoDaoDao.insert(erpKCInfoPO);
                List spInfoBOList = erpKCInfoBO.getSpInfo();
                for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                    ErpSpInfoPO erpSpInfoPO = new ErpSpInfoPO();
                    erpSpInfoPO.setErpSpInfoHaveCh(spInfoBO.getHaveCh());
                    erpSpInfoPO.setErpSpInfoZjm(spInfoBO.getZjm());
                    erpSpInfoPO.setErpSpInfoScmId(spInfoBO.getScmID());
                    if (null != spInfoBO.getCgType()) {
                        erpSpInfoPO.setErpSpInfoCgType(spInfoBO.getCgType());
                    }
                    erpSpInfoPO.setErpSpInfoType(spInfoBO.getType());
                    erpSpInfoPO.setErpSpInfoPp(spInfoBO.getPp());
                    erpSpInfoPO.setErpSpInfoName(spInfoBO.getName());
                    erpSpInfoPO.setErpSpInfoFullName(spInfoBO.getFullName());
                    erpSpInfoPO.setErpSpInfoColor(spInfoBO.getColor());
                    erpSpInfoPO.setErpSpInfoNc(spInfoBO.getNc());
                    String[] kcsls = spInfoBO.getKcsl().split("\\.");
                    erpSpInfoPO.setErpSpInfoKcsl(kcsls[0]);
                    erpSpInfoPO.setErpSpInfoJg1(spInfoBO.getJg1());
                    erpSpInfoPO.setErpKcInfoId(erpKCInfoPO.getErpKcInfoId());
                    this.erpSpInfoDao.insert(erpSpInfoPO);
                    List chInfoBOList = spInfoBO.getChInfo();
                    if (!CollectionUtils.isNotEmpty((Collection)chInfoBOList)) continue;
                    for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                        ErpChInfoPO erpChInfoPO = new ErpChInfoPO();
                        erpChInfoPO.setErpChInfoCh(erpChInfoBO.getCh());
                        erpChInfoPO.setErpSpInfoId(erpSpInfoPO.getErpSpInfoId());
                        this.erpChInfoDao.insert(erpChInfoPO);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u5e93\u5b58\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        return erpCommodityPO;
    }

    private void saveErpCommodityToCommodityCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        if (isDebug.booleanValue()) {
            logger.debug("\u8c03\u7528\u4e0a\u5546\u54c1\u4e2d\u5fc3\u4fdd\u5b58\u65b9\u6cd5\u5165\u53c2\uff1a" + erpCommodityBO.toString());
        }
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID());
            if (shopBO == null) {
                throw new Exception("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                CreateSkuBusiRspBO rsp;
                Long skuId;
                if (isDebug.booleanValue()) {
                    logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6skuId\uff0c\u95e8\u5e97Id:" + shopBO.getShopId() + "\u7269\u6599\u7f16\u7801\uff1a" + spInfoBO.getScmID() + "\u52a9\u8bb0\u7801\uff1a" + spInfoBO.getZjm());
                }
                if (null != (skuId = this.getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(shopBO.getShopId(), spInfoBO.getScmID(), spInfoBO.getZjm()))) {
                    if (!isDebug.booleanValue()) continue;
                    logger.debug("\u5f53\u524d\u5546\u54c1\u3010" + skuId + "\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u6267\u884c\u5546\u54c1\u521b\u5efa");
                    continue;
                }
                CreateSkuBusiReqBO createSkuBusiReqBO = new CreateSkuBusiReqBO();
                PriceBO priceBO = new PriceBO();
                Long salePriceLong = null;
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getJg1())) {
                    Double salePrice = Double.parseDouble(spInfoBO.getJg1()) * 10000.0;
                    salePriceLong = salePrice.longValue();
                    priceBO.setSalePrice(salePriceLong);
                }
                priceBO.setSupplierId(shopBO.getShopId());
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getLimitPrice())) {
                    Double limitPrice = Double.parseDouble(spInfoBO.getLimitPrice()) * 10000.0;
                    priceBO.setAgreementPrice(Long.valueOf(limitPrice.longValue()));
                }
                createSkuBusiReqBO.setPrice(priceBO);
                CommodityBO commodityBO = new CommodityBO();
                commodityBO.setCommodityTypeId(Long.valueOf(1L));
                commodityBO.setCommodityCode("no");
                commodityBO.setSupplierId(shopBO.getShopId());
                com.ohaotian.commodity.atom.sku.bo.SkuBO skuBO = new com.ohaotian.commodity.atom.sku.bo.SkuBO();
                skuBO.setSupplierId(shopBO.getShopId());
                skuBO.setMfgSku(spInfoBO.getName());
                skuBO.setSkuName(spInfoBO.getName());
                skuBO.setSkuLongName(spInfoBO.getFullName());
                skuBO.setSkuPrice(salePriceLong);
                skuBO.setExtSkuId(spInfoBO.getZjm());
                skuBO.setSkuLocation(Integer.valueOf(0));
                skuBO.setCommodityTypeId(Long.valueOf(1L));
                skuBO.setSkuStatus(Integer.valueOf(1));
                skuBO.setMaterialId(spInfoBO.getScmID());
                skuBO.setSupplierName(shopBO.getShopMdName());
                if (isDebug.booleanValue()) {
                    logger.debug("\u6dfb\u52a0\u54c1\u724c\u4fe1\u606f");
                }
                skuBO.setBrandId(Long.valueOf(900991231L));
                skuBO.setBrandName(spInfoBO.getPp());
                if (isDebug.booleanValue()) {
                    logger.debug("\u6dfb\u52a0\u5546\u54c1\u5c5e\u6027\u89c4\u683c\u4fe1\u606f");
                }
                ArrayList<SpecBO> specBOList = new ArrayList<SpecBO>();
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getColor())) {
                    SpecBO specBO_Color = new SpecBO();
                    specBO_Color.setSupplierId(shopBO.getShopId());
                    if (isDebug.booleanValue()) {
                        logger.debug("ERP\u989c\u8272\u7684\u5c5e\u6027\u7ec4\u522bID\u4e3a900991233");
                    }
                    specBO_Color.setPropName("\u989c\u8272");
                    specBO_Color.setPropShowName("\u989c\u8272");
                    specBO_Color.setCommodityPropGrpId(Long.valueOf(900991233L));
                    specBO_Color.setPropValue(spInfoBO.getColor());
                    specBOList.add(specBO_Color);
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getName())) {
                    SpecBO specBO_Model = new SpecBO();
                    specBO_Model.setSupplierId(shopBO.getShopId());
                    if (isDebug.booleanValue()) {
                        logger.debug("ERP\u578b\u53f7\u7684\u5c5e\u6027\u7ec4\u522bID\u4e3a900991232");
                    }
                    specBO_Model.setPropName("\u578b\u53f7");
                    specBO_Model.setPropShowName("\u578b\u53f7");
                    specBO_Model.setCommodityPropGrpId(Long.valueOf(900991232L));
                    specBO_Model.setPropValue(spInfoBO.getName());
                    specBOList.add(specBO_Model);
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getNc())) {
                    SpecBO specBO_DDR = new SpecBO();
                    specBO_DDR.setSupplierId(shopBO.getShopId());
                    if (isDebug.booleanValue()) {
                        logger.debug("ERP\u5185\u5b58\u7684\u5c5e\u6027\u7ec4\u522bID\u4e3a900991234");
                    }
                    specBO_DDR.setPropName("\u5185\u5b58");
                    specBO_DDR.setPropShowName("\u5185\u5b58");
                    specBO_DDR.setCommodityPropGrpId(Long.valueOf(900991234L));
                    specBO_DDR.setPropValue(spInfoBO.getNc());
                    specBOList.add(specBO_DDR);
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getPp())) {
                    SpecBO specBO_Brand = new SpecBO();
                    specBO_Brand.setSupplierId(shopBO.getShopId());
                    if (isDebug.booleanValue()) {
                        logger.debug("ERP\u54c1\u724c\u7684\u5c5e\u6027\u7ec4\u522bID\u4e3a900991231");
                    }
                    specBO_Brand.setPropName("\u54c1\u724c");
                    specBO_Brand.setPropShowName("\u54c1\u724c");
                    specBO_Brand.setCommodityPropGrpId(Long.valueOf(900991231L));
                    specBO_Brand.setPropValue(spInfoBO.getPp());
                    specBOList.add(specBO_Brand);
                }
                createSkuBusiReqBO.setSkuSpec(specBOList);
                createSkuBusiReqBO.setSku(skuBO);
                createSkuBusiReqBO.setSpu(commodityBO);
                createSkuBusiReqBO.setSkuPicture(new ArrayList());
                if (isDebug.booleanValue()) {
                    logger.debug("\u5f00\u59cb\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u5165\u53c2\uff1a" + createSkuBusiReqBO.toString());
                    logger.debug("\u5f00\u59cb\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0cJSON\uff1a" + JSON.toJSONString((Object)createSkuBusiReqBO));
                }
                if (null != (rsp = this.createSkuBusiService.createSku(createSkuBusiReqBO)) && "0000".equals(rsp.getRespCode())) continue;
                logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25\uff1a" + rsp.getRespDesc());
                throw new ResourceException("9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25");
            }
        }
    }

    private ExternaLinterResultData saveErpCommodityToShopCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        if (isDebug.booleanValue()) {
            logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u4fdd\u5b58\u65b9\u6cd5\u5165\u53c2\uff1a" + erpCommodityBO.toString());
        }
        SkuInfoListBO skuInfoLisBO = new SkuInfoListBO();
        ArrayList<SkuInfoBO> skuInfoBOList = new ArrayList<SkuInfoBO>();
        skuInfoLisBO.setSkuInfoBO(skuInfoBOList);
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            if (isDebug.booleanValue()) {
                logger.debug("\u8fdb\u5165KCInfoBO\u5faa\u73af");
            }
            if ((shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID())) == null) {
                logger.error("\u95e8\u5e97\u3010" + erpKCInfoBO.getMdID() + "\u3011\u4e0d\u5b58\u5728");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u95e8\u5e97\u3010" + erpKCInfoBO.getMdID() + "\u3011\u4e0d\u5b58\u5728");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                Long skuId;
                if (isDebug.booleanValue()) {
                    logger.debug("\u8fdb\u5165SpInfo\u5faa\u73af");
                    logger.debug("\u6253\u5370\u8fd9\u4e2a\u53c2\u6570\uff1a" + spInfoBO.toString());
                }
                List chInfoBOList = null;
                ArrayList<String> skuInstanceCode = new ArrayList<String>();
                if (isDebug.booleanValue()) {
                    logger.debug("\u5224\u65ad\u524d" + spInfoBO.getChInfo());
                }
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    chInfoBOList = spInfoBO.getChInfo();
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u5224\u65ad\u7ed3\u675f");
                }
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    if (isDebug.booleanValue()) {
                        logger.debug("chInfo\u4e0d\u4e3a\u7a7a\u7684\u60c5\u51b5");
                    }
                    for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                        if (!StringUtils.isNotBlank((CharSequence)erpChInfoBO.getCh())) continue;
                        skuInstanceCode.add(erpChInfoBO.getCh());
                    }
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6skuId\uff0c\u95e8\u5e97Id:" + shopBO.getShopId() + "\u7269\u6599\u7f16\u7801\uff1a" + spInfoBO.getScmID() + "\u52a9\u8bb0\u7801\uff1a" + spInfoBO.getZjm());
                }
                if (null == (skuId = this.getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(shopBO.getShopId(), spInfoBO.getScmID(), spInfoBO.getZjm()))) {
                    logger.error("\u672a\u83b7\u53d6skuId");
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u672a\u83b7\u53d6skuId");
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6skuId:" + skuId);
                }
                SkuInfoBO skuInfoBO = new SkuInfoBO();
                skuInfoBO.setSkuId(skuId);
                skuInfoBO.setShopId(shopBO.getShopId());
                String amount = spInfoBO.getKcsl();
                if (StringUtils.isNotBlank((CharSequence)amount)) {
                    if (amount.contains(".")) {
                        amount = amount.substring(0, amount.lastIndexOf("."));
                    }
                    if (!Pattern.matches(PATTERN, amount)) {
                        logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                        return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    }
                    skuInfoBO.setChangeAmount(Integer.valueOf(Integer.parseInt(amount)));
                }
                skuInfoBO.setSkuInstanceCode(skuInstanceCode);
                if (null != spInfoBO.getCgType() && !StringUtils.isEmpty((CharSequence)spInfoBO.getCgType().trim())) {
                    skuInfoBO.setSkuStockPurchaseType(Integer.valueOf(Integer.parseInt(spInfoBO.getCgType())));
                }
                skuInfoBO.setScmID(spInfoBO.getScmID());
                skuInfoBO.setZjm(spInfoBO.getZjm());
                skuInfoBOList.add(skuInfoBO);
            }
        }
        ResultData rsp = null;
        try {
            if (isDebug.booleanValue()) {
                logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)skuInfoLisBO));
            }
            rsp = this.stockService.inStock(skuInfoLisBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u5e93\u5931\u8d25");
        }
        if (!"0000".equals(rsp.getRespCode())) {
            logger.error("\u65b0\u589e\u5e93\u5b58\u5931\u8d25\uff1a" + rsp.getRespDesc());
            throw new ResourceException("9999", rsp.getRespDesc());
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private ShopBO getShopBoByShopMdId(String shopMdId) {
        ShopBO tempShop = new ShopBO();
        tempShop.setShopMdId(shopMdId);
        ResultData resultData = this.shopService.findShopByMdId(tempShop);
        ShopBO shopBO = (ShopBO)resultData.getRespData();
        return shopBO;
    }

    private Long getSkuIdFromCommodityCenterByExtSkuIdAndMaterialId(Long shopId, String materialId, String extSkuId) {
        QuerySkuByMaterialIdExtSkuIdCustomReqBO querySkuByMaterialIdExtSkuIdCustomReqBO = new QuerySkuByMaterialIdExtSkuIdCustomReqBO();
        querySkuByMaterialIdExtSkuIdCustomReqBO.setSupplierId(shopId);
        ArrayList<String> materialIds = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)materialId)) {
            materialIds.add(materialId);
        }
        querySkuByMaterialIdExtSkuIdCustomReqBO.setMaterialIds(materialIds);
        ArrayList<String> extSkuIds = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)extSkuId)) {
            extSkuIds.add(extSkuId);
        }
        querySkuByMaterialIdExtSkuIdCustomReqBO.setExtSkuIds(extSkuIds);
        QuerySkuByMaterialIdExtSkuIdCustomRspBO querySkuDetailRspBO = null;
        try {
            querySkuDetailRspBO = this.querySkuByMaterialIdExtSkuIdCustomService.querySkuByMaterialIdExtSkuId(querySkuByMaterialIdExtSkuIdCustomReqBO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2skuId\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u67e5\u8be2skuId\u5931\u8d25");
        }
        if (querySkuDetailRspBO != null && CollectionUtils.isNotEmpty((Collection)querySkuDetailRspBO.getSkus())) {
            return ((SkuBO)querySkuDetailRspBO.getSkus().get(0)).getSkuId();
        }
        return null;
    }

    private String validateErpCommodity(ErpCommodityBO erpCommodityBO) {
        if (isDebug.booleanValue()) {
            logger.debug("\u8fdb\u5165\u6821\u9a8c");
        }
        if (erpCommodityBO == null) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            return "\u5165\u53c2\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpCommodityBO.getOperID())) {
            logger.error("\u5355\u636e\u53f7\u4e3a\u7a7a");
            return "\u5355\u636e\u53f7\u4e3a\u7a7a";
        }
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        if (CollectionUtils.isEmpty((Collection)erpKCInfoBOList)) {
            logger.error("\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a");
            return "\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a";
        }
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            if (StringUtils.isBlank((CharSequence)erpKCInfoBO.getMdID())) {
                logger.error("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
                return "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a";
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            if (CollectionUtils.isEmpty((Collection)spInfoBOList)) {
                logger.error("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
                return "\u5546\u54c1\u5217\u8868\u4e3a\u7a7a";
            }
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                String amount;
                if (StringUtils.isBlank((CharSequence)spInfoBO.getHaveCh())) {
                    logger.error("\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
                    return "\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a";
                }
                if (!spInfoBO.getHaveCh().equals("1") && !spInfoBO.getHaveCh().equals("2")) {
                    logger.error("\u662f\u5426\u6709\u4e32\u53f7\u7c7b\u578b\u9519\u8bef");
                    return "\u662f\u5426\u6709\u4e32\u53f7\u7c7b\u578b\u9519\u8bef";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getZjm())) {
                    logger.error("\u52a9\u8bb0\u7801\u4e3a\u7a7a");
                    return "\u52a9\u8bb0\u7801\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getName())) {
                    logger.error("\u578b\u53f7\u4e3a\u7a7a");
                    return "\u578b\u53f7\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getFullName())) {
                    logger.error("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
                    return "\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getKcsl())) {
                    logger.error("\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a");
                    return "\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getJg1())) {
                    logger.error("\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a");
                    return "\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a";
                }
                ArrayList<ErpChInfoBO> chuanHaoBOS = new ArrayList<ErpChInfoBO>();
                HashSet<String> chSet = null;
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    chSet = new HashSet<String>();
                    for (ErpChInfoBO erpChInfoBO : spInfoBO.getChInfo()) {
                        if (!StringUtils.isNotBlank((CharSequence)erpChInfoBO.getCh())) continue;
                        chuanHaoBOS.add(erpChInfoBO);
                        chSet.add(erpChInfoBO.getCh());
                    }
                    if (chSet.size() < chuanHaoBOS.size()) {
                        logger.error("\u4e32\u53f7\u91cd\u590d");
                        return "\u4e32\u53f7\u91cd\u590d";
                    }
                }
                spInfoBO.setChInfo(chuanHaoBOS);
                boolean hasChs = false;
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    hasChs = true;
                }
                if (StringUtils.isNotBlank((CharSequence)(amount = spInfoBO.getKcsl())) && amount.contains(".")) {
                    amount = amount.substring(0, amount.lastIndexOf("."));
                }
                if (!Pattern.matches(PATTERN, amount)) {
                    logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                if ("1".equals(spInfoBO.getHaveCh()) && !hasChs) {
                    logger.error("\u5f53\u524d\u4e3a\u6709\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e3a\u7a7a");
                    return "\u5f53\u524d\u4e3a\u6709\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e3a\u7a7a";
                }
                if ("2".equals(spInfoBO.getHaveCh()) && hasChs) {
                    logger.error("\u5f53\u524d\u4e3a\u65e0\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e0d\u4e3a\u7a7a");
                    return "\u5f53\u524d\u4e3a\u65e0\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e0d\u4e3a\u7a7a";
                }
                if (!"1".equals(spInfoBO.getHaveCh()) || amount.equals(String.valueOf(spInfoBO.getChInfo().size()))) continue;
                logger.error("\u540c\u6b65\u6570\u91cf\u4e0e\u4e32\u53f7\u6570\u91cf\u4e0d\u7b26");
                return "\u540c\u6b65\u6570\u91cf\u4e0e\u4e32\u53f7\u6570\u91cf\u4e0d\u7b26";
            }
        }
        return null;
    }
}

