/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.StockChangeCallHisAtomService;
import com.tydic.externalinter.bo.ErpStockChangeRetryBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.ErpSpecialSalesReqBO;
import com.tydic.externalinter.busi.service.ErpStockChangeTaskService;
import com.tydic.externalinter.dao.StockChangeCallHistoryDao;
import com.tydic.externalinter.dao.po.StockChangeCallHistoryPO;
import com.tydic.externalinter.service.ErpStockService;
import com.tydic.externalinter.util.ExtJsonUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpStockChangeTaskServiceImpl
implements ErpStockChangeTaskService {
    private static final Logger logger = LoggerFactory.getLogger(ErpStockChangeTaskServiceImpl.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    @Autowired
    private StockChangeCallHistoryDao stockChangeErrorHistoryDao;
    @Autowired
    private ErpStockService erpStockService;
    @Autowired
    private StockChangeCallHisAtomService stockChangeCallHisAtomService;

    public void execute(ErpStockChangeRetryBO reqBO) {
        if (isDebug.booleanValue()) {
            logger.debug("\u5b9a\u65f6\u4fee\u590d\u5f00\u59cb");
        }
        Date zero = this.getZeroDate(new Date());
        StockChangeCallHistoryPO record = new StockChangeCallHistoryPO();
        record.setCreateTime(zero);
        List<StockChangeCallHistoryPO> historyPOS = null;
        try {
            historyPOS = this.stockChangeErrorHistoryDao.selectStandByTask(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u672a\u4fee\u590d\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u67e5\u8be2\u672a\u4fee\u590d\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(historyPOS)) {
            if (isDebug.booleanValue()) {
                logger.debug("\u5f53\u524d\u6ca1\u6709\u672a\u4fee\u590d\u5f02\u5e38");
            }
            return;
        }
        for (StockChangeCallHistoryPO historyPO : historyPOS) {
            historyPO.setTaskExecTime(new Date());
            if (StringUtils.isBlank((CharSequence)historyPO.getTaskExecStatus()) || "00".equals(historyPO.getTaskExecStatus())) {
                historyPO.setTaskExecStatus("01");
            }
            int time = 0;
            time = null == historyPO.getTaskExecTimes() ? 1 : historyPO.getTaskExecTimes() + 1;
            historyPO.setTaskExecTimes(time);
            String inputParams = historyPO.getInputParams();
            if (StringUtils.isBlank((CharSequence)inputParams)) {
                logger.error("\u5f53\u524d\u8bb0\u5f55\u3010" + historyPO.getRecordId() + "\u3011\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a");
                historyPO.setTaskExecRespCode("0001");
                historyPO.setTaskExecRespDesc("\u5f53\u524d\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a");
                this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(historyPO);
                continue;
            }
            try {
                ErpSpecialSalesReqBO erpSpecialSalesReqBO = ExtJsonUtils.jsonStringToObject(inputParams, ErpSpecialSalesReqBO.class);
                ExternaLinterResultData externaLinterResultData = this.erpStockService.reductionERPStock(erpSpecialSalesReqBO);
                if (null == externaLinterResultData || !externaLinterResultData.getSuccess().booleanValue()) {
                    logger.error("ERP\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff1a" + externaLinterResultData.getRespDesc());
                    if (StringUtils.isNotBlank((CharSequence)externaLinterResultData.getRespCode())) {
                        historyPO.setTaskExecRespCode(externaLinterResultData.getRespCode());
                    } else {
                        historyPO.setTaskExecRespCode("9999");
                    }
                    historyPO.setTaskExecRespDesc(externaLinterResultData.getRespDesc());
                    this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(historyPO);
                    continue;
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u8c03\u7528ERP\u5e93\u5b58\u6263\u51cf\u6210\u529f");
                }
                historyPO.setTaskExecRespCode(externaLinterResultData.getRespCode());
                historyPO.setTaskExecRespDesc(externaLinterResultData.getRespDesc());
                if ("0013".equals(externaLinterResultData.getRespCode())) {
                    historyPO.setTaskExecStatus("03");
                } else {
                    historyPO.setTaskExecStatus("02");
                }
                this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(historyPO);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528ERP\u5e93\u5b58\u6263\u51cf\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
                historyPO.setTaskExecRespCode("9999");
                historyPO.setTaskExecRespDesc("\u8c03\u7528ERP\u5e93\u5b58\u6263\u51cf\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
                this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(historyPO);
            }
        }
    }

    private Date getZeroDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static void main(String[] args) {
    }
}

