/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.atom.StockChangeCallHisAtomService;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.ErpSpecialSalesReqBO;
import com.tydic.externalinter.busi.bo.SpecialSalesRecordRspBO;
import com.tydic.externalinter.busi.service.SpecialSalesService;
import com.tydic.externalinter.dao.po.StockChangeCallHistoryPO;
import com.tydic.externalinter.service.ErpStockService;
import com.tydic.externalinter.util.ErpServiceUtils;
import com.tydic.ordunr.ability.UnrOrdInvoiceSyncAbilityService;
import com.tydic.ordunr.ability.bo.UnrInvoiceAbilityRespBO;
import com.tydic.ordunr.busi.bo.UnrQryOrderReqBO;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="erpStockService")
public class ErpStockServiceImpl
implements ErpStockService {
    private static Logger logger = LoggerFactory.getLogger(ErpStockServiceImpl.class);
    private static Boolean isDebug = logger.isDebugEnabled();
    @Resource
    private UnrOrdInvoiceSyncAbilityService unrOrdInvoiceSyncAbilityService;
    @Autowired
    private StockChangeCallHisAtomService stockChangeErrorHisAtomService;
    @Autowired
    private SpecialSalesService specialSalesService;

    public ExternaLinterResultData reductionERPStock(ErpSpecialSalesReqBO reqBO) {
        if (null == reqBO) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        String inputParams = JSON.toJSONString((Object)reqBO);
        if (isDebug.booleanValue()) {
            logger.debug("ERP\u5e93\u5b58\u6263\u51cf\u5165\u53c2\uff1a" + inputParams);
        }
        StockChangeCallHistoryPO record = this.toStockChangeCallHistoryPO(reqBO);
        StockChangeCallHistoryPO callHistoryPO = this.stockChangeErrorHisAtomService.getStockChangeCallHistory(record, true);
        if (reqBO.getSpecialAppliFlag().booleanValue()) {
            SpecialSalesRecordRspBO specialRsp;
            if (isDebug.booleanValue()) {
                logger.debug("\u5f53\u524d\u8ba2\u5355\u3010" + reqBO.getOrderID() + "\u3011\u9700\u8981\u7279\u4ef7\u7533\u8bf7");
            }
            if (!"0013".equals((specialRsp = this.specialSalesService.addSpecialSales(reqBO)).getRespCode())) {
                logger.error("\u7279\u4ef7\u7533\u8bf7\u5931\u8d25\uff1a" + specialRsp.getRespDesc());
                callHistoryPO.setRespCode(specialRsp.getRespCode());
                callHistoryPO.setRespDesc(specialRsp.getRespDesc());
                this.stockChangeErrorHisAtomService.modifyStockChangeCallHistory(callHistoryPO);
                return new ExternaLinterResultData(Boolean.valueOf(false), specialRsp.getRespCode(), specialRsp.getRespDesc());
            }
            callHistoryPO.setRespCode(specialRsp.getRespCode());
            callHistoryPO.setRespDesc(specialRsp.getRespDesc());
            callHistoryPO.setTaskExecStatus("03");
            callHistoryPO.setReservedContent("\u7279\u4ef7\u7533\u8bf7\u6210\u529f\uff0cbillId\uff1a" + specialRsp.getBillId());
            this.stockChangeErrorHisAtomService.modifyStockChangeCallHistory(callHistoryPO);
            return new ExternaLinterResultData(Boolean.valueOf(true), specialRsp.getRespCode(), specialRsp.getRespDesc());
        }
        if ("02".equals(callHistoryPO.getTaskExecStatus())) {
            logger.error("\u5f53\u524d\u8ba2\u5355\u5df2\u6263\u51cf\u5b8c\u6bd5");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5f53\u524d\u8ba2\u5355\u5df2\u6263\u51cf\u5b8c\u6bd5");
        }
        ExternaLinterResultData resultData = ErpServiceUtils.erpService(inputParams, "SYNC_DATA_URL");
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528ERP\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)resultData));
        }
        if (StringUtils.isNotBlank((String)resultData.getRespDesc()) && resultData.getRespDesc().contains("\u5f00\u7968\u6210\u529f")) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u8ba2\u5355\u3010" + reqBO.getOrderID() + "\u3011\u5f00\u7968\u6210\u529f\uff0c\u901a\u77e5\u8ba2\u5355\u4e2d\u5fc3");
                }
                UnrQryOrderReqBO unrQryOrderReqBO = new UnrQryOrderReqBO();
                unrQryOrderReqBO.setOrderId(Long.valueOf(Long.parseLong(reqBO.getOrderID())));
                UnrInvoiceAbilityRespBO unrInvoiceAbilityRespBO = this.unrOrdInvoiceSyncAbilityService.dealOrdInvoiceSync(unrQryOrderReqBO);
                if (isDebug.booleanValue()) {
                    logger.debug("\u53d1\u7968\u72b6\u6001\u540c\u6b65\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a" + JSON.toJSONString((Object)unrInvoiceAbilityRespBO));
                }
                if (!"0000".equals(unrInvoiceAbilityRespBO.getRespCode())) {
                    logger.debug("\u53d1\u7968\u72b6\u6001\u540c\u6b65\u5931\u8d25\uff1a" + unrInvoiceAbilityRespBO.getRespDesc());
                }
            }
            catch (Exception e) {
                logger.error("\u53d1\u7968\u72b6\u6001\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u53d1\u7968\u72b6\u6001\u540c\u6b65\u5b8c\u6210");
            }
        }
        callHistoryPO.setRespCode(resultData.getRespCode());
        callHistoryPO.setRespDesc(resultData.getRespDesc());
        if ("0000".equals(resultData.getRespCode())) {
            callHistoryPO.setTaskExecStatus("02");
        }
        this.stockChangeErrorHisAtomService.modifyStockChangeCallHistory(callHistoryPO);
        return resultData;
    }

    private StockChangeCallHistoryPO toStockChangeCallHistoryPO(ErpSpecialSalesReqBO reqBO) {
        StockChangeCallHistoryPO po = new StockChangeCallHistoryPO();
        po.setInputParams(JSON.toJSONString((Object)reqBO));
        po.setOperNum(Integer.parseInt(reqBO.getSaleNumber()));
        po.setOperType("0");
        po.setOrderId(reqBO.getOrderID());
        po.setOrderTime(reqBO.getOrderTime());
        return po;
    }
}

