/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.externalinter.busi.bo.IssueInvoiceBusiReqBO;
import com.tydic.externalinter.busi.bo.IssueInvoiceBusiRespBO;
import com.tydic.externalinter.busi.service.IssueInvoiceBusiService;
import com.tydic.externalinter.config.HttpUntil;
import com.tydic.externalinter.config.MyX509TrustManager;
import com.tydic.externalinter.config.ObtainPublicElement;
import com.tydic.externalinter.config.PropertiesReaderUtils;
import com.tydic.externalinter.dao.QueryUrlByProvienceIdDao;
import com.tydic.ordunr.ability.UnrQryOrderDetailAbilityService;
import com.tydic.ordunr.ability.bo.UnrQryOrderDetailAbilityRspBO;
import com.tydic.ordunr.busi.bo.UnrQryOrderReqBO;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.service.ShopService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="issueInvoiceBusiService")
public class IssueInvoiceBusiServiceImpl
implements IssueInvoiceBusiService {
    private static final Logger logger = LoggerFactory.getLogger(IssueInvoiceBusiServiceImpl.class);
    @Resource
    UnrQryOrderDetailAbilityService unrQryOrderDetailAbilityService;
    @Resource
    ShopService shopService;
    @Resource
    QueryUrlByProvienceIdDao queryUrlByProvienceIdDao;

    public IssueInvoiceBusiRespBO issueInvoice(IssueInvoiceBusiReqBO issueInvoiceBusiReqBO) {
        IssueInvoiceBusiRespBO issueInvoiceBusiRespBO = new IssueInvoiceBusiRespBO();
        logger.debug("\u5f00\u59cb\u8c03\u7528\u53d1\u7968\u670d\u52a1\u3002\u3002\u3002");
        try {
            String appId = PropertiesReaderUtils.getAppId();
            String secret = PropertiesReaderUtils.getAppSecret();
            String orderId = issueInvoiceBusiReqBO.getOrderID();
            UnrQryOrderReqBO unrQryOrderReqBO = new UnrQryOrderReqBO();
            UnrQryOrderDetailAbilityRspBO unrQryOrderDetailAbilityRspBO = new UnrQryOrderDetailAbilityRspBO();
            long l = Long.parseLong(orderId);
            unrQryOrderReqBO.setOrderId(Long.valueOf(l));
            logger.debug("\u4e4b\u524d\u53c2\u6570" + unrQryOrderReqBO.toString());
            unrQryOrderDetailAbilityRspBO = this.unrQryOrderDetailAbilityService.qryUnrQryOrderDetail(unrQryOrderReqBO);
            if (null == unrQryOrderDetailAbilityRspBO.getOrderId()) {
                issueInvoiceBusiRespBO.setRespCode("9999");
                issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u4e3a\u7a7a");
                return issueInvoiceBusiRespBO;
            }
            logger.debug("\u4e4b\u540e\u53c2\u6570" + unrQryOrderDetailAbilityRspBO.toString());
            logger.debug("\u83b7\u53d6\u5230\u8ba2\u5355\u8be6\u60c5\u3002\u3002\u3002");
            String shopCode = unrQryOrderDetailAbilityRspBO.getSupNo();
            logger.debug("\u83b7\u53d6\u5230\u95e8\u5e97\u7f16\u7801\u3002\u3002\u3002" + shopCode);
            ShopBO shopBO = new ShopBO();
            ResultData resultData = new ResultData();
            long p = Long.parseLong(shopCode);
            shopBO.setShopId(Long.valueOf(p));
            logger.debug("\u83b7\u53d6\u7701\u4efdid...");
            resultData = this.shopService.findShopByMdId(shopBO);
            if (null == resultData.getRespData()) {
                issueInvoiceBusiRespBO.setRespCode("9999");
                issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u5931\u8d25\uff0c\u83b7\u53d6\u5e97\u94fa\u8be6\u60c5\u4e3a\u7a7a");
                return issueInvoiceBusiRespBO;
            }
            shopBO = (ShopBO)resultData.getRespData();
            logger.debug("\u83b7\u53d6\u5230\u5e97\u94fa\u8be6\u60c5" + shopBO.getCywd() + shopBO.getShopSfId());
            String provicenId = shopBO.getShopMdId().substring(0, 5);
            logger.debug("\u83b7\u53d6\u5230\u7701\u4efdid..." + provicenId);
            String interfaceType = PropertiesReaderUtils.getHttpsURL();
            logger.debug(interfaceType);
            String url = interfaceType + provicenId;
            logger.debug("\u67e5\u770b\u53c2\u6570" + url + "==" + appId + "==" + provicenId);
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(new Date());
            Random random = new Random();
            String result = "";
            for (int i = 0; i < 6; ++i) {
                result = result + random.nextInt(10);
            }
            String rTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + result;
            String transid = provicenId + rTime;
            logger.debug("\u52a0\u5bc6\u4e2d...");
            String allToken = ObtainPublicElement.getPublicElement(timestamp, transid).get("sign").toString();
            logger.debug("\u5f97\u5230token" + allToken);
            String jsonHead = "{\"HEAD\": {\"APP_ID\": \"" + appId + "\",\"TIMESTAMP\": \"" + timestamp + "\",\"TRANS_ID\": \"" + transid + "\",\"TOKEN\":\"" + allToken + "\" ,\"RESERVED\":[{ \"RESERVED_ID\": \"\",\"RESERVED_VALUE\":\"\" },{\"RESERVED_ID\": \"\", \"RESERVED_VALUE\": \"\"} ] },";
            logger.debug("\u62fc\u8868\u5934");
            String jsonBody = "\"BODY\":" + JsonUtils.objectBeanToJsonString((Object)issueInvoiceBusiReqBO) + ",";
            String attached = "\"ATTACHED\": {\"MEDIA_INFO\":\"\"}}";
            String all = jsonHead + jsonBody + attached;
            logger.debug("url\u5730\u5740\uff1a" + url + "------------\u8bf7\u6c42\u62a5\u6587\uff1a" + all);
            String comeBack = null;
            if (url.startsWith("https")) {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                comeBack = myX509TrustManager.httpsRequest(url, "POST", all);
            } else {
                HttpUntil httpUntil = new HttpUntil();
                comeBack = httpUntil.httpPost(url, all);
            }
            logger.debug("\u53d1\u9001\u8bf7\u6c42\u7ed3\u675f\u3002\u3002\u3002");
            if (!comeBack.contains("0000")) {
                logger.info("ERP\u8fd4\u56de\u5931\u8d25");
                issueInvoiceBusiRespBO.setRespCode("9999");
                issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u5931\u8d25");
                return issueInvoiceBusiRespBO;
            }
            issueInvoiceBusiRespBO.setRespCode("0000");
            issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u6210\u529f");
        }
        catch (Exception e) {
            logger.info("\u7cfb\u7edf\u5f02\u5e38...");
            issueInvoiceBusiRespBO.setRespCode("9999");
            issueInvoiceBusiRespBO.setRespDesc("\u8865\u53d1\u5931\u8d25");
        }
        return issueInvoiceBusiRespBO;
    }
}

