/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.config.HttpUntil;
import com.tydic.externalinter.config.MyX509TrustManager;
import com.tydic.externalinter.config.ObtainPublicElement;
import com.tydic.externalinter.config.PropertiesReaderUtils;
import com.tydic.externalinter.constant.ErpConstants;
import com.tydic.externalinter.constant.ExtExceptionConstant;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErpServiceUtils {
    private static Logger logger = LoggerFactory.getLogger(ErpServiceUtils.class);
    private static SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");

    public static ExternaLinterResultData erpService(String erpJsonStr, String urlProperty) {
        String respDesc;
        String url;
        JSONObject erpJson = null;
        try {
            erpJson = JSONObject.fromObject((Object)erpJsonStr);
        }
        catch (Exception e) {
            logger.error("\u5165\u53c2\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5165\u53c2\u683c\u5f0f\u9519\u8bef");
        }
        if (!erpJson.containsKey((Object)"mdID") || StringUtils.isBlank((String)erpJson.getString("mdID")) || erpJson.getString("mdID").length() < ErpConstants.ERP_PRO_LENGTH) {
            logger.error("\u95e8\u5e97ID\u4e3a\u7a7a");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u95e8\u5e97ID\u4e3a\u7a7a");
        }
        String provCode = erpJson.getString("mdID").substring(0, ErpConstants.ERP_PRO_LENGTH);
        ErpServiceUtils.changeReqJson(erpJson);
        if ("SPECIAL_SALES_URL".equals(urlProperty) && erpJson.containsKey((Object)"czType")) {
            erpJson.remove("czType");
        }
        if (!(url = ExterPropertiesUtils.getProperty(urlProperty).trim()).contains("exter/erpCallSimulation/v1")) {
            url = url + provCode;
        }
        if (StringUtils.isBlank((String)url)) {
            logger.error("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u5730\u5740");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u5730\u5740");
        }
        String appId = null;
        String provicenId = null;
        try {
            appId = PropertiesReaderUtils.getAppId();
            logger.debug("appId\u5730\u5740\uff1a" + appId);
            provicenId = PropertiesReaderUtils.getAppSecret();
            logger.info("provicenId\u5730\u5740\uff1a" + provicenId);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ERP\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u83b7\u53d6ERP\u53c2\u6570\u5931\u8d25");
        }
        Date now = new Date();
        String timestamp = format.format(now);
        double random = (Math.random() * 9.0 + 1.0) * 100000.0;
        String rTime = fmt.format(now) + random;
        String transid = provicenId + rTime;
        logger.info("\u52a0\u5bc6\u4e2d...");
        String allToken = ObtainPublicElement.getPublicElement(timestamp, transid).get("sign").toString();
        String jsonHead = "{\"HEAD\": {\"APP_ID\": \"" + appId + "\",\"TIMESTAMP\": \"" + timestamp + "\",\"TRANS_ID\": \"" + transid + "\",\"TOKEN\":\"" + allToken + "\" ,\"RESERVED\":[{ \"RESERVED_ID\": \"\",\"RESERVED_VALUE\":\"\" },{\"RESERVED_ID\": \"\", \"RESERVED_VALUE\": \"\"} ] },";
        String jsonBody = "\"BODY\":" + erpJson.toString() + ",";
        String attached = "\"ATTACHED\": {\"MEDIA_INFO\":\"\"}}";
        String all = jsonHead + jsonBody + attached;
        logger.info("url\u5730\u5740\uff1a" + url + "------------\u8bf7\u6c42\u62a5\u6587\uff1a" + all);
        String comeBack = null;
        try {
            if (url.startsWith("https")) {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                comeBack = myX509TrustManager.httpsRequest(url, "POST", all);
            } else {
                HttpUntil httpUntil = new HttpUntil();
                comeBack = httpUntil.httpPost(url, all);
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42ERP\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", (String)ExtExceptionConstant.codeMap.get("0009"));
        }
        logger.debug("\u8fd4\u56de\u4fe1\u606f\uff1a" + comeBack);
        if (null == comeBack) {
            logger.error("\u8c03\u7528erp\u5e93\u5b58\u6263\u51cf\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6263\u51cf\u5931\u8d25");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u8c03\u7528ERP\u5e93\u5b58\u6263\u51cf\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6263\u51cf\u5931\u8d25");
        }
        JSONObject json = null;
        try {
            json = JSONObject.fromObject((Object)comeBack);
        }
        catch (Exception e) {
            logger.error("erp\u51fa\u53c2\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "ERP\u51fa\u53c2\u683c\u5f0f\u9519\u8bef");
        }
        JSONObject body = null;
        try {
            body = json.containsKey((Object)"BODY") ? json.getJSONObject("BODY") : null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u5931\u8d25");
        }
        if (null == body) {
            logger.error("\u672a\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\uff0cerp\u51fa\u53c2\uff1a" + comeBack);
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u672a\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\uff0cERP\u51fa\u53c2\uff1a" + comeBack);
        }
        String respCode = body.containsKey((Object)"respCode") ? body.getString("respCode") : null;
        String string = respDesc = body.containsKey((Object)"respDesc") ? body.getString("respDesc") : null;
        if (null == respCode || !"0000".equals(respCode)) {
            String desc = "ERP\u5931\u8d25\uff0cerp\u51fa\u53c2\uff1a" + comeBack;
            if (StringUtils.isNotBlank((String)respDesc)) {
                desc = respDesc;
            }
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", desc);
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f", (Object)body);
    }

    private static void changeReqJson(JSONObject erpJson) {
        if (erpJson.containsKey((Object)"mdID")) {
            erpJson.remove("mdID");
        }
        if (erpJson.containsKey((Object)"saleNumber")) {
            erpJson.remove("saleNumber");
        }
        if (erpJson.containsKey((Object)"sendErpFlag")) {
            erpJson.remove("sendErpFlag");
        }
        if (erpJson.containsKey((Object)"storeStaffId")) {
            erpJson.remove("storeStaffId");
        }
        if (erpJson.containsKey((Object)"specialAppliFlag")) {
            erpJson.remove("specialAppliFlag");
        }
        if (erpJson.containsKey((Object)"spInfo")) {
            JSONArray spInfoArray = null;
            try {
                spInfoArray = erpJson.getJSONArray("spInfo");
            }
            catch (Exception e) {
                logger.error("spInfo\u4e0d\u662fjsonArray");
            }
            if (CollectionUtils.isNotEmpty((Collection)spInfoArray)) {
                for (int i = 0; i < spInfoArray.size(); ++i) {
                    JSONObject spInfoJson = spInfoArray.getJSONObject(i);
                    if (spInfoJson.containsKey((Object)"itemType")) {
                        spInfoJson.remove("itemType");
                    }
                    if (spInfoJson.containsKey((Object)"autoId")) {
                        spInfoJson.remove("autoId");
                    }
                    if (spInfoJson.containsKey((Object)"QRcode")) {
                        spInfoJson.remove("QRcode");
                    }
                    if (spInfoJson.containsKey((Object)"extAtrr")) {
                        spInfoJson.remove("extAtrr");
                    }
                    if (spInfoJson.containsKey((Object)"shopId")) {
                        spInfoJson.remove("shopId");
                    }
                    if (spInfoJson.containsKey((Object)"skuId")) {
                        spInfoJson.remove("skuId");
                    }
                    if (!spInfoJson.containsKey((Object)"chInfo")) continue;
                    JSONArray chInfos = null;
                    try {
                        chInfos = spInfoJson.getJSONArray("chInfo");
                    }
                    catch (Exception e) {
                        logger.error("chInfo\u4e0d\u662fjsonArray");
                    }
                    if (!CollectionUtils.isEmpty((Collection)chInfos)) continue;
                    spInfoJson.remove("chInfo");
                }
            }
        }
        JSONArray fpInfos = null;
        try {
            fpInfos = erpJson.getJSONArray("fpInfo");
        }
        catch (Exception e) {
            logger.error("fpInfo\u4e0d\u662fjsonArray");
        }
        if (CollectionUtils.isEmpty((Collection)fpInfos)) {
            erpJson.remove("fpInfo");
        }
        if (erpJson.containsKey((Object)"shopId")) {
            erpJson.remove("shopId");
        }
        if (erpJson.containsKey((Object)"QRcode")) {
            erpJson.remove("QRcode");
        }
        if (erpJson.containsKey((Object)"sendErpFlag")) {
            erpJson.remove("sendErpFlag");
        }
    }
}

