/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.externalinter.dao.ExtEscapeCodeDao;
import com.tydic.externalinter.dao.po.EscapeCodePO;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ExtEscapeCodeUtils
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ExtEscapeCodeUtils.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    private static ExtEscapeCodeDao extEscapeCodeDao;
    private static CacheClient cacheClient;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (contextRefreshedEvent.getApplicationContext().getParent() == null) {
            if (isDebug.booleanValue()) {
                logger.debug("\u542f\u52a8\u52a0\u8f7d\u7801\u8868");
            }
            ExtEscapeCodeUtils.init();
        }
    }

    public static void refresh() {
        Set valueSet = null;
        try {
            valueSet = cacheClient.getkeys("EXTESCAPE_*");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6240\u6709\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)valueSet)) {
            if (isDebug.booleanValue()) {
                logger.debug("\u6e05\u9664\u7f13\u5b58");
            }
            for (String keyStr : valueSet) {
                try {
                    cacheClient.delete(keyStr);
                }
                catch (Exception e) {
                    logger.error("\u6e05\u9664\u3010" + keyStr + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58");
        }
        ExtEscapeCodeUtils.init();
    }

    private static void init() {
        List<EscapeCodePO> escapeCodePOS = null;
        try {
            escapeCodePOS = extEscapeCodeDao.selectAll();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8f6c\u4e49\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(escapeCodePOS)) {
            return;
        }
        for (EscapeCodePO po : escapeCodePOS) {
            String key = "EXTESCAPE_" + po.getParentCode() + "_" + po.getCode();
            String value = po.getCodeTitle();
            try {
                cacheClient.set(key, (Object)value);
            }
            catch (Exception e) {
                logger.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    public static String getCodeTitle(String parentCode, String code) {
        String key = "EXTESCAPE_" + parentCode + "_" + code;
        Object valueObj = null;
        try {
            valueObj = cacheClient.get(key);
        }
        catch (Exception e) {
            logger.error("\u4ece\u7f13\u5b58\u4e2d\u67e5\u8be2\u3010" + key + "\u3011\u5931\u8d25");
        }
        if (null != valueObj) {
            return valueObj.toString();
        }
        EscapeCodePO record = new EscapeCodePO();
        record.setParentCode(parentCode);
        record.setCode(code);
        try {
            valueObj = extEscapeCodeDao.selectByParentCodeAndCode(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u3010" + key + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null == valueObj) {
            return null;
        }
        try {
            cacheClient.set(key, (Object)valueObj.toString());
        }
        catch (Exception e) {
            logger.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return valueObj.toString();
    }

    @Autowired
    public void setEscapeCodeDao(ExtEscapeCodeDao extEscapeCodeDao) {
        ExtEscapeCodeUtils.extEscapeCodeDao = extEscapeCodeDao;
    }

    @Autowired
    public void setCacheClient(CacheClient cacheClient) {
        ExtEscapeCodeUtils.cacheClient = cacheClient;
    }
}

