/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.ability.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.opensearch.util.JsonUtil;
import com.tydic.externalinter.ability.bo.AbilityExternaLinterResultData;
import com.tydic.externalinter.ability.bo.ErpSyncDataAbilityBO;
import com.tydic.externalinter.ability.bo.PayInfoAbilityBO;
import com.tydic.externalinter.ability.service.ERPSyncDataAbilityService;
import com.tydic.externalinter.bo.ErpSyncDataBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.service.ERPSyncDataService;
import com.tydic.externalinter.util.ExtForwardUtils;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncDataAbilityService")
public class ERPSyncDataAbilityServiceImpl
implements ERPSyncDataAbilityService {
    public static final Logger logger = LoggerFactory.getLogger(ERPSyncDataAbilityServiceImpl.class);
    @Resource
    private ERPSyncDataService erpSyncDataService;

    public AbilityExternaLinterResultData syncData(ErpSyncDataAbilityBO erpSyncDataAbilityBO) {
        ExternaLinterResultData forwardRsp;
        boolean forwardSwitch = ExterPropertiesUtils.getBooleanProperty("FORWARD_SWITCH", false);
        if (forwardSwitch && null != (forwardRsp = this.checkShop(erpSyncDataAbilityBO))) {
            return new AbilityExternaLinterResultData(forwardRsp.getSuccess(), forwardRsp.getRespCode(), forwardRsp.getRespDesc());
        }
        logger.debug("\u5f00\u59cb\u8c03\u7528ERP\u9500\u552e\u6570\u636e\u540c\u6b65\u63a5\u53e3,\u5e76\u5f00\u59cb\u6821\u9a8c\u53c2\u6570");
        if (erpSyncDataAbilityBO == null) {
            logger.error("ERP\u53c2\u6570\u4e0d\u6b63\u786e");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty((String)erpSyncDataAbilityBO.getOrderID()) || StringUtils.isBlank((String)erpSyncDataAbilityBO.getOrderID())) {
            logger.error("ERP\u53c2\u6570\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u53c2\u6570\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)erpSyncDataAbilityBO.getMdID()) || StringUtils.isBlank((String)erpSyncDataAbilityBO.getMdID())) {
            logger.error("ERP\u53c2\u6570\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u53c2\u6570\u8ba2\u5355\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)erpSyncDataAbilityBO.getCzType()) || StringUtils.isBlank((String)erpSyncDataAbilityBO.getCzType())) {
            logger.error("ERP\u53c2\u6570\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u53c2\u6570\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String czType = erpSyncDataAbilityBO.getCzType();
        if (!("1".equals(czType) || "2".equals(czType) || "3".equals(czType))) {
            logger.error("ERP\u53c2\u6570\u64cd\u4f5c\u7c7b\u578b\u4e0d\u4e3a\u679a\u4e3e\u7c7b");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u53c2\u6570\u64cd\u4f5c\u7c7b\u578b\u4e0d\u4e3a\u679a\u4e3e\u7c7b");
        }
        List spInfo = erpSyncDataAbilityBO.getSpInfo();
        if (CollectionUtils.isEmpty((Collection)spInfo)) {
            logger.error("ERP\u53c2\u6570\u9500\u552e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u53c2\u6570\u9500\u552e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Object spInfoAbilityBO : spInfo) {
            if (spInfoAbilityBO == null) {
                logger.error("ERP\u9500\u552e\u660e\u7ec6\u53c2\u6570\u4e0d\u9f50");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u9500\u552e\u660e\u7ec6\u53c2\u6570\u4e0d\u9f50");
            }
            if (StringUtils.isBlank((String)spInfoAbilityBO.getZjm())) {
                logger.error("\u52a9\u8bb0\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u52a9\u8bb0\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)spInfoAbilityBO.getSjjg())) {
                logger.error("\u96f6\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u96f6\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)spInfoAbilityBO.getHdID())) {
                logger.error("\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String pattern = "^[1-9]\\d*$";
            if (StringUtils.isBlank((String)spInfoAbilityBO.getNumber())) {
                logger.error("\u9500\u552e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u9500\u552e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Pattern.matches(pattern, spInfoAbilityBO.getNumber())) continue;
            logger.error("\u9500\u552e\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u9500\u552e\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        }
        if (StringUtils.isBlank((String)erpSyncDataAbilityBO.getDdje())) {
            logger.error("ERP\u8ba2\u5355\u603b\u91d1\u989d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u8ba2\u5355\u603b\u91d1\u989d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List payInfo = erpSyncDataAbilityBO.getPayInfo();
        if (payInfo == null) {
            logger.error("ERP\u6536\u94f6\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u6536\u94f6\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PayInfoAbilityBO payInfoAbilityBO : payInfo) {
            if (StringUtils.isBlank((String)payInfoAbilityBO.getPayMode())) {
                logger.error("ERP\u652f\u4ed8\u65b9\u5f0f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u652f\u4ed8\u65b9\u5f0f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((String)payInfoAbilityBO.getPayMoney())) continue;
            logger.error("ERP\u652f\u4ed8\u91d1\u989d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "ERP\u652f\u4ed8\u91d1\u989d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(erpSyncDataAbilityBO.getHaveFp()) && !"2".equals(erpSyncDataAbilityBO.getHaveFp())) {
            logger.error("\u662f\u5426\u5f00\u7968\u7c7b\u578b\u9519\u8bef");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u662f\u5426\u5f00\u7968\u7c7b\u578b\u9519\u8bef");
        }
        String json = JSON.toJSONString((Object)erpSyncDataAbilityBO);
        ErpSyncDataBO erpSyncDataBO = (ErpSyncDataBO)JsonUtil.fromJson((String)json, ErpSyncDataBO.class);
        AbilityExternaLinterResultData abilityExternaLinterResultData = new AbilityExternaLinterResultData();
        ExternaLinterResultData externaLinterResultData = this.erpSyncDataService.syncData(erpSyncDataBO);
        BeanUtils.copyProperties((Object)externaLinterResultData, (Object)abilityExternaLinterResultData);
        return abilityExternaLinterResultData;
    }

    private ExternaLinterResultData checkShop(ErpSyncDataAbilityBO erpSyncDataBO) {
        String url = ExterPropertiesUtils.getProperty("FORWARD_URL_SYNCSALES_WH");
        String shopCode = ExterPropertiesUtils.getProperty("SHOP_CODE_WH");
        if (null != erpSyncDataBO && StringUtils.isNotBlank((String)erpSyncDataBO.getMdID()) && shopCode.equals(erpSyncDataBO.getMdID())) {
            return ExtForwardUtils.forward(url, erpSyncDataBO);
        }
        return null;
    }
}

