/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.ability.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.opensearch.util.JsonUtil;
import com.tydic.externalinter.ability.bo.AbilityExternaLinterResultData;
import com.tydic.externalinter.ability.bo.ERPSyncPriceAbilityBO;
import com.tydic.externalinter.ability.bo.ExtJgInfoBO;
import com.tydic.externalinter.ability.service.ERPSyncProductPriceAbilityService;
import com.tydic.externalinter.bo.ERPSyncPriceBusIBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.service.ERPSyncProductPriceService;
import com.tydic.externalinter.util.ExtForwardUtils;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncProductPriceAbilityService")
public class ERPSyncProductPriceAbilityServiceImpl
implements ERPSyncProductPriceAbilityService {
    public static final Logger logger = LoggerFactory.getLogger(ERPSyncProductPriceAbilityServiceImpl.class);
    @Resource
    private ERPSyncProductPriceService erpSyncProductPriceService;

    public AbilityExternaLinterResultData syncProductPrice(ERPSyncPriceAbilityBO erpSyncPriceAbilityBO) {
        ExternaLinterResultData checkShopRsp;
        boolean forwardSwitch = ExterPropertiesUtils.getBooleanProperty("FORWARD_SWITCH", false);
        if (forwardSwitch && null != (checkShopRsp = this.checkShop(erpSyncPriceAbilityBO))) {
            return new AbilityExternaLinterResultData(checkShopRsp.getSuccess(), checkShopRsp.getRespCode(), checkShopRsp.getRespDesc());
        }
        logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u5b9e\u73b0\u65b9\u6cd5\u5f00\u59cb");
        if (erpSyncPriceAbilityBO == null) {
            logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u5165\u53c2\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)erpSyncPriceAbilityBO.getOperID()) || StringUtils.isBlank((String)erpSyncPriceAbilityBO.getOperID())) {
            logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a:" + erpSyncPriceAbilityBO.getOperID());
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List jgInfo = erpSyncPriceAbilityBO.getJgInfo();
        if (jgInfo == null || jgInfo.size() == 0) {
            logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ExtJgInfoBO jgInfoBO : jgInfo) {
            if (StringUtils.isEmpty((String)jgInfoBO.getMdID()) || StringUtils.isBlank((String)jgInfoBO.getMdID())) {
                logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u6240\u5728\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u6240\u5728\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((StringUtils.isEmpty((String)jgInfoBO.getScmID()) || StringUtils.isEmpty((String)jgInfoBO.getScmID())) && (StringUtils.isEmpty((String)jgInfoBO.getZjm()) || StringUtils.isEmpty((String)jgInfoBO.getZjm()))) {
                logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u6240\u5728\u52a9\u8bb0\u7801\u4e0e\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u5168\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u6240\u5728\u52a9\u8bb0\u7801\u4e0e\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u5168\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)jgInfoBO.getVipPrice()) || StringUtils.isBlank((String)jgInfoBO.getVipPrice())) {
                logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4f1a\u5458\u4ef7\u4e0d\u80fd\u4e3a\u7a7a:" + jgInfoBO.getVipPrice());
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4f1a\u5458\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] price = jgInfoBO.getJg1().split("\\.");
            if (price[0].contains("-")) {
                logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e2d\u4f1a\u5458\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e2d\u4f1a\u5458\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
            }
            if (StringUtils.isEmpty((String)jgInfoBO.getJg1()) || StringUtils.isEmpty((String)jgInfoBO.getJg1())) {
                logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e2d\u8c03\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e2d\u8c03\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            price = jgInfoBO.getJg1().split("\\.");
            if (!price[0].contains("-")) continue;
            logger.debug("\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e2d\u8c03\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
            return new AbilityExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u8c03\u4ef7\u660e\u7ec6\u4e2d\u8c03\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        String json = JSON.toJSONString((Object)erpSyncPriceAbilityBO);
        ERPSyncPriceBusIBO erpSyncPriceBusIBO = (ERPSyncPriceBusIBO)JsonUtil.fromJson((String)json, ERPSyncPriceBusIBO.class);
        AbilityExternaLinterResultData abilityExternaLinterResultData = new AbilityExternaLinterResultData();
        ExternaLinterResultData externaLinterResultData = this.erpSyncProductPriceService.syncProductPrice(erpSyncPriceBusIBO);
        BeanUtils.copyProperties((Object)externaLinterResultData, (Object)abilityExternaLinterResultData);
        return abilityExternaLinterResultData;
    }

    private ExternaLinterResultData checkShop(ERPSyncPriceAbilityBO erpSyncPriceBusIBO) {
        if (null == erpSyncPriceBusIBO || CollectionUtils.isEmpty((Collection)erpSyncPriceBusIBO.getJgInfo())) {
            return null;
        }
        String url = ExterPropertiesUtils.getProperty("FORWARD_URL_SYNCPRICE_WH");
        String shopCode = ExterPropertiesUtils.getProperty("SHOP_CODE_WH");
        ArrayList<ExtJgInfoBO> whList = new ArrayList<ExtJgInfoBO>(erpSyncPriceBusIBO.getJgInfo().size());
        ArrayList<ExtJgInfoBO> elseList = new ArrayList<ExtJgInfoBO>(erpSyncPriceBusIBO.getJgInfo().size());
        for (ExtJgInfoBO jg : erpSyncPriceBusIBO.getJgInfo()) {
            if (StringUtils.isBlank((String)jg.getMdID())) {
                return null;
            }
            if (shopCode.equals(jg.getMdID())) {
                whList.add(jg);
                continue;
            }
            elseList.add(jg);
        }
        ExternaLinterResultData rsp = null;
        if (CollectionUtils.isNotEmpty(whList)) {
            ERPSyncPriceAbilityBO whReq = new ERPSyncPriceAbilityBO();
            whReq.setJgInfo(whList);
            whReq.setOperID(erpSyncPriceBusIBO.getOperID());
            rsp = ExtForwardUtils.forward(url, whReq);
        }
        if (CollectionUtils.isEmpty(elseList)) {
            return rsp;
        }
        erpSyncPriceBusIBO.setJgInfo(elseList);
        return null;
    }
}

