/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.ability.bo.ExtChuanHaoBO;
import com.tydic.externalinter.ability.bo.ExtSpInfoBO;
import com.tydic.externalinter.atom.CommDataSyncHisAtomService;
import com.tydic.externalinter.atom.QuerySkuInfoAtomService;
import com.tydic.externalinter.bo.ErpSyncDataBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.bo.PayInfoBO;
import com.tydic.externalinter.constant.ErpConstants;
import com.tydic.externalinter.constant.OrderConstants;
import com.tydic.externalinter.dao.po.CommodityDataSyncHistoryPO;
import com.tydic.externalinter.service.ERPSyncDataService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.ordunr.ability.UnrCreateOrderAbilityService;
import com.tydic.ordunr.ability.UnrDeleteOutOrderAbilityService;
import com.tydic.ordunr.ability.UnrQryOrderDetailAbilityService;
import com.tydic.ordunr.ability.bo.UnrCreateOrderAbilityReqBO;
import com.tydic.ordunr.ability.bo.UnrCreateOrderAbilityRespBO;
import com.tydic.ordunr.ability.bo.UnrDeleteOutOrderAbilityReqBO;
import com.tydic.ordunr.ability.bo.UnrDeleteOutOrderAbilityRespBO;
import com.tydic.ordunr.ability.bo.UnrOrdItemAbilityRspBO;
import com.tydic.ordunr.ability.bo.UnrOrdSkuImeiAbilityRspBO;
import com.tydic.ordunr.ability.bo.UnrQryOrderDetailAbilityRspBO;
import com.tydic.ordunr.busi.bo.UnrQryOrderReqBO;
import com.tydic.ordunr.comb.bo.AddressInfoCombReqBO;
import com.tydic.ordunr.comb.bo.SaleOrderInfoCombReqBO;
import com.tydic.ordunr.comb.bo.SaleOrderItemBO;
import com.tydic.zhmd.bo.QryStockByMnemReqBO;
import com.tydic.zhmd.bo.ReqBatchBO;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.ToErpStockInfo;
import com.tydic.zhmd.bo.erpstock.ChuanHaoBO;
import com.tydic.zhmd.bo.erpstock.SpInfoBO;
import com.tydic.zhmd.service.SalesDataSyncValidateService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncDataService")
public class ERPSyncDataServiceImpl
implements ERPSyncDataService {
    private static final Logger logger = LoggerFactory.getLogger(ERPSyncDataServiceImpl.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    @Autowired
    private QryEscapeAtomService exterQryEscapeAtomService;
    @Resource
    private UnrQryOrderDetailAbilityService unrQryOrderDetailAbilityService;
    @Resource
    private UnrCreateOrderAbilityService unrCreateOrderAbilityService;
    @Resource
    private UnrDeleteOutOrderAbilityService unrDeleteOutOrderAbilityService;
    @Autowired
    private QuerySkuInfoAtomService querySkuInfoAtomService;
    @Resource
    private StockService stockService;
    @Autowired
    private CommDataSyncHisAtomService commDataSyncHisAtomService;
    @Resource
    private SalesDataSyncValidateService salesDataSyncValidateService;

    public ExternaLinterResultData syncData(ErpSyncDataBO erpSyncDataBO) {
        String inputParams = JSON.toJSONString((Object)erpSyncDataBO);
        logger.debug("ERP\u9500\u552e\u6570\u636e\u540c\u6b65\u5165\u53c2:" + inputParams);
        CommodityDataSyncHistoryPO stockSyncTaskPO = null;
        try {
            CommodityDataSyncHistoryPO reqPO = new CommodityDataSyncHistoryPO();
            reqPO.setSerialNum(erpSyncDataBO.getOrderID());
            reqPO.setChangeType(erpSyncDataBO.getCzType());
            reqPO.setInputParams(inputParams);
            stockSyncTaskPO = this.commDataSyncHisAtomService.getTaskInfo(reqPO);
        }
        catch (ResourceException e) {
            if ("0015".equals(e.getMsgCode())) {
                return new ExternaLinterResultData(Boolean.valueOf(false), "0015", e.getMessage());
            }
            logger.error("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55\u3010" + erpSyncDataBO.getOrderID() + "\u3011\u5f02\u5e38\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55\u3010" + erpSyncDataBO.getOrderID() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        String code = "9999";
        ExternaLinterResultData<List<ShopBO>> checkShopRsp = this.checkShopInfo(erpSyncDataBO.getMdID());
        if (!checkShopRsp.getSuccess().booleanValue()) {
            logger.error("\u95e8\u5e97\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a" + checkShopRsp.getRespDesc());
            this.modifyHistory(stockSyncTaskPO, code, "\u95e8\u5e97\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a" + checkShopRsp.getRespDesc());
            return new ExternaLinterResultData(Boolean.valueOf(false), code, checkShopRsp.getRespDesc());
        }
        ShopBO shopBO = (ShopBO)((List)checkShopRsp.getRespData()).get(0);
        Long shopId = shopBO.getShopId();
        ExternaLinterResultData checkRsp = this.checkStockInfo(erpSyncDataBO, shopId);
        if (!checkRsp.getSuccess().booleanValue()) {
            logger.error("\u5e93\u5b58\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a" + checkRsp.getRespDesc());
            this.modifyHistory(stockSyncTaskPO, code, "\u5e93\u5b58\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a" + checkRsp.getRespDesc());
            return new ExternaLinterResultData(Boolean.valueOf(false), code, checkRsp.getRespDesc());
        }
        String czType = erpSyncDataBO.getCzType().trim();
        String orderCode = erpSyncDataBO.getOrderID().trim();
        List extSpInfoBOS = erpSyncDataBO.getSpInfo();
        List<SpInfoBO> stockSpInfoBOS = this.toStockSpInfoBOS(extSpInfoBOS);
        ToErpStockInfo toErpStockInfo = this.toErpStockInfo(orderCode, erpSyncDataBO.getOrderTime(), stockSpInfoBOS, shopId);
        ResultData stockRsp = null;
        switch (czType) {
            case "1": {
                if (isDebug.booleanValue()) {
                    logger.debug("ERP\u9500\u552e\u6570\u636e\u65b0\u589e");
                }
                try {
                    ExternaLinterResultData createRsp = this.saveOrderInfo(erpSyncDataBO, shopId);
                    if (!createRsp.getSuccess().booleanValue()) {
                        this.modifyHistory(stockSyncTaskPO, code, createRsp.getRespDesc());
                        return createRsp;
                    }
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u521b\u5efa\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
                }
                try {
                    stockRsp = this.stockService.outStock(toErpStockInfo);
                    break;
                }
                catch (Exception e) {
                    logger.error("\u9500\u552e\u6570\u636e\u65b0\u589e\u8c03\u7528\u5e93\u5b58\u51fa\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u9500\u552e\u6570\u636e\u65b0\u589e\u8c03\u7528\u5e93\u5b58\u51fa\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u9500\u552e\u6570\u636e\u65b0\u589e\u8c03\u7528\u5e93\u5b58\u51fa\u5e93\u5931\u8d25");
                }
            }
            case "2": {
                if (isDebug.booleanValue()) {
                    logger.debug("ERP\u9500\u552e\u6570\u636e\u5220\u9664");
                }
                try {
                    ExternaLinterResultData removeRsp = this.removeOrder(orderCode);
                    if (!removeRsp.getSuccess().booleanValue()) {
                        this.modifyHistory(stockSyncTaskPO, code, removeRsp.getRespDesc());
                        return removeRsp;
                    }
                }
                catch (Exception e) {
                    logger.error("\u5220\u9664\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u5220\u9664\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u5220\u9664\u8ba2\u5355\u5931\u8d25");
                }
                try {
                    stockRsp = this.stockService.backStock(toErpStockInfo);
                    break;
                }
                catch (Exception e) {
                    logger.error("\u9500\u552e\u6570\u636e\u5220\u9664\u8c03\u7528\u5e93\u5b58\u9000\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u9500\u552e\u6570\u636e\u5220\u9664\u8c03\u7528\u5e93\u5b58\u9000\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u9500\u552e\u6570\u636e\u5220\u9664\u8c03\u7528\u5e93\u5b58\u9000\u5e93\u5931\u8d25");
                }
            }
            case "3": {
                logger.debug("ERP\u9500\u552e\u6570\u636e\u4fee\u6539");
                try {
                    ExternaLinterResultData backRsp = this.backStock(orderCode, erpSyncDataBO.getOrderTime(), shopId);
                    if (!backRsp.getSuccess().booleanValue()) {
                        this.modifyHistory(stockSyncTaskPO, code, backRsp.getRespDesc());
                        return backRsp;
                    }
                }
                catch (Exception e) {
                    logger.error("\u5e93\u5b58\u56de\u9000\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u5e93\u5b58\u56de\u9000\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u5e93\u5b58\u56de\u9000\u5931\u8d25");
                }
                try {
                    ExternaLinterResultData removeRsp = this.removeOrder(orderCode);
                    if (!removeRsp.getSuccess().booleanValue()) {
                        this.modifyHistory(stockSyncTaskPO, code, removeRsp.getRespDesc());
                        return removeRsp;
                    }
                }
                catch (Exception e) {
                    logger.error("\u5220\u9664\u539f\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u5220\u9664\u539f\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u5220\u9664\u539f\u8ba2\u5355\u5931\u8d25");
                }
                try {
                    ExternaLinterResultData createRsp = this.saveOrderInfo(erpSyncDataBO, shopId);
                    if (!createRsp.getSuccess().booleanValue()) {
                        this.modifyHistory(stockSyncTaskPO, code, createRsp.getRespDesc());
                        return createRsp;
                    }
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u65b0\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u521b\u5efa\u65b0\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u521b\u5efa\u65b0\u8ba2\u5355\u5931\u8d25");
                }
                try {
                    stockRsp = this.stockService.outStock(toErpStockInfo);
                    break;
                }
                catch (Exception e) {
                    logger.error("\u9500\u552e\u6570\u636e\u4fee\u6539\u8c03\u7528\u5e93\u5b58\u51fa\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, code, "\u9500\u552e\u6570\u636e\u4fee\u6539\u8c03\u7528\u5e93\u5b58\u51fa\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), code, e.getMessage());
                }
            }
            default: {
                this.modifyHistory(stockSyncTaskPO, code, "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                return new ExternaLinterResultData(Boolean.valueOf(false), code, "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            }
        }
        String msg = "";
        boolean rspFlag = false;
        if ("0000".equals(stockRsp.getRespCode())) {
            msg = "\u9500\u552e\u6570\u636e\u540c\u6b65\u5b8c\u6210";
            code = "0000";
            rspFlag = true;
        } else {
            msg = stockRsp.getRespDesc();
        }
        this.modifyHistory(stockSyncTaskPO, code, msg);
        if (isDebug.booleanValue()) {
            logger.debug("\u9500\u552e\u6570\u636e\u540c\u6b65\u5b8c\u6210");
        }
        return new ExternaLinterResultData(Boolean.valueOf(rspFlag), code, msg);
    }

    private ExternaLinterResultData checkStockInfo(ErpSyncDataBO erpSyncDataBO, Long shopId) {
        ReqBatchBO reqBO = new ReqBatchBO();
        ArrayList<QryStockByMnemReqBO> reqList = new ArrayList<QryStockByMnemReqBO>();
        for (ExtSpInfoBO spInfoBO : erpSyncDataBO.getSpInfo()) {
            QryStockByMnemReqBO qryStockByMnemReqBO = new QryStockByMnemReqBO();
            qryStockByMnemReqBO.setMnemCode(spInfoBO.getZjm());
            qryStockByMnemReqBO.setSalesNum(Integer.valueOf(Integer.parseInt(spInfoBO.getNumber())));
            qryStockByMnemReqBO.setShopId(shopId);
            if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                ArrayList<String> codes = new ArrayList<String>(spInfoBO.getChInfo().size());
                for (ExtChuanHaoBO ch : spInfoBO.getChInfo()) {
                    codes.add(ch.getCh());
                }
                qryStockByMnemReqBO.setSerialCodes(codes);
            }
            reqList.add(qryStockByMnemReqBO);
        }
        reqBO.setReqList(reqList);
        ResultData validateStockRsp = this.salesDataSyncValidateService.validateStockInfo(reqBO, erpSyncDataBO.getCzType());
        if (!"0000".equals(validateStockRsp.getRespCode())) {
            return new ExternaLinterResultData(Boolean.valueOf(false), validateStockRsp.getRespCode(), validateStockRsp.getRespDesc());
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private ExternaLinterResultData<List<ShopBO>> checkShopInfo(String shopCode) {
        ArrayList<String> shopCodes = new ArrayList<String>();
        shopCodes.add(shopCode);
        ResultData shopBOResultData = this.salesDataSyncValidateService.validateShopInfo(shopCodes);
        if (!"0000".equals(shopBOResultData.getRespCode())) {
            return new ExternaLinterResultData(Boolean.valueOf(false), shopBOResultData.getRespCode(), shopBOResultData.getRespDesc());
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f", shopBOResultData.getRespData());
    }

    private List<SpInfoBO> toStockSpInfoBOS(List<ExtSpInfoBO> extSpInfoBOS) {
        ArrayList<SpInfoBO> rspList = new ArrayList<SpInfoBO>(extSpInfoBOS.size());
        for (ExtSpInfoBO bo : extSpInfoBOS) {
            SpInfoBO rsp = new SpInfoBO();
            List<ChuanHaoBO> chs = null;
            if (CollectionUtils.isNotEmpty((Collection)bo.getChInfo())) {
                chs = this.toExtChuanHaoBOS(bo.getChInfo());
                rsp.setChInfo(chs);
            }
            rsp.setNumber(bo.getNumber());
            rsp.setSkuId(bo.getSkuId());
            rsp.setShopId(bo.getShopId());
            rsp.setSjjg(bo.getSjjg());
            rsp.setMdID(bo.getMdID());
            rsp.setAutoId(bo.getAutoId());
            rsp.setZjm(bo.getZjm());
            rspList.add(rsp);
        }
        return rspList;
    }

    private List<ChuanHaoBO> toExtChuanHaoBOS(List<ExtChuanHaoBO> chInfo) {
        ArrayList<ChuanHaoBO> rspList = new ArrayList<ChuanHaoBO>(chInfo.size());
        for (ExtChuanHaoBO ext : chInfo) {
            ChuanHaoBO ch = new ChuanHaoBO();
            ch.setInsuranceType(ext.getInsuranceType());
            ch.setCustomerNumber(ext.getCustomerNumber());
            ch.setCustomerName(ext.getCustomerName());
            ch.setCustomerIDNumber(ext.getCustomerIDNumber());
            ch.setCh(ext.getCh());
            rspList.add(ch);
        }
        return rspList;
    }

    private void modifyHistory(CommodityDataSyncHistoryPO stockSyncTaskPO, String code, String desc) {
        try {
            stockSyncTaskPO.setRespCode(code);
            stockSyncTaskPO.setRespDesc(desc);
            this.commDataSyncHisAtomService.modifyTaskInfo(stockSyncTaskPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private ToErpStockInfo toErpStockInfo(String orderId, String orderTime, List<SpInfoBO> spInfoBOS, Long shopId) {
        ToErpStockInfo toErpStockInfo = new ToErpStockInfo();
        toErpStockInfo.setOrderID(orderId);
        toErpStockInfo.setOrderTime(orderTime);
        toErpStockInfo.setStockChangeType("01");
        ArrayList<SpInfoBO> spInfoBOList = new ArrayList<SpInfoBO>(spInfoBOS.size());
        for (SpInfoBO spInfoBO : spInfoBOS) {
            spInfoBO.setShopId(shopId.longValue());
            spInfoBOList.add(spInfoBO);
        }
        toErpStockInfo.setSpInfo(spInfoBOList);
        return toErpStockInfo;
    }

    private UnrQryOrderDetailAbilityRspBO getOrderDetails(String orderCode) {
        UnrQryOrderReqBO unrQryOrderReqBO = new UnrQryOrderReqBO();
        unrQryOrderReqBO.setOutOrderNo(orderCode);
        unrQryOrderReqBO.setOrderSystem("S001");
        UnrQryOrderDetailAbilityRspBO unrQryOrderDetailAbilityRspBO = null;
        try {
            unrQryOrderDetailAbilityRspBO = this.unrQryOrderDetailAbilityService.qryUnrQryOrderDetail(unrQryOrderReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38");
        }
        return unrQryOrderDetailAbilityRspBO;
    }

    private ExternaLinterResultData backStock(String orderCode, String orderTime, Long shopId) {
        UnrQryOrderDetailAbilityRspBO unrQryOrderDetailAbilityRspBO = null;
        try {
            unrQryOrderDetailAbilityRspBO = this.getOrderDetails(orderCode);
        }
        catch (ResourceException e) {
            return new ExternaLinterResultData(Boolean.valueOf(false), e.getMsgCode(), e.getMessage());
        }
        if (null == unrQryOrderDetailAbilityRspBO) {
            logger.error("\u8ba2\u5355\u8be6\u60c5\u4e3a\u7a7a");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u5931\u8d25");
        }
        if (!"0000".equals(unrQryOrderDetailAbilityRspBO.getRespCode())) {
            logger.error("\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff1a" + unrQryOrderDetailAbilityRspBO.getRespDesc());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", unrQryOrderDetailAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)unrQryOrderDetailAbilityRspBO.getOrdItemListRspBO())) {
            logger.debug("\u8ba2\u5355\u3010" + orderCode + "\u3011\u4e0d\u5b58\u5728");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8ba2\u5355\u3010" + orderCode + "\u3011\u4e0d\u5b58\u5728");
        }
        List ordItemListRspBO = unrQryOrderDetailAbilityRspBO.getOrdItemListRspBO();
        ArrayList<SpInfoBO> spInfoBOS = new ArrayList<SpInfoBO>();
        for (UnrOrdItemAbilityRspBO bo : ordItemListRspBO) {
            SpInfoBO spInfoBO = new SpInfoBO();
            spInfoBO.setShopId(shopId.longValue());
            if (StringUtils.isBlank((CharSequence)bo.getSkuId())) {
                logger.error("\u672a\u67e5\u8be2\u5230skuId");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u672a\u67e5\u8be2\u5230skuId");
            }
            try {
                spInfoBO.setSkuId(Long.valueOf(Long.parseLong(bo.getSkuId())));
            }
            catch (NumberFormatException e) {
                logger.error("skuId\u3010" + bo.getSkuId() + "\u3011\u683c\u5f0f\u9519\u8bef");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "skuId\u3010" + bo.getSkuId() + "\u3011\u683c\u5f0f\u9519\u8bef");
            }
            if (null == bo.getPurchaseCount()) {
                logger.error("\u672a\u67e5\u8be2\u5230\u9500\u552e\u6570\u91cf");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u6570\u91cf");
            }
            spInfoBO.setNumber(String.valueOf(bo.getPurchaseCount().longValue()));
            ArrayList<ChuanHaoBO> chuanHaoBOS = null;
            if (CollectionUtils.isNotEmpty((Collection)bo.getOrdSkuImeiList())) {
                chuanHaoBOS = new ArrayList<ChuanHaoBO>(bo.getOrdSkuImeiList().size());
                for (UnrOrdSkuImeiAbilityRspBO unrBO : bo.getOrdSkuImeiList()) {
                    ChuanHaoBO chuanHaoBO = new ChuanHaoBO();
                    chuanHaoBO.setCh(unrBO.getImei());
                    chuanHaoBOS.add(chuanHaoBO);
                }
            }
            spInfoBO.setChInfo(chuanHaoBOS);
            spInfoBOS.add(spInfoBO);
        }
        ResultData stockRsp = null;
        try {
            ToErpStockInfo toErpStockInfo = this.toErpStockInfo(orderCode, orderTime, spInfoBOS, shopId);
            stockRsp = this.stockService.backStock(toErpStockInfo);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u56de\u9000\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u56de\u9000\u5e93\u5b58\u5931\u8d25");
        }
        if (!"0000".equals(stockRsp.getRespCode())) {
            logger.error("\u539f\u8ba2\u5355\u5e93\u5b58\u9000\u56de\u5931\u8d25\uff1a" + stockRsp.getRespDesc());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", stockRsp.getRespDesc());
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private ExternaLinterResultData saveOrderInfo(ErpSyncDataBO erpSyncDataBO, Long shopId) {
        UnrCreateOrderAbilityReqBO unrCreateOrderAbilityReqBO = new UnrCreateOrderAbilityReqBO();
        ExternaLinterResultData paramsRsp = this.toUnrCreateOrderAbilityReqBO(unrCreateOrderAbilityReqBO, erpSyncDataBO, shopId);
        if (!paramsRsp.getSuccess().booleanValue()) {
            return paramsRsp;
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u8ba2\u5355\u521b\u5efa\u5165\u53c2\uff1a" + JSON.toJSONString((Object)unrCreateOrderAbilityReqBO));
        }
        UnrCreateOrderAbilityRespBO unrCreateOrderAbilityRespBO = null;
        try {
            unrCreateOrderAbilityRespBO = this.unrCreateOrderAbilityService.dealCreateOrder(unrCreateOrderAbilityReqBO);
            if (isDebug.booleanValue()) {
                logger.debug("\u8ba2\u5355\u521b\u5efa\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)unrCreateOrderAbilityRespBO));
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u521b\u5efa\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u521b\u5efa\u8ba2\u5355\u5f02\u5e38");
        }
        if (!"0000".equals(unrCreateOrderAbilityRespBO.getRespCode())) {
            logger.error("\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff1a" + unrCreateOrderAbilityRespBO.getRespDesc());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", unrCreateOrderAbilityRespBO.getRespDesc());
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    /*
     * WARNING - void declaration
     */
    private ExternaLinterResultData toUnrCreateOrderAbilityReqBO(UnrCreateOrderAbilityReqBO unrCreateOrderAbilityReqBO, ErpSyncDataBO erpSyncDataBO, Long shopId) {
        unrCreateOrderAbilityReqBO.setTotalAmount(new BigDecimal(erpSyncDataBO.getDdje()));
        BigDecimal realPyAmount = new BigDecimal(0);
        BigDecimal payedAmount = new BigDecimal(0);
        String payTypeStr = "";
        List payInfo = erpSyncDataBO.getPayInfo();
        for (PayInfoBO payInfoBO : payInfo) {
            payTypeStr = payInfoBO.getPayMode().trim();
            if ("\u73b0\u91d1".equals(payTypeStr)) {
                payedAmount = new BigDecimal(payInfoBO.getPayMoney()).add(payedAmount);
                continue;
            }
            realPyAmount = new BigDecimal(payInfoBO.getPayMoney()).add(realPyAmount);
        }
        unrCreateOrderAbilityReqBO.setPayedAmount(payedAmount);
        unrCreateOrderAbilityReqBO.setRealPayAmount(realPyAmount);
        String payType = null;
        try {
            payType = this.exterQryEscapeAtomService.getCodeTitle("payModeStr", payTypeStr);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8f6c\u4e49\u7801\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)payType)) {
            unrCreateOrderAbilityReqBO.setPayType(ErpConstants.PAY_MODE_DEFAULT);
        } else {
            unrCreateOrderAbilityReqBO.setPayType(Integer.valueOf(Integer.parseInt(payType)));
        }
        unrCreateOrderAbilityReqBO.setOrderSource(OrderConstants.ORDER_SOURCE_DEFAULT);
        unrCreateOrderAbilityReqBO.setOutOrderNo(erpSyncDataBO.getOrderID());
        unrCreateOrderAbilityReqBO.setOrderSystem("S001");
        unrCreateOrderAbilityReqBO.setPurchaseType(OrderConstants.PURCHASE_TYPE_DEFAULT);
        unrCreateOrderAbilityReqBO.setPurchaserId("-1");
        unrCreateOrderAbilityReqBO.setPurchaserName("ERP");
        unrCreateOrderAbilityReqBO.setShoppingCartFlag("0");
        unrCreateOrderAbilityReqBO.setTotalTransportationFee(new BigDecimal(0));
        unrCreateOrderAbilityReqBO.setIsDisPatch(OrderConstants.IS_DIS_PATCH_DEFAULT);
        unrCreateOrderAbilityReqBO.setAddressInfo(new AddressInfoCombReqBO());
        ArrayList<Object> saleOrderItemList = new ArrayList<Object>();
        List spInfoBOList = erpSyncDataBO.getSpInfo();
        ArrayList<String> zjms = new ArrayList<String>(spInfoBOList.size());
        for (ExtSpInfoBO spInfoBO : spInfoBOList) {
            void var15_17;
            zjms.add(spInfoBO.getZjm());
            SaleOrderItemBO saleOrderItemBO = new SaleOrderItemBO();
            saleOrderItemBO.setSeckillFlag("0");
            saleOrderItemBO.setPurchaseCount(new BigDecimal(spInfoBO.getNumber()));
            saleOrderItemBO.setSkuSalePrice(new BigDecimal(spInfoBO.getSjjg()));
            saleOrderItemBO.setSkuId(spInfoBO.getZjm());
            Object var15_18 = null;
            if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                ArrayList<String> arrayList = new ArrayList<String>(spInfoBO.getChInfo().size());
                for (ExtChuanHaoBO ch : spInfoBO.getChInfo()) {
                    if (StringUtils.isBlank((CharSequence)ch.getCh())) {
                        logger.error("\u4e32\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32");
                        return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u4e32\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32");
                    }
                    arrayList.add(ch.getCh());
                }
            }
            saleOrderItemBO.setLibraryIdList((List)var15_17);
            saleOrderItemList.add(saleOrderItemBO);
        }
        QuerySkuByMaterialIdExtSkuIdCustomRspBO skuInfoRsp = null;
        try {
            skuInfoRsp = this.querySkuInfoAtomService.getSkuInfoByShopIdAndZjm(zjms, null, shopId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u5546\u54c1\u67e5\u8be2\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)skuInfoRsp));
        }
        if (null == skuInfoRsp || CollectionUtils.isEmpty((Collection)skuInfoRsp.getSkus())) {
            logger.error("\u5546\u54c1\u4e0d\u5b58\u5728");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        for (SkuBO skuBO : skuInfoRsp.getSkus()) {
            skuMap.put(skuBO.getExtSkuId(), String.valueOf(skuBO.getSkuId()));
        }
        for (SaleOrderItemBO saleOrderItemBO : saleOrderItemList) {
            String zjm = saleOrderItemBO.getSkuId();
            if (!skuMap.containsKey(zjm)) {
                logger.error("\u5546\u54c1\u3010" + zjm + "\u3011\u4e0d\u5b58\u5728");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5546\u54c1\u3010" + zjm + "\u3011\u4e0d\u5b58\u5728");
            }
            saleOrderItemBO.setSkuId((String)skuMap.get(zjm));
        }
        SaleOrderInfoCombReqBO saleOrderInfoCombReqBO = new SaleOrderInfoCombReqBO();
        saleOrderInfoCombReqBO.setSkuEntrepotCode(String.valueOf(shopId));
        saleOrderInfoCombReqBO.setShopId(shopId);
        saleOrderInfoCombReqBO.setSaleOrderItemList(saleOrderItemList);
        ArrayList<SaleOrderInfoCombReqBO> arrayList = new ArrayList<SaleOrderInfoCombReqBO>();
        arrayList.add(saleOrderInfoCombReqBO);
        unrCreateOrderAbilityReqBO.setSaleOrderInfoList(arrayList);
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private ExternaLinterResultData removeOrder(String orderCode) {
        UnrDeleteOutOrderAbilityReqBO unrDeleteOutOrderAbilityReqBO = new UnrDeleteOutOrderAbilityReqBO();
        unrDeleteOutOrderAbilityReqBO.setOrderSystem("S001");
        unrDeleteOutOrderAbilityReqBO.setOutOrderNo(orderCode);
        if (isDebug.booleanValue()) {
            logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u5220\u9664\u8ba2\u5355\uff0c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)unrDeleteOutOrderAbilityReqBO));
        }
        UnrDeleteOutOrderAbilityRespBO unrDeleteOutOrderAbilityRespBO = null;
        try {
            unrDeleteOutOrderAbilityRespBO = this.unrDeleteOutOrderAbilityService.dealDeleteOutOrder(unrDeleteOutOrderAbilityReqBO);
            if (isDebug.booleanValue()) {
                logger.debug("\u5220\u9664\u8ba2\u5355\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)unrDeleteOutOrderAbilityRespBO));
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8ba2\u5355\u5220\u9664\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8c03\u7528\u8ba2\u5355\u5220\u9664\u670d\u52a1\u5f02\u5e38");
        }
        if (!"0000".equals(unrDeleteOutOrderAbilityRespBO.getRespCode())) {
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", unrDeleteOutOrderAbilityRespBO.getRespDesc());
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }
}

