/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.ability.bo.ExtJgInfoBO;
import com.tydic.externalinter.atom.CommDataSyncHisAtomService;
import com.tydic.externalinter.bo.ERPSyncPriceBusIBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.dao.CommPriceDataSyncDetailDao;
import com.tydic.externalinter.dao.po.CommodityDataSyncHistoryPO;
import com.tydic.externalinter.service.ERPSyncProductPriceService;
import com.tydic.externalinter.thread.PriceDetailSaveThread;
import com.tydic.externalinter.util.ExtCreateThreadUtils;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.service.ShopService;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncProductPriceService")
public class ERPSyncProductPriceServiceImpl
implements ERPSyncProductPriceService {
    private static final Logger logger = LoggerFactory.getLogger(ERPSyncProductPriceServiceImpl.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    @Resource
    private UpdateSkuPriceService updateSkuPriceService;
    @Resource
    private ShopService shopService;
    @Autowired
    private CommDataSyncHisAtomService commDataSyncHisAtomService;
    @Autowired
    private CommPriceDataSyncDetailDao commPriceDataSyncDetailDao;

    public ExternaLinterResultData syncProductPrice(ERPSyncPriceBusIBO erpSyncPriceBusIBO) {
        UpdateSkuPriceRspBO skuPriceRspBO;
        String inputParams = JSON.toJSONString((Object)erpSyncPriceBusIBO);
        if (isDebug.booleanValue()) {
            logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u5f00\u59cb");
            logger.debug("\u53c2\u6570\uff1a" + inputParams);
        }
        CommodityDataSyncHistoryPO stockSyncTaskPO = null;
        try {
            CommodityDataSyncHistoryPO reqPO = new CommodityDataSyncHistoryPO();
            reqPO.setSerialNum(UUID.randomUUID().toString().replace("-", ""));
            reqPO.setChangeType("6");
            reqPO.setInputParams(inputParams);
            stockSyncTaskPO = this.commDataSyncHisAtomService.getTaskInfo(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4ef7\u683c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        ArrayList<JgInfoReqBO> list = new ArrayList<JgInfoReqBO>();
        try {
            List jgInfo = erpSyncPriceBusIBO.getJgInfo();
            for (ExtJgInfoBO jgInfoBO : jgInfo) {
                JgInfoReqBO jgInfoReqBO = new JgInfoReqBO();
                jgInfoReqBO.setZjm(jgInfoBO.getZjm());
                jgInfoReqBO.setScmID(jgInfoBO.getScmID());
                ShopBO shopBO = new ShopBO();
                shopBO.setShopMdId(jgInfoBO.getMdID());
                ResultData shopByMdId = this.shopService.findShopByMdId(shopBO);
                shopBO = (ShopBO)shopByMdId.getRespData();
                if (shopBO == null) {
                    this.modifyHistory(stockSyncTaskPO, "9999", "\u95e8\u5e97\u3010" + jgInfoBO.getMdID() + "\u3011\u4e0d\u5b58\u5728");
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u95e8\u5e97\u3010" + jgInfoBO.getMdID() + "\u3011\u4e0d\u5b58\u5728");
                }
                jgInfoReqBO.setMdID(shopBO.getShopId().toString());
                if (StringUtils.isNotBlank((CharSequence)jgInfoBO.getJg1())) {
                    jgInfoReqBO.setJgl(jgInfoBO.getJg1());
                }
                if (StringUtils.isNotBlank((CharSequence)jgInfoBO.getVipPrice())) {
                    jgInfoReqBO.setVipPrice(jgInfoBO.getVipPrice());
                }
                if (StringUtils.isNotBlank((CharSequence)jgInfoBO.getLimitPrice())) {
                    jgInfoReqBO.setLimitPrice(jgInfoBO.getLimitPrice());
                }
                jgInfoReqBO.setAssessmentPrice(StringUtils.isNotBlank((CharSequence)jgInfoBO.getAssessmentPrice()) ? jgInfoBO.getAssessmentPrice() : null);
                jgInfoReqBO.setPurchasePrice(StringUtils.isNotBlank((CharSequence)jgInfoBO.getPurchasePrice()) ? jgInfoBO.getPurchasePrice() : null);
                list.add(jgInfoReqBO);
            }
            UpdateSkuPriceReqBO updateSkuPriceReqBO = new UpdateSkuPriceReqBO();
            updateSkuPriceReqBO.setJgInfo(list);
            if (isDebug.booleanValue()) {
                logger.debug("\u8c03\u7528\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5165\u53c2\uff1a" + updateSkuPriceReqBO);
            }
            skuPriceRspBO = this.updateSkuPriceService.updateSkuPrice(updateSkuPriceReqBO);
        }
        catch (Exception e) {
            logger.debug("\u4ef7\u683c\u540c\u6b65\u5931\u8d25:" + e.getMessage());
            this.modifyHistory(stockSyncTaskPO, "9999", "\u4ef7\u683c\u540c\u6b65\u5931\u8d25:" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u4ef7\u683c\u540c\u6b65\u5931\u8d25");
        }
        this.createPriceDetailSaveThread(skuPriceRspBO, stockSyncTaskPO.getRecordId());
        logger.debug("Erp\u9500\u552e\u4ef7\u683c\u540c\u6b65\u63a5\u53e3\u7ed3\u675f");
        this.modifyHistory(stockSyncTaskPO, "0000", "\u6210\u529f");
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private void createPriceDetailSaveThread(UpdateSkuPriceRspBO skuPriceRspBO, Long recordId) {
        try {
            PriceDetailSaveThread thread = new PriceDetailSaveThread(this.commPriceDataSyncDetailDao, skuPriceRspBO, recordId);
            ExecutorService singleThreadPool = ExtCreateThreadUtils.createSimpleThreadPool(thread, "pricedetail-pool", 1, 1);
            singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
            singleThreadPool.shutdown();
        }
        catch (Exception e) {
            logger.error("\u5f00\u542f\u4ef7\u683c\u540c\u6b65\u660e\u7ec6\u65b0\u589e\u7ebf\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void modifyHistory(CommodityDataSyncHistoryPO stockSyncTaskPO, String code, String desc) {
        try {
            stockSyncTaskPO.setRespCode(code);
            stockSyncTaskPO.setRespDesc(desc);
            this.commDataSyncHisAtomService.modifyTaskInfo(stockSyncTaskPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

