/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.fileservice.impl;

import com.ohaotian.commodity.busi.sku.QuerySkuDetailBusiService;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssUtil;
import com.tydic.externalinter.ability.bo.StockDataAbilityBo;
import com.tydic.externalinter.ability.bo.StockDataAbilityReqBo;
import com.tydic.externalinter.ability.bo.StockDataAbilityRspBo;
import com.tydic.externalinter.config.PropertiesReaderUtils;
import com.tydic.externalinter.dao.ErpKCInfoDao;
import com.tydic.externalinter.dao.po.ErpFileStockDataPO;
import com.tydic.externalinter.dao.po.StockDataPo;
import com.tydic.externalinter.fileservice.SyncFileStoreStockService;
import com.tydic.externalinter.util.HttpUtilsForFile;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.SkuComparedReqBO;
import com.tydic.zhmd.bo.SkuComparedRspBO;
import com.tydic.zhmd.bo.frontQueryBO.QuerySkuBO;
import com.tydic.zhmd.bo.frontQueryBO.QureryStockRspBO;
import com.tydic.zhmd.service.ShopService;
import com.tydic.zhmd.service.StockComparedService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.intfce.sku.QuerySkuByMaterialIdExtSkuIdCustomService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncFileStoreStockService")
public class SyncFileStoreStockServiceImpl
implements SyncFileStoreStockService {
    private static final Logger log = LoggerFactory.getLogger(SyncFileStoreStockServiceImpl.class);
    private static SimpleDateFormat time = new SimpleDateFormat("yyyyMMdd");
    private static final String LOCAL_FILE_DIR_PATH = "/home/admin/stockDataFile/";
    private static String[] provs = new String[]{"66100", "63400", "63500", "62300", "62200", "62100", "61200", "65300", "61400", "65200", "64300", "63600", "61500", "64200", "10086", "63200", "61300", "64100", "64400", "64600", "66300", "66500", "61100", "63100", "65100", "63700"};
    Map<String, Object> userServiceMap = new HashMap<String, Object>();
    @Autowired
    ShopService shopService;
    @Resource
    QuerySkuByMaterialIdExtSkuIdCustomService querySkuIdService;
    @Autowired
    StockService stockService;
    @Autowired
    ErpKCInfoDao erpKCInfoDao;
    @Autowired
    StockComparedService stockComparedService;
    @Resource
    QuerySkuDetailBusiService querySkuDetailBusiService;

    public static Date getNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public void stockaDataSyn(String stockaDataSyn) {
        Date current = new Date();
        String currentsTime = time.format(current);
        for (String prov : provs) {
            try {
                String httpUrlHead = "http://downloadFile.cmdc.139erp.com/FileStorage/DownLoadServlet?savePath=Files/" + prov + "/" + currentsTime + "/";
                String flieName = currentsTime + "_" + prov + "_stockData_0001.REQ.csv";
                String url = httpUrlHead + flieName + "&fileName=" + flieName;
                File uploadFile = new File(LOCAL_FILE_DIR_PATH + currentsTime + "/" + flieName);
                HttpUtilsForFile.downLoadFromUrl(url, flieName, LOCAL_FILE_DIR_PATH + currentsTime);
                if (uploadFile.exists()) {
                    OssUtil.uploadFile((File)uploadFile, (OssConfig)PropertiesReaderUtils.getOSS(), (String)("stockDataFile/" + currentsTime + "/"));
                    log.debug("\u4e0a\u4f20\u7701\u4efd[" + prov + "]oss\u6587\u4ef6\u6210\u529f\uff01,\u5f00\u59cb\u89e3\u6790\u6587\u4ef6\uff1a" + flieName);
                    this.readFile(flieName, 1, LOCAL_FILE_DIR_PATH + currentsTime + "/");
                    log.debug("\u89e3\u6790\u7701\u4efd[" + prov + "]\u6587\u4ef6\u6210\u529f\uff01,\u5f00\u59cb\u5220\u9664\u6587\u4ef6\uff1a" + flieName);
                    uploadFile.delete();
                    log.debug("\u5220\u9664\u7701\u4efd[" + prov + "]\u6587\u4ef6\u6210\u529f\uff01");
                }
                log.info("*****\u5904\u7406\u7701\u4efd[" + prov + "]\u7ed3\u675f\uff01*********");
            }
            catch (Exception e) {
                log.error("*****\u5904\u7406\u7701\u4efd[" + prov + "]\u51fa\u9519\uff01*********");
            }
        }
        File folder = new File(LOCAL_FILE_DIR_PATH + currentsTime);
        if (folder.exists()) {
            folder.delete();
        }
        log.info("*****\u5b9a\u65f6\u4efb\u52a1\u6b63\u5e38\u7ed3\u675f\uff01*********");
    }

    public void readFile(String fileName, int fileNum, String filePath) {
        log.debug("--------- \u89e3\u6790\u6587\u4ef6\u3010" + fileName + "\u3011\u5f00\u59cb ---------");
        List<Object> content = new ArrayList();
        content = SyncFileStoreStockServiceImpl.getFileContent(filePath + fileName);
        log.info(fileName + "\u6587\u4ef6\u5185\u5bb9\u8bfb\u53d6\u5b8c\u6210");
        if (Integer.parseInt((String)content.get(0)) != content.size() - 1) {
            log.info("\u603b\u8bb0\u5f55\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26!");
        } else {
            for (int j = 1; j < content.size(); ++j) {
                this.dealLineFile((String)content.get(j));
            }
            this.dealFiles(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getFileContent(String fileName) {
        ArrayList<String> fileContent = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(fileName)), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                fileContent.add(line);
            }
            return fileContent;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("9999", "\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    try {
                        br.close();
                        br = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        br = null;
                    }
                }
                catch (Throwable throwable) {
                    br = null;
                    throw throwable;
                }
            }
        }
    }

    public void dealLineFile(String lineContent) {
        try {
            String[] array = lineContent.split("\\|");
            Double kcslErp = 0.0;
            if (19 == array.length) {
                String mdIDErp = array[0].equals("") ? null : array[0];
                String haveChErp = array[1].equals("") ? null : array[1];
                String zjmErp = array[2].equals("") ? null : array[2];
                String scmIDErp = array[3].equals("") ? null : array[3];
                String cgTypeErp = array[4].equals("") ? null : array[4];
                String typeErp = array[5].equals("") ? null : array[5];
                String ppErp = array[6].equals("") ? null : array[6];
                String nameErp = array[7].equals("") ? null : array[7];
                String fullNameErp = array[8].equals("") ? null : array[8];
                String colorErp = array[9].equals("") ? null : array[9];
                String ncErp = array[10].equals("") ? null : array[10];
                String kcslErpStr = array[11].equals("") ? null : array[11];
                String jg1Erp = array[12].equals("") ? null : array[12];
                String vipPriceErp = array[13].equals("") ? null : array[13];
                String limitPriceErp = array[14].equals("") ? null : array[14];
                String assessmentPriceErp = array[15].equals("") ? null : array[15];
                String purchasePriceErp = array[16].equals("") ? null : array[16];
                String chErp = array[17].equals("") ? null : array[17];
                String endErp = array[18];
                if (null != kcslErpStr) {
                    kcslErp = Double.parseDouble(kcslErpStr);
                }
                if (!endErp.equals("0x0d0x0a")) {
                    ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdIDErp, haveChErp, null, chErp, null, zjmErp, null, scmIDErp, null, cgTypeErp, null, typeErp, null, ppErp, null, nameErp, null, fullNameErp, null, colorErp, null, ncErp, null, kcslErpStr, null, jg1Erp, null, vipPriceErp, null, limitPriceErp, null, assessmentPriceErp, null, purchasePriceErp);
                    this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                    return;
                }
                ResultData resultData = this.getSkuStockByShopCode(mdIDErp, zjmErp, scmIDErp, haveChErp);
                if (!"0000".equals(resultData.getRespCode())) {
                    ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdIDErp, haveChErp, null, chErp, null, zjmErp, null, scmIDErp, null, cgTypeErp, null, typeErp, null, ppErp, null, nameErp, null, fullNameErp, null, colorErp, null, ncErp, resultData.getRespDesc(), kcslErpStr, null, jg1Erp, null, vipPriceErp, null, limitPriceErp, null, assessmentPriceErp, null, purchasePriceErp);
                    this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                    return;
                }
                QureryStockRspBO queryStockRspBO = (QureryStockRspBO)resultData.getRespData();
                if (haveChErp.equals("1")) {
                    if (1.0 < kcslErp) {
                        ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdIDErp, haveChErp, null, chErp, null, zjmErp, null, scmIDErp, null, cgTypeErp, null, typeErp, null, ppErp, null, nameErp, null, fullNameErp, null, colorErp, null, ncErp, queryStockRspBO.getCurrentSku(), kcslErpStr, null, jg1Erp, null, vipPriceErp, null, limitPriceErp, null, assessmentPriceErp, null, purchasePriceErp);
                        this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                    } else if (CollectionUtils.isNotEmpty((Collection)queryStockRspBO.getCh()) && queryStockRspBO.getCh().contains(chErp) && 0.0 == kcslErp) {
                        ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdIDErp, haveChErp, null, chErp, null, zjmErp, null, scmIDErp, null, cgTypeErp, null, typeErp, null, ppErp, null, nameErp, null, fullNameErp, null, colorErp, null, ncErp, "1", kcslErpStr, null, jg1Erp, null, vipPriceErp, null, limitPriceErp, null, assessmentPriceErp, null, purchasePriceErp);
                        this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                    } else if ((CollectionUtils.isEmpty((Collection)queryStockRspBO.getCh()) || !queryStockRspBO.getCh().contains(chErp)) && 1.0 == kcslErp) {
                        ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdIDErp, haveChErp, null, chErp, null, zjmErp, null, scmIDErp, null, cgTypeErp, null, typeErp, null, ppErp, null, nameErp, null, fullNameErp, null, colorErp, null, ncErp, "0", kcslErpStr, null, jg1Erp, null, vipPriceErp, null, limitPriceErp, null, assessmentPriceErp, null, purchasePriceErp);
                        this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                    }
                    return;
                }
                if (Double.parseDouble(queryStockRspBO.getCurrentSku()) != kcslErp) {
                    ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdIDErp, haveChErp, null, chErp, null, zjmErp, null, scmIDErp, null, cgTypeErp, null, typeErp, null, ppErp, null, nameErp, null, fullNameErp, null, colorErp, null, ncErp, queryStockRspBO.getCurrentSku(), kcslErpStr, null, jg1Erp, null, vipPriceErp, null, limitPriceErp, null, assessmentPriceErp, null, purchasePriceErp);
                    this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6570\u636e\u65f6\u3001\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\uff01" + e.getMessage(), (Throwable)e);
            throw new BusinessException("9999", "\u5904\u7406\u6570\u636e\u65f6\u3001\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\uff01" + e.getMessage());
        }
    }

    public void dealFiles(List<String> contents) {
        block24: {
            try {
                SkuComparedReqBO skuComparedReqBO = new SkuComparedReqBO();
                HashSet<String> zjmList = new HashSet<String>();
                HashSet<String> instanceCodeList = new HashSet<String>();
                String mdId = null;
                for (int j = 1; j < contents.size(); ++j) {
                    String[] array = contents.get(j).split("\\|");
                    zjmList.add(array[2]);
                    mdId = array[0];
                    if (!StringUtils.isNotBlank((CharSequence)array[17])) continue;
                    instanceCodeList.add(array[17]);
                }
                skuComparedReqBO.setShopCode(mdId);
                skuComparedReqBO.setZjmList(zjmList);
                skuComparedReqBO.setInstanceCodeList(instanceCodeList);
                ResultData resultData = this.stockComparedService.comparedSkuStock(skuComparedReqBO);
                if (!"0000".equals(resultData.getRespCode())) {
                    log.error("\u5e93\u5b58\u5bf9\u8d26\u5dee\u5f02\u67e5\u8be2\u51fa\u9519\uff1a" + resultData.getRespDesc());
                    throw new BusinessException("9999", "\u5e93\u5b58\u5bf9\u8d26\u5dee\u5f02\u67e5\u8be2\u51fa\u9519\uff1a" + resultData.getRespDesc());
                }
                List skuComparedRspBOs = (List)resultData.getRespData();
                log.debug("\u5dee\u5f02\u603b\u6570\uff1a" + skuComparedRspBOs.toString());
                if (!CollectionUtils.isNotEmpty((Collection)skuComparedRspBOs)) break block24;
                ShopBO shopBO = new ShopBO();
                shopBO.setShopMdId(mdId);
                ResultData mdIdData = this.shopService.findShopByMdId(shopBO);
                shopBO = (ShopBO)mdIdData.getRespData();
                for (SkuComparedRspBO skuComparedRspBO : skuComparedRspBOs) {
                    String _ch;
                    Integer _haveCh;
                    Object skuComparedRspBO_ch2;
                    Long skuId = skuComparedRspBO.getCenterSkuId();
                    Integer haveCh = skuComparedRspBO.getIsRequiredCode() == null ? 2 : skuComparedRspBO.getIsRequiredCode();
                    String ScmID = skuComparedRspBO.getScmID();
                    Integer skuStockAmount = skuComparedRspBO.getSkuStockAmount();
                    String zjm = skuComparedRspBO.getZjm();
                    String ch = skuComparedRspBO.getSkuInstanceErpCode();
                    String color = null;
                    String nc = null;
                    String price = null;
                    String vipPrice = null;
                    String limitPrice = null;
                    String assessmentPrice = null;
                    String purchasePrice = null;
                    QuerySkuDetailReqBO querySkuDetailReqBO = new QuerySkuDetailReqBO();
                    querySkuDetailReqBO.setSupplierId(shopBO.getShopId());
                    querySkuDetailReqBO.setSkuId(skuId);
                    QuerySkuDetailRspBO querySkuDetailRspBO = this.querySkuDetailBusiService.querySkuDetail(querySkuDetailReqBO);
                    if (null != querySkuDetailRspBO && "0000".equals(querySkuDetailRspBO.getRespCode())) {
                        if (null != querySkuDetailRspBO.getPrice()) {
                            if (null != querySkuDetailRspBO.getPrice().getSalePrice()) {
                                price = querySkuDetailRspBO.getPrice().getSalePrice().toString();
                            }
                            if (null != querySkuDetailRspBO.getPrice().getMemberPrice()) {
                                vipPrice = querySkuDetailRspBO.getPrice().getMemberPrice().toString();
                            }
                            if (null != querySkuDetailRspBO.getPrice().getAgreementPrice()) {
                                limitPrice = querySkuDetailRspBO.getPrice().getAgreementPrice().toString();
                            }
                            if (null != querySkuDetailRspBO.getPrice().getAssessmentPrice()) {
                                assessmentPrice = querySkuDetailRspBO.getPrice().getAssessmentPrice().toString();
                            }
                            if (null != querySkuDetailRspBO.getPrice().getPurchasePrice()) {
                                purchasePrice = querySkuDetailRspBO.getPrice().getPurchasePrice().toString();
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)querySkuDetailRspBO.getSpecs())) {
                            for (SkuSpecBO skuSpecBO : querySkuDetailRspBO.getSpecs()) {
                                if ("900991233".equals(skuSpecBO.getCommodityPropGrpId().toString())) {
                                    color = skuSpecBO.getPropValue();
                                }
                                if (!"900991234".equals(skuSpecBO.getCommodityPropGrpId().toString())) continue;
                                nc = skuSpecBO.getPropValue();
                            }
                        }
                        if (null == zjm || StringUtils.isBlank((CharSequence)zjm)) {
                            zjm = querySkuDetailRspBO.getExtSkuId();
                        }
                        if (null == ScmID || StringUtils.isBlank((CharSequence)ScmID)) {
                            ScmID = querySkuDetailRspBO.getMaterialId();
                        }
                    } else {
                        if (null == querySkuDetailRspBO) {
                            log.error("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff1a" + querySkuDetailReqBO.toString());
                        }
                        if (!"0000".equals(querySkuDetailRspBO.getRespCode())) {
                            log.error("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u51fa\u9519\uff1a" + querySkuDetailRspBO.toString());
                        }
                    }
                    if (haveCh == 1 && StringUtils.isEmpty((CharSequence)ch)) {
                        for (Object skuComparedRspBO_ch2 : skuComparedRspBOs) {
                            Long _skuId = skuComparedRspBO_ch2.getCenterSkuId();
                            Integer _skuStockAmount = skuComparedRspBO_ch2.getSkuStockAmount();
                            _haveCh = skuComparedRspBO_ch2.getIsRequiredCode() == null ? 2 : skuComparedRspBO_ch2.getIsRequiredCode();
                            _ch = skuComparedRspBO_ch2.getSkuInstanceErpCode();
                            if (skuId.longValue() != _skuId.longValue() || _haveCh == 1 || !StringUtils.isNotEmpty((CharSequence)_ch)) continue;
                            ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdId, haveCh.toString(), _ch, null, zjm, null, ScmID, null, null, null, null, null, querySkuDetailRspBO.getBrandName(), null, querySkuDetailRspBO.getSkuName(), null, querySkuDetailRspBO.getSkuLongName(), null, color, null, nc, null, _skuStockAmount.toString(), "0", price, null, vipPrice, null, limitPrice, null, assessmentPrice, null, purchasePrice, null);
                            this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                        }
                        continue;
                    }
                    if (haveCh == 1 || !StringUtils.isNotEmpty((CharSequence)ch)) {
                        ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdId, haveCh.toString(), ch, null, zjm, null, ScmID, null, null, null, null, null, querySkuDetailRspBO.getBrandName(), null, querySkuDetailRspBO.getSkuName(), null, querySkuDetailRspBO.getSkuLongName(), null, color, null, nc, null, skuStockAmount.toString(), "0", price, null, vipPrice, null, limitPrice, null, assessmentPrice, null, purchasePrice, null);
                        this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                        continue;
                    }
                    boolean flag = false;
                    if (haveCh == 1 || !StringUtils.isNotEmpty((CharSequence)ch)) continue;
                    skuComparedRspBO_ch2 = skuComparedRspBOs.iterator();
                    while (skuComparedRspBO_ch2.hasNext()) {
                        SkuComparedRspBO skuComparedRspBO_ch3 = (SkuComparedRspBO)skuComparedRspBO_ch2.next();
                        Long _skuId = skuComparedRspBO_ch3.getCenterSkuId();
                        _haveCh = skuComparedRspBO_ch3.getIsRequiredCode() == null ? 2 : skuComparedRspBO_ch3.getIsRequiredCode();
                        _ch = skuComparedRspBO_ch3.getSkuInstanceErpCode();
                        if (skuId.longValue() != _skuId.longValue() || _haveCh != 1 || !StringUtils.isEmpty((CharSequence)_ch)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    ErpFileStockDataPO erpFileStockDataPO = this.setErpFileStockDataPO(mdId, "1", ch, null, zjm, null, ScmID, null, null, null, null, null, querySkuDetailRspBO.getBrandName(), null, querySkuDetailRspBO.getSkuName(), null, querySkuDetailRspBO.getSkuLongName(), null, color, null, nc, null, skuStockAmount.toString(), "0", price, null, vipPrice, null, limitPrice, null, assessmentPrice, null, purchasePrice, null);
                    this.erpKCInfoDao.insertFileStockData(erpFileStockDataPO);
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u6570\u636e\u65f6\u3001\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\uff01" + e.getMessage(), (Throwable)e);
                throw new BusinessException("9999", "\u5904\u7406\u6570\u636e\u65f6\u3001\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\uff01" + e.getMessage());
            }
        }
    }

    private ErpFileStockDataPO setErpFileStockDataPO(String mdId, String haveCh, String ch, String chErp, String zjm, String zjmErp, String scmId, String scmIdErp, String cgType, String cgTypeErp, String type, String typeErp, String pp, String ppErp, String name, String nameErp, String fullName, String fullNameErp, String color, String colorErp, String nc, String ncErp, String kcsl, String kcslErp, String jg1, String jg1Erp, String vipPrice, String vipPriceErp, String limitPrice, String limitPriceErp, String assessmentPrice, String assessmentPriceErp, String purchasePrice, String purchasePriceErp) {
        ErpFileStockDataPO fileStockDataPO = new ErpFileStockDataPO();
        fileStockDataPO.setMdId(mdId);
        fileStockDataPO.setHaveCh(haveCh);
        fileStockDataPO.setCh(ch);
        fileStockDataPO.setChErp(chErp);
        fileStockDataPO.setZjm(zjm);
        fileStockDataPO.setZjmErp(zjmErp);
        fileStockDataPO.setScmId(scmId);
        fileStockDataPO.setScmIdErp(scmIdErp);
        fileStockDataPO.setCgType(cgType);
        fileStockDataPO.setCgTypeErp(cgTypeErp);
        fileStockDataPO.setType(type);
        fileStockDataPO.setTypeErp(typeErp);
        fileStockDataPO.setPp(pp);
        fileStockDataPO.setPpErp(ppErp);
        fileStockDataPO.setName(name);
        fileStockDataPO.setNameErp(nameErp);
        fileStockDataPO.setFullName(fullName);
        fileStockDataPO.setFullNameErp(fullNameErp);
        fileStockDataPO.setColor(color);
        fileStockDataPO.setColorErp(colorErp);
        fileStockDataPO.setNc(nc);
        fileStockDataPO.setNcErp(ncErp);
        fileStockDataPO.setKcsl(kcsl);
        fileStockDataPO.setKcslErp(kcslErp);
        fileStockDataPO.setJg1(jg1);
        fileStockDataPO.setJg1Erp(jg1Erp);
        fileStockDataPO.setVipPrice(vipPrice);
        fileStockDataPO.setVipPriceErp(vipPriceErp);
        fileStockDataPO.setLimitPrice(limitPrice);
        fileStockDataPO.setLimitPriceErp(limitPriceErp);
        fileStockDataPO.setAssessmentPrice(assessmentPrice);
        fileStockDataPO.setAssessmentPriceErp(assessmentPriceErp);
        fileStockDataPO.setPurchasePrice(purchasePrice);
        fileStockDataPO.setPurchasePriceErp(purchasePriceErp);
        fileStockDataPO.setSyncDate(new Date());
        return fileStockDataPO;
    }

    private ResultData getSkuStockByShopCode(String shopCode, String zjm, String scmID, String isRequiredCode) {
        QuerySkuBO querySkuBO = new QuerySkuBO();
        querySkuBO.setShopCode(shopCode);
        querySkuBO.setZjm(zjm);
        querySkuBO.setScmID(scmID);
        querySkuBO.setIsRequiredCode(isRequiredCode);
        ResultData resultData = this.stockService.querySkuNumber(querySkuBO);
        return resultData;
    }

    public StockDataAbilityRspBo getStockData(StockDataAbilityReqBo stockDataAbilityReqBo) {
        StockDataAbilityRspBo stockDataAbilityRspBo = new StockDataAbilityRspBo();
        RspPage pageRsp = new RspPage();
        try {
            if (null == stockDataAbilityReqBo) {
                stockDataAbilityRspBo.setRespCode("9999");
                stockDataAbilityRspBo.setRespDesc("\u5165\u53c2\u4e3a\u7a7a\uff01");
                stockDataAbilityRspBo.setPageBO(pageRsp);
                return stockDataAbilityRspBo;
            }
            log.debug("\u5165\u53c2:" + stockDataAbilityReqBo.toString());
            if (StringUtils.isEmpty((CharSequence)stockDataAbilityReqBo.getDate())) {
                stockDataAbilityRspBo.setRespCode("9999");
                stockDataAbilityRspBo.setRespDesc("\u5165\u53c2Date\u4e3a\u7a7a\uff01");
                stockDataAbilityRspBo.setPageBO(pageRsp);
                return stockDataAbilityRspBo;
            }
            if (StringUtils.isEmpty((CharSequence)stockDataAbilityReqBo.getShopId())) {
                stockDataAbilityRspBo.setRespCode("9999");
                stockDataAbilityRspBo.setRespDesc("\u5165\u53c2ShopId\u4e3a\u7a7a\uff01");
                stockDataAbilityRspBo.setPageBO(pageRsp);
                return stockDataAbilityRspBo;
            }
            Page page = new Page(Integer.parseInt(stockDataAbilityReqBo.getCurrent()), Integer.parseInt(stockDataAbilityReqBo.getPageSize()));
            List<Object> stockDataPos = new ArrayList();
            ArrayList<StockDataAbilityBo> rspList = null;
            ShopBO shopBo = new ShopBO();
            shopBo.setShopId(Long.valueOf(Long.parseLong(stockDataAbilityReqBo.getShopId())));
            ResultData resultData = this.shopService.findShopByMdId(shopBo);
            if (null == resultData || !"0000".equals(resultData.getRespCode())) {
                stockDataAbilityRspBo.setRespCode("9999");
                stockDataAbilityRspBo.setRespDesc("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f\uff01");
                stockDataAbilityRspBo.setPageBO(pageRsp);
                return stockDataAbilityRspBo;
            }
            shopBo = (ShopBO)resultData.getRespData();
            stockDataPos = this.erpKCInfoDao.selectFileStockData((Page<StockDataPo>)page, stockDataAbilityReqBo.getDate(), shopBo.getShopMdId());
            if (CollectionUtils.isNotEmpty(stockDataPos)) {
                rspList = new ArrayList<StockDataAbilityBo>(stockDataPos.size());
                for (StockDataPo stockDataPo : stockDataPos) {
                    StockDataAbilityBo bo = new StockDataAbilityBo();
                    BeanUtils.copyProperties((Object)stockDataPo, (Object)bo);
                    bo.setMdName(shopBo.getShopMdName());
                    rspList.add(bo);
                }
            }
            stockDataAbilityRspBo.setRespCode("0000");
            stockDataAbilityRspBo.setRespDesc("\u67e5\u8be2\u5e93\u5b58\u5dee\u5f02\u6210\u529f\uff01");
            pageRsp.setRows(rspList);
            pageRsp.setTotal(page.getTotalPages());
            pageRsp.setRecordsTotal(page.getTotalCount());
            stockDataAbilityRspBo.setPageBO(pageRsp);
            return stockDataAbilityRspBo;
        }
        catch (Exception e) {
            e.printStackTrace();
            stockDataAbilityRspBo.setRespCode("9999");
            stockDataAbilityRspBo.setRespDesc("\u67e5\u8be2\u5e93\u5b58\u5dee\u5f02\u5931\u8d25\uff1a" + e.getMessage());
            stockDataAbilityRspBo.setPageBO(pageRsp);
            return stockDataAbilityRspBo;
        }
    }
}

