/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.thread;

import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.atom.StockChangeCallHisAtomService;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.ErpSpecialSalesReqBO;
import com.tydic.externalinter.constant.ExtExceptionConstant;
import com.tydic.externalinter.dao.po.StockChangeCallHistoryPO;
import com.tydic.externalinter.service.ErpStockService;
import com.tydic.externalinter.util.ExtJsonUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderDealThread
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(OrderDealThread.class);
    private StockChangeCallHisAtomService stockChangeCallHisAtomService;
    private ErpStockService erpStockService;
    private String specialState;
    private Long orderId;
    private String billId;

    public OrderDealThread(StockChangeCallHisAtomService stockChangeCallHisAtomService, ErpStockService erpStockService, String specialState, Long orderId, String billId) {
        this.stockChangeCallHisAtomService = stockChangeCallHisAtomService;
        this.erpStockService = erpStockService;
        this.specialState = specialState;
        this.orderId = orderId;
        this.billId = billId;
    }

    @Override
    public void run() {
        if (null == this.stockChangeCallHisAtomService || StringUtils.isBlank((CharSequence)this.specialState) || null == this.orderId || null == this.billId) {
            return;
        }
        StockChangeCallHistoryPO record = new StockChangeCallHistoryPO();
        record.setOrderId(String.valueOf(this.orderId));
        record.setOperType("1");
        StockChangeCallHistoryPO stockChangeCallHistoryPO = this.stockChangeCallHisAtomService.getAndSaveStockChangeCallHistory(record, false);
        if (null == stockChangeCallHistoryPO) {
            logger.error("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u6263\u51cf\u8bb0\u5f55");
            record.setRespCode("0010");
            record.setRespDesc((String)ExtExceptionConstant.codeMap.get("0010"));
            record.setCreateTime(new Date());
            this.stockChangeCallHisAtomService.saveStockChangeCallHistory(record);
            return;
        }
        if ("1".equals(this.specialState)) {
            this.modifyStockChangeCallHis(stockChangeCallHistoryPO);
            this.modifyReturnStockChangeCallHis();
        } else {
            this.returnAllOrder();
        }
    }

    private void returnAllOrder() {
        StockChangeCallHistoryPO record = new StockChangeCallHistoryPO();
        record.setOrderId(this.orderId.toString());
        record.setOperType("1");
        StockChangeCallHistoryPO historyPO = this.stockChangeCallHisAtomService.getAndSaveStockChangeCallHistory(record, false);
        if (null != historyPO.getParentOrderId()) {
            List<StockChangeCallHistoryPO> historyPOS = this.stockChangeCallHisAtomService.listChildOrders(historyPO.getParentOrderId(), "1");
            for (StockChangeCallHistoryPO his : historyPOS) {
                if ("04".equals(his.getTaskExecStatus()) || "05".equals(his.getTaskExecStatus())) continue;
                StockChangeCallHistoryPO backRecord = new StockChangeCallHistoryPO();
                backRecord.setOrderId(his.getOrderId());
                backRecord.setOperType("2");
                StockChangeCallHistoryPO backHis = this.stockChangeCallHisAtomService.getAndSaveStockChangeCallHistory(backRecord, false);
                String desc = "\u7279\u4ef7\u7533\u8bf7\u9000\u56de\uff0c\u7b49\u5f85\u4eba\u5de5\u5904\u7406";
                String code = "0017";
                String execStatus = "04";
                String status = "1";
                if (null != backHis) {
                    if (!backHis.getOrderId().equals(this.orderId.toString())) continue;
                    if ("0019".equals(backHis.getRespCode())) {
                        this.dealReturnOrder(backHis);
                    } else if ("0018".equals(backHis.getRespCode())) {
                        this.dealReturnOrder(backHis);
                        desc = "\u7279\u4ef7\u7533\u8bf7\u9000\u56de\uff0c\u5df2\u9000\u8d27\u8ba2\u5355\u4e0d\u5141\u8bb8\u4eba\u5de5\u5904\u7406";
                        code = "0000";
                        execStatus = "05";
                    }
                } else if ("0000".equals(his.getRespCode()) || "0013".equals(his.getRespCode())) {
                    ExternaLinterResultData stockRsp = this.callErpReturn(his.getInputParams());
                    if ("0019".equals(stockRsp.getRespCode())) {
                        desc = "\u6709\u9000\u8d27\u4efb\u52a1\u672a\u6267\u884c\uff0c\u6682\u4e0d\u5141\u8bb8\u4eba\u5de5\u5904\u7406";
                        code = "0019";
                        execStatus = "03";
                    } else if (!"0000".equals(stockRsp.getRespCode())) {
                        desc = "\u9000\u8d27\u5931\u8d25\uff0c\u6682\u4e0d\u5141\u8bb8\u4eba\u5de5\u5904\u7406";
                        code = "0009";
                        execStatus = "03";
                    }
                }
                his.setRecordStatus("0");
                this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(his);
                his.setRecordStatus(status);
                his.setTaskExecStatus(execStatus);
                his.setRespCode(code);
                his.setRespDesc(desc);
                his.setRecordId(null);
                his.setCreateTime(new Date());
                this.stockChangeCallHisAtomService.saveStockChangeCallHistory(his);
            }
        }
    }

    private ExternaLinterResultData callErpReturn(String inputParams) {
        ErpSpecialSalesReqBO erpSpecialSalesReqBO = ExtJsonUtils.jsonStringToObject(inputParams, ErpSpecialSalesReqBO.class);
        erpSpecialSalesReqBO.setCzType("2");
        erpSpecialSalesReqBO.setSpecialReturnFlag(Boolean.valueOf(true));
        return this.erpStockService.reductionERPStock(erpSpecialSalesReqBO);
    }

    private void modifyReturnStockChangeCallHis() {
        StockChangeCallHistoryPO record = new StockChangeCallHistoryPO();
        record.setOrderId(String.valueOf(this.orderId));
        record.setOperType("2");
        record.setTaskExecStatus("03");
        StockChangeCallHistoryPO stockChangeCallHistoryPO = this.stockChangeCallHisAtomService.getAndSaveStockChangeCallHistory(record, false);
        if (null == stockChangeCallHistoryPO) {
            return;
        }
        stockChangeCallHistoryPO.setTaskExecStatus("00");
        stockChangeCallHistoryPO.setReservedContent("\u6536\u5230\u7279\u4ef7\u7533\u8bf7\u7ed3\u679c\u901a\u77e5");
        this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(stockChangeCallHistoryPO);
        ErpSpecialSalesReqBO erpSpecialSalesReqBO = ExtJsonUtils.jsonStringToObject(stockChangeCallHistoryPO.getInputParams(), ErpSpecialSalesReqBO.class);
        ExternaLinterResultData stockRsp = this.callErpStockReduce(erpSpecialSalesReqBO);
        if ("0019".equals(stockChangeCallHistoryPO.getRespCode())) {
            String desc = "\u7279\u4ef7\u7533\u8bf7\u9000\u56de\uff0c\u7b49\u5f85\u4eba\u5de5\u5904\u7406";
            String code = "0017";
            String execStatus = "04";
            if (!"0000".equals(stockRsp.getRespCode())) {
                desc = "\u9000\u8d27\u5931\u8d25\uff0c\u6682\u4e0d\u5141\u8bb8\u4eba\u5de5\u5904\u7406";
                code = "0009";
                execStatus = "03";
            }
            StockChangeCallHistoryPO addRecord = new StockChangeCallHistoryPO();
            addRecord.setOrderId(String.valueOf(this.orderId));
            addRecord.setOperType("1");
            StockChangeCallHistoryPO addHis = this.stockChangeCallHisAtomService.getAndSaveStockChangeCallHistory(addRecord, false);
            addHis.setRecordStatus("0");
            this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(addHis);
            addHis.setRecordStatus("1");
            addHis.setRespCode(code);
            addHis.setRespDesc(desc);
            addHis.setTaskExecStatus(execStatus);
            addHis.setRecordId(null);
            addHis.setCreateTime(new Date());
            this.stockChangeCallHisAtomService.saveStockChangeCallHistory(addHis);
        }
    }

    private void dealReturnOrder(StockChangeCallHistoryPO stockChangeCallHistoryPO) {
        stockChangeCallHistoryPO.setRecordStatus("0");
        this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(stockChangeCallHistoryPO);
        stockChangeCallHistoryPO.setRespCode("0000");
        stockChangeCallHistoryPO.setRespDesc("\u7279\u4ef7\u7533\u8bf7\u9000\u56de\uff0c\u5f53\u524d\u5b50\u8ba2\u5355\u65e0\u9700\u9000\u8d27");
        stockChangeCallHistoryPO.setTaskExecStatus("02");
        stockChangeCallHistoryPO.setRecordStatus("1");
        stockChangeCallHistoryPO.setRecordId(null);
        stockChangeCallHistoryPO.setCreateTime(new Date());
        this.stockChangeCallHisAtomService.saveStockChangeCallHistory(stockChangeCallHistoryPO);
    }

    private void modifyStockChangeCallHis(StockChangeCallHistoryPO stockChangeCallHistoryPO) {
        ErpSpecialSalesReqBO erpSpecialSalesReqBO = ExtJsonUtils.jsonStringToObject(stockChangeCallHistoryPO.getInputParams(), ErpSpecialSalesReqBO.class);
        erpSpecialSalesReqBO.setSpecialAppliFlag(Boolean.valueOf(false));
        erpSpecialSalesReqBO.setSpecialBillId(this.billId);
        erpSpecialSalesReqBO.setIsSpecial("1");
        stockChangeCallHistoryPO.setInputParams(JSON.toJSONString((Object)erpSpecialSalesReqBO));
        stockChangeCallHistoryPO.setReservedContent("\u7279\u4ef7\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\uff0cbillId\uff1a" + this.billId);
        stockChangeCallHistoryPO.setTaskExecStatus("01");
        this.stockChangeCallHisAtomService.modifyStockChangeCallHistory(stockChangeCallHistoryPO);
        this.callErpStockReduce(erpSpecialSalesReqBO);
    }

    private ExternaLinterResultData callErpStockReduce(ErpSpecialSalesReqBO erpSpecialSalesReqBO) {
        ExternaLinterResultData rsp = new ExternaLinterResultData();
        try {
            rsp = this.erpStockService.reductionERPStock(erpSpecialSalesReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528ERP\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rsp;
    }
}

