/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.thread;

import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssUtil;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssOperateThread
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(OssOperateThread.class);
    private String filePath = null;
    private String erpInputParams = null;

    public OssOperateThread(String filePath, String erpInputParams) {
        this.filePath = filePath;
        this.erpInputParams = erpInputParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (StringUtils.isBlank((CharSequence)this.filePath) || StringUtils.isBlank((CharSequence)this.erpInputParams)) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.filePath);
            writer.write(this.erpInputParams);
            writer.flush();
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return;
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String endpoint = ExterPropertiesUtils.getProperty("oss.endpoint");
        String accessKeyId = ExterPropertiesUtils.getProperty("oss.accesskey");
        String accessKeySecret = ExterPropertiesUtils.getProperty("oss.accessKeySecret");
        String bucketName = ExterPropertiesUtils.getProperty("oss.bucketName");
        OssConfig ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName);
        OssUtil.uploadFile((File)new File(this.filePath), (OssConfig)ossConfig, (String)ExterPropertiesUtils.getProperty("oss.path.erprequest", "resfile/erp-request"));
    }
}

