/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.thread;

import com.tydic.externalinter.dao.CommPriceDataSyncDetailDao;
import com.tydic.externalinter.dao.po.CommPriceDataSyncDetailPO;
import com.xls.commodity.syncInfo.bo.PriceInfoRspBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceDetailSaveThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PriceDetailSaveThread.class);
    private UpdateSkuPriceRspBO updateSkuPriceRspBO;
    private CommPriceDataSyncDetailDao commPriceDataSyncDetailDao;
    private Long recordId;

    public PriceDetailSaveThread(CommPriceDataSyncDetailDao commPriceDataSyncDetailDao, UpdateSkuPriceRspBO updateSkuPriceRspBO, Long recordId) {
        this.commPriceDataSyncDetailDao = commPriceDataSyncDetailDao;
        this.updateSkuPriceRspBO = updateSkuPriceRspBO;
        this.recordId = recordId;
    }

    @Override
    public void run() {
        if (null == this.recordId || null == this.updateSkuPriceRspBO || null == this.commPriceDataSyncDetailDao || CollectionUtils.isEmpty((Collection)this.updateSkuPriceRspBO.getPriceInfos())) {
            return;
        }
        List priceInfoRspBOS = this.updateSkuPriceRspBO.getPriceInfos();
        ArrayList<CommPriceDataSyncDetailPO> records = new ArrayList<CommPriceDataSyncDetailPO>(priceInfoRspBOS.size());
        for (PriceInfoRspBO priceBO : priceInfoRspBOS) {
            records.add(this.toCommPriceDataSyncDetailPO(priceBO));
        }
        try {
            this.commPriceDataSyncDetailDao.insertByBatch(records);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u4ef7\u683c\u540c\u6b65\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public CommPriceDataSyncDetailPO toCommPriceDataSyncDetailPO(PriceInfoRspBO bo) {
        CommPriceDataSyncDetailPO po = new CommPriceDataSyncDetailPO();
        po.setAssessmentPrice(bo.getAssessmentPrice());
        po.setSourceAssessmentPrice(bo.getSourceAssessmentPrice());
        po.setLimitPrice(bo.getLimitPrice());
        po.setSourceLimitPrice(bo.getSourceLimitPrice());
        po.setPurchasePrice(bo.getPurchasePrice());
        po.setSourcePurchasePrice(bo.getSourcePurchasePrice());
        po.setSalePrice(bo.getJgl());
        po.setSourceSalePrice(bo.getSourceJgl());
        po.setVipPrice(bo.getVipPrice());
        po.setSourceVipPrice(bo.getSourceVipPrice());
        po.setRecordId(this.recordId);
        po.setCreateTime(new Date());
        po.setRespCode(bo.getCode());
        po.setRespDesc(bo.getMessage());
        po.setMnemCode(bo.getZjm());
        return po;
    }
}

