/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.tydic.externalinter.dao.ExterSysCallHistoryDao;
import com.tydic.externalinter.dao.po.ExterSysCallHistoryWithBLOBsPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExterSysCallHisUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExterSysCallHisUtils.class);
    private static ExterSysCallHistoryDao exterSysCallHistoryDao;

    public static void saveHisInfo(String url, String callType, String protoType, String input, String output, String status, Long time) {
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)callType) || StringUtils.isBlank((CharSequence)protoType)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            return;
        }
        ExterSysCallHistoryWithBLOBsPO reqPO = new ExterSysCallHistoryWithBLOBsPO();
        reqPO.setInputParams(input);
        reqPO.setOutputParams(output);
        reqPO.setCallType(callType);
        reqPO.setProtoType(protoType);
        reqPO.setReqUrl(url);
        reqPO.setRespStatus(status);
        reqPO.setCreateTime(new Date());
        reqPO.setRespTime(time);
        try {
            exterSysCallHistoryDao.insertSelective(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8c03\u7528\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Autowired
    public void setExterSysCallHistoryDao(ExterSysCallHistoryDao exterSysCallHistoryDao) {
        ExterSysCallHisUtils.exterSysCallHistoryDao = exterSysCallHistoryDao;
    }
}

