/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.ability.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.ability.bo.ERPSyncSalesPersonReqBO;
import com.tydic.externalinter.ability.bo.SalespersonInfo;
import com.tydic.externalinter.ability.service.ERPSyncSalesPersonService;
import com.tydic.externalinter.busi.bo.RspBaseBO;
import com.tydic.externalinter.dao.CommodityDataSyncHistoryDao;
import com.tydic.externalinter.dao.po.CommodityDataSyncHistoryPO;
import com.tydic.zhmd.bo.ErpParamBO;
import com.tydic.zhmd.bo.ErpParamReqBO;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.service.SalesPersonService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="eRPSyncSalesPersonService")
public class ERPSyncSalesPersonServiceImpl
implements ERPSyncSalesPersonService {
    public static final Logger logger = LoggerFactory.getLogger(ERPSyncSalesPersonServiceImpl.class);
    @Autowired
    private SalesPersonService salesPersonService;
    @Autowired
    private CommodityDataSyncHistoryDao commodityDataSyncHistoryDao;

    public RspBaseBO eRPSyncSalesPerson(ERPSyncSalesPersonReqBO eRPSyncSalesPersonReqBO) {
        logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u540c\u6b65\u4e1a\u52a1\u5458\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)eRPSyncSalesPersonReqBO));
        CommodityDataSyncHistoryPO commodityDataSyncHistoryPO = new CommodityDataSyncHistoryPO();
        String inputParams = JSON.toJSONString((Object)eRPSyncSalesPersonReqBO);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = df.format(new Date());
        commodityDataSyncHistoryPO.setSerialNum(date);
        commodityDataSyncHistoryPO.setChangeType("11");
        commodityDataSyncHistoryPO.setInputParams(inputParams);
        List salespersonInfos = eRPSyncSalesPersonReqBO.getSalespersonInfo();
        if (CollectionUtils.isEmpty((Collection)salespersonInfos)) {
            commodityDataSyncHistoryPO.setRespCode("9999");
            commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458\u5217\u8868\u4e3a\u7a7a");
            this.saveTaskInfo(commodityDataSyncHistoryPO);
            return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458\u5217\u8868\u4e3a\u7a7a");
        }
        ErpParamReqBO erpParamReqBO = new ErpParamReqBO();
        ArrayList<ErpParamBO> erpParamBOs = new ArrayList<ErpParamBO>();
        erpParamReqBO.setErpParamBO(erpParamBOs);
        for (SalespersonInfo salespersonInfo : salespersonInfos) {
            String czType = salespersonInfo.getCzType();
            if (StringUtils.isBlank((String)czType)) {
                commodityDataSyncHistoryPO.setRespCode("9999");
                commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
                this.saveTaskInfo(commodityDataSyncHistoryPO);
                return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            }
            String salespersonID = salespersonInfo.getSalespersonID();
            if (StringUtils.isBlank((String)salespersonID)) {
                commodityDataSyncHistoryPO.setRespCode("9999");
                commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458\u4e1a\u52a1\u5458ID\u4e3a\u7a7a");
                this.saveTaskInfo(commodityDataSyncHistoryPO);
                return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458\u4e1a\u52a1\u5458ID\u4e3a\u7a7a");
            }
            String salesperson = salespersonInfo.getSalesperson();
            if (StringUtils.isBlank((String)salesperson)) {
                commodityDataSyncHistoryPO.setRespCode("9999");
                commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458\u4e1a\u52a1\u5458\u540d\u79f0\u4e3a\u7a7a");
                this.saveTaskInfo(commodityDataSyncHistoryPO);
                return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458\u4e1a\u52a1\u5458\u540d\u79f0\u4e3a\u7a7a");
            }
            String mdID = salespersonInfo.getMdID();
            if (StringUtils.isBlank((String)mdID)) {
                commodityDataSyncHistoryPO.setRespCode("9999");
                commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458ERP\u95e8\u5e97ID\u4e3a\u7a7a");
                this.saveTaskInfo(commodityDataSyncHistoryPO);
                return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458ERP\u95e8\u5e97ID\u4e3a\u7a7a");
            }
            if (mdID.length() < 5) {
                commodityDataSyncHistoryPO.setRespCode("9999");
                commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458ERP\u95e8\u5e97ID\u957f\u5ea6\u4e0d\u8db35");
                this.saveTaskInfo(commodityDataSyncHistoryPO);
                return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458ERP\u95e8\u5e97ID\u957f\u5ea6\u4e0d\u8db35");
            }
            String status = salespersonInfo.getStatus();
            if (StringUtils.isBlank((String)status)) {
                commodityDataSyncHistoryPO.setRespCode("9999");
                commodityDataSyncHistoryPO.setRespDesc("ERP\u540c\u6b65\u4e1a\u52a1\u5458\u4e1a\u52a1\u5458\u72b6\u6001\u4e3a\u7a7a");
                this.saveTaskInfo(commodityDataSyncHistoryPO);
                return new RspBaseBO("9999", "ERP\u540c\u6b65\u4e1a\u52a1\u5458\u4e1a\u52a1\u5458\u72b6\u6001\u4e3a\u7a7a");
            }
            ErpParamBO erpParamBO = new ErpParamBO();
            erpParamBO.setCzType(czType);
            erpParamBO.setMdID(mdID);
            erpParamBO.setSalesperson(salesperson);
            erpParamBO.setSalespersonID(salespersonID);
            erpParamBO.setStatus(status.charAt(0));
            erpParamBOs.add(erpParamBO);
        }
        try {
            ResultData resultData = this.salesPersonService.insertSalesParson(erpParamReqBO);
            if (null == resultData || !"0000".equals(resultData.getRespCode())) {
                logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u540c\u6b65\u4e1a\u52a1\u5458\u670d\u52a1\u5931\u8d25\uff1a" + resultData.getRespDesc());
                throw new ResourceException("9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u540c\u6b65\u4e1a\u52a1\u5458\u670d\u52a1\u5931\u8d25");
            }
            logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u540c\u6b65\u4e1a\u52a1\u5458\u670d\u52a1\u51fa\u53c2=" + JSON.toJSONString((Object)resultData));
        }
        catch (Exception e) {
            e.printStackTrace();
            commodityDataSyncHistoryPO.setRespCode("9999");
            commodityDataSyncHistoryPO.setRespDesc("\u4e1a\u52a1\u5458\u4fe1\u606f\u540c\u6b65\u670d\u52a1\u5931\u8d25");
            this.saveTaskInfo(commodityDataSyncHistoryPO);
            return new RspBaseBO("9999", "\u4e1a\u52a1\u5458\u4fe1\u606f\u540c\u6b65\u670d\u52a1\u5931\u8d25");
        }
        commodityDataSyncHistoryPO.setRespCode("0000");
        commodityDataSyncHistoryPO.setRespDesc("\u6210\u529f");
        this.saveTaskInfo(commodityDataSyncHistoryPO);
        return new RspBaseBO("0000", "\u6210\u529f");
    }

    public void saveTaskInfo(CommodityDataSyncHistoryPO reqPO) {
        try {
            this.commodityDataSyncHistoryDao.insertSelective(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u65b0\u589e\u4efb\u52a1\u5931\u8d25");
        }
    }
}

