/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.ElectronicChannelAcceptanceMarketingPlanReqBO;
import com.tydic.externalinter.busi.bo.ElectronicChannelAcceptanceMarketingPlanRspBO;
import com.tydic.externalinter.busi.bo.ParamBO;
import com.tydic.externalinter.busi.bo.ResListItemBO;
import com.tydic.externalinter.busi.service.ElectronicChannelAcceptanceMarketingPlanService;
import com.tydic.externalinter.util.CommonAPIServiceUtils;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ElectronicChannelAcceptanceMarketingPlanServiceImpl
implements ElectronicChannelAcceptanceMarketingPlanService {
    private static Logger logger = LoggerFactory.getLogger(ElectronicChannelAcceptanceMarketingPlanServiceImpl.class);

    public RspBaseTBO<ElectronicChannelAcceptanceMarketingPlanRspBO> electronicChannelAcceptanceMarketingPlan(ElectronicChannelAcceptanceMarketingPlanReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        RspBaseTBO rsqBO = new RspBaseTBO();
        ElectronicChannelAcceptanceMarketingPlanRspBO rspResult = new ElectronicChannelAcceptanceMarketingPlanRspBO();
        rsqBO.setData((Object)rspResult);
        RspBaseBO checkRsp = this.checkParams(reqBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            return new RspBaseTBO(checkRsp.getRespCode(), checkRsp.getRespDesc());
        }
        logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u5165\u53c2\uff1a" + reqBO.toString());
        JSONObject jsonObject = JSONObject.fromObject((Object)reqBO);
        logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848json\u5165\u53c2\uff1a" + jsonObject.toString());
        try {
            externaLinterResultData = CommonAPIServiceUtils.commonUIPService(jsonObject.toString(), "FJBOSS005");
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            rsqBO.setRespCode("0009");
            rsqBO.setRespDesc("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            return rsqBO;
        }
        logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\uff1a" + externaLinterResultData.toString());
        if (externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\u4e0d\u6210\u529f");
            JSONObject body = (JSONObject)externaLinterResultData.getRespData();
            if (body.containsKey((Object)"operationOut")) {
                JSONObject operationOutBO = body.getJSONObject("operationOut");
                if (operationOutBO.containsKey((Object)"response") && operationOutBO.containsKey((Object)"content")) {
                    JSONObject operResponseBO = operationOutBO.getJSONObject("response");
                    JSONObject content = operationOutBO.getJSONObject("content");
                    if (operResponseBO.containsKey((Object)"respCode") && "0".equals(operResponseBO.getString("respCode")) && content.containsKey((Object)"response")) {
                        logger.debug("\u6210\u529f");
                        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                        JSONObject result = content.getJSONObject("response");
                        rspResult.setRespType(operResponseBO.getString("respType"));
                        rsqBO.setRespCode("0000");
                        rsqBO.setRespDesc("\u6210\u529f");
                        rspResult.setSaleId(result.getString("saleId"));
                        rspResult.setSaleIdName(result.getString("saleIdName"));
                        rspResult.setTransmitName(result.getString("transmitName"));
                        rspResult.setDescription(result.getString("description"));
                        try {
                            rspResult.setInureTime(format.parse(result.getString("inureTime")));
                            rspResult.setExpireTime(format.parse(result.getString("expireTime")));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        rspResult.setAuthResult(result.getInt("authResult"));
                        rspResult.setSmsContent(result.getString("smsContent"));
                        rspResult.setAcceptId(result.getInt("acceptId"));
                        rsqBO.setData((Object)rspResult);
                    } else {
                        rspResult.setRespType(operResponseBO.getString("respType"));
                        rsqBO.setRespCode("9999");
                        rsqBO.setRespDesc("\u5931\u8d25");
                        rsqBO.setData((Object)rspResult);
                    }
                } else {
                    logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\u6210\u529f-response\u4e0d\u5b58\u5728");
                    rsqBO.setRespCode("9999");
                    rsqBO.setRespDesc("\u5931\u8d25");
                }
            } else {
                logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\u6210\u529f-operationOut\u4e0d\u5b58\u5728");
                rsqBO.setRespCode("9999");
                rsqBO.setRespDesc("\u5931\u8d25");
            }
        } else {
            logger.debug("\u7535\u5b50\u6e20\u9053\u53d7\u7406\u8425\u9500\u65b9\u6848\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\u4e0d\u6210\u529f");
            rsqBO.setRespCode(externaLinterResultData.getRespCode());
            rsqBO.setRespDesc(externaLinterResultData.getRespDesc());
        }
        return rsqBO;
    }

    private RspBaseBO checkParams(ElectronicChannelAcceptanceMarketingPlanReqBO reqBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getMsisdn()) {
            rspBO.setRespDesc("\u5165\u53c2-getMsisdn-\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getChannelType()) {
            rspBO.setRespDesc("\u5165\u53c2-getChannelType-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSerial())) {
            rspBO.setRespDesc("\u5165\u53c2-getOrderSerial-\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getAllResListItem()) {
            rspBO.setRespDesc("\u5165\u53c2-getAllResListItem-\u4e3a\u7a7a");
            return rspBO;
        }
        for (ResListItemBO resListItemBO : reqBO.getAllResListItem()) {
            if (null == resListItemBO.getResItemId()) {
                rspBO.setRespDesc("\u5165\u53c2-getResItemId-\u4e3a\u7a7a");
                return rspBO;
            }
            if (null == resListItemBO.getAmount()) {
                rspBO.setRespDesc("\u5165\u53c2-getAmount-\u4e3a\u7a7a");
                return rspBO;
            }
            if (null != resListItemBO.getGoodsAmount()) continue;
            rspBO.setRespDesc("\u5165\u53c2-getGoodsAmount-\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getParamInfo()) {
            rspBO.setRespDesc("\u5165\u53c2-getParamInfo-\u4e3a\u7a7a");
            return rspBO;
        }
        for (ParamBO paramBO : reqBO.getParamInfo()) {
            if (StringUtils.isBlank((CharSequence)paramBO.getParamName())) {
                rspBO.setRespDesc("\u5165\u53c2-getParamName-\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.isBlank((CharSequence)paramBO.getParamValue())) continue;
            rspBO.setRespDesc("\u5165\u53c2-getParamValue-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSaleId()) && StringUtils.isEmpty((CharSequence)reqBO.getSaleOrderId()) && StringUtils.isEmpty((CharSequence)reqBO.getBassSaleId())) {
            rspBO.setRespDesc("\u8425\u9500\u9274\u6743\u6d41\u6c34\u3001\u8425\u9500\u6848\u7f16\u7801\u3001\u8425\u9500\u6863\u6b21\u7f16\u7801\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

