/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.StockChangeCallHisAtomService;
import com.tydic.externalinter.busi.bo.ErpSepcialSaleDetail;
import com.tydic.externalinter.busi.bo.ErpSpecialSalesReqBO;
import com.tydic.externalinter.busi.service.ErpStockSyncPretreatService;
import com.tydic.externalinter.dao.ErpActiveInfoDao;
import com.tydic.externalinter.dao.po.StockChangeCallHistoryPO;
import com.tydic.externalinter.service.ErpStockService;
import com.tydic.externalinter.util.ExtJsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpStockSyncPretreatServiceImpl
implements ErpStockSyncPretreatService {
    private static Logger logger = LoggerFactory.getLogger(ErpStockSyncPretreatServiceImpl.class);
    @Autowired
    private ErpActiveInfoDao erpActiveInfoDao;
    @Autowired
    private ErpStockService erpStockService;
    @Autowired
    private StockChangeCallHisAtomService stockChangeErrorHisAtomService;
    private Integer count;

    public void execute(ErpSpecialSalesReqBO reqBO) {
        this.count = 0;
        StockChangeCallHistoryPO record = this.toStockChangeCallHistoryPO(reqBO);
        StockChangeCallHistoryPO callHistoryPO = this.stockChangeErrorHisAtomService.getAndSaveStockChangeCallHistory(record, true);
        String desc = "";
        switch (reqBO.getCzType()) {
            case "1": {
                Object codes;
                callHistoryPO.setRecordStatus("2");
                this.modifyHis(callHistoryPO);
                String orderActCode = null;
                ArrayList<String> activityCodes = new ArrayList<String>();
                activityCodes.add(orderActCode);
                if (StringUtils.isNotBlank((CharSequence)reqBO.getHdID()) && CollectionUtils.isNotEmpty((Collection)(codes = this.listActivityCodes(activityCodes)))) {
                    orderActCode = (String)codes.get(0);
                }
                for (ErpSepcialSaleDetail detail : reqBO.getSpInfo()) {
                    this.callSpecialSales(detail, orderActCode, reqBO);
                }
                desc = "\u51fa\u5e93\u62c6\u5355\u9884\u5904\u7406\u5b8c\u6210";
                break;
            }
            case "2": {
                List<StockChangeCallHistoryPO> childs = null;
                callHistoryPO.setRespCode("0006");
                try {
                    childs = this.stockChangeErrorHisAtomService.listChildOrders(reqBO.getOrderID(), "1");
                }
                catch (ResourceException e) {
                    logger.error(e.getMessage());
                    callHistoryPO.setRespDesc(e.getMessage());
                    this.modifyHis(callHistoryPO);
                    break;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5b50\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                    callHistoryPO.setRespDesc("\u67e5\u8be2\u5b50\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                    this.modifyHis(callHistoryPO);
                    break;
                }
                if (CollectionUtils.isNotEmpty(childs)) {
                    callHistoryPO.setRecordStatus("2");
                    for (StockChangeCallHistoryPO po : childs) {
                        StockChangeCallHistoryPO backStockRecord = new StockChangeCallHistoryPO();
                        backStockRecord.setOrderId(String.valueOf(po.getOrderId()));
                        backStockRecord.setOperType("2");
                        StockChangeCallHistoryPO backStockRsp = this.stockChangeErrorHisAtomService.getAndSaveStockChangeCallHistory(backStockRecord, false);
                        if (null == backStockRsp) {
                            ErpSpecialSalesReqBO erpSpecialSalesReqBO = ExtJsonUtils.jsonStringToObject(po.getInputParams(), ErpSpecialSalesReqBO.class);
                            erpSpecialSalesReqBO.setCzType("2");
                            erpSpecialSalesReqBO.setPayId(reqBO.getPayId());
                            if (StringUtils.isBlank((CharSequence)erpSpecialSalesReqBO.getPayId())) {
                                logger.debug("\u6ca1\u6709\u9000\u6b3e\u6d41\u6c34ID");
                                if (StringUtils.isNotBlank((CharSequence)erpSpecialSalesReqBO.getPayMode()) && ("1".equals(erpSpecialSalesReqBO.getPayMode()) || "2".equals(erpSpecialSalesReqBO.getPayMode()))) {
                                    logger.debug("\u5fae\u4fe1\u652f\u4ed8\u6216\u8005\u652f\u4ed8\u5b9d\u652f\u4ed8");
                                    erpSpecialSalesReqBO.setPayId("0000");
                                }
                            }
                            if ("01".equals(((ErpSepcialSaleDetail)erpSpecialSalesReqBO.getSpInfo().get(0)).getSpecialApply())) {
                                erpSpecialSalesReqBO.setSpecialAppliFlag(Boolean.valueOf(true));
                            }
                            this.erpStockService.reductionERPStock(erpSpecialSalesReqBO);
                            continue;
                        }
                        if ("0000".equals(backStockRsp.getRespCode())) {
                            po.setRecordStatus("0");
                            this.stockChangeErrorHisAtomService.modifyStockChangeCallHistory(po);
                            po.setRecordStatus("1");
                            po.setRespCode("0000");
                            po.setRespDesc("\u5df2\u9000\u8d27\u8ba2\u5355\u4e0d\u5141\u8bb8\u4eba\u5de5\u5904\u7406");
                            po.setTaskExecStatus("05");
                            po.setRecordId(null);
                            po.setCreateTime(new Date());
                            this.stockChangeErrorHisAtomService.saveStockChangeCallHistory(po);
                            continue;
                        }
                        if (!"0019".equals(backStockRsp.getRespCode())) continue;
                        backStockRsp.setRecordStatus("0");
                        this.stockChangeErrorHisAtomService.modifyStockChangeCallHistory(backStockRsp);
                        backStockRsp.setRecordStatus("1");
                        backStockRsp.setRespCode("0018");
                        backStockRsp.setRespDesc("\u6682\u505c\u9000\u8d27");
                        backStockRsp.setRecordId(null);
                        backStockRsp.setCreateTime(new Date());
                        this.stockChangeErrorHisAtomService.saveStockChangeCallHistory(backStockRsp);
                    }
                } else {
                    this.erpStockService.reductionERPStock(reqBO);
                }
                desc = "\u9000\u8d27\u9884\u5904\u7406\u5b8c\u6210";
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u9884\u5904\u7406\u6210\u529f");
        }
        callHistoryPO.setRespCode("0000");
        callHistoryPO.setRespDesc(desc);
        callHistoryPO.setTaskExecStatus("02");
        this.modifyHis(callHistoryPO);
    }

    private void modifyHis(StockChangeCallHistoryPO callHistoryPO) {
        try {
            this.stockChangeErrorHisAtomService.modifyStockChangeCallHistory(callHistoryPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void callSpecialSales(ErpSepcialSaleDetail detail, String orderActCode, ErpSpecialSalesReqBO reqBO) {
        boolean isNoneAct;
        List<String> instanceActCodes;
        ErpSpecialSalesReqBO erpSyncReqBO = this.toErpSyncReqBO(reqBO);
        String instanceActCode = null;
        boolean hasCommAct = CollectionUtils.isNotEmpty((Collection)detail.getActivityCodes());
        if (hasCommAct && detail.getActivityCodes().size() == 1 && CollectionUtils.isNotEmpty(instanceActCodes = this.listActivityCodes(detail.getActivityCodes()))) {
            instanceActCode = instanceActCodes.get(0);
        }
        boolean isChangePrice = !detail.getDealPrice().equals(detail.getSalePrice()) && (hasCommAct || StringUtils.isNotBlank((CharSequence)orderActCode));
        boolean isMixAct = hasCommAct && StringUtils.isNotBlank((CharSequence)orderActCode);
        boolean isMultipleAct = hasCommAct && detail.getActivityCodes().size() > 1;
        boolean isOwnAct = hasCommAct && StringUtils.isBlank((CharSequence)instanceActCode);
        boolean bl = isNoneAct = !hasCommAct && StringUtils.isBlank((CharSequence)orderActCode);
        if (isChangePrice || isMixAct || isMultipleAct || isOwnAct || isNoneAct) {
            erpSyncReqBO.setHdID("LSLJ");
        } else {
            erpSyncReqBO.setHdID(StringUtils.isNotBlank((CharSequence)instanceActCode) ? instanceActCode : orderActCode);
        }
        if ("01".equals(detail.getSpecialApply())) {
            erpSyncReqBO.setSpecialAppliFlag(Boolean.valueOf(true));
        }
        for (int i = 0; i < Integer.parseInt(detail.getNumber()); ++i) {
            ArrayList<ErpSepcialSaleDetail> details = new ArrayList<ErpSepcialSaleDetail>(1);
            ErpSepcialSaleDetail erpSepcialSaleDetail = this.toErpSepcialSaleDetail(detail);
            if (CollectionUtils.isNotEmpty((Collection)detail.getChInfo())) {
                ArrayList chInfos = new ArrayList(1);
                chInfos.add(detail.getChInfo().get(i));
                erpSepcialSaleDetail.setChInfo(chInfos);
            }
            details.add(erpSepcialSaleDetail);
            erpSyncReqBO.setSpInfo(details);
            erpSyncReqBO.setParentOrderId(reqBO.getOrderID());
            this.count = this.count + 1;
            erpSyncReqBO.setOrderID(reqBO.getOrderID() + ErpStockSyncPretreatServiceImpl.toFixdLengthString(this.count.intValue(), 4));
            erpSyncReqBO.setDdje(detail.getSjjg());
            erpSyncReqBO.setSaleNumber("1");
            this.erpStockService.reductionERPStock(erpSyncReqBO);
        }
    }

    public static String toFixdLengthString(long num, int fixdlenth) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixdlenth - strNum.length() < 0) {
            return String.valueOf(num);
        }
        sb.append(ErpStockSyncPretreatServiceImpl.generateZeroString(fixdlenth - strNum.length()));
        sb.append(strNum);
        return sb.toString();
    }

    public static String generateZeroString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    private StockChangeCallHistoryPO toStockChangeCallHistoryPO(ErpSpecialSalesReqBO reqBO) {
        StockChangeCallHistoryPO po = new StockChangeCallHistoryPO();
        po.setInputParams(JSON.toJSONString((Object)reqBO));
        po.setOperNum(Integer.parseInt(reqBO.getSaleNumber()));
        po.setOperType(reqBO.getCzType());
        po.setOrderId(reqBO.getOrderID());
        po.setOrderTime(reqBO.getOrderTime());
        po.setTaskExecStatus("00");
        return po;
    }

    private ErpSepcialSaleDetail toErpSepcialSaleDetail(ErpSepcialSaleDetail detail) {
        ErpSepcialSaleDetail rsp = new ErpSepcialSaleDetail();
        rsp.setDealPrice(detail.getDealPrice());
        rsp.setSalePrice(detail.getSalePrice());
        rsp.setAgreementPrice(detail.getAgreementPrice());
        rsp.setZjm(detail.getZjm());
        rsp.setSjjg(detail.getSjjg());
        rsp.setScmID(detail.getScmID());
        rsp.setNumber("1");
        rsp.setMdID(detail.getMdID());
        rsp.setActWaresSign(detail.getActWaresSign());
        return rsp;
    }

    private List<String> listActivityCodes(List<String> activityCodes) {
        List<String> rspList = null;
        try {
            rspList = this.erpActiveInfoDao.selectByActivityCodes(activityCodes);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rspList;
    }

    private ErpSpecialSalesReqBO toErpSyncReqBO(ErpSpecialSalesReqBO reqBO) {
        ErpSpecialSalesReqBO rsp = new ErpSpecialSalesReqBO();
        try {
            BeanUtils.copyProperties((Object)reqBO, (Object)rsp);
        }
        catch (BeansException e) {
            logger.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0016", "\u53c2\u6570\u8f6c\u6362\u5931\u8d25");
        }
        rsp.setSpInfo(null);
        return rsp;
    }

    public static void main(String[] args) {
        System.out.println(ErpStockSyncPretreatServiceImpl.toFixdLengthString(3L, 3));
    }
}

