/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.base.common.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.externalinter.ability.bo.SaleOrderSync2ScmRetryReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemImeiBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemImeiReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordReqBO;
import com.tydic.externalinter.ability.bo.ScmProvWarehouseInfoBO;
import com.tydic.externalinter.ability.bo.ScmProvWarehouseInfoReqBO;
import com.tydic.externalinter.atom.ExtQryStoreInfoListService;
import com.tydic.externalinter.atom.ScmOrderSyncItemAtomService;
import com.tydic.externalinter.atom.ScmOrderSyncItemImeiAtomService;
import com.tydic.externalinter.atom.ScmOrderSyncRecordAtomService;
import com.tydic.externalinter.atom.ScmProvWarehouseAtomService;
import com.tydic.externalinter.atom.bo.ExtOrganisationBO;
import com.tydic.externalinter.atom.bo.ExtQryStoreInfoReqBO;
import com.tydic.externalinter.atom.bo.ExtQryStoreInfoRspBO;
import com.tydic.externalinter.busi.bo.SaleOrderSync2ScmReqBO;
import com.tydic.externalinter.busi.bo.ScmExterReqBO;
import com.tydic.externalinter.busi.service.ExtSaleOrderSync2ScmBusiService;
import com.tydic.externalinter.busi.service.ScmExterRspBO;
import com.tydic.externalinter.busi.service.ScmexterCommService;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTCodeDeatilBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTCodeTableBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTHeadDeatilBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTHeadTableBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTItemDeatilBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTItemTableBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTRmsgDeatilBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncReqTRmsgTableBO;
import com.tydic.externalinter.scm.ws.bo.ExtSaleOrderSyncRspBO;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.ordunr.ability.UnrScmOrdCodeAbilityService;
import com.tydic.ordunr.ability.bo.QryListXlsToSCMOrderAbilityReqBO;
import com.tydic.ordunr.ability.bo.XlsToSCMOrderDetailBO;
import com.tydic.ordunr.ability.bo.XlsToSCMOrderRspBO;
import com.tydic.ordunr.base.bo.OrdUnrRspListBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExtSaleOrderSync2ScmBusiServiceImpl
implements ExtSaleOrderSync2ScmBusiService {
    private static Logger logger = LoggerFactory.getLogger(ExtSaleOrderSync2ScmBusiServiceImpl.class);
    @Autowired
    private ExtQryStoreInfoListService extQryStoreInfoListService;
    @Autowired
    private ScmProvWarehouseAtomService scmProvWarehouseAtomService;
    @Autowired
    private ScmOrderSyncRecordAtomService ScmOrderSyncRecordAtomService;
    @Autowired
    private ScmOrderSyncItemAtomService scmOrderSyncItemAtomService;
    @Autowired
    private ScmOrderSyncItemImeiAtomService scmOrderSyncItemImeiAtomService;
    @Autowired
    private ScmexterCommService scmexterCommService;
    @Resource
    private UnrScmOrdCodeAbilityService unrScmOrdCodeAbilityService;
    @Resource(name="exterQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public void saleOrderSync2Scm(SaleOrderSync2ScmReqBO reqBO) {
        logger.debug("\u65b0\u96f6\u552e\u9500\u552e\u8ba2\u5355\u540c\u6b65SCM\u670d\u52a1\u5f00\u59cb");
        try {
            String VDATU = null;
            VDATU = null != reqBO && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getvDATU()) ? reqBO.getvDATU() : DateUtils.dateToStr((Date)DateUtils.getDate((Date)new Date(), (Integer)-1), (String)"yyyyMMdd");
            OrdUnrRspListBO rsp = null;
            try {
                QryListXlsToSCMOrderAbilityReqBO ordReqBO = new QryListXlsToSCMOrderAbilityReqBO();
                ordReqBO.setBusinessDate(VDATU);
                logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u5165\u53c2\uff1a" + ordReqBO.toString());
                rsp = this.unrScmOrdCodeAbilityService.qryListXlsToSCMOrder(ordReqBO);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
                throw new BusinessException("9999", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u5f02\u5e38");
            }
            if (rsp == null || CollectionUtils.isEmpty((Collection)rsp.getRows())) {
                logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return;
            }
            logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c:" + rsp.toString());
            HashSet<String> provinceCodes = new HashSet<String>();
            HashSet<String> cityCodes = new HashSet<String>();
            HashSet<String> shopCodes = new HashSet<String>();
            ArrayList<ScmOrderSyncRecordBO> scmOrderBOs = new ArrayList<ScmOrderSyncRecordBO>();
            ArrayList<ScmOrderSyncItemBO> scmOrderDetailBOs = new ArrayList<ScmOrderSyncItemBO>();
            ArrayList<ScmOrderSyncItemImeiBO> scmOrderImeiDetailBOs = new ArrayList<ScmOrderSyncItemImeiBO>();
            ArrayList<ScmOrderSyncItemBO> returnOrderDetailBOs = new ArrayList<ScmOrderSyncItemBO>();
            this.xls2scmOrder(rsp.getRows(), scmOrderBOs, scmOrderDetailBOs, scmOrderImeiDetailBOs, returnOrderDetailBOs, provinceCodes, cityCodes, shopCodes, VDATU);
            this.saveReturnScmOrderInfo(scmOrderDetailBOs, returnOrderDetailBOs);
            HashMap<String, String> provinceCodeMap = new HashMap<String, String>();
            HashMap<String, String> factoryCodeMap = new HashMap<String, String>();
            HashMap<String, String> warehouseCodeMap = new HashMap<String, String>();
            HashMap<String, String> cityCodeMap = new HashMap<String, String>();
            HashMap<String, String> shopCodeMap = new HashMap<String, String>();
            this.getScmCode(provinceCodeMap, factoryCodeMap, warehouseCodeMap, cityCodeMap, provinceCodes, cityCodes);
            this.getShopCodeMap(shopCodeMap, shopCodes);
            this.saveScmOrderInfo(scmOrderBOs, scmOrderDetailBOs, scmOrderImeiDetailBOs, provinceCodeMap, factoryCodeMap, warehouseCodeMap, cityCodeMap, shopCodeMap);
            this.syncSCM(scmOrderBOs, scmOrderDetailBOs, scmOrderImeiDetailBOs);
            logger.debug("XLS\u540c\u6b65SCM\u8ba2\u5355\u8bb0\u5f55\u6210\u529f\uff01\uff01");
        }
        catch (Exception e) {
            logger.debug("\u65b0\u96f6\u552e\u9500\u552e\u8ba2\u5355\u540c\u6b65SCM\u670d\u52a1\u5f02\u5e38" + e.getMessage());
        }
    }

    public RspBaseBO saleOrderSync2ScmRetry(SaleOrderSync2ScmRetryReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getBvbelns())) {
            logger.debug("scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u8ba2\u5355\u7f16\u7801\u96c6\u4e3a\u7a7a");
            return new RspBaseBO("0001", "scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u8ba2\u5355\u7f16\u7801\u96c6\u4e3a\u7a7a");
        }
        ScmOrderSyncRecordReqBO record = new ScmOrderSyncRecordReqBO();
        ScmOrderSyncItemReqBO detialRecord = new ScmOrderSyncItemReqBO();
        ScmOrderSyncItemImeiReqBO meiRecord = new ScmOrderSyncItemImeiReqBO();
        this.restSaleOrderSync2ScmRetryParam(record, detialRecord, meiRecord, reqBO);
        List<ScmOrderSyncRecordBO> scmOrderBOs = null;
        List<ScmOrderSyncItemBO> scmOrderDetailBOs = null;
        List<ScmOrderSyncItemImeiBO> scmOrderImeiDetailBOs = null;
        try {
            scmOrderBOs = this.ScmOrderSyncRecordAtomService.selectScmOrderSyncRecordByList(record);
            scmOrderDetailBOs = this.scmOrderSyncItemAtomService.selectScmOrderSyncItemByList(detialRecord);
            scmOrderImeiDetailBOs = this.scmOrderSyncItemImeiAtomService.selectScmOrderSyncItemImeiByList(meiRecord);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91cd\u8bd5scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("9999", "\u67e5\u8be2\u91cd\u8bd5scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(scmOrderBOs) || CollectionUtils.isEmpty(scmOrderDetailBOs)) {
            logger.debug("\u6839\u636escm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u8ba2\u5355\u7f16\u7801\u96c6\u67e5\u8be2\u8bb0\u5f55\u7ed3\u679c\u4e3a\u7a7a");
            return new RspBaseBO("0000", "\u6839\u636escm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u8ba2\u5355\u7f16\u7801\u96c6\u67e5\u8be2\u8bb0\u5f55\u7ed3\u679c\u4e3a\u7a7a");
        }
        for (ScmOrderSyncRecordBO scmOrderSyncRecordBO : scmOrderBOs) {
            if ("04".equals(scmOrderSyncRecordBO.getOrderStatus())) continue;
            String status = this.qryEscapeAtomService.getCodeTitle("SYN_SCM_ORDER_RECORD_STATUS", scmOrderSyncRecordBO.getOrderStatus());
            String statusStr = StringUtils.isNotBlank((String)status) ? status : "\u672a\u5b9a\u4e49";
            logger.error("\u5f53\u524dscm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u72b6\u6001\u3010" + statusStr + "\u3011\u4e0d\u80fd\u91cd\u65b0\u53d1\u9001");
            return new RspBaseBO("0010", "\u5f53\u524dscm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u72b6\u6001\u3010" + statusStr + "\u3011\u4e0d\u80fd\u91cd\u65b0\u53d1\u9001");
        }
        try {
            if (scmOrderImeiDetailBOs == null) {
                scmOrderImeiDetailBOs = new ArrayList<ScmOrderSyncItemImeiBO>();
            }
            this.syncSCM(scmOrderBOs, scmOrderDetailBOs, scmOrderImeiDetailBOs);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528\u540c\u6b65SCM\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("9999", "\u8c03\u7528\u540c\u6b65SCM\u5f02\u5e38");
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void restSaleOrderSync2ScmRetryParam(ScmOrderSyncRecordReqBO record, ScmOrderSyncItemReqBO detialRecord, ScmOrderSyncItemImeiReqBO meiRecord, SaleOrderSync2ScmRetryReqBO reqBO) {
        ArrayList<ScmOrderSyncRecordBO> item = new ArrayList<ScmOrderSyncRecordBO>(reqBO.getBvbelns().size());
        ArrayList<ScmOrderSyncItemBO> itemDetail = new ArrayList<ScmOrderSyncItemBO>(reqBO.getBvbelns().size());
        ArrayList<ScmOrderSyncItemImeiBO> itemMei = new ArrayList<ScmOrderSyncItemImeiBO>(reqBO.getBvbelns().size());
        for (String bvbeln : reqBO.getBvbelns()) {
            ScmOrderSyncRecordBO bo = new ScmOrderSyncRecordBO();
            bo.setBvbeln(bvbeln);
            item.add(bo);
            ScmOrderSyncItemBO detailbo = new ScmOrderSyncItemBO();
            detailbo.setBvbeln(bvbeln);
            itemDetail.add(detailbo);
            ScmOrderSyncItemImeiBO meibo = new ScmOrderSyncItemImeiBO();
            meibo.setBvbeln(bvbeln);
            itemMei.add(meibo);
        }
        record.setItem(item);
        detialRecord.setItem(itemDetail);
        meiRecord.setItem(itemMei);
    }

    private void xls2scmOrder(List<XlsToSCMOrderRspBO> rspList, List<ScmOrderSyncRecordBO> scmOrderBOs, List<ScmOrderSyncItemBO> scmOrderDetailBOs, List<ScmOrderSyncItemImeiBO> scmOrderImeiDetailBOs, List<ScmOrderSyncItemBO> returnOrderDetailBOs, Set<String> provinceCodes, Set<String> cityCodes, Set<String> shopCodes, String vDATU) {
        for (XlsToSCMOrderRspBO orderBO : rspList) {
            ScmOrderSyncRecordBO scmOrderBO = new ScmOrderSyncRecordBO();
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderBO.getProvinceCode())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u7701\u4efd\u7f16\u7801\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u7701\u4efd\u7f16\u7801\u3011\u4e3a\u7a7a");
            }
            scmOrderBO.setProvinceCode(orderBO.getProvinceCode());
            provinceCodes.add(orderBO.getProvinceCode());
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderBO.getCityCode())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u5730\u5e02\u7f16\u7801\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u5730\u5e02\u7f16\u7801\u3011\u4e3a\u7a7a");
            }
            scmOrderBO.setCityCode(orderBO.getCityCode());
            cityCodes.add(orderBO.getCityCode());
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderBO.getShopCode())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u95e8\u5e97\u7f16\u7801\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u95e8\u5e97\u7f16\u7801\u3011\u4e3a\u7a7a");
            }
            scmOrderBO.setShopCode(orderBO.getShopCode());
            shopCodes.add(orderBO.getShopCode());
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderBO.getScmOrderCode())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7f16\u7801\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7f16\u7801\u3011\u4e3a\u7a7a");
            }
            scmOrderBO.setBvbeln(orderBO.getScmOrderCode());
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderBO.getOrderType())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7c7b\u578b\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7c7b\u578b\u3011\u4e3a\u7a7a");
            }
            scmOrderBO.setAuart(orderBO.getOrderType());
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderBO.getShipType())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u88c5\u8fd0\u7c7b\u578b\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u88c5\u8fd0\u7c7b\u578b\u3011\u4e3a\u7a7a");
            }
            scmOrderBO.setVsart(orderBO.getShipType());
            if ("Z005".equals(orderBO.getOrderType())) {
                scmOrderBO.setAugru("101");
            } else if ("Z004".equals(orderBO.getOrderType())) {
                scmOrderBO.setAugru("F01");
            } else if (!"Z001".equals(orderBO.getOrderType())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7c7b\u578b\u5f02\u5e38\u3011\uff1a" + orderBO.getOrderType());
                throw new BusinessException("0008", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7c7b\u578b\u5f02\u5e38\u3011" + orderBO.getOrderType());
            }
            scmOrderBO.setVdatu(vDATU);
            scmOrderBO.setVtweg("20");
            scmOrderBO.setSpart("10");
            scmOrderBO.setVsbed("01");
            scmOrderBO.setZyul5("ZC");
            scmOrderBOs.add(scmOrderBO);
            if (CollectionUtils.isEmpty((Collection)orderBO.getXlsToSCMOrderDetailBOList())) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u8be6\u60c5\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u8be6\u60c5\u3011\u4e3a\u7a7a");
            }
            for (XlsToSCMOrderDetailBO orderDetailBO : orderBO.getXlsToSCMOrderDetailBOList()) {
                ScmOrderSyncItemBO scmOrderDetailBO = new ScmOrderSyncItemBO();
                scmOrderDetailBO.setProvinceCode(orderBO.getProvinceCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderDetailBO.getScmOrderCode())) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7f16\u7801\u3011\u4e3a\u7a7a");
                    throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u7f16\u7801\u3011\u4e3a\u7a7a");
                }
                scmOrderDetailBO.setBvbeln(orderDetailBO.getScmOrderCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderDetailBO.getScmOrderItemCode())) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u884c\u53f7\u3011\u4e3a\u7a7a");
                    throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u8ba2\u5355\u884c\u53f7\u3011\u4e3a\u7a7a");
                }
                scmOrderDetailBO.setBposnr(orderDetailBO.getScmOrderItemCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderDetailBO.getMaterialId())) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u7269\u6599\u7f16\u7801\u3011\u4e3a\u7a7a");
                    throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u7269\u6599\u7f16\u7801\u3011\u4e3a\u7a7a");
                }
                scmOrderDetailBO.setMatnr(orderDetailBO.getMaterialId());
                if (null == orderDetailBO.getSaleNum()) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9500\u552e\u6570\u91cf\u3011\u4e3a\u7a7a");
                    throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9500\u552e\u6570\u91cf\u3011\u4e3a\u7a7a");
                }
                scmOrderDetailBO.setKwmeng(Long.valueOf(orderDetailBO.getSaleNum().longValue()));
                if (null == orderDetailBO.getSalePrice()) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9500\u552e\u5355\u4ef7\u3011\u4e3a\u7a7a");
                    throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9500\u552e\u6570\u91cf\u3011\u4e3a\u7a7a");
                }
                scmOrderDetailBO.setSoamt(TkCalculatorUtils.transferY((long)orderDetailBO.getSalePrice().longValue()));
                if ("Z005".equals(orderBO.getOrderType())) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderDetailBO.getScmOrderCodeBefore())) {
                        logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9000\u8d27\u5355\u8ba2\u5355\u7f16\u7801\u3011\u4e3a\u7a7a");
                        throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9000\u8d27\u5355\u8ba2\u5355\u7f16\u7801\u3011\u4e3a\u7a7a");
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderDetailBO.getScmOrderItemCodeBefore())) {
                        logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9000\u8d27\u5355\u8ba2\u5355\u884c\u53f7\u3011\u4e3a\u7a7a");
                        throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u9000\u8d27\u5355\u8ba2\u5355\u884c\u53f7\u3011\u4e3a\u7a7a");
                    }
                    scmOrderDetailBO.setXlsZyul2(orderDetailBO.getScmOrderCodeBefore() + orderDetailBO.getScmOrderItemCodeBefore());
                    ScmOrderSyncItemBO returnOrderDetailBO = new ScmOrderSyncItemBO();
                    returnOrderDetailBO.setBvbeln(orderDetailBO.getScmOrderCodeBefore());
                    returnOrderDetailBO.setBposnr(orderDetailBO.getScmOrderItemCodeBefore());
                    returnOrderDetailBOs.add(returnOrderDetailBO);
                }
                scmOrderDetailBOs.add(scmOrderDetailBO);
                if (CollectionUtils.isEmpty((Collection)orderDetailBO.getIMEI())) continue;
                for (String imei : orderDetailBO.getIMEI()) {
                    ScmOrderSyncItemImeiBO orderImeiDetailBO = new ScmOrderSyncItemImeiBO();
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)imei)) {
                        logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u4e32\u7801\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u4e32\u7801LIST\u5185\u542b\u6709\u4e32\u7801\u4fe1\u606f\u3011\u4e3a\u7a7a");
                        throw new BusinessException("0001", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9700\u540c\u6b65SCM\u9500\u552e\u8ba2\u5355\u3010\u8be6\u60c5\u3011\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\u3010\u4e32\u7801LIST\u5185\u542b\u6709\u4e32\u7801\u4fe1\u606f\u3011\u4e3a\u7a7a");
                    }
                    orderImeiDetailBO.setBvbeln(orderDetailBO.getScmOrderCode());
                    orderImeiDetailBO.setBposnr(orderDetailBO.getScmOrderItemCode());
                    orderImeiDetailBO.setMatnr(orderDetailBO.getMaterialId());
                    orderImeiDetailBO.setCmnum(imei);
                    if ("Z005".equals(orderBO.getOrderType())) {
                        orderImeiDetailBO.setOptType("2");
                    } else {
                        orderImeiDetailBO.setOptType("1");
                    }
                    scmOrderImeiDetailBOs.add(orderImeiDetailBO);
                }
            }
        }
    }

    private void getShopCodeMap(Map<String, String> shopCodeMap, Set<String> shopCodes) {
        ExtQryStoreInfoReqBO qryStoreInfoReqBO = new ExtQryStoreInfoReqBO();
        ArrayList<String> storeIds = new ArrayList<String>(shopCodes);
        qryStoreInfoReqBO.setStoreIds(storeIds);
        ExtQryStoreInfoRspBO qryStoreInfoRspBO = this.extQryStoreInfoListService.qryStoreInfoList(qryStoreInfoReqBO);
        if ("0000".equals(qryStoreInfoRspBO.getRespCode()) && !CollectionUtils.isEmpty(qryStoreInfoRspBO.getStoreInfoList())) {
            for (ExtOrganisationBO organisationBO : qryStoreInfoRspBO.getStoreInfoList()) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)organisationBO.getScmCustomerNo())) continue;
                shopCodeMap.put(organisationBO.getField2(), organisationBO.getScmCustomerNo());
            }
        } else {
            logger.debug("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5931\u8d25");
            throw new BusinessException("0003", "\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void getScmCode(Map<String, String> provinceCodeMap, Map<String, String> factoryCodeMap, Map<String, String> warehouseCodeMap, Map<String, String> cityCodeMap, Set<String> provinceCodes, Set<String> cityCodes) {
        ScmProvWarehouseInfoBO scmProvWarehouseInfoBO2;
        ScmProvWarehouseInfoReqBO record = new ScmProvWarehouseInfoReqBO();
        ArrayList<ScmProvWarehouseInfoBO> scmProvWarehouseInfoBOS = new ArrayList<ScmProvWarehouseInfoBO>();
        for (String provinceCode : provinceCodes) {
            scmProvWarehouseInfoBO2 = new ScmProvWarehouseInfoBO();
            scmProvWarehouseInfoBO2.setXlsProvinceCode(provinceCode);
            scmProvWarehouseInfoBOS.add(scmProvWarehouseInfoBO2);
        }
        for (String cityCode : cityCodes) {
            scmProvWarehouseInfoBO2 = new ScmProvWarehouseInfoBO();
            scmProvWarehouseInfoBO2.setXlsCityCode(cityCode);
            scmProvWarehouseInfoBOS.add(scmProvWarehouseInfoBO2);
        }
        record.setScmProvWarehouseInfoBOS(scmProvWarehouseInfoBOS);
        List<ScmProvWarehouseInfoBO> provWareHouseRspBO = this.scmProvWarehouseAtomService.selectscmProvWarehouseByList(record);
        if (null == provWareHouseRspBO || CollectionUtils.isEmpty(provWareHouseRspBO)) {
            logger.error("\u67e5\u8be2scm\u7701\u4ed3\u5e93\u5b58\u8868\u5f02\u5e38");
            throw new BusinessException("9999", "\u67e5\u8be2scm\u7701\u4ed3\u5e93\u5b58\u8868\u5f02\u5e38");
        }
        for (ScmProvWarehouseInfoBO scmProvWarehouseInfoBO2 : provWareHouseRspBO) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scmProvWarehouseInfoBO2.getXlsProvinceCode())) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scmProvWarehouseInfoBO2.getScmProvinceCode()) && !provinceCodeMap.containsKey(scmProvWarehouseInfoBO2.getXlsProvinceCode())) {
                    provinceCodeMap.put(scmProvWarehouseInfoBO2.getXlsProvinceCode(), scmProvWarehouseInfoBO2.getScmProvinceCode());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scmProvWarehouseInfoBO2.getScmFactoryNo()) && !factoryCodeMap.containsKey(scmProvWarehouseInfoBO2.getXlsProvinceCode())) {
                    factoryCodeMap.put(scmProvWarehouseInfoBO2.getXlsProvinceCode(), scmProvWarehouseInfoBO2.getScmFactoryNo());
                }
                if ("2".equals(scmProvWarehouseInfoBO2.getScmWarehouseType()) && "1".equals(scmProvWarehouseInfoBO2.getIsProWarehouse()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scmProvWarehouseInfoBO2.getScmWarehouseNo()) && !warehouseCodeMap.containsKey(scmProvWarehouseInfoBO2.getXlsProvinceCode())) {
                    warehouseCodeMap.put(scmProvWarehouseInfoBO2.getXlsProvinceCode(), scmProvWarehouseInfoBO2.getScmWarehouseNo());
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scmProvWarehouseInfoBO2.getXlsCityCode()) || cityCodeMap.containsKey(scmProvWarehouseInfoBO2.getXlsCityCode())) continue;
            cityCodeMap.put(scmProvWarehouseInfoBO2.getXlsCityCode(), scmProvWarehouseInfoBO2.getScmCityCode());
        }
    }

    private void saveScmOrderInfo(List<ScmOrderSyncRecordBO> scmOrderBOs, List<ScmOrderSyncItemBO> scmOrderDetailBOs, List<ScmOrderSyncItemImeiBO> scmOrderImeiDetailBOs, Map<String, String> provinceCodeMap, Map<String, String> factoryCodeMap, Map<String, String> warehouseCodeMap, Map<String, String> cityCodeMap, Map<String, String> shopCodeMap) {
        try {
            HashSet<String> exBvbeln = new HashSet<String>();
            Iterator<ScmOrderSyncRecordBO> iterator = scmOrderBOs.iterator();
            while (iterator.hasNext()) {
                ScmOrderSyncRecordBO scmOrderSyncRecordBO = iterator.next();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)shopCodeMap.get(scmOrderSyncRecordBO.getShopCode()))) {
                    exBvbeln.add(scmOrderSyncRecordBO.getBvbeln());
                    iterator.remove();
                    continue;
                }
                scmOrderSyncRecordBO.setVkorg(provinceCodeMap.get(scmOrderSyncRecordBO.getProvinceCode()));
                scmOrderSyncRecordBO.setVkbur(cityCodeMap.get(scmOrderSyncRecordBO.getCityCode()));
                scmOrderSyncRecordBO.setKunnr(shopCodeMap.get(scmOrderSyncRecordBO.getShopCode()));
                scmOrderSyncRecordBO.setKunwe(shopCodeMap.get(scmOrderSyncRecordBO.getShopCode()));
                scmOrderSyncRecordBO.setOrderStatus("00");
            }
            Iterator<ScmOrderSyncItemBO> iterator2 = scmOrderDetailBOs.iterator();
            while (iterator2.hasNext()) {
                ScmOrderSyncItemBO scmOrderSyncItemBO = iterator2.next();
                if (exBvbeln.contains(scmOrderSyncItemBO.getBvbeln())) {
                    iterator2.remove();
                    continue;
                }
                scmOrderSyncItemBO.setWerks(factoryCodeMap.get(scmOrderSyncItemBO.getProvinceCode()));
                scmOrderSyncItemBO.setLgort(warehouseCodeMap.get(scmOrderSyncItemBO.getProvinceCode()));
                scmOrderSyncItemBO.setItemStatus("00");
            }
            Iterator<ScmOrderSyncItemImeiBO> iterator3 = scmOrderImeiDetailBOs.iterator();
            while (iterator3.hasNext()) {
                ScmOrderSyncItemImeiBO scmOrderSyncItemImeiBO = iterator3.next();
                if (!exBvbeln.contains(scmOrderSyncItemImeiBO.getBvbeln())) continue;
                iterator3.remove();
            }
            if (CollectionUtils.isEmpty(scmOrderBOs) || CollectionUtils.isEmpty(scmOrderDetailBOs)) {
                logger.debug("\u9700\u8981\u540c\u6b65\u7684\u8ba2\u5355\u4e3a\u7a7a");
                return;
            }
            this.ScmOrderSyncRecordAtomService.saveRecordBatch(scmOrderBOs);
            this.scmOrderSyncItemAtomService.saveRecordBatch(scmOrderDetailBOs);
            if (!CollectionUtils.isEmpty(scmOrderImeiDetailBOs)) {
                this.scmOrderSyncItemImeiAtomService.saveRecordBatch(scmOrderImeiDetailBOs);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u540c\u6b65SCM\u8ba2\u5355\u8bb0\u5f55\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("9999", "\u65b0\u589e\u540c\u6b65SCM\u8ba2\u5355\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    private void syncSCM(List<ScmOrderSyncRecordBO> scmOrderBOs, List<ScmOrderSyncItemBO> scmOrderDetailBOs, List<ScmOrderSyncItemImeiBO> scmOrderImiDetailBOs) {
        if (CollectionUtils.isEmpty(scmOrderBOs) || CollectionUtils.isEmpty(scmOrderDetailBOs)) {
            logger.debug("\u9700\u8981\u540c\u6b65\u7684\u8ba2\u5355\u4e3a\u7a7a");
            return;
        }
        ExtSaleOrderSyncReqTHeadTableBO extSaleOrderSyncReqTHeadTableBO = new ExtSaleOrderSyncReqTHeadTableBO();
        ArrayList<ExtSaleOrderSyncReqTHeadDeatilBO> item1 = new ArrayList<ExtSaleOrderSyncReqTHeadDeatilBO>();
        for (ScmOrderSyncRecordBO scmOrderSyncRecordBO : scmOrderBOs) {
            ExtSaleOrderSyncReqTHeadDeatilBO extSaleOrderSyncReqTHeadDeatilBO = new ExtSaleOrderSyncReqTHeadDeatilBO();
            BeanUtils.copyProperties((Object)scmOrderSyncRecordBO, (Object)extSaleOrderSyncReqTHeadDeatilBO);
            item1.add(extSaleOrderSyncReqTHeadDeatilBO);
        }
        extSaleOrderSyncReqTHeadTableBO.setItem(item1);
        ExtSaleOrderSyncReqTItemTableBO extSaleOrderSyncReqTItemTableBO = new ExtSaleOrderSyncReqTItemTableBO();
        ArrayList<Object> item2 = new ArrayList<Object>();
        for (ScmOrderSyncItemBO scmOrderSyncItemBO : scmOrderDetailBOs) {
            ExtSaleOrderSyncReqTItemDeatilBO extSaleOrderSyncReqTItemDeatilBO = new ExtSaleOrderSyncReqTItemDeatilBO();
            BeanUtils.copyProperties((Object)scmOrderSyncItemBO, (Object)extSaleOrderSyncReqTItemDeatilBO);
            extSaleOrderSyncReqTItemDeatilBO.setKwmeng(scmOrderSyncItemBO.getKwmeng().toString());
            extSaleOrderSyncReqTItemDeatilBO.setSoamt(scmOrderSyncItemBO.getSoamt().toString());
            item2.add(extSaleOrderSyncReqTItemDeatilBO);
        }
        extSaleOrderSyncReqTItemTableBO.setItem(item2);
        ExtSaleOrderSyncReqTCodeTableBO extSaleOrderSyncReqTCodeTableBO = new ExtSaleOrderSyncReqTCodeTableBO();
        ArrayList<ExtSaleOrderSyncReqTCodeDeatilBO> item3 = new ArrayList<ExtSaleOrderSyncReqTCodeDeatilBO>();
        for (ScmOrderSyncItemImeiBO scmOrderSyncItemBO : scmOrderImiDetailBOs) {
            ExtSaleOrderSyncReqTCodeDeatilBO extSaleOrderSyncReqTItemDeatilBO = new ExtSaleOrderSyncReqTCodeDeatilBO();
            BeanUtils.copyProperties((Object)scmOrderSyncItemBO, (Object)extSaleOrderSyncReqTItemDeatilBO);
            item3.add(extSaleOrderSyncReqTItemDeatilBO);
        }
        extSaleOrderSyncReqTCodeTableBO.setItem(item3);
        ExtSaleOrderSyncReqBO extSaleOrderSyncReqBO = new ExtSaleOrderSyncReqBO();
        extSaleOrderSyncReqBO.settHead(extSaleOrderSyncReqTHeadTableBO);
        extSaleOrderSyncReqBO.settItem(extSaleOrderSyncReqTItemTableBO);
        extSaleOrderSyncReqBO.settCode(extSaleOrderSyncReqTCodeTableBO);
        extSaleOrderSyncReqBO.settRmsg(new ExtSaleOrderSyncReqTRmsgTableBO());
        ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
        scmExterReqBO.setReqData((Object)extSaleOrderSyncReqBO);
        scmExterReqBO.setWsdl(ExterPropertiesUtils.getProperty("scm.syncOrder.url"));
        ScmExterRspBO scmExterRspBO = null;
        try {
            scmExterRspBO = this.scmexterCommService.scmExter(scmExterReqBO);
        }
        catch (Exception e) {
            logger.error("XLS\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (scmExterRspBO != null) {
            logger.debug("xls\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\u63a5\u53e3\u51fa\u53c2", (Object)scmExterRspBO.toString());
        } else {
            logger.debug("xls\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\u63a5\u53e3\u51fa\u53c2\u4e3anull");
        }
        if (scmExterRspBO == null || !"0000".equals(scmExterRspBO.getRespCode())) {
            String orderRemark = "XLS\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\u63a5\u53e3\u5f02\u5e38";
            String order_status = "01";
            this.updateOrderRecord(null, orderRemark, order_status, scmOrderBOs, scmOrderDetailBOs);
            return;
        }
        JSONObject rspJson = JSONObject.parseObject((String)scmExterRspBO.getScmRspData().toString());
        if (!rspJson.containsKey((Object)"Zsdif022Response")) {
            logger.error("xls\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif111Response");
            String orderRemark = "\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif111Response";
            String order_status = "01";
            this.updateOrderRecord(null, orderRemark, order_status, scmOrderBOs, scmOrderDetailBOs);
            return;
        }
        ExtSaleOrderSyncRspBO extSaleOrderSyncRspBO = null;
        try {
            extSaleOrderSyncRspBO = (ExtSaleOrderSyncRspBO)JSONObject.parseObject((String)rspJson.getString("Zsdif022Response"), ExtSaleOrderSyncRspBO.class);
        }
        catch (Exception e) {
            logger.error("xls\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\uff0c\u51fa\u53c2\u8f6c\u6362\u5f02\u5e38");
            String orderRemark = "\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u51fa\u53c2\u8f6c\u6362\u5f02\u5e38";
            String order_status = "01";
            this.updateOrderRecord(null, orderRemark, order_status, scmOrderBOs, scmOrderDetailBOs);
            return;
        }
        if (null == extSaleOrderSyncRspBO || null == extSaleOrderSyncRspBO.gettRmsg() || CollectionUtils.isEmpty((Collection)extSaleOrderSyncRspBO.gettRmsg().getItem())) {
            logger.error("xls\u8ba2\u5355\u540c\u6b65SCM\u63a5\u53e3\u8c03\u7528SCM\u540c\u6b65\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230TRmsg");
            String orderRemark = "\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230TRmsg";
            String order_status = "01";
            this.updateOrderRecord(null, orderRemark, order_status, scmOrderBOs, scmOrderDetailBOs);
            return;
        }
        this.updateOrderRecord(extSaleOrderSyncRspBO.gettRmsg().getItem(), null, null, scmOrderBOs, scmOrderDetailBOs);
    }

    private void updateOrderRecord(List<ExtSaleOrderSyncReqTRmsgDeatilBO> tRmgs, String orderRemark, String order_status, List<ScmOrderSyncRecordBO> scmOrderBOs, List<ScmOrderSyncItemBO> scmOrderDetailBOs) {
        if (null == tRmgs) {
            for (ScmOrderSyncRecordBO scmOrderSyncRecordBO : scmOrderBOs) {
                scmOrderSyncRecordBO.setOrderStatus(order_status);
                scmOrderSyncRecordBO.setRemark(orderRemark);
            }
            for (ScmOrderSyncItemBO scmOrderSyncItemBO : scmOrderDetailBOs) {
                scmOrderSyncItemBO.setItemStatus(order_status);
                scmOrderSyncItemBO.setRemark(orderRemark);
            }
        } else {
            ExtSaleOrderSyncReqTRmsgDeatilBO tRmg;
            HashMap<String, ExtSaleOrderSyncReqTRmsgDeatilBO> tRmgMap = new HashMap<String, ExtSaleOrderSyncReqTRmsgDeatilBO>(tRmgs.size());
            HashMap<String, String> orderStatusMap = new HashMap<String, String>(tRmgMap.size());
            for (ExtSaleOrderSyncReqTRmsgDeatilBO tRmg2 : tRmgs) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tRmg2.getBposnr())) {
                    tRmgMap.put(tRmg2.getBvbeln() + tRmg2.getBposnr(), tRmg2);
                    if (!"1".equals(tRmg2.getZsfcg())) continue;
                    orderStatusMap.put(tRmg2.getBvbeln(), "04");
                    continue;
                }
                tRmgMap.put(tRmg2.getBvbeln(), tRmg2);
            }
            for (ScmOrderSyncRecordBO scmOrderSyncRecordBO : scmOrderBOs) {
                if (tRmgMap.containsKey(scmOrderSyncRecordBO.getBvbeln())) {
                    tRmg = (ExtSaleOrderSyncReqTRmsgDeatilBO)tRmgMap.get(scmOrderSyncRecordBO.getBvbeln());
                    scmOrderSyncRecordBO.setVbeln(tRmg.getVbeln());
                    scmOrderSyncRecordBO.setZjcjg(tRmg.getZjcjg());
                    if ("0".equals(tRmg.getZsfcg())) {
                        scmOrderSyncRecordBO.setRemark("\u540c\u6b65\u6210\u529f");
                        if (orderStatusMap.containsKey(scmOrderSyncRecordBO.getBvbeln())) {
                            scmOrderSyncRecordBO.setRemark("\u8ba2\u5355\u6210\u529f\uff0c\u4f46\u8fd4\u56de\u884c\u9879\u76ee\u5b58\u5728\u5931\u8d25");
                            scmOrderSyncRecordBO.setOrderStatus("04");
                            continue;
                        }
                        scmOrderSyncRecordBO.setOrderStatus("02");
                        continue;
                    }
                    scmOrderSyncRecordBO.setRemark("\u540c\u6b65\u5931\u8d25");
                    scmOrderSyncRecordBO.setOrderStatus("04");
                    continue;
                }
                scmOrderSyncRecordBO.setOrderStatus("04");
                scmOrderSyncRecordBO.setRemark("\u672a\u83b7\u53d6\u5230\u8be5\u8ba2\u5355\u8fd4\u56de\u4fe1\u606f");
            }
            for (ScmOrderSyncItemBO scmOrderSyncItemBO : scmOrderDetailBOs) {
                if (tRmgMap.containsKey(scmOrderSyncItemBO.getBvbeln() + scmOrderSyncItemBO.getBposnr())) {
                    tRmg = (ExtSaleOrderSyncReqTRmsgDeatilBO)tRmgMap.get(scmOrderSyncItemBO.getBvbeln() + scmOrderSyncItemBO.getBposnr());
                    scmOrderSyncItemBO.setVbeln(tRmg.getVbeln());
                    scmOrderSyncItemBO.setPosnr(tRmg.getPosnr());
                    scmOrderSyncItemBO.setZjcjg(tRmg.getZjcjg());
                    scmOrderSyncItemBO.setZsfcg(tRmg.getZsfcg());
                    if ("0".equals(tRmg.getZsfcg())) {
                        scmOrderSyncItemBO.setItemStatus("02");
                        scmOrderSyncItemBO.setRemark("\u6210\u529f");
                        continue;
                    }
                    scmOrderSyncItemBO.setItemStatus("03");
                    scmOrderSyncItemBO.setRemark("\u5931\u8d25");
                    continue;
                }
                scmOrderSyncItemBO.setItemStatus("03");
                scmOrderSyncItemBO.setRemark("\u672a\u83b7\u53d6\u5230\u8be5\u8ba2\u5355\u884c\u53f7\u8fd4\u56de\u4fe1\u606f");
            }
        }
        try {
            this.ScmOrderSyncRecordAtomService.modifyBatchByKey(scmOrderBOs);
            this.scmOrderSyncItemAtomService.modifyBatchByKey(scmOrderDetailBOs);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u540c\u6b65SCM\u8ba2\u5355\u8bb0\u5f55\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("9999", "\u66f4\u65b0\u540c\u6b65SCM\u8ba2\u5355\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    private void saveReturnScmOrderInfo(List<ScmOrderSyncItemBO> scmOrderDetailBOs, List<ScmOrderSyncItemBO> returnOrderDetailBOs) {
        if (CollectionUtils.isEmpty(returnOrderDetailBOs)) {
            return;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ScmOrderSyncItemReqBO reqBOs = new ScmOrderSyncItemReqBO();
        reqBOs.setItem(returnOrderDetailBOs);
        List<ScmOrderSyncItemBO> rspBOs = null;
        rspBOs = this.scmOrderSyncItemAtomService.selectScmOrderSyncItemByList(reqBOs);
        if (rspBOs == null || CollectionUtils.isEmpty(rspBOs)) {
            logger.debug("\u672a\u67e5\u8be2\u5230\u539f\u9000\u8d27\u8ba2\u5355\u4fe1\u606f");
            return;
        }
        for (ScmOrderSyncItemBO scmOrderSyncItemBO : rspBOs) {
            if (!"02".equals(scmOrderSyncItemBO.getItemStatus())) continue;
            returnMap.put(scmOrderSyncItemBO.getBvbeln() + scmOrderSyncItemBO.getBposnr(), scmOrderSyncItemBO.getVbeln() + "-" + scmOrderSyncItemBO.getPosnr());
        }
        for (ScmOrderSyncItemBO scmOrderSyncItemBO : scmOrderDetailBOs) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scmOrderSyncItemBO.getXlsZyul2()) || !returnMap.containsKey(scmOrderSyncItemBO.getXlsZyul2())) continue;
            scmOrderSyncItemBO.setZyul2((String)returnMap.get(scmOrderSyncItemBO.getXlsZyul2()));
        }
    }

    public static void main(String[] args) {
        ScmOrderSyncRecordReqBO scmOrderSyncRecordReqBO = new ScmOrderSyncRecordReqBO();
        ArrayList<ScmOrderSyncRecordBO> item = new ArrayList<ScmOrderSyncRecordBO>();
        ScmOrderSyncRecordBO scmOrderSyncRecordBO = new ScmOrderSyncRecordBO();
        scmOrderSyncRecordBO.setKunwe("AAAAAAAA");
        scmOrderSyncRecordBO.setKunnr("AAAAAAAAA");
        ScmOrderSyncRecordBO scmOrderSyncRecordBO2 = new ScmOrderSyncRecordBO();
        scmOrderSyncRecordBO2.setKunwe("BBBBBBBB");
        scmOrderSyncRecordBO2.setKunnr("BBBBBBBBB");
        item.add(scmOrderSyncRecordBO);
        item.add(scmOrderSyncRecordBO2);
        Iterator iterator = item.iterator();
        while (iterator.hasNext()) {
            ScmOrderSyncRecordBO scmOrderSyncRecordBO1 = (ScmOrderSyncRecordBO)iterator.next();
            if (scmOrderSyncRecordBO1.getKunnr().equals("AAAAAAAAA")) {
                iterator.remove();
                continue;
            }
            System.out.println("111");
            scmOrderSyncRecordBO1.setZjcjg("11122121212122121");
        }
        System.out.println(((Object)item).toString());
    }
}

