/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.SpecialSalesAtomService;
import com.tydic.externalinter.atom.StockChangeCallHisAtomService;
import com.tydic.externalinter.atom.bo.SpecialSalesRecordBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.ChInfo;
import com.tydic.externalinter.busi.bo.ErpSepcialSaleDetail;
import com.tydic.externalinter.busi.bo.ErpSpecialSalesReqBO;
import com.tydic.externalinter.busi.bo.RspBaseBO;
import com.tydic.externalinter.busi.bo.SpecialSalesCheckReqBO;
import com.tydic.externalinter.busi.bo.SpecialSalesRecordRspBO;
import com.tydic.externalinter.busi.service.SpecialSalesService;
import com.tydic.externalinter.constant.ExtExceptionConstant;
import com.tydic.externalinter.constant.SpecialSalesConstants;
import com.tydic.externalinter.dao.po.SpecialSalesRecordDetailsPO;
import com.tydic.externalinter.service.ErpStockService;
import com.tydic.externalinter.thread.OrderDealThread;
import com.tydic.externalinter.util.ErpServiceUtils;
import com.tydic.externalinter.util.ExtCreateThreadUtils;
import com.tydic.externalinter.util.ExtForwardUtils;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.zhmd.service.ShopService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpecialSalesServiceImpl
implements SpecialSalesService {
    private static Logger logger = LoggerFactory.getLogger(SpecialSalesServiceImpl.class);
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private SpecialSalesAtomService specialSalesAtomService;
    @Autowired
    private StockChangeCallHisAtomService stockChangeCallHisAtomService;
    @Autowired
    private ErpStockService erpStockService;
    @Resource
    private ShopService shopService;
    public static final String PRICE_PATTERN = "^[0-9]+([.]{1}[0-9]+){0,1}$";
    private static final String NUMBER_PATTERN = "^(-)?([1-9]\\d*|[0]{1,1})$";

    public SpecialSalesRecordRspBO addSpecialSales(ErpSpecialSalesReqBO reqBO) {
        SpecialSalesRecordRspBO validRet;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7279\u4ef7\u7533\u8bf7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        }
        if (null != (validRet = this.vaildAddArg(reqBO))) {
            logger.error(validRet.getRespDesc());
            return validRet;
        }
        SpecialSalesRecordRspBO rspBO = new SpecialSalesRecordRspBO();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55");
            }
            SpecialSalesRecordBO atomBO = null;
            List<SpecialSalesRecordDetailsPO> detailsPOS = null;
            try {
                atomBO = this.addBOToAtomBO(reqBO);
                detailsPOS = this.toSpecialSalesRecordDetails(reqBO);
            }
            catch (Exception e) {
                logger.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u53c2\u6570\u8f6c\u6362\u5931\u8d25");
                return rspBO;
            }
            try {
                atomBO = this.specialSalesAtomService.getSpecialSalesRecord(atomBO, detailsPOS);
            }
            catch (ResourceException e) {
                rspBO.setRespCode(e.getMsgCode());
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u7533\u8bf7\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u83b7\u53d6\u7533\u8bf7\u5355\u5f02\u5e38");
                return rspBO;
            }
            if (null == atomBO || null == atomBO.getSalesRecordId()) {
                logger.error("\u83b7\u53d6\u7533\u8bf7\u5355\u5931\u8d25");
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u83b7\u53d6\u7533\u8bf7\u5355\u5931\u8d25");
                return rspBO;
            }
            reqBO.setOrderTime(format.format(atomBO.getCreateTime()));
            reqBO.setOrderID(atomBO.getReqBillId());
            ExternaLinterResultData resultData = ErpServiceUtils.erpService(JSON.toJSONString((Object)reqBO), "SPECIAL_SALES_URL");
            if (logger.isDebugEnabled()) {
                logger.debug("\u8c03\u7528ERP\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)resultData));
            }
            if (!resultData.getSuccess().booleanValue()) {
                rspBO.setRespCode(resultData.getRespCode());
                rspBO.setRespDesc(resultData.getRespDesc());
                return rspBO;
            }
            JSONObject data = JSONObject.fromObject((Object)resultData.getRespData());
            if (!data.containsKey((Object)"billId")) {
                logger.error("ERP\u8fd4\u56de\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("ERP\u8fd4\u56de\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
                return rspBO;
            }
            atomBO.setUpdateTime(new Date());
            atomBO.setBillId(data.getString("billId"));
            atomBO.setState("0");
            this.specialSalesAtomService.updateSpecialSalesRecord(atomBO);
            rspBO = this.atomBOToBO(atomBO);
        }
        catch (ResourceException e) {
            logger.error("\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u7279\u4ef7\u7533\u8bf7\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u63d2\u5165\u7279\u4ef7\u7533\u8bf7\u5f02\u5e38");
            return rspBO;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u7279\u4ef7\u7533\u8bf7\u6210\u529f");
        }
        rspBO.setRespDesc("\u7b49\u5f85\u7279\u4ef7\u7533\u8bf7\u5ba1\u6838\u901a\u77e5\uff0c\u6682\u505c\u6267\u884c");
        rspBO.setRespCode("0013");
        return rspBO;
    }

    private List<SpecialSalesRecordDetailsPO> toSpecialSalesRecordDetails(ErpSpecialSalesReqBO reqBO) {
        ArrayList<SpecialSalesRecordDetailsPO> list = null;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSpInfo())) {
            list = new ArrayList<SpecialSalesRecordDetailsPO>(reqBO.getSpInfo().size());
            for (ErpSepcialSaleDetail detail : reqBO.getSpInfo()) {
                SpecialSalesRecordDetailsPO po = new SpecialSalesRecordDetailsPO();
                po.setAgreementPrice(detail.getAgreementPrice());
                po.setDealPrice(detail.getDealPrice());
                po.setMaterialCode(detail.getScmID());
                po.setMnemCode(detail.getZjm());
                po.setSalePrice(detail.getSalePrice());
                po.setSalesNum(Integer.valueOf(detail.getNumber()));
                String serialNums = null;
                if (CollectionUtils.isNotEmpty((Collection)detail.getChInfo())) {
                    serialNums = "";
                    for (ChInfo ch : detail.getChInfo()) {
                        if (StringUtils.isBlank((String)ch.getCh())) continue;
                        serialNums = serialNums + ch.getCh() + " ";
                    }
                }
                if (StringUtils.isNotBlank((String)serialNums) && serialNums.length() > SpecialSalesConstants.SERIAL_NUMS_LENGTH) {
                    logger.error("\u4e32\u7801\u96c6\u5408\u957f\u5ea6\u8fc7\u957f");
                    serialNums = serialNums.substring(0, SpecialSalesConstants.SERIAL_NUMS_LENGTH);
                }
                po.setSerialNumList(serialNums);
                list.add(po);
            }
        }
        return list;
    }

    public RspBaseBO updateSpecialSales(SpecialSalesCheckReqBO reqBO) {
        ExternaLinterResultData checkRsp;
        RspBaseBO validRet;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7279\u4ef7\u7533\u8bf7\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        }
        if (null != (validRet = this.vaildUpdateArg(reqBO))) {
            logger.error(validRet.getRespDesc());
            return validRet;
        }
        RspBaseBO rspBO = new RspBaseBO("0000", "\u6210\u529f");
        SpecialSalesRecordBO atomBO = this.specialSalesAtomService.querySpecialSalesByBillId(Long.valueOf(reqBO.getBillid()));
        boolean forwardSwitch = ExterPropertiesUtils.getBooleanProperty("FORWARD_SWITCH", false);
        if (null == atomBO && !forwardSwitch) {
            logger.error("\u672a\u67e5\u8be2\u5230\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55");
            rspBO.setRespCode("0008");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55");
            return rspBO;
        }
        if (null == atomBO && forwardSwitch && null != (checkRsp = this.checkShop(reqBO, atomBO))) {
            return new RspBaseBO(checkRsp.getRespCode(), checkRsp.getRespDesc());
        }
        if ("1".equals(atomBO.getState())) {
            logger.error("\u5ba1\u6838\u901a\u8fc7\u7684\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u91cd\u590d\u901a\u77e5");
            rspBO.setRespCode("0011");
            rspBO.setRespDesc((String)ExtExceptionConstant.codeMap.get("0011"));
            return rspBO;
        }
        atomBO.setCheckTime(new Date());
        atomBO.setState(reqBO.getState());
        try {
            this.specialSalesAtomService.updateSpecialSalesRecord(atomBO);
        }
        catch (ResourceException e) {
            logger.error("\u66f4\u65b0\u7279\u4ef7\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7279\u4ef7\u7533\u8bf7\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7279\u4ef7\u7533\u8bf7\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5f02\u5e38");
            return rspBO;
        }
        Long orderId = atomBO.getOrderId();
        try {
            OrderDealThread orderDealThread = new OrderDealThread(this.stockChangeCallHisAtomService, this.erpStockService, reqBO.getState(), orderId, atomBO.getBillId());
            ExecutorService singleThreadPool = ExtCreateThreadUtils.createSimpleThreadPool(orderDealThread, "ORDER-DEAL-POOL", 1, 1);
            singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
            singleThreadPool.shutdown();
        }
        catch (Exception e) {
            logger.error("\u5f00\u542f\u8ba2\u5355\u5904\u7406\u7ebf\u7a0b\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBO;
    }

    private ExternaLinterResultData checkShop(SpecialSalesCheckReqBO reqBO, SpecialSalesRecordBO atomBO) {
        String url = ExterPropertiesUtils.getProperty("FORWARD_URL_SYNCSPECIAL_WH");
        ExternaLinterResultData rsp = ExtForwardUtils.forward(url, reqBO);
        return rsp;
    }

    private SpecialSalesRecordBO addBOToAtomBO(ErpSpecialSalesReqBO bo) {
        SpecialSalesRecordBO atomBO = new SpecialSalesRecordBO();
        atomBO.setActivityId(bo.getHdID());
        atomBO.setCreateTime(new Date());
        atomBO.setIsInvoice(bo.getHaveFp());
        atomBO.setOrderId(Long.valueOf(bo.getOrderID()));
        atomBO.setShopId(bo.getShopId());
        Date time = null;
        try {
            time = format.parse(bo.getOrderTime());
            atomBO.setOrderTime(time);
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        atomBO.setPayMode(bo.getPayMode());
        try {
            atomBO.setSaleAmount(new BigDecimal(bo.getDdje()).multiply(new BigDecimal("10000")).longValue());
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
        }
        try {
            atomBO.setSaleNumber(Long.valueOf(bo.getSaleNumber()));
        }
        catch (NumberFormatException e) {
            logger.error("\u9500\u552e\u603b\u6570\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u9500\u552e\u603b\u6570\u683c\u5f0f\u9519\u8bef");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u53c2\u6570\u8f6c\u6362\u5b8c\u6210");
        }
        return atomBO;
    }

    private SpecialSalesRecordRspBO atomBOToBO(SpecialSalesRecordBO bo) {
        SpecialSalesRecordRspBO rspBO = new SpecialSalesRecordRspBO();
        rspBO.setActivityId(bo.getActivityId());
        rspBO.setBillId(bo.getBillId());
        rspBO.setCheckTime(bo.getCheckTime());
        rspBO.setCreateTime(bo.getCreateTime());
        rspBO.setIsInvoice(bo.getIsInvoice());
        rspBO.setOrderId(bo.getOrderId());
        rspBO.setOrderTime(bo.getOrderTime());
        rspBO.setPayMode(bo.getPayMode());
        rspBO.setSaleAmount(bo.getSaleAmount());
        rspBO.setSaleNumber(bo.getSaleNumber());
        rspBO.setSalesRecordId(bo.getSalesRecordId());
        rspBO.setState(bo.getState());
        rspBO.setUpdateTime(bo.getUpdateTime());
        return rspBO;
    }

    private SpecialSalesRecordRspBO vaildAddArg(ErpSpecialSalesReqBO reqBO) {
        SpecialSalesRecordRspBO rsp = new SpecialSalesRecordRspBO();
        if (null == reqBO) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getOrderID())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u8ba2\u5355\u7f16\u53f7orderID\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getOrderTime())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u4e0b\u5355\u65f6\u95f4orderTime\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getDdje())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u8ba2\u5355\u603b\u91d1\u989dddje\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getSaleNumber())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u8ba2\u5355\u603b\u6570\u91cfsaleNumber\u4e3a\u7a7a");
            return rsp;
        }
        if (!Pattern.matches(NUMBER_PATTERN, reqBO.getSaleNumber())) {
            rsp.setRespCode("0002");
            rsp.setRespDesc("\u9500\u552e\u603b\u6570\u683c\u5f0f\u9519\u8bef");
            return rsp;
        }
        if (!Pattern.matches(PRICE_PATTERN, reqBO.getDdje())) {
            rsp.setRespCode("0002");
            rsp.setRespDesc("\u8ba2\u5355\u603b\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
            return rsp;
        }
        return null;
    }

    private RspBaseBO vaildUpdateArg(SpecialSalesCheckReqBO reqBO) {
        RspBaseBO rsp = new RspBaseBO();
        if (null == reqBO) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getBillid())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u7279\u4ef7\u5355\u8fd4\u56de\u7f16\u7801billid\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getFsrq())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u4e0b\u5355\u65f6\u95f4fsrq\u4e3a\u7a7a");
            return rsp;
        }
        if (StringUtils.isBlank((String)reqBO.getState())) {
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u72b6\u6001state\u4e3a\u7a7a");
            return rsp;
        }
        if (!"2".equals(reqBO.getState()) && !"1".equals(reqBO.getState())) {
            rsp.setRespCode("0012");
            rsp.setRespDesc("\u5ba1\u6838\u72b6\u6001\u7c7b\u578b\u9519\u8bef");
            return rsp;
        }
        return null;
    }
}

