/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.externalinter.util.MyDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.DefaultDefaultValueProcessor;
import net.sf.json.processors.DefaultValueProcessor;
import net.sf.json.util.PropertyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtJsonUtils {
    public static ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(ExtJsonUtils.class);
    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    public static <T> T JavaBeanToObject(Object object, Class<T> valueType) {
        if (valueType == null) {
            return null;
        }
        if (object == null) {
            return null;
        }
        try {
            String content = ExtJsonUtils.beanToJson(object);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b\uff01", (Throwable)e);
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b", e);
        }
    }

    public static <T> T JavaBeanToObjectAndKeyChange(Object object, Class<T> valueType) {
        if (valueType == null) {
            return null;
        }
        if (object == null) {
            return null;
        }
        try {
            String content = ExtJsonUtils.beanToJson(object);
            Map map = (Map)objectMapper.readValue(content, Map.class);
            map = ExtJsonUtils.map2Uppercase(map);
            content = JSONObject.fromObject((Object)map).toString();
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b\uff01", (Throwable)e);
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b", e);
        }
    }

    public static <T> T jsonStringToObject(String content, Class<T> valueType) {
        if (valueType == null) {
            return null;
        }
        try {
            DateFormat dateFormat = objectMapper.getDateFormat();
            objectMapper.setDateFormat((DateFormat)new MyDateFormat(dateFormat));
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
            objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
            objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b\uff01", (Throwable)e);
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b", e);
        }
    }

    public static String beanToJson(Object object) {
        String content = null;
        try {
            if (object == null) {
                return content;
            }
            content = objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("\u5c06\u5bf9\u8c61\u751f\u6210json\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8be5\u5bf9\u8c61\uff01", (Throwable)e);
        }
        return content;
    }

    public static Map map2Uppercase(Map<String, Object> map) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof List) {
                ArrayList<Map> list = new ArrayList<Map>();
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    list.add(ExtJsonUtils.map2Uppercase((Map)((List)obj).get(i)));
                }
                m.put(ExtJsonUtils.underscoreName(key), list);
                continue;
            }
            m.put(ExtJsonUtils.underscoreName(key), obj);
        }
        return m;
    }

    public static String underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        if (camelCaseName != null && camelCaseName.length() > 0) {
            result.append(camelCaseName.substring(0, 1).toUpperCase());
            for (int i = 1; i < camelCaseName.length(); ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(ch);
                    continue;
                }
                result.append(Character.toUpperCase(ch));
            }
        }
        return result.toString();
    }

    public static JSONObject changeMapToJson(Map map) {
        JSONObject jsonObject = null;
        try {
            if (map == null) {
                return jsonObject;
            }
            jsonObject = JSONObject.fromObject((Object)map);
        }
        catch (RuntimeException e) {
            log.error("map\u8f6cjson\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6539map", (Throwable)e);
        }
        return jsonObject;
    }

    public static String humpToLine(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static <T> String toJson(T src) {
        try {
            return src instanceof String ? (String)src : objectMapper.writeValueAsString(src);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonConfig getConfig() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerDefaultValueProcessor(Double.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Long.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Integer.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Integer.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(String.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return null == value;
            }
        });
        return jsonConfig;
    }
}

