/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.ability.bo.ScmStockInfoBO;
import com.tydic.externalinter.atom.ScmStockInfoAtomService;
import com.tydic.externalinter.dao.ScmStockInfoDAO;
import com.tydic.externalinter.dao.po.ScmStockInfoPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScmStockInfoAtomServiceImpl
implements ScmStockInfoAtomService {
    private static final Logger log = LoggerFactory.getLogger(ScmStockInfoAtomServiceImpl.class);
    @Autowired
    private ScmStockInfoDAO scmStockInfoDAO;

    @Override
    public List<ScmStockInfoBO> saveRecordBatch(List<ScmStockInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("scm\u5e93\u5b58\u96c6\u5408\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "scm\u5e93\u5b58\u96c6\u5408\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ScmStockInfoPO> pos = new ArrayList<ScmStockInfoPO>(reqBOs.size());
        for (ScmStockInfoBO bo : reqBOs) {
            this.checkParams(bo);
            ScmStockInfoPO po = new ScmStockInfoPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateTime(new Date());
            pos.add(po);
        }
        try {
            this.scmStockInfoDAO.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589escm\u5e93\u5b58\u539f\u5b50\u5c42\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589escm\u5e93\u5b58\u539f\u5b50\u5c42\u5931\u8d25");
        }
        ArrayList<ScmStockInfoBO> rspList = new ArrayList<ScmStockInfoBO>(pos.size());
        for (ScmStockInfoPO po : pos) {
            ScmStockInfoBO bo = new ScmStockInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspList.add(bo);
        }
        return rspList;
    }

    @Override
    public void modifyBatchByKey(List<ScmStockInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6279\u91cf\u66f4\u65b0scm\u5e93\u5b58\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6279\u91cf\u66f4\u65b0scm\u5e93\u5b58\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ScmStockInfoPO> list = new ArrayList<ScmStockInfoPO>(reqBOs.size());
        for (ScmStockInfoBO bo : reqBOs) {
            ScmStockInfoPO po = new ScmStockInfoPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setUpdateTime(new Date());
            list.add(po);
        }
        try {
            this.scmStockInfoDAO.updateByBatch(list);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0scm\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u6279\u91cf\u66f4\u65b0scm\u5e93\u5b58\u5931\u8d25");
        }
    }

    private void checkParams(ScmStockInfoBO bo) {
        if (null == bo.getKczl()) {
            log.error("SCM\u5e93\u5b58\u603b\u91cf\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"SCM\u5e93\u5b58\u603b\u91cf\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getMatnr())) {
            log.error("SCM\u7269\u6599\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"SCM\u7269\u6599\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getWerks())) {
            log.error("SCM\u5de5\u5382\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"SCM\u5de5\u5382\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getLgort())) {
            log.error("SCM\u5e93\u5b58\u5730\u70b9\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"SCM\u5e93\u5b58\u5730\u70b9\u4e3a\u7a7a");
        }
    }
}

