/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.atom.spu.bo.CommodityBO;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.CommDataSyncHisAtomService;
import com.tydic.externalinter.bo.ErpCommodityBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.bo.commodity.ErpChInfoBO;
import com.tydic.externalinter.bo.commodity.ErpKCInfoBO;
import com.tydic.externalinter.bo.commodity.ErpSpInfoBO;
import com.tydic.externalinter.constant.ErpConstants;
import com.tydic.externalinter.dao.ErpChInfoDao;
import com.tydic.externalinter.dao.ErpCommodityDao;
import com.tydic.externalinter.dao.ErpSpInfoDao;
import com.tydic.externalinter.dao.po.CommodityDataSyncHistoryPO;
import com.tydic.externalinter.dao.po.ErpChInfoPO;
import com.tydic.externalinter.dao.po.ErpCommodityPO;
import com.tydic.externalinter.dao.po.ErpSpInfoPO;
import com.tydic.externalinter.service.ErpCommodityService;
import com.tydic.externalinter.thread.OssOperateThread;
import com.tydic.externalinter.util.ExtCreateThreadUtils;
import com.tydic.externalinter.util.ExtForwardUtils;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.bo.SkuInfoBO;
import com.tydic.zhmd.bo.SkuInfoListBO;
import com.tydic.zhmd.service.ShopService;
import com.tydic.zhmd.service.StockService;
import com.xls.commodity.busi.sku.QuerySkuBasicDataService;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataNoPageReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataRspBO;
import com.xls.commodity.intfce.sku.ErpToSkuService;
import com.xls.commodity.intfce.sku.QuerySkuByMaterialIdExtSkuIdCustomService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.ErpToSkuReqBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomReqBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuByMaterialIdExtSkuIdCustomRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="erpCommodityService")
public class ErpCommodityServiceImpl
implements ErpCommodityService {
    private static Logger logger = LoggerFactory.getLogger(ErpCommodityServiceImpl.class);
    private static Boolean isDebug = logger.isDebugEnabled();
    @Resource
    QuerySkuByMaterialIdExtSkuIdCustomService querySkuByMaterialIdExtSkuIdCustomService;
    @Resource
    QuerySkuBasicDataService querySkuBasicDataService;
    @Resource
    StockService stockService;
    @Resource
    ShopService shopService;
    @Resource
    ErpCommodityDao erpCommodityDao;
    @Resource
    ErpSpInfoDao erpSpInfoDao;
    @Resource
    ErpChInfoDao erpChInfoDao;
    @Autowired
    private CommDataSyncHisAtomService commDataSyncHisAtomService;
    @Resource
    private ErpToSkuService erpToSkuService;
    private static final String ZERO_PATTERN = "^[+-]?[0]+(\\.[0]+)?$|^$|^([0]+|\\-){7,}$";
    private static final String ADD_PATTERN = "^(-)?([1-9]\\d*|[0]{1,1})$";
    private static final String DEL_PATTERN = "^([1-9]\\d*|[0]{1,1})$";

    public ExternaLinterResultData receiveCommodity(ErpCommodityBO erpCommodityBO) {
        ExternaLinterResultData checkShopRsp;
        boolean forwardSwitch = ExterPropertiesUtils.getBooleanProperty("FORWARD_SWITCH", false);
        if (forwardSwitch && null != (checkShopRsp = this.checkShop(erpCommodityBO))) {
            return checkShopRsp;
        }
        String erpInputParams = JSON.toJSONString((Object)erpCommodityBO);
        if (isDebug.booleanValue()) {
            logger.debug("\u5e93\u5b58\u4fe1\u606f\u540c\u6b65\u5165\u53c2\uff1a" + erpCommodityBO);
        }
        if (StringUtils.isBlank((CharSequence)erpCommodityBO.getOperID()) || StringUtils.isBlank((CharSequence)erpCommodityBO.getCzType())) {
            logger.error("\u64cd\u4f5c\u5355\u636e\u53f7\u3010operID\u3011\u548c\u64cd\u4f5c\u7c7b\u578b\u3010czType\u3011\u5fc5\u586b");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0001", "\u64cd\u4f5c\u5355\u636e\u53f7\u3010operID\u3011\u548c\u64cd\u4f5c\u7c7b\u578b\u3010czType\u3011\u5fc5\u586b");
        }
        String operId = erpCommodityBO.getOperID();
        String czType = erpCommodityBO.getCzType();
        CommodityDataSyncHistoryPO stockSyncTaskPO = this.getOrSaveTaskInfo(czType, operId, erpInputParams);
        if (!"0000".equals(stockSyncTaskPO.getRespCode())) {
            return new ExternaLinterResultData(Boolean.valueOf(false), stockSyncTaskPO.getRespCode(), stockSyncTaskPO.getRespDesc());
        }
        String validStr = this.validateErpCommodity(erpCommodityBO);
        if (StringUtils.isNotBlank((CharSequence)validStr)) {
            this.modifyHistory(stockSyncTaskPO, "9999", validStr);
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", validStr);
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u5f00\u59cb\u672c\u5730\u4fdd\u5b58");
        }
        ErpCommodityPO erpCommodityPO = this.saveErpCommodity(erpCommodityBO);
        if (isDebug.booleanValue()) {
            logger.debug("\u672c\u5730\u4fdd\u5b58\u6210\u529f\uff01");
        }
        switch (czType) {
            case "1": {
                if (isDebug.booleanValue()) {
                    logger.debug("\u5e93\u5b58\u65b0\u589e");
                }
                try {
                    if (isDebug.booleanValue()) {
                        logger.debug("\u65b0\u589e\u5546\u54c1");
                    }
                    this.saveErpCommodityToCommodityCenter(erpCommodityBO);
                    erpCommodityPO.setErpCommodityCommodityState(ErpConstants.STATUS_SUCCESS);
                    this.erpCommodityDao.updateByPrimaryKeySelective(erpCommodityPO);
                    if (isDebug.booleanValue()) {
                        logger.debug("\u65b0\u589e\u5546\u54c1\u6210\u529f");
                    }
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, "9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25:" + e.getMessage());
                    ExternaLinterResultData externaLinterResultData = new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
                    return externaLinterResultData;
                }
                ExternaLinterResultData instockRsp = this.saveErpCommodityToShopCenter(erpCommodityBO, stockSyncTaskPO);
                if (!instockRsp.getSuccess().booleanValue()) {
                    ExternaLinterResultData externaLinterResultData = new ExternaLinterResultData(Boolean.valueOf(false), "9999", instockRsp.getRespDesc());
                    return externaLinterResultData;
                }
                erpCommodityPO.setErpCommodityStockState(ErpConstants.STATUS_SUCCESS);
                erpCommodityPO.setErpCommodityState(ErpConstants.STATUS_SUCCESS);
                this.erpCommodityDao.updateByPrimaryKeySelective(erpCommodityPO);
                if (!isDebug.booleanValue()) break;
                logger.debug("\u5e93\u5b58\u65b0\u589e\u5b8c\u6210");
                break;
            }
            case "2": {
                if (isDebug.booleanValue()) {
                    logger.debug("\u5e93\u5b58\u5220\u9664");
                }
                ResultData<SkuInfoListBO> delStockRsp = null;
                try {
                    delStockRsp = this.deleteErpCommodityToShopCenter(erpCommodityBO);
                    if (!"0000".equals(delStockRsp.getRespCode())) {
                        throw new Exception(delStockRsp.getRespDesc());
                    }
                    erpCommodityPO.setErpCommodityStockState(ErpConstants.STATUS_SUCCESS);
                    erpCommodityPO.setErpCommodityState(ErpConstants.STATUS_SUCCESS);
                    this.erpCommodityDao.updateByPrimaryKeySelective(erpCommodityPO);
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, "9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                }
                try {
                    SkuInfoListBO skuInfoListBO = (SkuInfoListBO)delStockRsp.getRespData();
                    if (null == skuInfoListBO) break;
                    for (SkuInfoBO bo : skuInfoListBO.getSkuInfoBO()) {
                        ErpToSkuReqBO erpToSkuReqBO = new ErpToSkuReqBO();
                        com.ohaotian.commodity.atom.sku.bo.SkuBO skuBO = new com.ohaotian.commodity.atom.sku.bo.SkuBO();
                        skuBO.setSupplierId(bo.getShopId());
                        skuBO.setExtSkuId(bo.getZjm());
                        skuBO.setCgType(bo.getPurchaseType());
                        erpToSkuReqBO.setSku(skuBO);
                        this.erpToSkuService.erpToSku(erpToSkuReqBO);
                    }
                    break;
                }
                catch (Exception e) {
                    logger.error("\u4fee\u6539\u5546\u54c1\u91c7\u8d2d\u7c7b\u578b\u5931\u8d25\uff1a" + e.getMessage());
                    break;
                }
            }
            default: {
                logger.error("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                this.modifyHistory(stockSyncTaskPO, "9999", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            }
        }
        this.modifyHistory(stockSyncTaskPO, "0000", "\u6210\u529f");
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    public ExternaLinterResultData receiveSkuStock(ErpCommodityBO erpCommodityBO) {
        String erpInputParams = JSON.toJSONString((Object)erpCommodityBO);
        if (isDebug.booleanValue()) {
            logger.debug("\u5e93\u5b58\u4fe1\u606f\u540c\u6b65\u5165\u53c2\uff1a" + erpCommodityBO);
        }
        if (StringUtils.isBlank((CharSequence)erpCommodityBO.getOperID()) || StringUtils.isBlank((CharSequence)erpCommodityBO.getCzType())) {
            logger.error("\u64cd\u4f5c\u5355\u636e\u53f7\u3010operID\u3011\u548c\u64cd\u4f5c\u7c7b\u578b\u3010czType\u3011\u5fc5\u586b");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0001", "\u64cd\u4f5c\u5355\u636e\u53f7\u3010operID\u3011\u548c\u64cd\u4f5c\u7c7b\u578b\u3010czType\u3011\u5fc5\u586b");
        }
        String operId = erpCommodityBO.getOperID();
        String czType = erpCommodityBO.getCzType();
        CommodityDataSyncHistoryPO stockSyncTaskPO = this.getOrSaveTaskInfo(czType, operId, erpInputParams);
        if (!"0000".equals(stockSyncTaskPO.getRespCode())) {
            return new ExternaLinterResultData(Boolean.valueOf(false), stockSyncTaskPO.getRespCode(), stockSyncTaskPO.getRespDesc());
        }
        String validStr = this.validateSkuStock(erpCommodityBO);
        if (StringUtils.isNotBlank((CharSequence)validStr)) {
            this.modifyHistory(stockSyncTaskPO, "9999", validStr);
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", validStr);
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u5f00\u59cb\u672c\u5730\u4fdd\u5b58");
        }
        ErpCommodityPO erpCommodityPO = this.saveErpCommodity(erpCommodityBO);
        if (isDebug.booleanValue()) {
            logger.debug("\u672c\u5730\u4fdd\u5b58\u6210\u529f\uff01");
        }
        switch (czType) {
            case "1": {
                ExternaLinterResultData instockRsp;
                if (isDebug.booleanValue()) {
                    logger.debug("\u5e93\u5b58\u65b0\u589e");
                }
                if (!(instockRsp = this.saveErpCommodityToShopCenter(erpCommodityBO, stockSyncTaskPO)).getSuccess().booleanValue()) {
                    ExternaLinterResultData externaLinterResultData = new ExternaLinterResultData(Boolean.valueOf(false), "9999", instockRsp.getRespDesc());
                    return externaLinterResultData;
                }
                erpCommodityPO.setErpCommodityStockState(ErpConstants.STATUS_SUCCESS);
                erpCommodityPO.setErpCommodityState(ErpConstants.STATUS_SUCCESS);
                this.erpCommodityDao.updateByPrimaryKeySelective(erpCommodityPO);
                if (!isDebug.booleanValue()) break;
                logger.debug("\u5e93\u5b58\u65b0\u589e\u5b8c\u6210");
                break;
            }
            case "2": {
                if (isDebug.booleanValue()) {
                    logger.debug("\u5e93\u5b58\u5220\u9664");
                }
                ResultData<SkuInfoListBO> delStockRsp = null;
                try {
                    delStockRsp = this.deleteErpCommodityToShopCenter(erpCommodityBO);
                    if (!"0000".equals(delStockRsp.getRespCode())) {
                        throw new Exception(delStockRsp.getRespDesc());
                    }
                    erpCommodityPO.setErpCommodityStockState(ErpConstants.STATUS_SUCCESS);
                    erpCommodityPO.setErpCommodityState(ErpConstants.STATUS_SUCCESS);
                    this.erpCommodityDao.updateByPrimaryKeySelective(erpCommodityPO);
                    break;
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                    this.modifyHistory(stockSyncTaskPO, "9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5220\u9664\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            default: {
                logger.error("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                this.modifyHistory(stockSyncTaskPO, "9999", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            }
        }
        this.modifyHistory(stockSyncTaskPO, "0000", "\u6210\u529f");
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
    }

    private ResultData<SkuInfoListBO> deleteErpCommodityToShopCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        SkuInfoListBO reqBO = new SkuInfoListBO();
        ArrayList<SkuInfoBO> reqList = new ArrayList<SkuInfoBO>();
        for (ErpKCInfoBO kc : erpCommodityBO.getKcInfo()) {
            List spInfoBOS = kc.getSpInfo();
            for (ErpSpInfoBO erpSpInfoBO : spInfoBOS) {
                SkuInfoBO sku = new SkuInfoBO();
                String amount = erpSpInfoBO.getKcsl();
                if (StringUtils.isNotBlank((CharSequence)amount)) {
                    if (amount.contains(".")) {
                        amount = amount.substring(0, amount.lastIndexOf("."));
                    }
                    if (!Pattern.matches(DEL_PATTERN, amount)) {
                        logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                        throw new ResourceException("9999", "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    }
                    sku.setChangeAmount(Integer.valueOf(Integer.parseInt(amount)));
                }
                sku.setScmID(erpSpInfoBO.getScmID());
                if (StringUtils.isNotBlank((CharSequence)erpSpInfoBO.getCgType())) {
                    sku.setPurchaseType(erpSpInfoBO.getCgType());
                }
                sku.setShopCode(kc.getMdID());
                sku.setShopId(kc.getShopId());
                ArrayList<String> erpCodes = null;
                if (CollectionUtils.isNotEmpty((Collection)erpSpInfoBO.getChInfo())) {
                    erpCodes = new ArrayList<String>(erpSpInfoBO.getChInfo().size());
                    for (ErpChInfoBO chInfo : erpSpInfoBO.getChInfo()) {
                        if (!StringUtils.isNotBlank((CharSequence)chInfo.getCh())) continue;
                        erpCodes.add(chInfo.getCh());
                    }
                    sku.setSkuInstanceCode(erpCodes);
                }
                sku.setZjm(erpSpInfoBO.getZjm());
                sku.setSkuId(erpSpInfoBO.getSkuId());
                reqList.add(sku);
            }
        }
        reqBO.setSkuInfoBO(reqList);
        if (isDebug.booleanValue()) {
            logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u53c2\uff1a" + reqBO);
        }
        return this.stockService.removeSkuStock(reqBO);
    }

    private CommodityDataSyncHistoryPO getOrSaveTaskInfo(String czType, String operId, String erpInputParams) {
        String fileName = operId + "_" + czType + "_" + System.currentTimeMillis();
        this.writeInputToOss(fileName, erpInputParams);
        CommodityDataSyncHistoryPO stockSyncTaskPO = new CommodityDataSyncHistoryPO();
        try {
            CommodityDataSyncHistoryPO reqPO = new CommodityDataSyncHistoryPO();
            reqPO.setSerialNum(operId);
            reqPO.setInputParams(ExterPropertiesUtils.getProperty("oss.path.erprequest", "resfile/erp-request/") + fileName);
            if ("2".equals(czType)) {
                reqPO.setChangeType("5");
            } else {
                reqPO.setChangeType("4");
            }
            stockSyncTaskPO = this.commDataSyncHisAtomService.getTaskInfo(reqPO);
        }
        catch (ResourceException e) {
            if ("0015".equals(e.getMsgCode())) {
                stockSyncTaskPO.setRespCode("0015");
                stockSyncTaskPO.setRespDesc(e.getMessage());
                return stockSyncTaskPO;
            }
            logger.error("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55\u3010" + operId + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55\u3010" + operId + "\u3011\u5f02\u5e38\uff1a" + e.getMessage());
        }
        stockSyncTaskPO.setRespCode("0000");
        return stockSyncTaskPO;
    }

    private ExternaLinterResultData checkShop(ErpCommodityBO erpCommodityBO) {
        ArrayList<ErpKCInfoBO> whInfo = new ArrayList<ErpKCInfoBO>();
        ArrayList<ErpKCInfoBO> elseInfo = new ArrayList<ErpKCInfoBO>();
        if (CollectionUtils.isEmpty((Collection)erpCommodityBO.getKcInfo())) {
            return null;
        }
        String url = ExterPropertiesUtils.getProperty("FORWARD_URL_SYNCSTOCK_WH");
        String shopCode = ExterPropertiesUtils.getProperty("SHOP_CODE_WH");
        for (ErpKCInfoBO bo : erpCommodityBO.getKcInfo()) {
            if (shopCode.equals(bo.getMdID())) {
                whInfo.add(bo);
                continue;
            }
            elseInfo.add(bo);
        }
        ExternaLinterResultData rsp = null;
        if (CollectionUtils.isNotEmpty(whInfo)) {
            ErpCommodityBO whReq = new ErpCommodityBO();
            whReq.setCzType(erpCommodityBO.getCzType());
            whReq.setOperID(erpCommodityBO.getOperID());
            whReq.setKcInfo(whInfo);
            rsp = ExtForwardUtils.forward(url, whReq);
        }
        if (CollectionUtils.isEmpty(elseInfo)) {
            return rsp;
        }
        erpCommodityBO.setKcInfo(elseInfo);
        return null;
    }

    private void writeInputToOss(String fileName, String erpInputParams) {
        String dir = System.getProperty("java.io.tmpdir") + File.separator + fileName;
        try {
            OssOperateThread ossOperateThread = new OssOperateThread(dir, erpInputParams);
            ExecutorService singleThreadPool = ExtCreateThreadUtils.createSimpleThreadPool(ossOperateThread, "ossupload-pool", 1, 1);
            singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
            singleThreadPool.shutdown();
        }
        catch (Exception e) {
            logger.error("\u5f00\u542f\u6587\u4ef6\u4e0a\u4f20\u7ebf\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void modifyHistory(CommodityDataSyncHistoryPO stockSyncTaskPO, String code, String desc) {
        try {
            stockSyncTaskPO.setRespCode(code);
            stockSyncTaskPO.setRespDesc(desc);
            this.commDataSyncHisAtomService.modifyTaskInfo(stockSyncTaskPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private ErpCommodityPO saveErpCommodity(ErpCommodityBO erpCommodityBO) {
        ErpCommodityPO erpCommodityPO = new ErpCommodityPO();
        try {
            if (isDebug.booleanValue()) {
                logger.debug("\u4fdd\u5b58\u5230\u672c\u5730\u7684\u65b9\u5f0f\u5165\u53c2\uff1a" + erpCommodityBO.toString());
            }
            String operID = erpCommodityBO.getOperID();
            erpCommodityPO.setErpCommodityOperid(operID);
            erpCommodityPO.setErpCommodityState(ErpConstants.STATUS_DEFAULT);
            erpCommodityPO.setErpCommodityCommodityState(ErpConstants.STATUS_DEFAULT);
            erpCommodityPO.setErpCommodityStockState(ErpConstants.STATUS_DEFAULT);
            if (isDebug.booleanValue()) {
                logger.debug("erp\u5546\u54c1\u6570\u636e\uff1a" + erpCommodityPO);
            }
            this.erpCommodityDao.insert(erpCommodityPO);
            if (isDebug.booleanValue()) {
                logger.debug("erp\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff1a");
            }
            List erpKCInfoBOList = erpCommodityBO.getKcInfo();
            ArrayList<ErpSpInfoPO> erpSpInfoPOS = new ArrayList<ErpSpInfoPO>();
            for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
                List spInfoBOList = erpKCInfoBO.getSpInfo();
                for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                    ErpSpInfoPO erpSpInfoPO = new ErpSpInfoPO();
                    erpSpInfoPO.setErpSpInfoHaveCh(spInfoBO.getHaveCh());
                    erpSpInfoPO.setErpSpInfoZjm(spInfoBO.getZjm());
                    erpSpInfoPO.setErpSpInfoScmId(spInfoBO.getScmID());
                    if (null != spInfoBO.getCgType()) {
                        erpSpInfoPO.setErpSpInfoCgType(spInfoBO.getCgType());
                    }
                    erpSpInfoPO.setErpSpInfoType(spInfoBO.getType());
                    erpSpInfoPO.setErpSpInfoPp(spInfoBO.getPp());
                    erpSpInfoPO.setErpSpInfoName(spInfoBO.getName());
                    erpSpInfoPO.setErpSpInfoFullName(spInfoBO.getFullName());
                    erpSpInfoPO.setErpSpInfoColor(spInfoBO.getColor());
                    erpSpInfoPO.setErpSpInfoNc(spInfoBO.getNc());
                    String[] kcsls = spInfoBO.getKcsl().split("\\.");
                    erpSpInfoPO.setErpSpInfoKcsl(kcsls[0]);
                    erpSpInfoPO.setErpSpInfoJg1(spInfoBO.getJg1());
                    erpSpInfoPO.setErpMdId(erpKCInfoBO.getMdID());
                    erpSpInfoPO.setSkuId(spInfoBO.getSkuId());
                    erpSpInfoPO.setErpCommodityId(erpCommodityPO.getErpCommodityId());
                    erpSpInfoPOS.add(erpSpInfoPO);
                    List chInfoBOList = spInfoBO.getChInfo();
                    ArrayList<ErpChInfoPO> erpChInfoPOS = new ArrayList<ErpChInfoPO>();
                    if (CollectionUtils.isNotEmpty((Collection)chInfoBOList)) {
                        for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                            ErpChInfoPO erpChInfoPO = new ErpChInfoPO();
                            erpChInfoPO.setErpChInfoCh(erpChInfoBO.getCh());
                            erpChInfoPO.setErpSpInfoId(erpSpInfoPO.getErpSpInfoId());
                            erpChInfoPOS.add(erpChInfoPO);
                        }
                    }
                    erpSpInfoPO.setErpChInfoPOS(erpChInfoPOS);
                }
            }
            this.erpSpInfoDao.insertBath(erpSpInfoPOS);
            ArrayList<ErpChInfoPO> erpChInfoPOS = new ArrayList<ErpChInfoPO>();
            for (ErpSpInfoPO erpSpInfoPO : erpSpInfoPOS) {
                for (ErpChInfoPO erpChInfoPO : erpSpInfoPO.getErpChInfoPOS()) {
                    erpChInfoPO.setErpSpInfoId(erpSpInfoPO.getErpSpInfoId());
                    erpChInfoPOS.add(erpChInfoPO);
                }
            }
            if (CollectionUtils.isNotEmpty(erpChInfoPOS)) {
                this.erpChInfoDao.insertBath(erpChInfoPOS);
            }
            if (isDebug.booleanValue()) {
                logger.debug("erpSpInfoPOS\uff1a" + ((Object)erpSpInfoPOS).toString());
                logger.debug("erpChInfoPOS\uff1a" + ((Object)erpChInfoPOS).toString());
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u5e93\u5b58\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        return erpCommodityPO;
    }

    private void saveErpCommodityToCommodityCenter(ErpCommodityBO erpCommodityBO) throws Exception {
        if (isDebug.booleanValue()) {
            logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u4fdd\u5b58\u65b9\u6cd5\u5165\u53c2\uff1a" + erpCommodityBO.toString());
        }
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        ShopBO shopBO = null;
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID(), erpKCInfoBO.getShopId());
            if (shopBO == null) {
                throw new Exception("\u672a\u627e\u5230\u95e8\u5e97\u4fe1\u606f");
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                com.ohaotian.commodity.atom.sku.bo.SkuBO skuBO = new com.ohaotian.commodity.atom.sku.bo.SkuBO();
                skuBO.setCgType(spInfoBO.getCgType());
                PriceBO priceBO = new PriceBO();
                if (StringUtils.isBlank((CharSequence)spInfoBO.getJg1())) {
                    skuBO.setSkuStatus(Integer.valueOf(4));
                    spInfoBO.setJg1("99999.0");
                } else if (Pattern.matches(ZERO_PATTERN, spInfoBO.getJg1())) {
                    skuBO.setSkuStatus(Integer.valueOf(4));
                } else {
                    skuBO.setSkuStatus(Integer.valueOf(1));
                }
                Double salePrice = Double.parseDouble(spInfoBO.getJg1()) * 10000.0;
                Long salePriceLong = salePrice.longValue();
                priceBO.setSalePrice(salePriceLong);
                priceBO.setSupplierId(shopBO.getShopId());
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getLimitPrice())) {
                    Double limitPrice = Double.parseDouble(spInfoBO.getLimitPrice()) * 10000.0;
                    priceBO.setAgreementPrice(Long.valueOf(limitPrice.longValue()));
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getPurchasePrice())) {
                    if (StringUtils.isBlank((CharSequence)spInfoBO.getPriceType())) {
                        throw new Exception("\u6709\u91c7\u8d2d\u4ef7\uff0c\u672a\u4f20\u91c7\u8d2d\u4ef7\u7c7b\u578b");
                    }
                    try {
                        Double purchasePrice = Double.parseDouble(spInfoBO.getPurchasePrice()) * 10000.0;
                        if ("0".equals(spInfoBO.getPriceType())) {
                            priceBO.setPurchasePrice(Long.valueOf(purchasePrice.longValue()));
                        } else if ("1".equals(spInfoBO.getPriceType())) {
                            priceBO.setSparePrice1(Long.valueOf(purchasePrice.longValue()));
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.error("\u91c7\u8d2d\u4ef7\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getAssessmentPrice())) {
                    try {
                        Double accessmentPrice = Double.parseDouble(spInfoBO.getAssessmentPrice()) * 10000.0;
                        priceBO.setAssessmentPrice(Long.valueOf(accessmentPrice.longValue()));
                    }
                    catch (NumberFormatException e) {
                        logger.error("\u53c2\u8003\u4ef7\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                CommodityBO commodityBO = new CommodityBO();
                commodityBO.setCommodityTypeId(Long.valueOf(1L));
                commodityBO.setCommodityCode("no");
                commodityBO.setSupplierId(shopBO.getShopId());
                skuBO.setSupplierId(shopBO.getShopId());
                skuBO.setMfgSku(spInfoBO.getName());
                skuBO.setSkuName(spInfoBO.getFullName());
                skuBO.setProvinceCode(shopBO.getProvinceCode());
                skuBO.setCityCode(shopBO.getCityCode());
                skuBO.setSkuLongName(spInfoBO.getFullName());
                skuBO.setSkuPrice(salePriceLong);
                skuBO.setExtSkuId(spInfoBO.getZjm());
                skuBO.setSkuLocation(Integer.valueOf(0));
                skuBO.setCommodityTypeId(Long.valueOf(1L));
                skuBO.setMaterialId(spInfoBO.getScmID());
                skuBO.setSupplierName(shopBO.getShopMdName());
                skuBO.setBrandId(Long.valueOf(900991231L));
                skuBO.setBrandName(spInfoBO.getPp());
                skuBO.setErpType(spInfoBO.getType());
                skuBO.setIsVirtualGood("0");
                if ("0".equals(spInfoBO.getIsNegative())) {
                    skuBO.setIsVirtualGood("1");
                }
                ArrayList<SpecBO> specBOList = new ArrayList<SpecBO>();
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getColor())) {
                    SpecBO specBO_Color = new SpecBO();
                    specBO_Color.setSupplierId(shopBO.getShopId());
                    specBO_Color.setPropName("\u989c\u8272");
                    specBO_Color.setPropShowName("\u989c\u8272");
                    specBO_Color.setCommodityPropGrpId(Long.valueOf(900991233L));
                    specBO_Color.setPropValue(spInfoBO.getColor());
                    specBOList.add(specBO_Color);
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getName())) {
                    SpecBO specBO_Model = new SpecBO();
                    specBO_Model.setSupplierId(shopBO.getShopId());
                    specBO_Model.setPropName("\u578b\u53f7");
                    specBO_Model.setPropShowName("\u578b\u53f7");
                    specBO_Model.setCommodityPropGrpId(Long.valueOf(900991232L));
                    specBO_Model.setPropValue(spInfoBO.getName());
                    specBOList.add(specBO_Model);
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getNc())) {
                    SpecBO specBO_DDR = new SpecBO();
                    specBO_DDR.setSupplierId(shopBO.getShopId());
                    specBO_DDR.setPropName("\u5185\u5b58");
                    specBO_DDR.setPropShowName("\u5185\u5b58");
                    specBO_DDR.setCommodityPropGrpId(Long.valueOf(900991234L));
                    specBO_DDR.setPropValue(spInfoBO.getNc());
                    specBOList.add(specBO_DDR);
                }
                if (StringUtils.isNotBlank((CharSequence)spInfoBO.getPp())) {
                    SpecBO specBO_Brand = new SpecBO();
                    specBO_Brand.setSupplierId(shopBO.getShopId());
                    specBO_Brand.setPropName("\u54c1\u724c");
                    specBO_Brand.setPropShowName("\u54c1\u724c");
                    specBO_Brand.setCommodityPropGrpId(Long.valueOf(900991231L));
                    specBO_Brand.setPropValue(spInfoBO.getPp());
                    specBOList.add(specBO_Brand);
                }
                ErpToSkuReqBO erpToSkuReqBO = new ErpToSkuReqBO();
                erpToSkuReqBO.setSkuSpec(specBOList);
                erpToSkuReqBO.setSku(skuBO);
                erpToSkuReqBO.setSpu(commodityBO);
                erpToSkuReqBO.setPrice(priceBO);
                logger.debug("\u5546\u54c1\u5165\u53c2" + JSONObject.toJSONString((Object)erpToSkuReqBO));
                BaseRspBO erpToSkuRsp = this.erpToSkuService.erpToSku(erpToSkuReqBO);
                if (null != erpToSkuRsp && "0000".equals(erpToSkuRsp.getRespCode())) continue;
                logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25\uff1a" + erpToSkuRsp.getRespDesc());
                throw new ResourceException("9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25");
            }
        }
    }

    private ExternaLinterResultData saveErpCommodityToShopCenter(ErpCommodityBO erpCommodityBO, CommodityDataSyncHistoryPO stockSyncTaskPO) {
        try {
            if (isDebug.booleanValue()) {
                logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u4fdd\u5b58\u65b9\u6cd5\u5165\u53c2\uff1a" + erpCommodityBO.toString());
            }
            SkuInfoListBO skuInfoLisBO = new SkuInfoListBO();
            ArrayList<SkuInfoBO> skuInfoBOList = new ArrayList<SkuInfoBO>();
            skuInfoLisBO.setSkuInfoBO(skuInfoBOList);
            List erpKCInfoBOList = erpCommodityBO.getKcInfo();
            ShopBO shopBO = null;
            for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
                Long skuId;
                shopBO = this.getShopBoByShopMdId(erpKCInfoBO.getMdID(), erpKCInfoBO.getShopId());
                if (shopBO == null) {
                    logger.error("\u95e8\u5e97\u3010" + erpKCInfoBO.getMdID() + "\u3011\u4e0d\u5b58\u5728");
                    return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u95e8\u5e97\u3010" + erpKCInfoBO.getMdID() + "\u3011\u4e0d\u5b58\u5728");
                }
                List spInfoBOList = erpKCInfoBO.getSpInfo();
                ArrayList<String> zjms = new ArrayList<String>();
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                    List chInfoBOList = null;
                    ArrayList<String> skuInstanceCode = new ArrayList<String>();
                    if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                        chInfoBOList = spInfoBO.getChInfo();
                    }
                    if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                        for (ErpChInfoBO erpChInfoBO : chInfoBOList) {
                            if (!StringUtils.isNotBlank((CharSequence)erpChInfoBO.getCh())) continue;
                            skuInstanceCode.add(erpChInfoBO.getCh());
                        }
                    }
                    if (null == (skuId = spInfoBO.getSkuId())) {
                        zjms.add(spInfoBO.getZjm());
                    } else {
                        skuIds.add(skuId);
                    }
                    SkuInfoBO skuInfoBO = new SkuInfoBO();
                    skuInfoBO.setSkuId(skuId);
                    skuInfoBO.setShopId(shopBO.getShopId());
                    String amount = spInfoBO.getKcsl();
                    if (StringUtils.isNotBlank((CharSequence)amount)) {
                        if (amount.contains(".")) {
                            amount = amount.substring(0, amount.lastIndexOf("."));
                        }
                        if (!Pattern.matches(ADD_PATTERN, amount)) {
                            logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                        }
                        skuInfoBO.setChangeAmount(Integer.valueOf(Integer.parseInt(amount)));
                    }
                    skuInfoBO.setSkuInstanceCode(skuInstanceCode);
                    if (null != spInfoBO.getCgType() && !StringUtils.isEmpty((CharSequence)spInfoBO.getCgType().trim())) {
                        skuInfoBO.setPurchaseType(spInfoBO.getCgType());
                    }
                    skuInfoBO.setScmID(spInfoBO.getScmID());
                    skuInfoBO.setZjm(spInfoBO.getZjm());
                    skuInfoBO.setVirtualFlag("0");
                    if ("0".equals(spInfoBO.getIsNegative())) {
                        skuInfoBO.setVirtualFlag("1");
                    }
                    if ("1".equals(spInfoBO.getHaveCh())) {
                        skuInfoBO.setHasSerailNum(Boolean.valueOf(true));
                    }
                    skuInfoBOList.add(skuInfoBO);
                }
                Map<Object, Object> zjmMap = new HashMap();
                if (CollectionUtils.isNotEmpty(zjms)) {
                    zjmMap = this.getSkuIdsFromCommodityCenterByExtSkuIds(shopBO.getShopId(), zjms);
                }
                Map<Object, Object> skuMap = new HashMap();
                if (CollectionUtils.isNotEmpty(skuIds)) {
                    skuMap = this.getSkusFromCommodityCenterBySkuIds(shopBO.getShopId(), skuIds);
                }
                for (SkuInfoBO sku : skuInfoBOList) {
                    skuId = sku.getSkuId();
                    if (null != skuId) {
                        QuerySkuBasicDataRspBO skuBO = (QuerySkuBasicDataRspBO)skuMap.get(skuId);
                        if (null == skuBO) {
                            throw new ResourceException("9999", "\u672a\u67e5\u8be2\u5230skuId\u4e3a\u3010" + skuId + "\u3011\u7684\u5546\u54c1");
                        }
                        if ("1".equals(skuBO.getHasSerialNumber())) {
                            sku.setHasSerailNum(Boolean.valueOf(true));
                        }
                        sku.setVirtualFlag(skuBO.getAllowNegativeStock());
                        sku.setZjm(skuBO.getExtSkuId());
                        sku.setScmID(skuBO.getMaterialId());
                        sku.setPurchaseType(skuBO.getCgType());
                        continue;
                    }
                    skuId = (Long)zjmMap.get(sku.getZjm());
                    if (null == skuId) {
                        throw new ResourceException("9999", "\u672a\u67e5\u8be2\u5230\u52a9\u8bb0\u7801\u4e3a\u3010" + sku.getZjm() + "\u3011\u7684\u5546\u54c1");
                    }
                    sku.setSkuId(skuId);
                }
            }
            ResultData rsp = null;
            try {
                if (isDebug.booleanValue()) {
                    logger.debug("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)skuInfoLisBO));
                }
                if (null == (rsp = this.stockService.inStock(skuInfoLisBO)) || !"0000".equals(rsp.getRespCode())) {
                    logger.error("\u65b0\u589e\u5e93\u5b58\u5931\u8d25\uff1a" + rsp.getRespDesc());
                    throw new ResourceException("9999", rsp.getRespDesc());
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage());
                throw new ResourceException("9999", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (isDebug.booleanValue()) {
                logger.debug("\u65b0\u589e\u5e93\u5b58\u6210\u529f");
            }
            return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5e93\u5b58\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            this.modifyHistory(stockSyncTaskPO, "9999", "\u5e93\u5b58\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", e.getMessage());
        }
    }

    private ShopBO getShopBoByShopMdId(String shopMdId, Long shopId) {
        ShopBO tempShop = new ShopBO();
        tempShop.setShopId(shopId);
        tempShop.setShopMdId(shopMdId);
        ResultData resultData = this.shopService.findShopByMdId(tempShop);
        ShopBO shopBO = (ShopBO)resultData.getRespData();
        return shopBO;
    }

    private Map<Long, QuerySkuBasicDataRspBO> getSkusFromCommodityCenterBySkuIds(Long shopId, List<Long> skuIds) {
        HashMap<Long, QuerySkuBasicDataRspBO> map = new HashMap<Long, QuerySkuBasicDataRspBO>();
        QuerySkuBasicDataNoPageReqBO querySkuBasicDataNoPageReqBO = new QuerySkuBasicDataNoPageReqBO();
        querySkuBasicDataNoPageReqBO.setSupplierId(shopId);
        querySkuBasicDataNoPageReqBO.setSkuIds(skuIds);
        try {
            RspInfoListBO rsp = this.querySkuBasicDataService.querySkuBasicDataNoPage(querySkuBasicDataNoPageReqBO);
            if (rsp != null && CollectionUtils.isNotEmpty((Collection)rsp.getRows())) {
                for (QuerySkuBasicDataRspBO sku : rsp.getRows()) {
                    map.put(sku.getSkuId(), sku);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2skuId\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u67e5\u8be2skuId\u5931\u8d25");
        }
        return map;
    }

    private Map<String, Long> getSkuIdsFromCommodityCenterByExtSkuIds(Long shopId, List<String> extSkuIds) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        QuerySkuByMaterialIdExtSkuIdCustomReqBO querySkuByMaterialIdExtSkuIdCustomReqBO = new QuerySkuByMaterialIdExtSkuIdCustomReqBO();
        querySkuByMaterialIdExtSkuIdCustomReqBO.setSupplierId(shopId);
        querySkuByMaterialIdExtSkuIdCustomReqBO.setExtSkuIds(extSkuIds);
        QuerySkuByMaterialIdExtSkuIdCustomRspBO querySkuDetailRspBO = null;
        try {
            querySkuDetailRspBO = this.querySkuByMaterialIdExtSkuIdCustomService.querySkuByMaterialIdExtSkuId(querySkuByMaterialIdExtSkuIdCustomReqBO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2skuId\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", "\u67e5\u8be2skuId\u5931\u8d25");
        }
        if (querySkuDetailRspBO != null && CollectionUtils.isNotEmpty((Collection)querySkuDetailRspBO.getSkus())) {
            for (SkuBO sku : querySkuDetailRspBO.getSkus()) {
                map.put(sku.getExtSkuId(), sku.getSkuId());
            }
        }
        return map;
    }

    private String validateErpCommodity(ErpCommodityBO erpCommodityBO) {
        if (isDebug.booleanValue()) {
            logger.debug("\u8fdb\u5165\u6821\u9a8c");
        }
        if (erpCommodityBO == null) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            return "\u5165\u53c2\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpCommodityBO.getOperID())) {
            logger.error("\u5355\u636e\u53f7\u4e3a\u7a7a");
            return "\u5355\u636e\u53f7\u4e3a\u7a7a";
        }
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        if (CollectionUtils.isEmpty((Collection)erpKCInfoBOList)) {
            logger.error("\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a");
            return "\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a";
        }
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            if (StringUtils.isBlank((CharSequence)erpKCInfoBO.getMdID())) {
                logger.error("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
                return "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a";
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            if (CollectionUtils.isEmpty((Collection)spInfoBOList)) {
                logger.error("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
                return "\u5546\u54c1\u5217\u8868\u4e3a\u7a7a";
            }
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                int chSize;
                String amount;
                if (StringUtils.isBlank((CharSequence)spInfoBO.getCgType())) {
                    logger.error("\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
                    spInfoBO.setCgType("0");
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getType())) {
                    logger.error("\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a");
                    return "\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getHaveCh())) {
                    logger.error("\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
                    return "\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a";
                }
                if (!spInfoBO.getHaveCh().equals("1") && !spInfoBO.getHaveCh().equals("2")) {
                    logger.error("\u662f\u5426\u6709\u4e32\u53f7\u7c7b\u578b\u9519\u8bef");
                    return "\u662f\u5426\u6709\u4e32\u53f7\u7c7b\u578b\u9519\u8bef";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getZjm())) {
                    logger.error("\u52a9\u8bb0\u7801\u4e3a\u7a7a");
                    return "\u52a9\u8bb0\u7801\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getName())) {
                    logger.error("\u578b\u53f7\u4e3a\u7a7a");
                    return "\u578b\u53f7\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getFullName())) {
                    logger.error("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
                    return "\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getKcsl())) {
                    logger.error("\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a");
                    return "\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a";
                }
                ArrayList<ErpChInfoBO> chuanHaoBOS = new ArrayList<ErpChInfoBO>();
                HashSet<String> chSet = null;
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    chSet = new HashSet<String>();
                    for (ErpChInfoBO erpChInfoBO : spInfoBO.getChInfo()) {
                        if (!StringUtils.isNotBlank((CharSequence)erpChInfoBO.getCh())) continue;
                        chuanHaoBOS.add(erpChInfoBO);
                        chSet.add(erpChInfoBO.getCh());
                    }
                    if (chSet.size() < chuanHaoBOS.size()) {
                        logger.error("\u4e32\u53f7\u91cd\u590d");
                        return "\u4e32\u53f7\u91cd\u590d";
                    }
                }
                spInfoBO.setChInfo(chuanHaoBOS);
                boolean hasChs = false;
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    hasChs = true;
                }
                if (StringUtils.isNotBlank((CharSequence)(amount = spInfoBO.getKcsl())) && amount.contains(".")) {
                    amount = amount.substring(0, amount.lastIndexOf("."));
                }
                if ("1".equals(erpCommodityBO.getCzType()) && !Pattern.matches(ADD_PATTERN, amount)) {
                    logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                if ("2".equals(erpCommodityBO.getCzType()) && !Pattern.matches(DEL_PATTERN, amount)) {
                    logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                int n = chSize = CollectionUtils.isEmpty((Collection)spInfoBO.getChInfo()) ? 0 : spInfoBO.getChInfo().size();
                if (!"0".equals(amount) && "1".equals(spInfoBO.getHaveCh()) && !hasChs) {
                    logger.error("\u5f53\u524d\u4e3a\u6709\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e3a\u7a7a");
                    return "\u5f53\u524d\u4e3a\u6709\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e3a\u7a7a";
                }
                if ("2".equals(spInfoBO.getHaveCh()) && hasChs) {
                    logger.error("\u5f53\u524d\u4e3a\u65e0\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e0d\u4e3a\u7a7a");
                    return "\u5f53\u524d\u4e3a\u65e0\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e0d\u4e3a\u7a7a";
                }
                if (!"1".equals(spInfoBO.getHaveCh()) || amount.equals(String.valueOf(chSize))) continue;
                logger.error("\u540c\u6b65\u6570\u91cf\u4e0e\u4e32\u53f7\u6570\u91cf\u4e0d\u7b26");
                return "\u540c\u6b65\u6570\u91cf\u4e0e\u4e32\u53f7\u6570\u91cf\u4e0d\u7b26";
            }
        }
        return null;
    }

    private String validateSkuStock(ErpCommodityBO erpCommodityBO) {
        if (isDebug.booleanValue()) {
            logger.debug("\u8fdb\u5165\u6821\u9a8c");
        }
        if (erpCommodityBO == null) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            return "\u5165\u53c2\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpCommodityBO.getOperID())) {
            logger.error("\u5355\u636e\u53f7\u4e3a\u7a7a");
            return "\u5355\u636e\u53f7\u4e3a\u7a7a";
        }
        List erpKCInfoBOList = erpCommodityBO.getKcInfo();
        if (CollectionUtils.isEmpty((Collection)erpKCInfoBOList)) {
            logger.error("\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a");
            return "\u5e93\u5b58\u5217\u8868\u4e3a\u7a7a";
        }
        for (ErpKCInfoBO erpKCInfoBO : erpKCInfoBOList) {
            if (null == erpKCInfoBO.getMdID()) {
                logger.error("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
                return "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a";
            }
            if (null == erpKCInfoBO.getShopId()) {
                logger.error("\u95e8\u5e97id\u4e3a\u7a7a");
                return "\u95e8\u5e97id\u4e3a\u7a7a";
            }
            List spInfoBOList = erpKCInfoBO.getSpInfo();
            if (CollectionUtils.isEmpty((Collection)spInfoBOList)) {
                logger.error("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
                return "\u5546\u54c1\u5217\u8868\u4e3a\u7a7a";
            }
            for (ErpSpInfoBO spInfoBO : spInfoBOList) {
                int chSize;
                String amount;
                if (null == spInfoBO.getSkuId()) {
                    logger.error("skuId\u4e3a\u7a7a");
                    return "skuId\u4e3a\u7a7a";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getHaveCh())) {
                    logger.error("\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
                    return "\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a";
                }
                if (!spInfoBO.getHaveCh().equals("1") && !spInfoBO.getHaveCh().equals("2")) {
                    logger.error("\u662f\u5426\u6709\u4e32\u53f7\u7c7b\u578b\u9519\u8bef");
                    return "\u662f\u5426\u6709\u4e32\u53f7\u7c7b\u578b\u9519\u8bef";
                }
                if (StringUtils.isBlank((CharSequence)spInfoBO.getKcsl())) {
                    logger.error("\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a");
                    return "\u53ef\u7528\u5e93\u5b58\u91cf\u4e3a\u7a7a";
                }
                ArrayList<ErpChInfoBO> chuanHaoBOS = new ArrayList<ErpChInfoBO>();
                HashSet<String> chSet = null;
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    chSet = new HashSet<String>();
                    for (ErpChInfoBO erpChInfoBO : spInfoBO.getChInfo()) {
                        if (!StringUtils.isNotBlank((CharSequence)erpChInfoBO.getCh())) continue;
                        chuanHaoBOS.add(erpChInfoBO);
                        chSet.add(erpChInfoBO.getCh());
                    }
                    if (chSet.size() < chuanHaoBOS.size()) {
                        logger.error("\u4e32\u53f7\u91cd\u590d");
                        return "\u4e32\u53f7\u91cd\u590d";
                    }
                }
                spInfoBO.setChInfo(chuanHaoBOS);
                boolean hasChs = false;
                if (CollectionUtils.isNotEmpty((Collection)spInfoBO.getChInfo())) {
                    hasChs = true;
                }
                if (StringUtils.isNotBlank((CharSequence)(amount = spInfoBO.getKcsl())) && amount.contains(".")) {
                    amount = amount.substring(0, amount.lastIndexOf("."));
                }
                if ("1".equals(erpCommodityBO.getCzType()) && !Pattern.matches(ADD_PATTERN, amount)) {
                    logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                if ("2".equals(erpCommodityBO.getCzType()) && !Pattern.matches(DEL_PATTERN, amount)) {
                    logger.error("\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return "\u5e93\u5b58\u53d8\u52a8\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                int n = chSize = CollectionUtils.isEmpty((Collection)spInfoBO.getChInfo()) ? 0 : spInfoBO.getChInfo().size();
                if (!"0".equals(amount) && "1".equals(spInfoBO.getHaveCh()) && !hasChs) {
                    logger.error("\u5f53\u524d\u4e3a\u6709\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e3a\u7a7a");
                    return "\u5f53\u524d\u4e3a\u6709\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e3a\u7a7a";
                }
                if ("2".equals(spInfoBO.getHaveCh()) && hasChs) {
                    logger.error("\u5f53\u524d\u4e3a\u65e0\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e0d\u4e3a\u7a7a");
                    return "\u5f53\u524d\u4e3a\u65e0\u4e32\u53f7\u540c\u6b65\uff0c\u4f46\u4e32\u53f7\u4e0d\u4e3a\u7a7a";
                }
                if (!"1".equals(spInfoBO.getHaveCh()) || amount.equals(String.valueOf(chSize))) continue;
                logger.error("\u540c\u6b65\u6570\u91cf\u4e0e\u4e32\u53f7\u6570\u91cf\u4e0d\u7b26");
                return "\u540c\u6b65\u6570\u91cf\u4e0e\u4e32\u53f7\u6570\u91cf\u4e0d\u7b26";
            }
        }
        return null;
    }
}

