/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.atom.CommDataSyncHisAtomService;
import com.tydic.externalinter.bo.commodity.ErpKCInfoBO;
import com.tydic.externalinter.bo.commodity.ErpSpInfoBO;
import com.tydic.externalinter.busi.bo.RspBaseBO;
import com.tydic.externalinter.dao.po.CommodityDataSyncHistoryPO;
import com.tydic.externalinter.service.ErpModifyCommService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.zhmd.bo.SkuStockBO;
import com.tydic.zhmd.service.ModifyStockInfoService;
import com.tydic.zhmd.service.QueryStockInfoService;
import com.xls.commodity.busi.sku.ErpUpdateSkuService;
import com.xls.commodity.busi.sku.bo.ErpUpdateSkuReqBO;
import com.xls.commodity.busi.sku.bo.ErpUpdateSkuReqListBO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpModifyCommServiceImpl
implements ErpModifyCommService {
    private static Logger logger = LoggerFactory.getLogger(ErpModifyCommServiceImpl.class);
    @Resource
    private QueryStockInfoService queryStockInfoService;
    @Resource
    private ModifyStockInfoService modifyStockInfoService;
    @Resource
    private ErpUpdateSkuService erpUpdateSkuService;
    @Autowired
    private CommDataSyncHisAtomService commDataSyncHisAtomService;

    public RspBaseBO modifyCommInfo(ErpKCInfoBO reqBO) {
        RspBatchBaseBO skuStockRsp;
        String inputParams = JSON.toJSONString((Object)reqBO);
        logger.debug("\u5546\u54c1\u4fee\u6539\u5165\u53c2{}", (Object)inputParams);
        CommodityDataSyncHistoryPO stockSyncTaskPO = null;
        try {
            CommodityDataSyncHistoryPO reqPO = new CommodityDataSyncHistoryPO();
            reqPO.setSerialNum(UUID.randomUUID().toString().replace("-", ""));
            reqPO.setChangeType("10");
            reqPO.setInputParams(inputParams);
            stockSyncTaskPO = this.commDataSyncHisAtomService.getTaskInfo(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4ef7\u683c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        HashSet<String> menmCodes = new HashSet<String>(16);
        RspBaseBO checkRsp = this.checkParams(reqBO, menmCodes);
        if (null != checkRsp) {
            this.modifyHistory(stockSyncTaskPO, checkRsp.getRespCode(), checkRsp.getRespDesc());
            return checkRsp;
        }
        try {
            skuStockRsp = this.queryStockInfoService.listSkuByMnemCode(menmCodes);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u52a9\u8bb0\u7801\u67e5\u8be2\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            this.modifyHistory(stockSyncTaskPO, "0011", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u52a9\u8bb0\u7801\u67e5\u8be2\u670d\u52a1\u5931\u8d25");
            return new RspBaseBO("0011", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u52a9\u8bb0\u7801\u67e5\u8be2\u670d\u52a1\u5931\u8d25");
        }
        if (!"0000".equals(skuStockRsp.getRespCode())) {
            this.modifyHistory(stockSyncTaskPO, skuStockRsp.getRespCode(), skuStockRsp.getRespDesc());
            return new RspBaseBO(skuStockRsp.getRespCode(), skuStockRsp.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)skuStockRsp.getRows())) {
            logger.error("\u672a\u67e5\u8be2\u5230\u52a9\u8bb0\u7801\u5bf9\u5e94\u5546\u54c1\u4fe1\u606f");
            this.modifyHistory(stockSyncTaskPO, "0000", "\u672a\u67e5\u8be2\u5230\u52a9\u8bb0\u7801\u5bf9\u5e94\u5546\u54c1\u4fe1\u606f");
            return new RspBaseBO("0000", "\u672a\u67e5\u8be2\u5230\u52a9\u8bb0\u7801\u5bf9\u5e94\u5546\u54c1\u4fe1\u606f");
        }
        RspBaseBO modifyStockRsp = this.modifyStockInfo(reqBO, (RspBatchBaseBO<SkuStockBO>)skuStockRsp);
        if (!"0000".equals(modifyStockRsp.getRespCode())) {
            this.modifyHistory(stockSyncTaskPO, modifyStockRsp.getRespCode(), modifyStockRsp.getRespDesc());
            return modifyStockRsp;
        }
        RspBaseBO modifyCommRsp = this.modifyGoodsInfo(reqBO);
        if (!"0000".equals(modifyCommRsp.getRespCode())) {
            this.modifyHistory(stockSyncTaskPO, modifyCommRsp.getRespCode(), modifyCommRsp.getRespDesc());
            return modifyCommRsp;
        }
        this.modifyHistory(stockSyncTaskPO, "0000", "\u64cd\u4f5c\u6210\u529f");
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private RspBaseBO modifyGoodsInfo(ErpKCInfoBO reqBO) {
        BaseRspBO modifyRsp;
        ErpUpdateSkuReqListBO skuReqBO = new ErpUpdateSkuReqListBO();
        ArrayList<ErpUpdateSkuReqBO> modifyBOs = new ArrayList<ErpUpdateSkuReqBO>(reqBO.getSpInfo().size());
        for (ErpSpInfoBO bo : reqBO.getSpInfo()) {
            ErpUpdateSkuReqBO modifyBO = new ErpUpdateSkuReqBO();
            modifyBO.setBrand(bo.getPp());
            modifyBO.setCgType(bo.getCgType());
            modifyBO.setColor(bo.getColor());
            modifyBO.setErpLongName(bo.getFullName());
            modifyBO.setErpStatus(bo.getStatus());
            modifyBO.setErpType(bo.getType());
            modifyBO.setExtSkuId(bo.getZjm());
            modifyBO.setMaterialId(bo.getScmID());
            modifyBO.setModel(bo.getName());
            modifyBO.setRam(bo.getNc());
            if ("0".equals(bo.getIsNegative())) {
                modifyBO.setIsVirtualGood("1");
            } else {
                modifyBO.setIsVirtualGood("0");
            }
            modifyBOs.add(modifyBO);
        }
        skuReqBO.setErpUpdateSkuReqBOs(modifyBOs);
        try {
            modifyRsp = this.erpUpdateSkuService.erpUpdateSku(skuReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u4fee\u6539\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            return new RspBaseBO("0011", "\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u4fee\u6539\u670d\u52a1\u5931\u8d25");
        }
        return new RspBaseBO(modifyRsp.getRespCode(), modifyRsp.getRespDesc());
    }

    private RspBaseBO modifyStockInfo(ErpKCInfoBO reqBO, RspBatchBaseBO<SkuStockBO> skuStockRsp) {
        com.tydic.newretail.toolkit.bo.RspBaseBO modifyRsp;
        Map<String, ErpSpInfoBO> skuMap = this.toSkuMap(reqBO.getSpInfo());
        List skuStockBOs = skuStockRsp.getRows();
        for (SkuStockBO bo : skuStockBOs) {
            ErpSpInfoBO spInfoBO = skuMap.get(bo.getZjm());
            if ("0".equals(spInfoBO.getIsNegative())) {
                bo.setVirtualFlag("1");
            } else {
                bo.setVirtualFlag("0");
            }
            bo.setScmID(spInfoBO.getScmID());
            bo.setPurchaseType(spInfoBO.getCgType());
        }
        try {
            modifyRsp = this.modifyStockInfoService.modifyStockInfoBatch(skuStockBOs);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u4fe1\u606f\u4fee\u6539\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            return new RspBaseBO("0011", "\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u4fe1\u606f\u4fee\u6539\u670d\u52a1\u5931\u8d25");
        }
        if (!"0000".equals(modifyRsp.getRespCode())) {
            return new RspBaseBO(modifyRsp.getRespCode(), modifyRsp.getRespDesc());
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private Map<String, ErpSpInfoBO> toSkuMap(List<ErpSpInfoBO> rows) {
        HashMap<String, ErpSpInfoBO> skuMap = new HashMap<String, ErpSpInfoBO>(rows.size());
        for (ErpSpInfoBO bo : rows) {
            skuMap.put(bo.getZjm(), bo);
        }
        return skuMap;
    }

    private RspBaseBO checkParams(ErpKCInfoBO reqBO, Set<String> menmCodes) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSpInfo())) {
            return this.emptyReturn("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (ErpSpInfoBO spInfoBO : reqBO.getSpInfo()) {
            if (StringUtils.isBlank((CharSequence)spInfoBO.getZjm())) {
                return this.emptyReturn("\u52a9\u8bb0\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)spInfoBO.getCgType())) {
                return this.emptyReturn("\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)spInfoBO.getType())) {
                return this.emptyReturn("\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)spInfoBO.getName())) {
                return this.emptyReturn("\u578b\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)spInfoBO.getFullName())) {
                return this.emptyReturn("\u5168\u79f0\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)spInfoBO.getIsNegative())) {
                return this.emptyReturn("\u8d1f\u5e93\u5b58\u6807\u8bc6\u4e3a\u7a7a");
            }
            menmCodes.add(spInfoBO.getZjm());
        }
        return null;
    }

    private RspBaseBO emptyReturn(String desc) {
        logger.error(desc);
        return new RspBaseBO("0001", desc);
    }

    private void modifyHistory(CommodityDataSyncHistoryPO stockSyncTaskPO, String code, String desc) {
        if (null == stockSyncTaskPO) {
            return;
        }
        try {
            stockSyncTaskPO.setRespCode(code);
            stockSyncTaskPO.setRespDesc(desc);
            this.commDataSyncHisAtomService.modifyTaskInfo(stockSyncTaskPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

