/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.CommDataSyncHisAtomService;
import com.tydic.externalinter.bo.ErpShopBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.dao.CommodityShopDataSyncDetailDao;
import com.tydic.externalinter.dao.po.CommodityDataSyncHistoryPO;
import com.tydic.externalinter.dao.po.CommodityShopDataSyncDetailPO;
import com.tydic.externalinter.service.ErpShopService;
import com.tydic.zhmd.bo.ResultData;
import com.tydic.zhmd.bo.ShopBO;
import com.tydic.zhmd.service.ShopService;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="erpShopService")
public class ErpShopServiceImpl
implements ErpShopService {
    private static final Logger logger = LoggerFactory.getLogger(ErpShopServiceImpl.class);
    @Resource
    private ShopService shopService;
    @Autowired
    private CommDataSyncHisAtomService commDataSyncHisAtomService;
    @Autowired
    private CommodityShopDataSyncDetailDao commodityShopDataSyncDetailDao;

    public ExternaLinterResultData receiveShop(ErpShopBO erpShopBO) {
        ResultData resultData;
        if (StringUtils.isBlank((CharSequence)erpShopBO.getOperID()) || StringUtils.isBlank((CharSequence)erpShopBO.getShopCzType())) {
            logger.error("\u64cd\u4f5c\u5355\u636e\u53f7\u3010operID\u3011\u548c\u64cd\u4f5c\u7c7b\u578b\u3010czType\u3011\u5fc5\u586b");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0001", "\u64cd\u4f5c\u5355\u636e\u53f7\u3010operID\u3011\u548c\u64cd\u4f5c\u7c7b\u578b\u3010czType\u3011\u5fc5\u586b");
        }
        CommodityDataSyncHistoryPO stockSyncTaskPO = null;
        try {
            stockSyncTaskPO = this.getHisInfo(erpShopBO);
        }
        catch (ResourceException e) {
            if ("0015".equals(e.getMsgCode())) {
                return new ExternaLinterResultData(Boolean.valueOf(false), "0015", e.getMessage());
            }
            logger.error("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55\u3010" + erpShopBO.getOperID() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55\u3010" + erpShopBO.getOperID() + "\u3011\u5f02\u5e38\uff1a" + e.getMessage());
        }
        this.saveDetail(erpShopBO, stockSyncTaskPO);
        String code = "9999";
        String checkRsp = this.validateShop(erpShopBO);
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            this.modifyHis(code, checkRsp, stockSyncTaskPO);
            return new ExternaLinterResultData(Boolean.valueOf(false), "0001", checkRsp);
        }
        if ("3".equals(erpShopBO.getShopCzType())) {
            this.modifyHis("0000", "\u64cd\u4f5c\u6210\u529f", stockSyncTaskPO);
            return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ShopBO shopBO = new ShopBO();
        BeanUtils.copyProperties((Object)erpShopBO, (Object)shopBO);
        try {
            resultData = this.shopService.saveShop(shopBO);
        }
        catch (Exception e) {
            logger.error("\u95e8\u5e97\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            this.modifyHis(code, e.getMessage(), stockSyncTaskPO);
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u95e8\u5e97\u540c\u6b65\u5931\u8d25");
        }
        this.modifyHis(resultData.getRespCode(), resultData.getRespDesc(), stockSyncTaskPO);
        ExternaLinterResultData abilityResultData = new ExternaLinterResultData(resultData.getSuccess(), resultData.getRespCode(), resultData.getRespDesc());
        return abilityResultData;
    }

    private void saveDetail(ErpShopBO erpShopBO, CommodityDataSyncHistoryPO stockSyncTaskPO) {
        if (null == stockSyncTaskPO) {
            return;
        }
        CommodityShopDataSyncDetailPO po = new CommodityShopDataSyncDetailPO();
        po.setCreateTime(new Date());
        po.setRecordId(stockSyncTaskPO.getRecordId());
        po.setShopDsgsId(erpShopBO.getShopDsgsId());
        po.setShopDsgsName(erpShopBO.getShopDsgsName());
        po.setShopDsId(erpShopBO.getShopDsId());
        po.setShopManager(erpShopBO.getShopManager());
        po.setShopMdAddress(erpShopBO.getShopMdAddress());
        po.setShopMdId(erpShopBO.getShopMdId());
        po.setShopMdLeader(erpShopBO.getShopMdLeader());
        po.setShopMdLevel(erpShopBO.getShopMdLevel());
        po.setShopMdName(erpShopBO.getShopMdName());
        po.setShopPhone(erpShopBO.getShopPhone());
        po.setShopSfId(erpShopBO.getShopSfId());
        po.setShopSgsId(erpShopBO.getShopSgsId());
        po.setShopSgsName(erpShopBO.getShopSgsName());
        try {
            this.commodityShopDataSyncDetailDao.insert(po);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u95e8\u5e97\u540c\u6b65\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void modifyHis(String code, String checkRsp, CommodityDataSyncHistoryPO stockSyncTaskPO) {
        if (null == stockSyncTaskPO) {
            return;
        }
        try {
            stockSyncTaskPO.setRespDesc(checkRsp);
            stockSyncTaskPO.setRespCode(code);
            this.commDataSyncHisAtomService.modifyTaskInfo(stockSyncTaskPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private CommodityDataSyncHistoryPO getHisInfo(ErpShopBO erpShopBO) {
        CommodityDataSyncHistoryPO reqPO = new CommodityDataSyncHistoryPO();
        reqPO.setSerialNum(erpShopBO.getOperID());
        reqPO.setInputParams(JSON.toJSONString((Object)erpShopBO));
        switch (erpShopBO.getShopCzType()) {
            case "1": {
                reqPO.setChangeType("7");
                break;
            }
            case "2": {
                reqPO.setChangeType("8");
                break;
            }
            default: {
                reqPO.setChangeType("9");
            }
        }
        CommodityDataSyncHistoryPO stockSyncTaskPO = this.commDataSyncHisAtomService.getTaskInfo(reqPO);
        return stockSyncTaskPO;
    }

    private String validateShop(ErpShopBO erpShopBO) {
        logger.debug("\u6b63\u5728\u6821\u9a8c\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)erpShopBO));
        if (erpShopBO == null) {
            logger.debug("\u95e8\u5e97\u4fe1\u606f\u4e3a\u7a7a");
            return "\u95e8\u5e97\u4fe1\u606f\u4e3a\u7a7a";
        }
        if (erpShopBO.getShopCzType() == null) {
            logger.debug("\u672a\u6307\u5b9a\u64cd\u4f5c\u7c7b\u578b");
            return "\u672a\u6307\u5b9a\u64cd\u4f5c\u7c7b\u578b";
        }
        if (!("1".equals(erpShopBO.getShopCzType()) || "3".equals(erpShopBO.getShopCzType()) || "2".equals(erpShopBO.getShopCzType()))) {
            logger.debug("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            return "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopSgsId())) {
            logger.debug("\u7701\u5206\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
            return "\u7701\u5206\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopSgsName())) {
            logger.debug("\u7701\u5206\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
            return "\u7701\u5206\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopDsgsId())) {
            logger.debug("\u5730\u5e02\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
            return "\u5730\u5e02\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopDsgsName())) {
            logger.debug("\u5730\u5e02\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
            return "\u5730\u5e02\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopMdId())) {
            logger.debug("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            return "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopMdName())) {
            logger.debug("\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a");
            return "\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopMdAddress())) {
            logger.debug("\u95e8\u5e97\u5730\u5740\u4e3a\u7a7a");
            return "\u95e8\u5e97\u5730\u5740\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopSfId())) {
            logger.debug("\u5f52\u5c5e\u7701\u5206\u7f16\u7801\u4e3a\u7a7a");
            return "\u5f52\u5c5e\u7701\u5206\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopDsId())) {
            logger.debug("\u5f52\u5c5e\u5730\u5e02\u7f16\u7801\u4e3a\u7a7a");
            return "\u5f52\u5c5e\u5730\u5e02\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopMdLevel())) {
            logger.debug("\u95e8\u5e97\u7b49\u7ea7\u4e3a\u7a7a");
            return "\u95e8\u5e97\u7b49\u7ea7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopMdLeader())) {
            logger.debug("\u95e8\u5e97\u8d1f\u8d23\u4eba\u4e3a\u7a7a");
            return "\u95e8\u5e97\u8d1f\u8d23\u4eba\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopPhone())) {
            logger.debug("\u95e8\u5e97\u8d1f\u8d23\u4eba\u7535\u8bdd\u4e3a\u7a7a");
            return "\u95e8\u5e97\u8d1f\u8d23\u4eba\u7535\u8bdd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)erpShopBO.getShopManager())) {
            logger.debug("\u96f6\u552e\u7ecf\u7406\u4e3a\u7a7a");
            return "\u96f6\u552e\u7ecf\u7406\u4e3a\u7a7a";
        }
        return null;
    }
}

