/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.OrderInfoBO;
import com.tydic.externalinter.busi.bo.OrderSyncReqBO;
import com.tydic.externalinter.busi.bo.OrderSyncRspBO;
import com.tydic.externalinter.busi.bo.SubOrderBO;
import com.tydic.externalinter.busi.service.OrderSyncService;
import com.tydic.externalinter.util.CommonAPIServiceUtils;
import com.tydic.externalinter.util.ExtJsonUtils;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderSyncServiceImpl
implements OrderSyncService {
    private static Logger logger = LoggerFactory.getLogger(OrderSyncServiceImpl.class);
    @Value(value="${order_call_back_url}")
    private String feedBackUrl;

    public OrderSyncRspBO sync(OrderSyncReqBO orderSyncReqBO) {
        OrderSyncRspBO rspBaseBO = new OrderSyncRspBO();
        logger.debug("\u8ba2\u5355\u540c\u6b65\u5165\u53c2\uff1a" + orderSyncReqBO.toString());
        String urlProperity = "OSPB017";
        logger.debug("\u8ba2\u5355\u540c\u6b65\uff1afeedBackUrl=" + this.feedBackUrl);
        orderSyncReqBO.setFeedbackUrl(this.feedBackUrl);
        JSONObject jsonObject = JSONObject.fromObject((Object)orderSyncReqBO, (JsonConfig)ExtJsonUtils.getConfig());
        logger.debug("\u8ba2\u5355\u540c\u6b65json\u5165\u53c2\uff1a" + jsonObject.toString());
        ExternaLinterResultData externaLinterResultData = CommonAPIServiceUtils.commonUIPService(jsonObject.toString(), urlProperity);
        logger.debug("\u8ba2\u5355\u540c\u6b65\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\uff1a" + externaLinterResultData.toString());
        if (externaLinterResultData.getSuccess().booleanValue()) {
            JSONObject body = (JSONObject)externaLinterResultData.getRespData();
            if (body.containsKey((Object)"bizCode") && "1".equals(body.getString("bizCode"))) {
                rspBaseBO.setRespCode("0000");
                rspBaseBO.setRespDesc("\u6210\u529f");
                OrderInfoBO orderInfoBO = new OrderInfoBO();
                if (body.containsKey((Object)"orderInfo") && body.getJSONObject("orderInfo") != null) {
                    JSONObject orderInfo = body.getJSONObject("orderInfo");
                    orderInfoBO.setOrderId(orderInfo.containsKey((Object)"orderId") ? orderInfo.getString("orderId") : "");
                    orderInfoBO.setOspOrderId(orderInfo.containsKey((Object)"ospOrderId") ? orderInfo.getString("ospOrderId") : "");
                    ArrayList<SubOrderBO> subOrderBOS = new ArrayList<SubOrderBO>();
                    if (orderInfo.containsKey((Object)"subOrderList") && orderInfo.getJSONArray("subOrderList") != null) {
                        JSONArray jsonArray = orderInfo.getJSONArray("subOrderList");
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject object = jsonArray.getJSONObject(i);
                            SubOrderBO subOrderBO = new SubOrderBO();
                            subOrderBO.setSubOrderId(object.getString("subOrderId"));
                            subOrderBO.setOspsubOrderId(object.getString("ospsubOrderId"));
                            subOrderBOS.add(subOrderBO);
                        }
                        orderInfoBO.setSubOrderList(subOrderBOS);
                    } else {
                        orderInfoBO.setSubOrderList(subOrderBOS);
                    }
                }
                rspBaseBO.setOrderInfo(orderInfoBO);
            } else {
                rspBaseBO.setRespCode(body.containsKey((Object)"bizCode") ? body.getString("bizCode") : "9999");
                rspBaseBO.setRespDesc(body.containsKey((Object)"bizDesc") ? body.getString("bizDesc") : "\u5931\u8d25");
            }
        } else {
            rspBaseBO.setRespCode(externaLinterResultData.getRespCode());
            rspBaseBO.setRespDesc(externaLinterResultData.getRespDesc());
        }
        return rspBaseBO;
    }
}

