/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.fileservice.impl;

import com.tydic.externalinter.ability.bo.ErpCommodityAbilityBO;
import com.tydic.externalinter.ability.bo.commodity.ErpChInfoAbilityBO;
import com.tydic.externalinter.ability.bo.commodity.ErpKCInfoAbilityBO;
import com.tydic.externalinter.ability.bo.commodity.ErpSpInfoAbilityBO;
import com.tydic.externalinter.ability.service.ErpCommodityAbilityService;
import com.tydic.externalinter.ability.service.SyncCommodityService;
import com.tydic.externalinter.dao.ErpKCInfoDao;
import com.tydic.externalinter.dao.po.ErpFileStockDataPO;
import com.tydic.externalinter.fileservice.impl.SyncFileStoreStockServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncCommodityServiceImpl
implements SyncCommodityService {
    private static String mdID = "1008601008";
    private static final Logger log = LoggerFactory.getLogger(SyncFileStoreStockServiceImpl.class);
    @Autowired
    ErpCommodityAbilityService erpCommodityAbilityService;
    @Autowired
    ErpKCInfoDao erpKCInfoDao;

    public void sysnKcData() {
        String syncDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        try {
            log.debug("---------------------\u5e93\u5b58\u5dee\u5f02\u62c9\u9f50\u5f00\u59cb-------------");
            List<ErpFileStockDataPO> stockDataPoByInst = this.erpKCInfoDao.selectErpDiffStockData(syncDate, mdID);
            Long operID = new Date().getTime();
            if (CollectionUtils.isNotEmpty(stockDataPoByInst)) {
                for (ErpFileStockDataPO erpFileStockDataPO : stockDataPoByInst) {
                    ErpCommodityAbilityBO erpCommodityAbilityBO = new ErpCommodityAbilityBO();
                    ArrayList<ErpKCInfoAbilityBO> kcInfo = new ArrayList<ErpKCInfoAbilityBO>();
                    ErpKCInfoAbilityBO erpKCInfoAbilityBO = new ErpKCInfoAbilityBO();
                    erpKCInfoAbilityBO.setMdID(mdID);
                    ArrayList<ErpSpInfoAbilityBO> spInfo = new ArrayList<ErpSpInfoAbilityBO>();
                    ErpSpInfoAbilityBO erpSpInfoAbilityBO = new ErpSpInfoAbilityBO();
                    ArrayList<ErpChInfoAbilityBO> chInfo = new ArrayList<ErpChInfoAbilityBO>();
                    ErpChInfoAbilityBO erpChInfoAbilityBO = new ErpChInfoAbilityBO();
                    operID = operID + 1L;
                    erpCommodityAbilityBO.setOperID(operID.toString());
                    Double Kcsl = Double.parseDouble(erpFileStockDataPO.getKcsl());
                    Double KcslErp = Double.parseDouble(erpFileStockDataPO.getKcslErp());
                    Double num = KcslErp - Kcsl;
                    Double numAbs = Kcsl - KcslErp;
                    erpSpInfoAbilityBO.setHaveCh(erpFileStockDataPO.getHaveCh());
                    erpSpInfoAbilityBO.setZjm(erpFileStockDataPO.getZjmErp());
                    erpSpInfoAbilityBO.setScmID(erpFileStockDataPO.getScmIdErp());
                    erpSpInfoAbilityBO.setCgType(erpFileStockDataPO.getCgTypeErp());
                    erpSpInfoAbilityBO.setType(erpFileStockDataPO.getTypeErp());
                    erpSpInfoAbilityBO.setPp(erpFileStockDataPO.getPpErp());
                    erpSpInfoAbilityBO.setName(erpFileStockDataPO.getNameErp());
                    erpSpInfoAbilityBO.setFullName(erpFileStockDataPO.getFullNameErp());
                    erpSpInfoAbilityBO.setColor(erpFileStockDataPO.getColorErp());
                    erpSpInfoAbilityBO.setNc(erpFileStockDataPO.getNcErp());
                    erpSpInfoAbilityBO.setJg1(erpFileStockDataPO.getJg1Erp());
                    erpSpInfoAbilityBO.setLimitPrice(erpFileStockDataPO.getLimitPriceErp());
                    erpSpInfoAbilityBO.setAssessmentPrice(erpFileStockDataPO.getAssessmentPriceErp());
                    erpSpInfoAbilityBO.setPurchasePrice(erpFileStockDataPO.getPurchasePriceErp());
                    erpChInfoAbilityBO.setCh(erpFileStockDataPO.getChErp());
                    if (num > 0.0) {
                        erpCommodityAbilityBO.setCzType("1");
                        erpSpInfoAbilityBO.setKcsl(num.toString());
                    } else {
                        erpCommodityAbilityBO.setCzType("2");
                        erpSpInfoAbilityBO.setKcsl(numAbs.toString());
                    }
                    chInfo.add(erpChInfoAbilityBO);
                    erpSpInfoAbilityBO.setChInfo(chInfo);
                    spInfo.add(erpSpInfoAbilityBO);
                    erpKCInfoAbilityBO.setSpInfo(spInfo);
                    kcInfo.add(erpKCInfoAbilityBO);
                    erpCommodityAbilityBO.setKcInfo(kcInfo);
                    this.erpCommodityAbilityService.receiveCommodity(erpCommodityAbilityBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u51fa\u9519", (Object)e.getMessage());
        }
    }
}

