/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.externalinter.ability.bo.UIPServiceBO.IMEICheckReqBO;
import com.tydic.externalinter.ability.bo.UIPServiceBO.IMEICheckRspBO;
import com.tydic.externalinter.ability.service.UIPService.IMEICheckAbility;
import com.tydic.externalinter.bo.CheckImeiReqBO;
import com.tydic.externalinter.bo.CheckImeiRspBO;
import com.tydic.externalinter.bo.CheckResultImeiBO;
import com.tydic.externalinter.service.CheckImeiService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMEICheckAbilityImpl
implements IMEICheckAbility {
    static final Logger logger = LoggerFactory.getLogger(IMEICheckAbilityImpl.class);
    @Autowired
    private CheckImeiService checkImeiService;

    public IMEICheckRspBO iMEICheck(IMEICheckReqBO reqBO) {
        IMEICheckRspBO rspBO = new IMEICheckRspBO();
        logger.debug("IMEI\u6821\u9a8c\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((CharSequence)reqBO.getProvinceCode()) || StringUtils.isEmpty((CharSequence)reqBO.getChannelCode())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u7701\u4efd\u7f16\u7801\u6216\u8005\u6e20\u9053\u7f16\u7801\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        switch (reqBO.getChannelCode()) {
            case "02": {
                switch (reqBO.getProvinceCode()) {
                    case "220000": {
                        this.checkImeiBack(reqBO, rspBO);
                        break;
                    }
                    case "150000": {
                        this.checkImeiBack(reqBO, rspBO);
                        break;
                    }
                    case "240000": {
                        CheckImeiReqBO checkImeiReqBO = new CheckImeiReqBO();
                        ArrayList<String> imeiList = new ArrayList<String>();
                        if (CollectionUtils.isNotEmpty((Collection)reqBO.getImeiIds())) {
                            for (String imeiId : reqBO.getImeiIds()) {
                                imeiList.add(imeiId);
                            }
                        }
                        checkImeiReqBO.setImeiIds(imeiList);
                        CheckImeiRspBO checkImeiBO = null;
                        try {
                            checkImeiBO = this.checkImeiService.checkImeiList(checkImeiReqBO);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            rspBO.setRespCode("9999");
                            rspBO.setRespDesc("\u5c71\u4e1c-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0-IMEI\u6821\u9a8c\u5f02\u5e38\uff01");
                            return rspBO;
                        }
                        if (null == checkImeiBO) {
                            rspBO.setRespCode("0000");
                            rspBO.setRespDesc("\u5c71\u4e1c-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0-IMEI\u6821\u9a8c\u7ed3\u679c\u4e3a\u7a7a");
                            return rspBO;
                        }
                        rspBO.setRespCode(checkImeiBO.getRespCode());
                        rspBO.setRespDesc(checkImeiBO.getRespDesc());
                        rspBO.setResultImeiList(checkImeiBO.getResultImeiList());
                        if (!"0000".equals(checkImeiBO.getRespCode())) break;
                        rspBO.setResultCode("0000");
                        rspBO.setResultDesc(checkImeiBO.getRespDesc());
                        break;
                    }
                }
                break;
            }
            case "01": {
                CheckImeiReqBO checkImeiReqBO = new CheckImeiReqBO();
                ArrayList<String> imeiList = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getImeiIds())) {
                    for (String imeiId : reqBO.getImeiIds()) {
                        imeiList.add(imeiId);
                    }
                }
                checkImeiReqBO.setImeiIds(imeiList);
                CheckImeiRspBO checkImeiRspBO = null;
                try {
                    checkImeiRspBO = this.checkImeiService.checkImeiList(checkImeiReqBO);
                }
                catch (Exception e) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u5c71\u4e1c-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0-IMEI\u6821\u9a8c\u5f02\u5e38\uff01");
                    return rspBO;
                }
                if (null == checkImeiRspBO) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u5c71\u4e1c-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0-IMEI\u6821\u9a8c\u7ed3\u679c\u4e3a\u7a7a");
                    return rspBO;
                }
                rspBO.setRespCode(checkImeiRspBO.getRespCode());
                rspBO.setRespDesc(checkImeiRspBO.getRespDesc());
                rspBO.setResultImeiList(checkImeiRspBO.getResultImeiList());
                if (!"0000".equals(checkImeiRspBO.getRespCode())) break;
                rspBO.setResultCode("0000");
                rspBO.setResultDesc(checkImeiRspBO.getRespDesc());
                break;
            }
        }
        return rspBO;
    }

    private void checkImeiBack(IMEICheckReqBO reqBO, IMEICheckRspBO rspBO) {
        ArrayList<CheckResultImeiBO> resultImeiList = new ArrayList<CheckResultImeiBO>();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getImeiIds())) {
            for (String imeiBO : reqBO.getImeiIds()) {
                CheckResultImeiBO checkResultImeiBO = new CheckResultImeiBO();
                checkResultImeiBO.setCheckCode("1");
                checkResultImeiBO.setCheckDesc("\u901a\u8fc7");
                checkResultImeiBO.setImeiId(imeiBO);
                resultImeiList.add(checkResultImeiBO);
            }
        }
        rspBO.setResultImeiList(resultImeiList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setResultCode("0000");
        rspBO.setResultDesc("\u6210\u529f");
    }
}

