/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordItemReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordItemRspBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordReqBO;
import com.tydic.externalinter.atom.ScmOrderSyncRecordAtomService;
import com.tydic.externalinter.busi.bo.ScmSeparateOrderSyncRecordBO;
import com.tydic.externalinter.dao.ScmOrderSyncRecordDAO;
import com.tydic.externalinter.dao.po.ScmOrderSyncRecordItemPO;
import com.tydic.externalinter.dao.po.ScmOrderSyncRecordPO;
import com.tydic.externalinter.dao.po.StoreSalesStatisticsPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScmOrderSyncRecordAtomServiceImpl
implements ScmOrderSyncRecordAtomService {
    private static final Logger log = LoggerFactory.getLogger(ScmOrderSyncRecordAtomServiceImpl.class);
    @Autowired
    private ScmOrderSyncRecordDAO scmOrderSyncRecordDAO;

    @Override
    public List<ScmOrderSyncRecordBO> saveRecordBatch(List<ScmOrderSyncRecordBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u96c6\u5408\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u96c6\u5408\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ScmOrderSyncRecordPO> pos = new ArrayList<ScmOrderSyncRecordPO>(reqBOs.size());
        for (ScmOrderSyncRecordBO bo : reqBOs) {
            this.checkParams(bo);
            ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateTime(new Date());
            pos.add(po);
        }
        try {
            this.scmOrderSyncRecordDAO.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u96c6\u5408\u539f\u5b50\u5c42\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589e\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u96c6\u5408\u539f\u5b50\u5c42\u5931\u8d25");
        }
        ArrayList<ScmOrderSyncRecordBO> rspList = new ArrayList<ScmOrderSyncRecordBO>(pos.size());
        for (ScmOrderSyncRecordPO po : pos) {
            ScmOrderSyncRecordBO bo = new ScmOrderSyncRecordBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspList.add(bo);
        }
        return rspList;
    }

    @Override
    public void modifyBatchByKey(List<ScmOrderSyncRecordBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ScmOrderSyncRecordPO> list = new ArrayList<ScmOrderSyncRecordPO>(reqBOs.size());
        for (ScmOrderSyncRecordBO bo : reqBOs) {
            ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setUpdateTime(new Date());
            list.add(po);
        }
        try {
            this.scmOrderSyncRecordDAO.updateByBatch(list);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u5931\u8d25");
        }
    }

    @Override
    public List<ScmOrderSyncRecordBO> selectScmOrderSyncRecordByList(ScmOrderSyncRecordReqBO reqBOs) {
        List<ScmOrderSyncRecordPO> bos;
        log.debug("\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2" + reqBOs.toString());
        ArrayList<ScmOrderSyncRecordPO> pos = new ArrayList<ScmOrderSyncRecordPO>(reqBOs.getItem().size());
        for (ScmOrderSyncRecordBO bo : reqBOs.getItem()) {
            ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            bos = this.scmOrderSyncRecordDAO.selectScmOrderSyncRecordByList(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(bos)) {
            return null;
        }
        ArrayList<ScmOrderSyncRecordBO> rspBOs = new ArrayList<ScmOrderSyncRecordBO>(bos.size());
        for (ScmOrderSyncRecordPO po : bos) {
            ScmOrderSyncRecordBO bo = new ScmOrderSyncRecordBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspBOs.add(bo);
        }
        return rspBOs;
    }

    @Override
    public List<ScmOrderSyncRecordBO> selectByPage(ScmOrderSyncRecordBO record, Page<Map<String, Object>> page) {
        List<ScmOrderSyncRecordPO> pos;
        ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
        BeanUtils.copyProperties((Object)record, (Object)po);
        try {
            pos = this.scmOrderSyncRecordDAO.selectByPage(page, po);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u5206\u9875\u67e5\u8be2scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5217\u8868\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ScmOrderSyncRecordBO> bos = new ArrayList<ScmOrderSyncRecordBO>(pos.size());
        for (ScmOrderSyncRecordPO scmOrderSyncRecordPO : pos) {
            ScmOrderSyncRecordBO bo = new ScmOrderSyncRecordBO();
            BeanUtils.copyProperties((Object)scmOrderSyncRecordPO, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    @Override
    public ScmOrderSyncRecordBO selectScmOrderSyncRecordByID(ScmOrderSyncRecordBO reqBOs) {
        ScmOrderSyncRecordPO bo;
        try {
            bo = this.scmOrderSyncRecordDAO.selectByPrimaryKey(reqBOs.getId());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8be6\u60c5\u5931\u8d25");
        }
        if (null == bo) {
            return null;
        }
        ScmOrderSyncRecordBO rspBO = new ScmOrderSyncRecordBO();
        BeanUtils.copyProperties((Object)bo, (Object)rspBO);
        return rspBO;
    }

    private void checkParams(ScmOrderSyncRecordBO bo) {
        if (StringUtils.isBlank((CharSequence)bo.getOrgTreePath())) {
            log.error("\u673a\u6784\u6811\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u673a\u6784\u6811\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getBvbeln())) {
            log.error("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getAuart())) {
            log.error("\u8ba2\u5355\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getVkorg())) {
            log.error("\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getVtweg())) {
            log.error("\u5206\u9500\u6e20\u9053\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5206\u9500\u6e20\u9053\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getSpart())) {
            log.error("\u4ea7\u54c1\u7ec4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4ea7\u54c1\u7ec4\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getVsbed())) {
            log.error("\u88c5\u8fd0\u6761\u4ef6\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u88c5\u8fd0\u6761\u4ef6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getVdatu())) {
            log.error("\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getKunnr())) {
            log.error("\u552e\u8fbe\u65b9\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u552e\u8fbe\u65b9\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getKunwe())) {
            log.error("\u9001\u8fbe\u65b9\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9001\u8fbe\u65b9\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getVsart())) {
            log.error("\u88c5\u8fd0\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u88c5\u8fd0\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getOrderStatus())) {
            log.error("\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a");
        }
    }

    @Override
    public int updateScmOrderSyncRecordByBvblen(ScmOrderSyncRecordBO recordBO) {
        if (recordBO == null || StringUtils.isBlank((CharSequence)recordBO.getBvbeln())) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u4fee\u6539\u540c\u6b65\u8bb0\u5f55\u5165\u53c2\u4e3a\u7a7a");
        }
        log.info("\u539f\u5b50\u5c42\u4fee\u6539scm\u540c\u6b65\u8bb0\u5f55\u5165\u53c2-------" + JSON.toJSONString((Object)recordBO));
        ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
        BeanUtils.copyProperties((Object)recordBO, (Object)po);
        int res = 0;
        try {
            res = this.scmOrderSyncRecordDAO.updateScmOrderSyncRecordByBvblen(po);
        }
        catch (Exception e) {
            log.error("\u539f\u5b50\u5c42\u4fee\u6539scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u539f\u5b50\u5c42\u4fee\u6539scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        return res;
    }

    @Override
    public int deleteScmOrderSyncRecordByBo(ScmOrderSyncRecordBO recordBO) {
        if (recordBO == null || StringUtils.isBlank((CharSequence)recordBO.getBvbeln())) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u5220\u9664\u540c\u6b65\u8bb0\u5f55\u5165\u53c2\u4e3a\u7a7a");
        }
        log.info("\u539f\u5b50\u5c42\u5220\u9664scm\u540c\u6b65\u8bb0\u5f55\u5165\u53c2-------" + JSON.toJSONString((Object)recordBO));
        ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
        BeanUtils.copyProperties((Object)recordBO, (Object)po);
        int res = 0;
        try {
            res = this.scmOrderSyncRecordDAO.deleteByPo(po);
        }
        catch (Exception e) {
            log.error("\u539f\u5b50\u5c42\u5220\u9664scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u539f\u5b50\u5c42\u5220\u9664scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        return res;
    }

    @Override
    public int deleteAllRecordByBvblen(String bvbeln) {
        if (StringUtils.isBlank((CharSequence)bvbeln)) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u5220\u9664\u540c\u6b65\u8bb0\u5f55\u5165\u53c2\u4e3a\u7a7a");
        }
        log.info("\u539f\u5b50\u5c42\u5220\u9664\u8be5\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e0b\u7684\u6240\u6709\u8ba2\u5355\u8bb0\u5f55");
        ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
        po.setBvbeln(bvbeln);
        int res = 0;
        try {
            res = this.scmOrderSyncRecordDAO.deleteAllRecordByBvblen(po);
        }
        catch (Exception e) {
            log.error("\u539f\u5b50\u5c42\u5220\u9664\u8be5\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e0b\u7684\u6240\u6709\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)("\u539f\u5b50\u5c42\u5220\u9664\u8be5\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e0b\u7684\u6240\u6709\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25"));
        }
        return res;
    }

    @Override
    public List<ScmSeparateOrderSyncRecordBO> selectSeparateOrder(ScmOrderSyncRecordBO recordBO) {
        ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
        po.setVdatu(recordBO.getVdatu());
        List<ScmSeparateOrderSyncRecordBO> bos = null;
        try {
            bos = this.scmOrderSyncRecordDAO.selectSeparateOrder(po);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4e32\u53f7\u7ea7\u9500\u5355\u51fa\u9519\uff01" + e);
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u4e32\u53f7\u7ea7\u9500\u5355\u51fa\u9519\uff01");
        }
        return bos;
    }

    @Override
    public List<ScmOrderSyncRecordBO> selectBybvbelns(Set<String> bvbelns) {
        if (CollectionUtils.isEmpty(bvbelns)) {
            return new ArrayList<ScmOrderSyncRecordBO>();
        }
        ArrayList<ScmOrderSyncRecordBO> bos = new ArrayList<ScmOrderSyncRecordBO>();
        List<ScmOrderSyncRecordPO> syncRecordPOS = null;
        try {
            syncRecordPOS = this.scmOrderSyncRecordDAO.selectBybvbelns(bvbelns);
        }
        catch (Exception e) {
            log.error("\u6839\u636eSCM\u5355\u53f7\u96c6\u5408\u67e5\u8be2\u5931\u8d25\uff01");
            TkThrExceptionUtils.thrQryExce((String)"\u6839\u636eSCM\u5355\u53f7\u96c6\u5408\u67e5\u8be2\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty(syncRecordPOS)) {
            for (ScmOrderSyncRecordPO po : syncRecordPOS) {
                ScmOrderSyncRecordBO bo = new ScmOrderSyncRecordBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bos.add(bo);
            }
        }
        return bos;
    }

    @Override
    public void updateStatusBybvbelns(Set<String> bvbelns) {
        try {
            this.scmOrderSyncRecordDAO.updateStatusBybvbelns(bvbelns);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9500\u5355\u662f\u5426\u62c6\u5355\u72b6\u6001\u5931\u8d25\uff01" + e);
        }
    }

    @Override
    public void updateStatusReturnBybvbelns(Set<String> bvbelns) {
        try {
            this.scmOrderSyncRecordDAO.updateStatusReturnBybvbelns(bvbelns);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9500\u5355\u4e3a\u9000\u5355\u5f85\u540c\u6b65\u72b6\u6001\uff01" + e);
        }
    }

    @Override
    public List<ScmSeparateOrderSyncRecordBO> selectByStatus(String bvbelns) {
        if (StringUtils.isBlank((CharSequence)bvbelns)) {
            log.info("\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a\uff01");
            return new ArrayList<ScmSeparateOrderSyncRecordBO>();
        }
        ArrayList<ScmSeparateOrderSyncRecordBO> list = new ArrayList();
        try {
            list = this.scmOrderSyncRecordDAO.selectByStatus(bvbelns);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u72b6\u6001\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            TkThrExceptionUtils.thrQryExce((String)"\u6839\u636e\u72b6\u6001\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
        }
        return list;
    }

    @Override
    public List<ScmOrderSyncRecordItemRspBO> selectScmOrderSyncRecordItemByPage(Page<Map<String, Object>> page, ScmOrderSyncRecordItemReqBO reqBO) {
        List<ScmOrderSyncRecordItemRspBO> scmOrderSyncRecordItemRspBOS;
        log.info("\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2" + JSON.toJSONString((Object)reqBO) + JSON.toJSONString(page));
        if (null == reqBO) {
            log.error("\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u8ba2\u5355\u540c\u6b65scm\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        ScmOrderSyncRecordItemPO scmOrderSyncRecordItemPO = new ScmOrderSyncRecordItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)scmOrderSyncRecordItemPO);
        try {
            scmOrderSyncRecordItemRspBOS = this.scmOrderSyncRecordDAO.selectScmOrderSyncRecordItemByPage(page, scmOrderSyncRecordItemPO);
        }
        catch (Exception e) {
            log.error("\u8054\u5408\u5206\u9875\u67e5\u8be2scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u8054\u5408\u5206\u9875\u67e5\u8be2scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5217\u8868\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(scmOrderSyncRecordItemRspBOS)) {
            return null;
        }
        return scmOrderSyncRecordItemRspBOS;
    }

    @Override
    public List<StoreSalesStatisticsPO> selectSalesAmountByVdatu(ScmOrderSyncRecordBO record) {
        if (record == null) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u5165\u53c2\u4e3a\u7a7a");
        }
        log.info("\u539f\u5b50\u5c42\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u5165\u53c2" + JSON.toJSONString((Object)record));
        ScmOrderSyncRecordPO po = new ScmOrderSyncRecordPO();
        BeanUtils.copyProperties((Object)record, (Object)po);
        ArrayList<StoreSalesStatisticsPO> res = new ArrayList();
        try {
            res = this.scmOrderSyncRecordDAO.selectSalesAmountByVdatu(po);
        }
        catch (Exception e) {
            log.error("\u539f\u5b50\u5c42\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u539f\u5b50\u5c42\u67e5\u8be2\u5931\u8d25" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u539f\u5b50\u5c42\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u539f\u5b50\u5c42\u67e5\u8be2\u5931\u8d25");
        }
        log.info("\u539f\u5b50\u5c42\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u51fa\u53c2" + JSON.toJSONString(res));
        return res;
    }
}

