/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.externalinter.ability.bo.GDBillingResultQueryBatchReqBO;
import com.tydic.externalinter.ability.bo.GDBillingResultQueryBatchRspBO;
import com.tydic.externalinter.ability.bo.GDBillingResultQueryOneReqBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.FjBillingResultQueryBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.RspBatchInfoBO;
import com.tydic.externalinter.busi.service.InvoiceServices.GDBillingResultQueryBusiService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.scm.ws.bo.ElectroniceInfo;
import com.tydic.externalinter.scm.ws.bo.QueryEliBatchData;
import com.tydic.externalinter.scm.ws.bo.QueryEliData;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GDBillingResultQueryBusiServiceImpl
implements GDBillingResultQueryBusiService {
    private static Logger logger = LoggerFactory.getLogger(GDBillingResultQueryBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    @Resource(name="exterQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspBaseTBO<FjBillingResultQueryBO> billingResultQueryOne(GDBillingResultQueryOneReqBO reqBO, String cityCode) {
        ExternaLinterResultData externaLinterResultData;
        QueryEliData queryEliData = new QueryEliData();
        RspBaseBO checkRsp = this.checkParams(reqBO, queryEliData, cityCode);
        if (!"0000".equals(checkRsp.getRespCode())) {
            return new RspBaseTBO(checkRsp.getRespCode(), checkRsp.getRespDesc());
        }
        RspBaseTBO rspBO = new RspBaseTBO();
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_10_003");
        publicCallExtReqBO.setReqParam((Object)queryEliData);
        publicCallExtReqBO.setWhichOne("GD");
        logger.debug("\u67e5\u8be2\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u63a5\u53e3(\u5355\u5f20)-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryEliData));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25");
            return rspBO;
        }
        logger.debug("\u67e5\u8be2\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u63a5\u53e3(\u5355\u5f20)-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        JSONObject jsonObject = JSONObject.parseObject((String)externaLinterResultData.getRespData().toString());
        JSONObject response = jsonObject.getJSONObject("queryEliDataResponse");
        JSONObject out = response.getJSONObject("out");
        FjBillingResultQueryBO queryBO = new FjBillingResultQueryBO();
        queryBO.setcOrderno(out.getString("DDH"));
        queryBO.setcFpqqlsh(out.getString("FPQQLSH"));
        if (out.containsKey((Object)"returnCode")) {
            if ("0".equals(out.getString("returnCode"))) {
                queryBO.setcStatus("2");
            } else if ("00".equals(out.getString("returnCode"))) {
                queryBO.setcStatus("21");
            } else {
                queryBO.setcStatus("22");
            }
        } else {
            queryBO.setcStatus("21");
        }
        queryBO.setcMsg(out.getString("returnMsg"));
        if (out.containsKey((Object)"PDF_URL")) {
            queryBO.setcUrl(out.getString("PDF_URL"));
        }
        if (out.containsKey((Object)"PDF_FILE")) {
            queryBO.setPdfFile(out.getString("PDF_FILE"));
        }
        if (out.containsKey((Object)"SE")) {
            queryBO.setSe(out.getString("SE"));
        }
        if (out.containsKey((Object)"CZDM")) {
            queryBO.setCzdm(out.getString("CZDM"));
        }
        if (out.containsKey((Object)"KPLX")) {
            queryBO.setKplx(out.getString("KPLX"));
        }
        if (out.containsKey((Object)"KPRQ")) {
            queryBO.setcKprq(Long.valueOf(TkDateUtils.datetimeStrToDate((String)out.getString("KPRQ").substring(0, out.getString("KPRQ").lastIndexOf("."))).getTime()));
        }
        if (out.containsKey((Object)"FP_DM")) {
            queryBO.setcFpdm(out.getString("FP_DM"));
        }
        if (out.containsKey((Object)"FP_HM")) {
            queryBO.setcFphm(out.getString("FP_HM"));
        }
        if (out.containsKey((Object)"HJBHSJE")) {
            queryBO.setcBhsje(out.getString("HJBHSJE"));
        }
        if (out.containsKey((Object)"SE")) {
            queryBO.setcHjse(out.getString("SE"));
        }
        if (out.containsKey((Object)"returnMsg")) {
            queryBO.setcResultMsg(out.getString("returnMsg"));
        }
        if (out.containsKey((Object)"JYM")) {
            queryBO.setcJym(out.getString("JYM"));
        }
        rspBO.setData((Object)queryBO);
        rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspBatchInfoBO<GDBillingResultQueryBatchRspBO> billingResultQueryBatch(GDBillingResultQueryBatchReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        RspBatchInfoBO rspBO = new RspBatchInfoBO();
        QueryEliBatchData queryEliBatchData = new QueryEliBatchData();
        RspBaseBO checkRsp = this.batchCheckParams(reqBO, queryEliBatchData);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_10_004");
        publicCallExtReqBO.setReqParam((Object)queryEliBatchData);
        logger.debug("\u67e5\u8be2\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u63a5\u53e3(\u591a\u5f20)-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryEliBatchData));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25");
            return rspBO;
        }
        logger.debug("\u67e5\u8be2\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u63a5\u53e3(\u591a\u5f20)-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        return null;
    }

    private RspBaseBO checkParams(GDBillingResultQueryOneReqBO reqBO, QueryEliData queryEliData, String cityCode) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        ElectroniceInfo info = new ElectroniceInfo();
        if (StringUtils.isBlank((CharSequence)reqBO.getFpqqlsh())) {
            rspBO.setRespDesc("\u5165\u53c2-FPQQLSH-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDdh())) {
            rspBO.setRespDesc("\u5165\u53c2-DDH-\u4e3a\u7a7a");
            return rspBO;
        }
        List qryEscapeBOS = this.qryEscapeAtomService.listEscapeByParentCode("CITY_CODE");
        for (QryEscapeBO item : qryEscapeBOS) {
            if (!item.getEscapeCode().equals(cityCode)) continue;
            String in0 = item.getRemark();
            JSONObject jsonObject = JSONObject.parseObject((String)in0);
            String kpnsrsbh = jsonObject.getString("kpnsrsbh");
            String xhfnsrsbh = jsonObject.getString("xhfnsrsbh");
            info.setKPNSRSBH(kpnsrsbh);
            info.setXHFNSRSBH(xhfnsrsbh);
        }
        info.setFPQQLSH(reqBO.getFpqqlsh());
        info.setDDH(reqBO.getDdh());
        queryEliData.setIn0(info);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO batchCheckParams(GDBillingResultQueryBatchReqBO reqBO, QueryEliBatchData queryEliBatchData) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

