/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.externalinter.ability.bo.ScmProvWarehouseInfoBO;
import com.tydic.externalinter.atom.ScmProvWarehouseAtomService;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.ScmExterReqBO;
import com.tydic.externalinter.busi.bo.ScmInvenBO;
import com.tydic.externalinter.busi.bo.ScmInventoryBO;
import com.tydic.externalinter.busi.bo.SkuInventoryReqBo;
import com.tydic.externalinter.busi.bo.SkuInventoryRspBo;
import com.tydic.externalinter.busi.service.GetScmSkuInventoryService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.busi.service.ScmExterRspBO;
import com.tydic.externalinter.busi.service.ScmexterCommService;
import com.tydic.externalinter.scm.ws.bo.SkuInventoryReqBO;
import com.tydic.externalinter.scm.ws.bo.SkuInventoryReqDetailsBo;
import com.tydic.externalinter.scm.ws.bo.SkuInventoryReqTableBo;
import com.tydic.externalinter.scm.ws.bo.SkuInventoryRspBO;
import com.tydic.externalinter.scm.ws.bo.SkuInventoryRspDetailsBo;
import com.tydic.externalinter.scm.ws.bo.SkuInventoryRspTableBo;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetScmSkuInventoryServiceImpl
implements GetScmSkuInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(GetScmSkuInventoryServiceImpl.class);
    @Autowired
    private ScmexterCommService scmexterCommService;
    @Autowired
    private ScmProvWarehouseAtomService scmProvWarehouseAtomService;
    @Autowired
    private PublicCallExtService publicCallExtService;

    public SkuInventoryRspBo getScmSkuInventory(SkuInventoryReqBo skuInventoryReqBo) {
        ScmExterRspBO result;
        SkuInventoryRspBo rspBo = new SkuInventoryRspBo();
        logger.debug("\u83b7\u53d6\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)skuInventoryReqBo));
        ScmProvWarehouseInfoBO record = new ScmProvWarehouseInfoBO();
        record.setScmWarehouseType("1");
        record.setIsProWarehouse("1");
        record.setXlsProvinceCode(skuInventoryReqBo.getmProvince());
        List<ScmProvWarehouseInfoBO> scmProvWarehouseInfoBOList = this.scmProvWarehouseAtomService.selectByIdOrCode(record);
        if (CollectionUtils.isEmpty(scmProvWarehouseInfoBOList)) {
            rspBo.setRespCode("9999");
            rspBo.setRespDesc("\u672a\u83b7\u53d6\u5230\u5de5\u5382\u548c\u4ed3\u5e93\u5730\u70b9");
            return rspBo;
        }
        if (CollectionUtils.isEmpty((Collection)skuInventoryReqBo.getScmInventoryBOList())) {
            rspBo.setRespCode("9999");
            rspBo.setRespDesc("\u5165\u53c2\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        ArrayList<SkuInventoryReqDetailsBo> skuInventoryReqDetailsBos = new ArrayList<SkuInventoryReqDetailsBo>();
        for (ScmInventoryBO scmInventoryBO : skuInventoryReqBo.getScmInventoryBOList()) {
            if (scmInventoryBO.getMaterialCode() == null) {
                rspBo.setRespCode("9999");
                rspBo.setRespDesc("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBo;
            }
            SkuInventoryReqDetailsBo skuInventoryReqDetailsBo = new SkuInventoryReqDetailsBo();
            skuInventoryReqDetailsBo.setMatnr(scmInventoryBO.getMaterialCode());
            if (StringUtils.isNotBlank((CharSequence)scmInventoryBO.getWerks()) && StringUtils.isNotBlank((CharSequence)scmInventoryBO.getLgort())) {
                skuInventoryReqDetailsBo.setWerks(scmInventoryBO.getWerks());
                skuInventoryReqDetailsBo.setLgort(scmInventoryBO.getLgort());
            } else {
                skuInventoryReqDetailsBo.setWerks(scmProvWarehouseInfoBOList.get(0).getScmFactoryNo());
                skuInventoryReqDetailsBo.setLgort(scmProvWarehouseInfoBOList.get(0).getScmWarehouseNo());
            }
            skuInventoryReqDetailsBos.add(skuInventoryReqDetailsBo);
        }
        logger.info("skuInventoryReqDetailsBos:" + skuInventoryReqDetailsBos);
        SkuInventoryReqTableBo skuInventoryReqTableBo = new SkuInventoryReqTableBo();
        skuInventoryReqTableBo.setItem(skuInventoryReqDetailsBos);
        SkuInventoryReqBO ser = new SkuInventoryReqBO();
        ser.setImRule(skuInventoryReqBo.getImRule());
        ser.setImSysid(Objects.requireNonNull(TkPropertiesUtils.getProperty((String)"scm_qry_posting_sys_id")).trim());
        ser.setItInput(skuInventoryReqTableBo);
        ser.setItOutput(new SkuInventoryRspTableBo());
        ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
        scmExterReqBO.setReqData((Object)ser);
        scmExterReqBO.setWsdl(Objects.requireNonNull(TkPropertiesUtils.getProperty((String)"scm_qry_stock_url")).trim());
        try {
            result = this.scmexterCommService.scmExter(scmExterReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528SCM\u83b7\u53d6\u5e93\u5b58\u4fe1\u606f\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            rspBo.setRespCode("9999");
            rspBo.setRespDesc("\u8c03\u7528SCM\u83b7\u53d6\u5e93\u5b58\u4fe1\u606f\u670d\u52a1\u5f02\u5e38");
            return rspBo;
        }
        if (result == null) {
            String desc = "\u8c03\u7528SCM\u83b7\u53d6\u5e93\u5b58\u4fe1\u606f\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a";
            rspBo.setRespCode("9999");
            rspBo.setRespDesc(desc);
            return rspBo;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result.getScmRspData().toString());
        JSONObject response = jsonObject.getJSONObject("Zmmif236Response");
        JSONObject JsonTData = response.getJSONObject("ItOutput");
        JSONArray jsonItem = new JSONArray();
        Object itemObj = JsonTData.get((Object)"item");
        if (itemObj instanceof JSONObject) {
            JSONObject itemJson = JsonTData.getJSONObject("item");
            jsonItem.add((Object)itemJson);
        } else if (itemObj instanceof JSONArray) {
            jsonItem = JsonTData.getJSONArray("item");
        } else {
            logger.error("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\u4e86\uff0citem\u7c7b\u578b\u9519\u8bef");
            rspBo.setRespCode("9999");
            rspBo.setRespDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\u4e86\uff0citem\u7c7b\u578b\u9519\u8bef");
            return rspBo;
        }
        if (jsonItem.size() <= 0) {
            logger.error("\u5e93\u5b58\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5e93\u5b58\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            return rspBo;
        }
        ArrayList<ScmInvenBO> scmInvenBOList = new ArrayList<ScmInvenBO>();
        for (int i = 0; i < jsonItem.size(); ++i) {
            JSONObject job = jsonItem.getJSONObject(i);
            ScmInvenBO scmInvenBO = new ScmInvenBO();
            scmInvenBO.setMaterialCode(job.getString("Matnr"));
            scmInvenBO.setScmCnt(job.getString("Labst"));
            scmInvenBO.setStockFlag(job.getString("Yl1"));
            scmInvenBO.setStockSupplyId(job.getString("Yl2"));
            scmInvenBOList.add(scmInvenBO);
        }
        rspBo.setScmInvenBOList(scmInvenBOList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return rspBo;
    }

    public SkuInventoryRspBo getScmSkuInventoryList(SkuInventoryReqBo reqBo) {
        logger.info("\u5916\u90e8\u63a5\u53e3\u67e5\u8be2SCM\u5e93\u5b58\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBo));
        SkuInventoryRspBo rspBO = new SkuInventoryRspBo();
        try {
            SkuInventoryRspBO skuInventoryRspBO;
            JSONObject rspJson;
            ExternaLinterResultData res;
            if (CollectionUtils.isEmpty((Collection)reqBo.getScmInventoryBOList())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u67e5\u8be2SCM\u5e93\u5b58\u5165\u53c2\u7269\u6599\u5217\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                logger.error("\u67e5\u8be2SCM\u5e93\u5b58\u5165\u53c2\u7269\u6599\u5217\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            List<ScmProvWarehouseInfoBO> scmProvWarehouseInfoBOSendList = null;
            if (reqBo.getbQryWarehouse().booleanValue()) {
                ScmProvWarehouseInfoBO record = new ScmProvWarehouseInfoBO();
                record.setIsProWarehouse(reqBo.getIsProWarehouse());
                record.setXlsProvinceCode(reqBo.getmProvince());
                record.setScmWarehouseAttribute(reqBo.getScmWarehouseAttribute());
                logger.debug("\u67e5\u8be2\u5916\u90e8\u63a5\u53e3\u5de5\u5382\u3001\u4ed3\u5e93\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)record));
                scmProvWarehouseInfoBOSendList = this.scmProvWarehouseAtomService.selectByIdOrCode(record);
                logger.debug("\u67e5\u8be2\u5916\u90e8\u63a5\u53e3\u5de5\u5382\u3001\u4ed3\u5e93\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString(scmProvWarehouseInfoBOSendList));
            }
            HashMap<String, SkuInventoryReqDetailsBo> scmReqMap = new HashMap<String, SkuInventoryReqDetailsBo>();
            List<ScmProvWarehouseInfoBO> finalScmProvWarehouseInfoBOSendList = scmProvWarehouseInfoBOSendList;
            reqBo.getScmInventoryBOList().forEach(scmInventoryBO -> {
                if (scmInventoryBO.getMaterialCode() == null) {
                    logger.error("\u67e5\u8be2SCM\u5e93\u5b58\u5b58\u5728\u7269\u6599\u4e3a\u7a7a-\u8df3\u8fc7");
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)scmInventoryBO.getWerks()) && StringUtils.isNotBlank((CharSequence)scmInventoryBO.getLgort())) {
                    if (!scmReqMap.containsKey(scmInventoryBO.getMaterialCode() + "-" + scmInventoryBO.getLgort())) {
                        scmReqMap.put(scmInventoryBO.getMaterialCode() + "-" + scmInventoryBO.getLgort(), new SkuInventoryReqDetailsBo(scmInventoryBO.getMaterialCode(), scmInventoryBO.getWerks(), scmInventoryBO.getLgort()));
                    }
                } else if (CollectionUtils.isNotEmpty((Collection)finalScmProvWarehouseInfoBOSendList)) {
                    finalScmProvWarehouseInfoBOSendList.forEach(bo -> {
                        if (StringUtils.isBlank((CharSequence)bo.getScmFactoryNo()) || StringUtils.isBlank((CharSequence)bo.getScmWarehouseNo())) {
                            return;
                        }
                        if (!scmReqMap.containsKey(scmInventoryBO.getMaterialCode() + "-" + bo.getScmWarehouseNo())) {
                            scmReqMap.put(scmInventoryBO.getMaterialCode() + "-" + bo.getScmWarehouseNo(), new SkuInventoryReqDetailsBo(scmInventoryBO.getMaterialCode(), bo.getScmFactoryNo(), bo.getScmWarehouseNo()));
                        }
                    });
                } else {
                    logger.error("\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a-\u8df3\u8fc7");
                }
            });
            ArrayList skuInventoryReqDetailsBos = new ArrayList();
            scmReqMap.forEach((key, value) -> skuInventoryReqDetailsBos.add(value));
            PublicCallExtReqBO extReqBO = new PublicCallExtReqBO();
            SkuInventoryReqBO ser = new SkuInventoryReqBO();
            SkuInventoryReqTableBo skuInventoryReqTableBo = new SkuInventoryReqTableBo();
            skuInventoryReqTableBo.setItem(skuInventoryReqDetailsBos);
            ser.setImRule(reqBo.getImRule());
            ser.setItInput(skuInventoryReqTableBo);
            ser.setItOutput(new SkuInventoryRspTableBo());
            ser.setImSysid(Objects.requireNonNull(TkPropertiesUtils.getProperty((String)"scm_qry_posting_sys_id")).trim());
            extReqBO.setBusiCode("EX_SYS_4_003");
            extReqBO.setReqParam((Object)ser);
            try {
                res = this.publicCallExtService.callService(extReqBO);
            }
            catch (Exception e) {
                logger.error("scm\u5e93\u5b58\u67e5\u8be2-\u8c03\u7528\u5916\u90e8\u516c\u5171\u63a5\u53e3\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
                rspBO.setRespCode("0020");
                rspBO.setRespDesc("scm\u5e93\u5b58-\u8c03\u7528\u5916\u90e8\u516c\u5171\u63a5\u53e3\u5f02\u5e38");
                return rspBO;
            }
            if (!res.getSuccess().booleanValue()) {
                logger.error("scm\u5e93\u5b58\u67e5\u8be2-\u8c03\u7528\u5916\u90e8\u516c\u5171\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
                rspBO.setRespCode(res.getRespCode());
                rspBO.setRespDesc(res.getRespDesc());
                return rspBO;
            }
            try {
                rspJson = JSONObject.parseObject((String)res.getRespData().toString());
            }
            catch (Exception e) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0cJSON\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0cJSON\u8f6c\u6362\u5f02\u5e38");
                return rspBO;
            }
            if (!rspJson.containsKey((Object)"Zmmif236Response")) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif236Response");
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif236Response");
                return rspBO;
            }
            try {
                skuInventoryRspBO = (SkuInventoryRspBO)JSONObject.parseObject((String)rspJson.getString("Zmmif236Response"), SkuInventoryRspBO.class);
            }
            catch (Exception e) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0cmmif236Response\u8f6c\u6362SkuInventoryRspBO\u5f02\u5e38" + e.getMessage());
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif236Response");
                return rspBO;
            }
            if (null == skuInventoryRspBO.getItOutput() || CollectionUtils.isEmpty((Collection)skuInventoryRspBO.getItOutput().getItem())) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230getItem\u4fe1\u606f");
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230getItOutput\u4fe1\u606f");
                return rspBO;
            }
            if (reqBo.getbMap().booleanValue()) {
                HashMap scmStockMap = new HashMap();
                skuInventoryRspBO.getItOutput().getItem().forEach(item -> scmStockMap.put(item.getMatnr() + "-" + item.getLgort(), this.getScmInvenBO((SkuInventoryRspDetailsBo)item)));
                rspBO.setScmStockMap(scmStockMap);
            } else {
                ArrayList scmInvenBOs = new ArrayList();
                skuInventoryRspBO.getItOutput().getItem().forEach(item -> scmInvenBOs.add(this.getScmInvenBO((SkuInventoryRspDetailsBo)item)));
                rspBO.setScmInvenBOList(scmInvenBOs);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            logger.info("\u5916\u90e8\u63a5\u53e3\u67e5\u8be2SCM\u5e93\u5b58\u670d\u52a1\u51fa\u53c2" + JSON.toJSONString((Object)rspBO));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2SCM\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
    }

    public SkuInventoryRspBo getScmInventoryList(SkuInventoryReqBo skuInventoryReqBo) {
        logger.info("\u5916\u90e8\u63a5\u53e3\u67e5\u8be2SCM\u5e93\u5b58\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)skuInventoryReqBo));
        SkuInventoryRspBo rspBO = new SkuInventoryRspBo();
        try {
            SkuInventoryRspBO skuInventoryRspBO;
            JSONObject rspJson;
            ExternaLinterResultData res;
            if (CollectionUtils.isEmpty((Collection)skuInventoryReqBo.getSkuInventoryReqDetailsBos())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u67e5\u8be2SCM\u5e93\u5b58\u5165\u53c2\u7269\u6599\u5217\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                logger.error("\u67e5\u8be2SCM\u5e93\u5b58\u5165\u53c2\u7269\u6599\u5217\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            PublicCallExtReqBO extReqBO = new PublicCallExtReqBO();
            SkuInventoryReqBO ser = new SkuInventoryReqBO();
            SkuInventoryReqTableBo skuInventoryReqTableBo = new SkuInventoryReqTableBo();
            skuInventoryReqTableBo.setItem(skuInventoryReqBo.getSkuInventoryReqDetailsBos());
            ser.setImRule(skuInventoryReqBo.getImRule());
            ser.setItInput(skuInventoryReqTableBo);
            ser.setItOutput(new SkuInventoryRspTableBo());
            ser.setImSysid(Objects.requireNonNull(TkPropertiesUtils.getProperty((String)"scm_qry_posting_sys_id")).trim());
            extReqBO.setBusiCode("EX_SYS_4_003");
            extReqBO.setReqParam((Object)ser);
            try {
                res = this.publicCallExtService.callService(extReqBO);
            }
            catch (Exception e) {
                logger.error("scm\u5e93\u5b58\u67e5\u8be2-\u8c03\u7528\u5916\u90e8\u516c\u5171\u63a5\u53e3\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
                rspBO.setRespCode("0020");
                rspBO.setRespDesc("scm\u5e93\u5b58-\u8c03\u7528\u5916\u90e8\u516c\u5171\u63a5\u53e3\u5f02\u5e38");
                return rspBO;
            }
            if (!res.getSuccess().booleanValue()) {
                logger.error("scm\u5e93\u5b58\u67e5\u8be2-\u8c03\u7528\u5916\u90e8\u516c\u5171\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
                rspBO.setRespCode(res.getRespCode());
                rspBO.setRespDesc(res.getRespDesc());
                return rspBO;
            }
            try {
                rspJson = JSONObject.parseObject((String)res.getRespData().toString());
            }
            catch (Exception e) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0cJSON\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0cJSON\u8f6c\u6362\u5f02\u5e38");
                return rspBO;
            }
            if (!rspJson.containsKey((Object)"Zmmif236Response")) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif236Response");
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif236Response");
                return rspBO;
            }
            try {
                skuInventoryRspBO = (SkuInventoryRspBO)JSONObject.parseObject((String)rspJson.getString("Zmmif236Response"), SkuInventoryRspBO.class);
            }
            catch (Exception e) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0cmmif236Response\u8f6c\u6362SkuInventoryRspBO\u5f02\u5e38" + e.getMessage());
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif236Response");
                return rspBO;
            }
            if (null == skuInventoryRspBO.getItOutput() || CollectionUtils.isEmpty((Collection)skuInventoryRspBO.getItOutput().getItem())) {
                logger.error("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230getItem\u4fe1\u606f");
                rspBO.setRespCode("0008");
                rspBO.setRespDesc("scm\u5e93\u5b58\uff0c\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230getItOutput\u4fe1\u606f");
                return rspBO;
            }
            HashMap scmStockMap = new HashMap();
            skuInventoryRspBO.getItOutput().getItem().forEach(item -> scmStockMap.put(item.getMatnr() + item.getLgort(), this.getScmInvenBO((SkuInventoryRspDetailsBo)item)));
            ArrayList scmInvenBOs = new ArrayList();
            skuInventoryRspBO.getItOutput().getItem().forEach(item -> scmInvenBOs.add(this.getScmInvenBO((SkuInventoryRspDetailsBo)item)));
            rspBO.setScmInvenBOList(scmInvenBOs);
            rspBO.setScmStockMap(scmStockMap);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            logger.info("\u5916\u90e8\u63a5\u53e3\u67e5\u8be2SCM\u5e93\u5b58\u670d\u52a1\u51fa\u53c2" + JSON.toJSONString((Object)rspBO));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2SCM\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
    }

    private ScmInvenBO getScmInvenBO(SkuInventoryRspDetailsBo item) {
        ScmInvenBO scmInvenBO = new ScmInvenBO();
        scmInvenBO.setMaterialCode(item.getMatnr());
        scmInvenBO.setLgort(item.getLgort());
        scmInvenBO.setScmCnt(StringUtils.isBlank((CharSequence)item.getLabst()) ? "0" : item.getLabst());
        scmInvenBO.setStockFlag(item.getYl1());
        scmInvenBO.setStockSupplyId(item.getYl2());
        return scmInvenBO;
    }
}

